function KMS_EndCensAppl(DGP,yyvec,knopt,alpha,ncpus)

% This code estimates confidence sets for benefit elasticity using SIPP data
% similar to Chetty(2008) with KMS method and c-dependence
%   DGP             DGP = 1, 5 regressors
%                   DGP = 2, 3 regressors
%   yyvec           yyvec(1):yyvec(2):yyvec(3) = grid for y
%   knopt           Slackness sequence contstant (see def. of kappa below)
%   alpha           Significance level
%   ncpus           Number of CPUs used
%   KMSoptions      Structure of options set by user.

%% Key Parameters:
method      = 'KMS';    % Method - either AS or KMS
component   = 3;        % Component of theta to build confidence interval around
name        = strcat('_cdep_DGP',num2str(DGP),'_coverage',num2str(100*(1-alpha)),...
                     '_k',num2str(knopt),'_ymax',num2str(yyvec(3)),'_ystep',num2str(yyvec(2)));
KMSoptions  = KMSoptions();

%% Load data
dname = sprintf('../SIPP1spdat%d',DGP);
load(dname); n = size(data,1);
x = data(:,3:end);

%% Extract/Save Information to KMSoptions, and set seed
KMSoptions.DGP = DGP;
KMSoptions.n = n;
KMSoptions.component = component;
KMSoptions.num_cores = ncpus;
KMSoptions.seed =  1;
stream = RandStream('mlfg6331_64','Seed',1);
RandStream.setGlobalStream(stream)

%% Parameters
type = 'two-sided';                 % Two-sided or one sided test?  Set to 'one-sided-UB' or 'one-sided-LB' or 'two-sided'
kappa = @(n) sqrt(knopt*log(n));    % Kappa function
phi   = NaN;                        % Default GMS function      

%% Parameters that depend on DGP
if DGP == 6
    c = 0.31395; 
elseif DGP == 4||DGP == 16
    c = 0.26283;
elseif DGP == 11
    c = 0.2772;
elseif DGP == 13
    c = 0.2684;
elseif DGP == 14||DGP == 15
    c = 0.11874;
elseif DGP == 17
    c = 0.25529;
elseif DGP == 18    
    c = 0.31548;
elseif DGP == 19    
    c = 0.36522;
elseif DGP == 20    
    c = 0.15946;
elseif DGP == 21
    c = 0.13583;
elseif DGP == 22
    c = 0.15356;
elseif DGP == 23
    c = 0.12148;
elseif DGP == 24
    c = 0.077746;
elseif DGP == 25
    c = 0.1541;
elseif DGP == 26
    c = 0.1627;
end
KMSoptions.c = c;
    
xx = unique(x,'rows');          % Discrete X values
KMSoptions.xx = xx;
kk = size(xx,1); KMSoptions.kk = kk;
KMSoptions.uH = [yyvec(1):yyvec(2):yyvec(3)]';   % Discrete evaluation points for duration Y
xname = sprintf('../x00_%d',DGP); load(xname);
theta_0 = x00';                  % Initial parameter vector
p = zeros(size(theta_0,1),1);   % Projection direction
p(component) = 1;               % Projection direction
KMSoptions.S =  0;              % Rho Polytope Constraints
xs = size(x,2);
LB_theta = [1e-12 1e-12 -10*ones(1,xs)]';  % Lower bound on parameter space
UB_theta = 10*ones(1,2+xs)';               % Upper on parameter space
A_theta = [];                   % No polytope constraints
b_theta = [];                   % No polytope constraints
CVXGEN_name = [];               % CVXGEN file name

t1 = tic;
[KMS_confidence_interval,KMS_output] = KMS_0_Main(data,theta_0,...
    p,[],LB_theta,UB_theta,A_theta,b_theta,alpha,type,method,kappa,phi,CVXGEN_name,KMSoptions)
totaltime_KMS = toc(t1)

%% Save  KMS
%date = datestr(now, 'yyyy_mm_dd_HH_MM_SS');
filename = strcat('Results/IDset',name,'.mat');
save(filename)

