function KMS_EndCensAppl(DGP,yyvec,knopt,alpha,ncpus)

% This code estimates confidence sets for benefit elasticity using SIPP data
% similar to Chetty(2008) with KMS method
%   DGP             DGP = 1, 5 regressors
%                   DGP = 2, 3 regressors
%   
%   knopt           Slackness sequence contstant (see def. of kappa below)
%   alpha           Significance level
%   ncpus           Number of CPUs used
%   KMSoptions      Structure of options set by user.

%% Key Parameters:
method      = 'KMS';    % Method - either AS or KMS
component   = 3;        % Component of theta to build confidence interval around
name        = strcat('_DGP',num2str(DGP),'_coverage',num2str(100*(1-alpha)),...
                     '_k',num2str(knopt),'_ymax',num2str(yyvec(3)),'_ystep',num2str(yyvec(2)));
KMSoptions  = KMSoptions();

%% Load data
dname = sprintf('../SIPP1spdat%d',DGP);
load(dname); n = size(data,1);
x = data(:,3:end);

%% Extract/Save Information to KMSoptions, and set seed
KMSoptions.DGP = DGP;
KMSoptions.n = n;
KMSoptions.component = component;
KMSoptions.num_cores = ncpus;
KMSoptions.seed =  1;
stream = RandStream('mlfg6331_64','Seed',1);
RandStream.setGlobalStream(stream)

%% Parameters
type = 'two-sided';                 % Two-sided or one sided test?  Set to 'one-sided-UB' or 'one-sided-LB' or 'two-sided'
kappa = @(n) sqrt(knopt*log(n));    % Kappa function
phi   = NaN;                        % Default GMS function      

%% Parameters that depend on DGP
xx = unique(x,'rows');          % Discrete X values
KMSoptions.xx = xx;
kk = size(xx,1); KMSoptions.kk = kk;
KMSoptions.uH = [yyvec(1):yyvec(2):yyvec(3)]';   % Discrete evaluation points for duration Y
xname = sprintf('../x00_%d',DGP); load(xname);
theta_0 = x00';                  % Initial parameter vector
p = zeros(size(theta_0,1),1);   % Projection direction
p(component) = 1;               % Projection direction
KMSoptions.S =  0;              % Rho Polytope Constraints
xs = size(x,2);
LB_theta = [1e-12 1e-12 -20*ones(1,xs)]';  % Lower bound on parameter space
UB_theta = 20*ones(1,2+xs)';               % Upper on parameter space
A_theta = [];                   % No polytope constraints
b_theta = [];                   % No polytope constraints
CVXGEN_name = [];               % CVXGEN file name

t1 = tic;
[KMS_confidence_interval,KMS_output] = KMS_0_Main(data,theta_0,...
    p,[],LB_theta,UB_theta,A_theta,b_theta,alpha,type,method,kappa,phi,CVXGEN_name,KMSoptions)
totaltime_KMS = toc(t1)

%% Save  KMS
%date = datestr(now, 'yyyy_mm_dd_HH_MM_SS');
filename = strcat('Results/IDset',name,'.mat');
save(filename)

