/*estimation program for bivariate exceedance probability*/

new;
format /rz 6, 10;
library pgraph;

/*this program calculates tail indices and tail quantiles+asymmetry/structural change tests: figure 1+Table 2*/
/*tests are preformed with block bootstrap of length 50*/ 

/*bivariate tail beta's and accompanying tests are calculated with a comparable program*/

/*marg. significance level*/

p=0.0002;


/*hill thresholds determined via beirlant algorithm (see other program unibeir.txt)*/

ml1=...;   /*left tail/pre-9/11*/ 
mr1=...;   /*right tail/pre-9/11*/
ml2=...;   /*left tail/post-9/11*/
mr2=...;   /*right tail/post-9/11*/

/*log returns - weekend and overnight returns linearly scaled to the halfhour time horizon*/


load q[]=c:\sep11\returnseries.txt;


/*define subsamples with 9/11 as midpoint: left/right tail and pre-9/11-post-9/11*/

q1=q[1:8380];
q2=q[8381:16760];





xl1=-q1;  /*left tail;pre-9/11*/
xr1=q1;   /*right tail;pre-9/11*/
xl2=-q2;  /*left tail;post-9/11*/
xr2=q2;   /*right tail;post-9/11*/



sorl1=sortc(xl1,1);
sorr1=sortc(xr1,1);
sorl2=sortc(xl2,1);
sorr2=sortc(xr2,1);

n=rows(xl1);

/*pre-and post-break +left and right tail Hill estimates*/

al1=(meanc(ln(sorl1[(n-ml1+1):n]/sorl1[n-ml1])))^(-1);
ar1=(meanc(ln(sorr1[(n-mr1+1):n]/sorr1[n-mr1])))^(-1);
al2=(meanc(ln(sorl2[(n-ml2+1):n]/sorl2[n-ml2])))^(-1);
ar2=(meanc(ln(sorr2[(n-mr2+1):n]/sorr2[n-mr2])))^(-1);


gl1=1/al1;
gl2=1/al2;
gr1=1/ar1;
gr2=1/ar2;

/*quantiles*/

ql1=sorl1[n-ml1]*(ml1/(p*n))^(1/al1);
qr1=sorr1[n-mr1]*(mr1/(p*n))^(1/ar1);
ql2=sorl2[n-ml2]*(ml2/(p*n))^(1/al2);
qr2=sorr2[n-mr2]*(mr2/(p*n))^(1/ar2);



@full sample block Bootstrap for standard deviations@

block=50;  /*block length */
k=floor(n/block);  /*Number of blocks*/
rep=1000;  /*number of bootstrap replications*/


al1block=zeros(rep,1);
ar1block=zeros(rep,1);
al2block=zeros(rep,1);
ar2block=zeros(rep,1);
ql1block=zeros(rep,1);
qr1block=zeros(rep,1);
ql2block=zeros(rep,1);
qr2block=zeros(rep,1);


i=1;

 do while i <=rep;

   @Bootstrap index in blocks@

     nj=1;

    do while nj <=k;

    rn=ceil(rndu(1,1)*(n-1)+1);
   
    if  rn>=n-block+1;
    rn=n-block+1;    
    else;
    rn=rn;

    endif;


    z=seqa(rn,1,block);

     if nj==1;
     z2=z;
     else;
     z2=z2|z;
     endif;

    nj=nj+1;
    endo;
        
   
    xl1block=xl1[z2];
    xl2block=xl2[z2];
    xr1block=xr1[z2];
    xr2block=xr2[z2];

    sl1block=sortc(xl1block,1);
    sl2block=sortc(xl2block,1); 
    sr1block=sortc(xr1block,1);
    sr2block=sortc(xr2block,1);

   
    n1=rows(sl1block);   
    
    n2=rows(sl2block);  

    
   al1block[i]=1/meanc(ln(sl1block[(n1-ml1+1):n1]/sl1block[n1-ml1]));
   al2block[i]=1/meanc(ln(sl2block[(n2-ml2+1):n2]/sl2block[n2-ml2])); 
   ar1block[i]=1/meanc(ln(sr1block[(n1-mr1+1):n1]/sr1block[n1-mr1]));
   ar2block[i]=1/meanc(ln(sr2block[(n2-mr2+1):n2]/sr2block[n2-mr2]));

 

     
    ql1block[i]=ln(sl1block[n1-ml1]*(ml1/(p*n1))^(1/al1block[i]));
    ql2block[i]=ln(sl2block[n2-ml2]*(ml2/(p*n2))^(1/al2block[i]));
    qr1block[i]=ln(sr1block[n1-mr1]*(mr1/(p*n1))^(1/ar1block[i]));
    qr2block[i]=ln(sr2block[n2-mr2]*(mr2/(p*n2))^(1/ar2block[i]));
     

i=i+1;
i;
endo;


tss1=(al1-al2)/stdc(al1block-al2block);
tss2=(ar1-ar2)/stdc(ar1block-ar2block);
tas1=(al1-ar1)/stdc(al1block-ar1block);
tas2=(al2-ar2)/stdc(al2block-ar2block);


tss3=(ln(ql1)-ln(ql2))/stdc(ql1block-ql2block);
tss4=(ln(qr1)-ln(qr2))/stdc(qr1block-qr2block);
tas3=(ln(ql1)-ln(qr1))/stdc(ql1block-qr1block);
tas4=(ln(ql2)-ln(qr2))/stdc(ql2block-qr2block);



"Tail indexes:";
al1;
ar1;
al2;
ar2;

"Tail quantiles:";
ql1;
qr1;
ql2;
qr2;


"Structural change (SS) and asymmetry (AS) tests for tail indexes:";
tss1;
tss2;
tas1;
tas2;

"Structural change (SS) and asymmetry (AS) tests for tail quantiles:"; 
tss3;
tss4;
tas3;
tas4;
