/*Gauss estimation program for AMSE and optimal threshold selection based on Beirlant et al. (1999)*/

new;
cls;
library pgraph;
graphset;


format /rz 6, 15;


/*load price series*/


load q[]=c:\revquin\series.txt;

/*log returns*/

q=ln(q);
q=trimr(q,1,0)-trimr(q,0,1);

 /*you are interested in left tail*/

q=-q;  
  
s=sortc(q,1);


/*define range over which you want to calculate the AMSE*/


kup=400; 
kind=50;

sek=seqa(kind,1,kup-(kind-1));

{m}=beir(s);

m;


/*gauss procedure*/


proc(1)=beir(s);
local  n, v, optim, k, m, Zk, X2, j, Zj, X2j, X1, X12, coef, gam_kn, b, b_kn, AMSE_H_kn, AMSE_H_all; 

k=kind;

do while k<=kup;

Zk=0;
X2=0;

j=1;

do while j<=k;
     n=rows(s);
    Zj = j*(ln(s[n-j+1,1])-ln(s[n-j,1]));
    X2j = j*(n+1)/(k+1)^2;    
    if j==1;
        Zk=Zj;
        X2=X2j;
    else;
        Zk=Zk|Zj;
        X2=X2|X2j;
    endif;

j=j+1;
endo;

X1=ones(k,1);

X12=X1~X2;

coef=inv(X12'X12)*X12'Zk;
gam_kn=coef[1,1];
b=coef[2,1];
b_kn=b*((n+1)/(k+1));   
AMSE_H_kn = (b_kn/2)^2 + (gam_kn^2)/k; /*determines MSE for given k*/

if k==kind;
    AMSE_H_all = AMSE_H_kn;
else;
    AMSE_H_all = AMSE_H_all|AMSE_H_kn;
endif;

k=k+1;
endo;


v=sek~AMSE_H_all;

optim=sortc(v,2);

m=optim[1,1];

/*
m=minindc(AMSE_H_all);
*/

retp(m);
endp;

