%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%This is the main programme that gives the results in tables in the main
%%text
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all;

clc;
tic;


global  alphaf3list alphaf4list alphaf5list alpham3list alpham4list alpham5list alphak3list alphak4list alphak5list  betaf3list betam3list betak3list betaf4list betam4list betak4list betaf5list betam5list betak5list eta_z3list eta_z4list eta_z5list kid3_list kid4_list kid5_list x3_instlist x4_instlist x5_instlist instlist3 instlist4 instlist5 eta_k3list eta_k4list eta_k5list x3 x4 x5 nkids3 nkids4 nkids5 tiny sf_3 sf_4 sf_5 sm_3 sm_4 sm_5 sk_3 sk_4 sk_5 xnlsuri2 x3hat dmednkids3 dmednkids4 dmednkids5 constant x4hat x5hat xgmmi2 village3;



load matlab_regs.csv;
data=matlab_regs;
min_childage5=data(:,1);
share_girls5=data(:,2);
kids_enrolled5=data(:,3);
agehead5=data(:,4);
agespouse5=data(:,5);
treated=data(:,6);
nkids5=data(:,7);
min_childage4=data(:,8);
share_girls4=data(:,9);
kids_enrolled4=data(:,10);
agehead4=data(:,11);
agespouse4=data(:,12);
nkids4=data(:,13);
min_childage3=data(:,14);
share_girls3=data(:,15);
wealthindex=data(:,16);
kids_enrolled3=data(:,17);
agehead3=data(:,18);
agespouse3=data(:,19);
nkids3=data(:,20);
educhead=data(:,21);
educspouse=data(:,22);
mean_wageall3=data(:,23);
mean_wageall4=data(:,24);
mean_wageall5=data(:,25);
drought5=data(:,26);
grocers5=data(:,27);
drought4=data(:,28);
grocers4=data(:,29);
drought3=data(:,30);
grocers3=data(:,31);
state1=data(:,32);
state2=data(:,33);
state3=data(:,34);
state4=data(:,35);
state5=data(:,36);
state6=data(:,37);
state7=data(:,38);
ln_mean_wageall3=data(:,39);
ln_mean_wageall4=data(:,40);
ln_mean_wageall5=data(:,41);
one=data(:,42);
x3=data(:,43);
x4=data(:,47);
x5=data(:,51);

village3=data(:,104);
village4=data(:,105);
village5=data(:,106);

dmednkids3=data(:,107);
dmednkids4=data(:,108);
dmednkids5=data(:,109);
constant=data(:,110);

%define private assignable goods shares according to desired specification:

%sum of shoes and clothes:
sm_3=data(:,44);
sf_3=data(:,45);
sk_3=data(:,46);
sm_4=data(:,48);
sf_4=data(:,49);
sk_4=data(:,50);
sm_5=data(:,52);
sf_5=data(:,53);
sk_5=data(:,54);

%use the variables below if you want to use shoes only:
% sm_3=data(:,85);
% sf_3=data(:,86);
% sk_3=data(:,87);
% sm_4=data(:,88);
% sf_4=data(:,89);
% sk_4=data(:,90);
% sm_5=data(:,91);
% sf_5=data(:,92);
% sk_5=data(:,93);

%use the variables below if you want to use clothes only:
% sm_3=data(:,94);
% sf_3=data(:,95);
% sk_3=data(:,96);
% sm_4=data(:,97);
% sf_4=data(:,98);
% sk_4=data(:,99);
% sm_5=data(:,100);
% sf_5=data(:,101);
% sk_5=data(:,102);

tiny=data(:,55);
kid31=data(:,56);
kid32=data(:,57);
kid33=data(:,58);
kid34=data(:,59);
dmagehead3=data(:,60);
dmagespouse3=data(:,61);
dmchildage3=data(:,62);
dmshare_girls3=data(:,63);
kid41=data(:,64);
kid42=data(:,65);
kid43=data(:,66);
kid44=data(:,67);
dmagehead4=data(:,68);
dmagespouse4=data(:,69);
dmchildage4=data(:,70);
dmshare_girls4=data(:,71);
kid51=data(:,72);
kid52=data(:,73);
kid53=data(:,74);
kid54=data(:,75);
dmagehead5=data(:,76);
dmagespouse5=data(:,77);
dmchildage5=data(:,78);
dmshare_girls5=data(:,79);
dmeduchead=data(:,80);
dmeducspouse=data(:,81);
folio=data(:,115);
folio2=data(:,117);
indi=data(:,116);

alphaf3list = [state1 state2 state3 state4 state5 state6 constant dmednkids3 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
alphaf4list = [state1 state2 state3 state4 state5 state6 constant dmednkids4 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
alphaf5list = [state1 state2 state3 state4 state5 state6 constant dmednkids5 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];
alpham3list = [state1 state2 state3 state4 state5 state6 constant dmednkids3 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
alpham4list = [state1 state2 state3 state4 state5 state6 constant dmednkids4 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
alpham5list = [state1 state2 state3 state4 state5 state6 constant dmednkids5 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];
alphak3list = [state1 state2 state3 state4 state5 state6 constant dmednkids3 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
alphak4list = [state1 state2 state3 state4 state5 state6 constant dmednkids4 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
alphak5list = [state1 state2 state3 state4 state5 state6 constant dmednkids5 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];

betaf3list  = [state1 state2 state3 state4 state5 state6 constant dmednkids3 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
betam3list  = [state1 state2 state3 state4 state5 state6 constant dmednkids3 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
betak3list  = [state1 state2 state3 state4 state5 state6 constant dmednkids3 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
eta_z3list=[treated dmeduchead dmeducspouse dmagehead3 dmagespouse3 dmshare_girls3 dmchildage3 indi drought3 state1 state2 state3 state4 state5 state6];
betaf4list=[state1 state2 state3 state4 state5 state6 constant dmednkids4 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
betam4list=[state1 state2 state3 state4 state5 state6 constant dmednkids4 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
betak4list=[state1 state2 state3 state4 state5 state6 constant dmednkids4 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
eta_z4list=[treated dmeduchead dmeducspouse dmagehead4 dmagespouse4 dmshare_girls4 dmchildage4 indi drought4 state1 state2 state3 state4 state5 state6];
betaf5list=[state1 state2 state3 state4 state5 state6 constant dmednkids5 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];
betam5list=[state1 state2 state3 state4 state5 state6 constant dmednkids5 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];
betak5list=[state1 state2 state3 state4 state5 state6 constant dmednkids5 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];
eta_z5list=[treated dmeduchead dmeducspouse dmagehead5 dmagespouse5 dmshare_girls5 dmchildage5 indi drought5 state1 state2 state3 state4 state5 state6];
   
kid3_list=[constant dmednkids3];  
kid4_list=[constant dmednkids4];
kid5_list=[constant dmednkids5];

x3_instlist=ln_mean_wageall3;
x4_instlist=ln_mean_wageall4;
x5_instlist=ln_mean_wageall5;

instlist3=[state1 state2 state3 state4 state5 state6 dmagehead3 dmagespouse3 dmeduchead dmeducspouse dmshare_girls3 dmchildage3 treated indi drought3];
instlist4=[state1 state2 state3 state4 state5 state6 dmagehead4 dmagespouse4 dmeduchead dmeducspouse dmshare_girls4 dmchildage4 treated indi drought4];
instlist5=[state1 state2 state3 state4 state5 state6 dmagehead5 dmagespouse5 dmeduchead dmeducspouse dmshare_girls5 dmchildage5 treated indi drought5];
eta_k3list=[constant dmednkids3];
eta_k4list=[constant dmednkids4];
eta_k5list=[constant dmednkids5];

%load the matrix of starting values 
SVM=dlmread('SVM40.txt');

%6th row of the matrix gives the smallest fvalue so we consider the results
%from that
 xi=SVM(6,:);

 % first step SUR
options=optimoptions('fminunc','Display','iter','FunValCheck','off','MaxIter', 100000, 'MaxFunEvals',3000000000,'TolFun',1e-10, 'TolX',1e-10);
[xnlsuri2,fvali2,exitflag,output] = fminunc('nlsurbeta_onecons',xi,options);  
save xnlsuri2;
save fvali2;

xi2=xnlsuri2;
% %second step SUR
options=optimoptions('fminunc','Display','iter','FunValCheck','off','MaxIter', 100000, 'MaxFunEvals',3000000000,'TolFun',1e-10, 'TolX',1e-10);
[xnlsur22,fval22,exitflag,output] = fminunc('nlsurbeta2_onecons',xi2,options);  
save xnlsur22;
save fval22;


var_xnlsur2=derfinal2_onecons(xnlsur22);
std_xnlsur2=real(diag(var_xnlsur2)).^(1/2); 
t_xnlsur=xnlsur22'./std_xnlsur2;

%%SS: Calculation of kid's parameters and their std deviations:

E3fhat=[xnlsur22(1) xnlsur22(2) xnlsur22(3) xnlsur22(4) xnlsur22(5) xnlsur22(6) xnlsur22(7) xnlsur22(8) xnlsur22(9) xnlsur22(10) xnlsur22(11) xnlsur22(12) xnlsur22(13) xnlsur22(14) xnlsur22(15) xnlsur22(16) xnlsur22(17)];
E3mhat=[xnlsur22(18) xnlsur22(19) xnlsur22(20) xnlsur22(21) xnlsur22(22) xnlsur22(23) xnlsur22(24) xnlsur22(25) xnlsur22(26) xnlsur22(27) xnlsur22(28) xnlsur22(29) xnlsur22(30) xnlsur22(31) xnlsur22(32) xnlsur22(33) xnlsur22(34)];
E4fhat=[xnlsur22(35) xnlsur22(36) xnlsur22(37) xnlsur22(38) xnlsur22(39) xnlsur22(40) xnlsur22(41) xnlsur22(42) xnlsur22(43) xnlsur22(44) xnlsur22(45) xnlsur22(46) xnlsur22(47) xnlsur22(48) xnlsur22(49) xnlsur22(50) xnlsur22(51)];
E4mhat=[xnlsur22(52) xnlsur22(53) xnlsur22(54) xnlsur22(55) xnlsur22(56) xnlsur22(57) xnlsur22(58) xnlsur22(59) xnlsur22(60) xnlsur22(61) xnlsur22(62) xnlsur22(63) xnlsur22(64) xnlsur22(65) xnlsur22(66) xnlsur22(67) xnlsur22(68)];
E5fhat=[xnlsur22(69) xnlsur22(70) xnlsur22(71) xnlsur22(72) xnlsur22(73) xnlsur22(74) xnlsur22(75) xnlsur22(76) xnlsur22(77) xnlsur22(78) xnlsur22(79) xnlsur22(80) xnlsur22(81) xnlsur22(82) xnlsur22(83) xnlsur22(84) xnlsur22(85)];
E5mhat=[xnlsur22(86) xnlsur22(87) xnlsur22(88) xnlsur22(89) xnlsur22(90) xnlsur22(91) xnlsur22(92) xnlsur22(93) xnlsur22(94) xnlsur22(95) xnlsur22(96) xnlsur22(97) xnlsur22(98) xnlsur22(99) xnlsur22(100) xnlsur22(101) xnlsur22(102)];

transv=[1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

% %parameters
E3khat=transv'-(E3fhat'+E3mhat');
E4khat=transv'-(E4fhat'+E4mhat');
E5khat=transv'-(E5fhat'+E5mhat');

% %standard errors
for i=1:17;
stdEk3(i)=real((var_xnlsur2(i,i)+var_xnlsur2(i+17,i+17)+(2*var_xnlsur2(i,i+17)))^(1/2));
stdEk4(i)=real((var_xnlsur2(34+i,34+i)+var_xnlsur2(i+34+17,i+34+17)+(2*var_xnlsur2(i+34,i+34+17)))^(1/2));
stdEk5(i)=real((var_xnlsur2(68+i,68+i)+var_xnlsur2(i+68+17,i+68+17)+(2*var_xnlsur2(i+68,i+68+17)))^(1/2));
end;
 
tEk3=E3khat./stdEk3';
tEk4=E4khat./stdEk4';
tEk5=E5khat./stdEk5';


% %std_nlsur2 and t_nlsur for the latex table

results_p=[];
results_std=[];
results_t=[];

results_p=[xnlsur22 E3khat' E4khat' E5khat' fval22 0 0.4 0]; %parameter estimates
results_std=[std_xnlsur2;stdEk3';stdEk4';stdEk5';0;0;0;0]; %std 
results_t=[t_xnlsur; tEk3; tEk4; tEk5;0;0;0;0];





%%%%%GMM code starts from here%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%regress expenditures on insturments and get the predicted values%%%
x3regs=[constant dmednkids3 instlist3 x3_instlist];
x4regs=[constant dmednkids4 instlist4 x4_instlist];
x5regs=[constant dmednkids5 instlist5 x5_instlist];
x3hat=x3regs*inv(x3regs'*x3regs)*x3regs'*x3;
x4hat=x4regs*inv(x4regs'*x4regs)*x4regs'*x4;
x5hat=x5regs*inv(x5regs'*x5regs)*x5regs'*x5;

%%first step GMM estimation%%
xi3=xnlsur22;
options=optimoptions('fminunc','Display','iter','FunValCheck','off','MaxIter', 100000, 'MaxFunEvals',3000000000,'TolFun',1e-10, 'TolX',1e-10);
[xgmmi2,fvalg2,exitflag,output] = fminunc('gmmonestep_onecons',xi3,options); 
save xgmmi2;
save fvalg2_vuongtest;
 
var_gmm=vargmmonestep_onecons(xgmmi2);
std_xgmm=real(diag(var_gmm)).^(1/2); 
t_gmm=xgmmi2'./std_xgmm;


var_gmm_clus=vargmmonestep_clus_onecons(xgmmi2); 
std_xgmm_clus=real(diag(var_gmm_clus)).^(1/2);
t_gmm_clus=xgmmi2'./std_xgmm_clus;


%  Calculation of kid's parameters and their std deviations:
E3fhat_gmm=[xgmmi2(1) xgmmi2(2) xgmmi2(3) xgmmi2(4) xgmmi2(5) xgmmi2(6) xgmmi2(7) xgmmi2(8) xgmmi2(9) xgmmi2(10) xgmmi2(11) xgmmi2(12) xgmmi2(13) xgmmi2(14) xgmmi2(15) xgmmi2(16) xgmmi2(17)];
E3mhat_gmm=[xgmmi2(18) xgmmi2(19) xgmmi2(20) xgmmi2(21) xgmmi2(22) xgmmi2(23) xgmmi2(24) xgmmi2(25) xgmmi2(26) xgmmi2(27) xgmmi2(28) xgmmi2(29) xgmmi2(30) xgmmi2(31) xgmmi2(32) xgmmi2(33) xgmmi2(34)];
E4fhat_gmm=[xgmmi2(35) xgmmi2(36) xgmmi2(37) xgmmi2(38) xgmmi2(39) xgmmi2(40) xgmmi2(41) xgmmi2(42) xgmmi2(43) xgmmi2(44) xgmmi2(45) xgmmi2(46) xgmmi2(47) xgmmi2(48) xgmmi2(49) xgmmi2(50) xgmmi2(51)];
E4mhat_gmm=[xgmmi2(52) xgmmi2(53) xgmmi2(54) xgmmi2(55) xgmmi2(56) xgmmi2(57) xgmmi2(58) xgmmi2(59) xgmmi2(60) xgmmi2(61) xgmmi2(62) xgmmi2(63) xgmmi2(64) xgmmi2(65) xgmmi2(66) xgmmi2(67) xgmmi2(68)];
E5fhat_gmm=[xgmmi2(69) xgmmi2(70) xgmmi2(71) xgmmi2(72) xgmmi2(73) xgmmi2(74) xgmmi2(75) xgmmi2(76) xgmmi2(77) xgmmi2(78) xgmmi2(79) xgmmi2(80) xgmmi2(81) xgmmi2(82) xgmmi2(83) xgmmi2(84) xgmmi2(85)];
E5mhat_gmm=[xgmmi2(86) xgmmi2(87) xgmmi2(88) xgmmi2(89) xgmmi2(90) xgmmi2(91) xgmmi2(92) xgmmi2(93) xgmmi2(94) xgmmi2(95) xgmmi2(96) xgmmi2(97) xgmmi2(98) xgmmi2(99) xgmmi2(100) xgmmi2(101) xgmmi2(102)];


% %parameters
E3khat_gmm=transv'-(E3fhat_gmm'+E3mhat_gmm');
E4khat_gmm=transv'-(E4fhat_gmm'+E4mhat_gmm');
E5khat_gmm=transv'-(E5fhat_gmm'+E5mhat_gmm');

% %standard errors
for i=1:17;
stdEk3_gmm(i)=real((var_gmm(i,i)+var_gmm(i+17,i+17)+(2*var_gmm(i,i+17)))^(1/2));
stdEk4_gmm(i)=real((var_gmm(34+i,34+i)+var_gmm(i+34+17,i+34+17)+(2*var_gmm(i+34,i+34+17)))^(1/2));
stdEk5_gmm(i)=real((var_gmm(68+i,68+i)+var_gmm(i+68+17,i+68+17)+(2*var_gmm(i+68,i+68+17)))^(1/2));
end;

tEk3_gmm=E3khat_gmm./stdEk3_gmm';
tEk4_gmm=E4khat_gmm./stdEk4_gmm';
tEk5_gmm=E5khat_gmm./stdEk5_gmm';

for i=1:17;
stdEk3_gmm_c(i)=real((var_gmm_clus(i,i)+var_gmm_clus(i+17,i+17)+(2*var_gmm_clus(i,i+17)))^(1/2));
stdEk4_gmm_c(i)=real((var_gmm_clus(34+i,34+i)+var_gmm_clus(i+34+17,i+34+17)+(2*var_gmm_clus(i+34,i+34+17)))^(1/2));
stdEk5_gmm_c(i)=real((var_gmm_clus(68+i,68+i)+var_gmm_clus(i+68+17,i+68+17)+(2*var_gmm_clus(i+68,i+68+17)))^(1/2));
end;

tEk3_gmm_c=E3khat_gmm./stdEk3_gmm_c';
tEk4_gmm_c=E4khat_gmm./stdEk4_gmm_c';
tEk5_gmm_c=E5khat_gmm./stdEk5_gmm_c';

% %%%Hausman test%%%%%%%%

hausman2=real((xgmmi2-xnlsur22)*inv(var_xnlsur2-var_gmm)*(xgmmi2'-xnlsur22')); 
   %%distributed by chi-square with XXX= degrees of freedom. 
   %%10%,chi_square(54)=67.673, 5%chi_square(54)=72.15
hausman_clus=real((xgmmi2-xnlsur22)*inv(var_xnlsur2-var_gmm_clus)*(xgmmi2'-xnlsur22')); 
   

%std_nlsur2 and t_nlsur for the latex table
results_pgmm=[xgmmi2 E3khat_gmm' E4khat_gmm' E5khat_gmm' fval22 fvalg2 0.4 hausman2]; %parameter estimates
results_stdgmm=[std_xgmm;stdEk3_gmm';stdEk4_gmm';stdEk5_gmm'; 0; 0; 0.4 ;0]; %std 
results_tgmm=[t_gmm; tEk3_gmm; tEk4_gmm; tEk5_gmm; 0; 0; 0.4;0];

%results with clustered standard errors
results_stdgmm_clus=[std_xgmm_clus;stdEk3_gmm_c';stdEk4_gmm_c';stdEk5_gmm_c'; 0; 0; 0.4;0]; %std 
results_tgmm_clus=[t_gmm_clus; tEk3_gmm_c; tEk4_gmm_c; tEk5_gmm_c; 0; 0; 0.4;hausman_clus];  


%%Tests for joint significancy of progresa parameters%%%%%%%%%%
%%Males%%%
Rm=zeros(3,306);
Rm(1,20)=1;
Rm(2,54)=1;
Rm(3,88)=1;
test_progresa_m=(Rm*xgmmi2')'*inv(Rm*real(var_gmm_clus)*Rm')*(Rm*xgmmi2');

%%females%%%
Rf=zeros(3,306);
Rf(1,3)=1;
Rf(2,37)=1;
Rf(3,71)=1;
test_progresa_f=(Rf*xgmmi2')'*inv(Rf*real(var_gmm_clus)*Rf')*(Rf*xgmmi2');

%%Kids%%%
Rk=zeros(3,306);
Rk(1,3)=1;
Rk(1,20)=1;
Rk(2,37)=1;
Rk(2,54)=1;
Rk(3,71)=1;
Rk(3,88)=1;

test_progresa_k=(Rk*xgmmi2')'*inv(Rk*real(var_gmm_clus)*Rk')*(Rk*xgmmi2');
%%chi-sq(3) critical value 7.815 at 95% and 6.251 at 90%


%%period 1%%%
R3=zeros(2,306);
R3(1,3)=1;
R3(2,20)=1;

rtime=zeros(2,1);
test_progresa_1=(R3*xgmmi2'-rtime)'*inv(R3*real(var_gmm_clus)*R3')*(R3*xgmmi2'-rtime);


%%%period 2%%%
R4=zeros(2,306);
R4(1,37)=1;
R4(2,54)=1;

test_progresa_2=(R4*xgmmi2'-rtime)'*inv(R4*real(var_gmm_clus)*R4')*(R4*xgmmi2'-rtime);


%%period 3%%%
R5=zeros(2,306);
R5(1,71)=1;
R5(2,88)=1;

test_progresa_3=(R5*xgmmi2'-rtime)'*inv(R5*real(var_gmm_clus)*R5')*(R5*xgmmi2'-rtime);

%%all periods and everyone
Rall=zeros(6,306);
Rall(1,3)=1;
Rall(2,20)=1;
Rall(3,37)=1;
Rall(4,54)=1;
Rall(5,71)=1;
Rall(6,88)=1;
test_progresa_all=(Rall*xgmmi2')'*inv(Rall*real(var_gmm_clus)*Rall')*(Rall*xgmmi2');

%%Tests for equality of progresa parameters across time for different
%%individuals

%%%Female%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%period 1 and 2%%%%%%%
Rf12=zeros(1,306);
Rf12(1,3)=1;
Rf12(1,37)=-1;

test_progresa_f12=(Rf12*xgmmi2')'*inv(Rf12*real(var_gmm)*Rf12')*(Rf12*xgmmi2')

%%period 1 and 3%%%%%%%
Rf13=zeros(1,306);
Rf13(1,3)=1;
Rf13(1,71)=-1;
test_progresa_f13=(Rf13*xgmmi2')'*inv(Rf13*real(var_gmm)*Rf13')*(Rf13*xgmmi2')

%%period 2 and 3%%%%%%%
Rf23=zeros(1,306);
Rf23(1,37)=1;
Rf23(1,71)=-1;
test_progresa_f23=(Rf23*xgmmi2')'*inv(Rf23*real(var_gmm)*Rf23')*(Rf23*xgmmi2')


%%%Male%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%period 1 and 2%%%%%%%
Rm12=zeros(1,306);
Rm12(1,20)=1;
Rm12(1,54)=-1;
test_progresa_m12=(Rm12*xgmmi2')'*inv(Rm12*real(var_gmm)*Rm12')*(Rm12*xgmmi2')

%%period 1 and 3%%%%%%%
Rm13=zeros(1,306);
Rm13(1,20)=1;
Rm13(1,88)=-1;
test_progresa_m13=(Rm13*xgmmi2')'*inv(Rm13*real(var_gmm)*Rm13')*(Rm13*xgmmi2')

%%period 2 and 3%%%%%%%
Rm23=zeros(1,306);
Rm23(1,54)=1;
Rm23(1,88)=-1;
test_progresa_m23=(Rm23*xgmmi2')'*inv(Rm23*real(var_gmm)*Rm23')*(Rm23*xgmmi2')

%%%Kids%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%period 1 and 2%%%%%%%
Rk12=zeros(1,306);
Rk12(1,3)=1;
Rk12(1,20)=1;
Rk12(1,37)=-1;
Rk12(1,54)=-1;

test_progresa_k12=(Rk12*xgmmi2')'*inv(Rk12*real(var_gmm)*Rk12')*(Rk12*xgmmi2')

%%period 1 and 3%%%%%%%
Rk13=zeros(1,306);
Rk13(1,3)=1;
Rk13(1,20)=1;
Rk13(1,71)=-1;
Rk13(1,88)=-1;

test_progresa_k13=(Rk13*xgmmi2')'*inv(Rk13*real(var_gmm)*Rk13')*(Rk13*xgmmi2')

%%period 2 and 3%%%%%%%
Rk23=zeros(1,306);
Rk23(1,37)=1;
Rk23(1,54)=1;
Rk23(1,71)=-1;
Rk23(1,88)=-1;
test_progresa_k23=(Rk23*xgmmi2')'*inv(Rk23*real(var_gmm)*Rk23')*(Rk23*xgmmi2')
%%chi-sq(3) critical value 7.815 at 95% and 6.251 at 90%

%%%Test for joint significancy of beta_nokids parameters (SAT)%%%
Rbetak=zeros(3,306);
Rbetak(1,263)=1;
Rbetak(2,280)=1;
Rbetak(3,297)=1;
test_betak=(Rbetak*xgmmi2')'*inv(Rbetak*real(var_gmm_clus)*Rbetak')*(Rbetak*xgmmi2')

% %%%%Test for equality of beta parameters across individuals (SAT)%%%%

Rbeta=zeros(34,306);
for i=1:17;
    Rbeta(i,i+255)=1;
    Rbeta(i,i+272)=-1;
    Rbeta(i+17,i+255)=1;
    Rbeta(i+17,i+289)=-1;
end
test_beta=(Rbeta*xgmmi2')'*inv(Rbeta*real(var_gmm_clus)*Rbeta')*(Rbeta*xgmmi2')

%%Chi-square(34)=48.602, Chi-square(51)=68.669 both at 95% level

%%%%%to make latex tables%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

parameters_e3f=['constant-e3f      ';'dmednkids3-e3f    ';'treated-e3f       ';'dmeduchead-e3f    ';'dmeducspouse-e3f  ';'dmagehead3-e3f    ';'dmagespouse3-e3f  ';'dmshare-girls3-e3f';'dmchildage3-e3f   ';'indi-e3f          ';'drought3-e3f      ';'state1-e3f        ';'state2-e3f        ';'state3-e3f        ';'state4-e3f        ';'state5-e3f        ';'state6-e3f        '];
parameters_e3m=['constant-e3m      ';'dmednkids3-e3m    ';'treated-e3m       ';'dmeduchead-e3m    ';'dmeducspouse-e3m  ';'dmagehead3-e3m    ';'dmagespouse3-e3m  ';'dmshare-girls3-e3m';'dmchildage3-e3m   ';'indi-e3m          ';'drought3-e3m      ';'state1-e3m        ';'state2-e3m        ';'state3-e3m        ';'state4-e3m        ';'state5-e3m        ';'state6-e3m        '];
parameters_e4f=['constant-e4f      ';'dmednkids4-e4f    ';'treated-e4f       ';'dmeduchead-e4f    ';'dmeducspouse-e4f  ';'dmagehead4-e4f    ';'dmagespouse4-e4f  ';'dmshare-girls4-e4f';'dmchildage4-e4f   ';'indi-e4f          ';'drought4-e4f      ';'state1-e4f        ';'state2-e4f        ';'state3-e4f        ';'state4-e4f        ';'state5-e4f        ';'state6-e4f        '];
parameters_e4m=['constant-e4m      ';'dmednkids4-e4m    ';'treated-e4m       ';'dmeduchead-e4m    ';'dmeducspouse-e4m  ';'dmagehead4-e4m    ';'dmagespouse4-e4m  ';'dmshare-girls4-e4m';'dmchildage4-e4m   ';'indi-e4m          ';'drought4-e4m      ';'state1-e4m        ';'state2-e4m        ';'state3-e4m        ';'state4-e4m        ';'state5-e4m        ';'state6-e4m        '];
parameters_e5f=['constant-e5f      ';'dmednkids5-e5f    ';'treated-e5f       ';'dmeduchead-e5f    ';'dmeducspouse-e5f  ';'dmagehead5-e5f    ';'dmagespouse5-e5f  ';'dmshare-girls5-e5f';'dmchildage5-e5f   ';'indi-e5f          ';'drought5-e5f      ';'state1-e5f        ';'state2-e5f        ';'state3-e5f        ';'state4-e5f        ';'state5-e5f        ';'state6-e5f        '];
parameters_e5m=['constant-e5m      ';'dmednkids5-e5m    ';'treated-e5m       ';'dmeduchead-e5m    ';'dmeducspouse-e5m  ';'dmagehead5-e5m    ';'dmagespouse5-e5m  ';'dmshare-girls5-e5m';'dmchildage5-e5m   ';'indi-e5m          ';'drought5-e5m      ';'state1-e5m        ';'state2-e5m        ';'state3-e5m        ';'state4-e5m        ';'state5-e5m        ';'state6-e5m        '];
parameters_a3f=['state1-a3f        ';'state2-a3f        ';'state3-a3f        ';'state4-a3f        ';'state5-a3f        ';'state6-a3f        ';'constant-a3f      ';'dmednkids3-a3f    ';'dmagehead3-a3f    ';'dmagespouse3-a3f  ';'dmeduchead-a3f    ';'dmeducspouse-a3f  ';'dmshare-girls3-a3f';'dmchildage3-a3f   ';'treated-a3f       ';'indi-a3f          ';'drought3-a3f      '];
parameters_a3m=['state1-a3m        ';'state2-a3m        ';'state3-a3m        ';'state4-a3m        ';'state5-a3m        ';'state6-a3m        ';'constant-a3m      ';'dmednkids3-a3m    ';'dmagehead3-a3m    ';'dmagespouse3-a3m  ';'dmeduchead-a3m    ';'dmeducspouse-a3m  ';'dmshare-girls3-a3m';'dmchildage3-a3m   ';'treated-a3m       ';'indi-a3m          ';'drought3-a3m      '];
parameters_a3k=['state1-a3k        ';'state2-a3k        ';'state3-a3k        ';'state4-a3k        ';'state5-a3k        ';'state6-a3k        ';'constant-a3k      ';'dmednkids3-a3k    ';'dmagehead3-a3k    ';'dmagespouse3-a3k  ';'dmeduchead-a3k    ';'dmeducspouse-a3k  ';'dmshare-girls3-a3k';'dmchildage3-a3k   ';'treated-a3k       ';'indi-a3k          ';'drought3-a3k      '];
parameters_a4f=['state1-a4f        ';'state2-a4f        ';'state3-a4f        ';'state4-a4f        ';'state5-a4f        ';'state6-a4f        ';'constant-a4f      ';'dmednkids4-a4f    ';'dmagehead4-a4f    ';'dmagespouse4-a4f  ';'dmeduchead-a4f    ';'dmeducspouse-a4f  ';'dmshare-girls4-a4f';'dmchildage4-a4f   ';'treated-a4f       ';'indi-a4f          ';'drought4-a4f      '];
parameters_a4m=['state1-a4m        ';'state2-a4m        ';'state3-a4m        ';'state4-a4m        ';'state5-a4m        ';'state6-a4m        ';'constant-a4m      ';'dmednkids4-a4m    ';'dmagehead4-a4m    ';'dmagespouse4-a4m  ';'dmeduchead-a4m    ';'dmeducspouse-a4m  ';'dmshare-girls4-a4m';'dmchildage4-a4m   ';'treated-a4m       ';'indi-a4m          ';'drought4-a4m      '];
parameters_a4k=['state1-a4k        ';'state2-a4k        ';'state3-a4k        ';'state4-a4k        ';'state5-a4k        ';'state6-a4k        ';'constant-a4k      ';'dmednkids4-a4k    ';'dmagehead4-a4k    ';'dmagespouse4-a4k  ';'dmeduchead-a4k    ';'dmeducspouse-a4k  ';'dmshare-girls4-a4k';'dmchildage4-a4k   ';'treated-a4k       ';'indi-a4k          ';'drought4-a4k      '];
parameters_a5f=['state1-a5f        ';'state2-a5f        ';'state3-a5f        ';'state4-a5f        ';'state5-a5f        ';'state6-a5f        ';'constant-a5f      ';'dmednkids5-a5f    ';'dmagehead5-a5f    ';'dmagespouse5-a5f  ';'dmeduchead-a5f    ';'dmeducspouse-a5f  ';'dmshare-girls5-a5f';'dmchildage5-a5f   ';'treated-a5f       ';'indi-a5f          ';'drought5-a5f      '];
parameters_a5m=['state1-a5m        ';'state2-a5m        ';'state3-a5m        ';'state4-a5m        ';'state5-a5m        ';'state6-a5m        ';'constant-a5m      ';'dmednkids5-a5m    ';'dmagehead5-a5m    ';'dmagespouse5-a5m  ';'dmeduchead-a5m    ';'dmeducspouse-a5m  ';'dmshare-girls5-a5m';'dmchildage5-a5m   ';'treated-a5m       ';'indi-a5m          ';'drought5-a5m      '];
parameters_a5k=['state1-a5k        ';'state2-a5k        ';'state3-a5k        ';'state4-a5k        ';'state5-a5k        ';'state6-a5k        ';'constant-a5k      ';'dmednkids5-a5k    ';'dmagehead5-a5k    ';'dmagespouse5-a5k  ';'dmeduchead-a5k    ';'dmeducspouse-a5k  ';'dmshare-girls5-a5k';'dmchildage5-a5k   ';'treated-a5k       ';'indi-a5k          ';'drought5-a5k      '];

parameters_bf=['state1-bf         ';'state2-bf         ';'state3-bf         ';'state4-bf         ';'state5-bf         ';'state6-bf         ';'constant-bf       ';'dmednkids5-bf     ';'dmagehead5-bf     ';'dmagespouse5-bf   ';'dmeduchead-bf     ';'dmeducspouse-bf   ' ;'dmshare-girls5-bf ';'dmchildage5-bf    ';'treated-bf        ';'indi-bf           ';'drought5-bf       '];
parameters_bm=['state1-bm         ';'state2-bm         ';'state3-bm         ';'state4-bm         ';'state5-bm         ';'state6-bm         ';'constant-bm       ';'dmednkids5-bm     ';'dmagehead5-bm     ';'dmagespouse5-bm   ';'dmeduchead-bm     ';'dmeducspouse-bm   ' ;'dmshare-girls5-bm ';'dmchildage5-bm    ';'treated-bm        ' ;'indi-bm           ';'drought5-bm       '];
parameters_bk=['state1-bk         ';'state2-bk         ';'state3-bk         ';'state4-bk         ';'state5-bk         ';'state6-bk         ';'constant-bk       ';'dmednkids5-bk     ';'dmagehead5-bk     ';'dmagespouse5-bk   ';'dmeduchead-bk     ';'dmeducspouse-bk   ' ;'dmshare-girls5-bk ';'dmchildage5-bk    ';'treated-bk        ' ;'indi-bk           ';'drought5-bk       '];


parameters_e3k=['constant-e3k      ';'dmednkids3-e3k    ';'treated-e3k       ';'dmeduchead-e3k    ';'dmeducspouse-e3k  ';'dmagehead3-e3k    ';'dmagespouse3-e3k  ';'dmshare-girls3-e3k';'dmchildage3-e3k   ';'indi-e3k          ';'drought3-e3k      ';'state1-e3k        ';'state2-e3k        ';'state3-e3k        ';'state4-e3k        ';'state5-e3k        ';'state6-e3k        '];
parameters_e4k=['constant-e4k      ';'dmednkids4-e4k    ';'treated-e4k       ';'dmeduchead-e4k    ';'dmeducspouse-e4k  ';'dmagehead4-e4k    ';'dmagespouse4-e4k  ';'dmshare-girls4-e4k';'dmchildage4-e4k   ';'indi-e4k          ';'drought4-e4k      ';'state1-e4k        ';'state2-e4k        ';'state3-e4k        ';'state4-e4k        ';'state5-e4k        ';'state6-e4k        '];
parameters_e5k=['constant-e5k      ';'dmednkids5-e5k    ';'treated-e5k       ';'dmeduchead-e5k    ';'dmeducspouse-e5k  ';'dmagehead5-e5k    ';'dmagespouse5-e5k  ';'dmshare-girls5-e5k';'dmchildage5-e5k   ';'indi-e5k          ';'drought5-e5k      ';'state1-e5k        ';'state2-e5k        ';'state3-e5k        ';'state4-e5k        ';'state5-e5k        ';'state6-e5k        '];

%to add fvalues and starting values to the graph

fvalue_nlsur=['fvalue nlsur      '];
fvalue_gmm=['fvalue gmm        '];
initial_v=['initial value     '];
hausman=['hausman test      '];

parameters=[parameters_e3f;parameters_e3m;parameters_e4f;parameters_e4m;parameters_e5f;parameters_e5m;parameters_a3f;parameters_a3m;parameters_a3k;parameters_a4f;parameters_a4m;parameters_a4k;parameters_a5f;parameters_a5m;parameters_a5k;parameters_bf;parameters_bm;parameters_bk;parameters_e3k;parameters_e4k;parameters_e5k;fvalue_nlsur;fvalue_gmm;initial_v;hausman];



%%%%%%%%%%%%%%%%%%%%%%%%%table for nlsur%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


fid=fopen('filenlsur_finalrobustFeb18.tex','w');
fprintf(fid,'\\documentclass{article}');
fprintf(fid,'\\begin{document}');
fprintf(fid,'\\begin{tabular}{l|c|c|c|}\\hline \n');
fprintf(fid,'\\multicolumn{7}{c}{NLSUR Estimation Results} \\\\ \\hline\n');
fprintf(fid,'&Estimate&Std Dev&t-stat\\\\ \\hline\n');
for k=1:length(xi)+3*length(E4fhat)+4;
    fprintf(fid, '%s & %8.3f & %8.3f & %8.2f \\\\ ', parameters(k,:), results_p(k), results_std(k), results_t(k,:));
    if k==length(xi)+3*length(E4fhat)+4;
        fprintf(fid, '\\hline ');
    end
    fprintf(fid, '\n');
end
 
fprintf(fid, '\\end{tabular}\n');
fclose(fid);

%create .csv table to ease editing

m1 = [parameters];
m2 = [results_p' results_std results_t];

csvwrite('nlsur_resultsnames_finalrobustFeb18.dat',m1);
csvwrite('nlsur_resultsres_finalrobustFeb18.dat',m2);
type nlsur_resultsnames_finalrobustFeb18.dat;
type nlsur_resultsres_finalrobustFeb18.dat;


%%%%%%%%%%%%%%%%%%%%%%%%%table for gmm%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fid=fopen('filegmm_finalrobustFeb18.tex','w');
fprintf(fid,'\\documentclass{article}');
fprintf(fid,'\\begin{document}');
fprintf(fid,'\\begin{tabular}{l|c|c|c|}\\hline \n');
fprintf(fid,'\\multicolumn{7}{c}{GMM Estimation Results, start val=xi(1,1), fval=fvalg2} \\\\ \\hline\n');
fprintf(fid,'&Estimate&Std Dev&t-stat\\\\ \\hline\n');
for k=1:length(xi)+3*length(E4fhat)+4;
    fprintf(fid, '%s & %8.5f & %8.5f & %8.5f & %8.5f & %8.5f \\\\ ', parameters(k,:), results_pgmm(k), results_stdgmm(k), results_tgmm(k,:), results_stdgmm_clus(k), results_tgmm_clus(k,:));
    if k==length(xi)+3*length(E4fhat)+4;
        fprintf(fid, '\\hline ');
    end
    fprintf(fid, '\n');
end
 
fprintf(fid, '\\end{tabular}\n');
fclose(fid);



m1_gmm = [parameters];
m2_gmm = [results_pgmm' results_stdgmm results_tgmm];

csvwrite('gmm_resultsnames_finalrobustFeb18.dat',m1_gmm);
csvwrite('gmm_resultsres_finalrobustFeb18.dat',m2_gmm);
type gmm_resultsnames_finalrobustFeb18.dat;
type gmm_resultsres_finalrobustFeb18.dat;


%%%%To export results to xlsx%%%%%
eta3fres=repmat(E3fhat_gmm,size(x3,1),1);
eta3mres=repmat(E3mhat_gmm,size(x3,1),1);
eta3kres=repmat(E3khat_gmm',size(x3,1),1);
eta4fres=repmat(E4fhat_gmm,size(x3,1),1);
eta4mres=repmat(E4mhat_gmm,size(x3,1),1);
eta4kres=repmat(E4khat_gmm',size(x3,1),1);
eta5fres=repmat(E5fhat_gmm,size(x3,1),1);
eta5mres=repmat(E5mhat_gmm,size(x3,1),1);
eta5kres=repmat(E5khat_gmm',size(x3,1),1);

resi=fittedonestep_onecons(xgmmi2);
res=resi(:,1:15);

eta3k_nlsur=[eta_k3list eta_z3list];
eta4k_nlsur=[eta_k4list eta_z4list];
eta5k_nlsur=[eta_k5list eta_z5list];

e3k=E3khat_gmm'*eta3k_nlsur';
e4k=E4khat_gmm'*eta4k_nlsur';
e5k=E5khat_gmm'*eta5k_nlsur';

resultmatrix=[eta3fres eta3mres eta3kres eta4fres eta4mres eta4kres eta5fres eta5mres eta5kres res e3k' e4k' e5k' folio];

filename='results_finalrobustFeb18.xlsx';
xlswrite(filename,resultmatrix,1,'A2');
C1={'constant-e3f','dmednkids3-e3f','treated-e3f','dmeduchead-e3f','dmeducspouse-e3f','dmagehead3-e3f','dmagespouse3-e3f','dmshare-girls3-e3f','dmchildage3-e3f','indi-e3f ','drought3-e3f ','state1-e3f ','state2-e3f ','state3-e3f ','state4-e3f ','state5-e3f ','state6-e3f','constant-e3m','dmednkids3-e3m','treated-e3m','dmeduchead-e3m','dmeducspouse-e3m','dmagehead3-e3m','dmagespouse3-e3m','dmshare-girls3-e3m','dmchildage3-e3m','indi-e3m ','drought3-e3m ','state1-e3m ','state2-e3m ','state3-e3m ','state4-e3m ','state5-e3m ','state6-e3m','constant-e3k','dmednkids3-e3k','treated-e3k','dmeduchead-e3k','dmeducspouse-e3k','dmagehead3-e3k','dmagespouse3-e3k','dmshare-girls3-e3k','dmchildage3-e3k','indi-e3k ','drought3-e3k ','state1-e3k ','state2-e3k ','state3-e3k ','state4-e3k ','state5-e3k ','state6-e3k'};
% C2={'constant-e3m','dmednkids3-e3m','treated-e3m','dmeduchead-e3m','dmeducspouse-e3m','dmagehead3-e3m','dmagespouse3-e3m','dmshare-girls3-e3m','dmchildage3-e3m','indi-e3m ','drought3-e3m ','state1-e3m ','state2-e3m ','state3-e3m ','state4-e3m ','state5-e3m ','state6-e3m'};
% C3={'constant-e3k','dmednkids3-e3k','treated-e3k','dmeduchead-e3k','dmeducspouse-e3k','dmagehead3-e3k','dmagespouse3-e3k','dmshare-girls3-e3k','dmchildage3-e3k','indi-e3k ','drought3-e3k ','state1-e3k ','state2-e3k ','state3-e3k ','state4-e3k ','state5-e3k ','state6-e3k'};
C4={'constant-e4f','dmednkids3-e4f','treated-e4f','dmeduchead-e4f','dmeducspouse-e4f','dmagehead3-e4f','dmagespouse3-e4f','dmshare-girls3-e4f','dmchildage3-e4f','indi-e4f ','drought3-e4f ','state1-e4f ','state2-e4f ','state3-e4f ','state4-e4f ','state5-e4f ','state6-e4f','constant-e4m','dmednkids3-e4m','treated-e4m','dmeduchead-e4m','dmeducspouse-e4m','dmagehead3-e4m','dmagespouse3-e4m','dmshare-girls3-e4m','dmchildage3-e4m','indi-e4m ','drought3-e4m ','state1-e4m ','state2-e4m ','state3-e4m ','state4-e4m ','state5-e4m ','state6-e4m','constant-e4k','dmednkids3-e4k','treated-e4k','dmeduchead-e4k','dmeducspouse-e4k','dmagehead3-e4k','dmagespouse3-e4k','dmshare-girls3-e4k','dmchildage3-e4k','indi-e4k ','drought3-e4k ','state1-e4k ','state2-e4k ','state3-e4k ','state4-e4k ','state5-e4k ','state6-e4k'};
% C5={'constant-e4m','dmednkids3-e4m','treated-e4m','dmeduchead-e4m','dmeducspouse-e4m','dmagehead3-e4m','dmagespouse3-e4m','dmshare-girls3-e4m','dmchildage3-e4m','indi-e4m ','drought3-e4m ','state1-e4m ','state2-e4m ','state3-e4m ','state4-e4m ','state5-e4m ','state6-e4m'};
% C6={'constant-e4k','dmednkids3-e4k','treated-e4k','dmeduchead-e4k','dmeducspouse-e4k','dmagehead3-e4k','dmagespouse3-e4k','dmshare-girls3-e4k','dmchildage3-e4k','indi-e4k ','drought3-e4k ','state1-e4k ','state2-e4k ','state3-e4k ','state4-e4k ','state5-e4k ','state6-e4k'};
C7={'constant-e5f','dmednkids3-e5f','treated-e5f','dmeduchead-e5f','dmeducspouse-e5f','dmagehead3-e5f','dmagespouse3-e5f','dmshare-girls3-e5f','dmchildage3-e5f','indi-e5f ','drought3-e5f ','state1-e5f ','state2-e5f ','state3-e5f ','state4-e5f ','state5-e5f ','state6-e5f','constant-e5m','dmednkids3-e5m','treated-e5m','dmeduchead-e5m','dmeducspouse-e5m','dmagehead3-e5m','dmagespouse3-e5m','dmshare-girls3-e5m','dmchildage3-e5m','indi-e5m ','drought3-e5m ','state1-e5m ','state2-e5m ','state3-e5m ','state4-e5m ','state5-e5m ','state6-e5m','constant-e5k','dmednkids3-e5k','treated-e5k','dmeduchead-e5k','dmeducspouse-e5k','dmagehead3-e5k','dmagespouse3-e5k','dmshare-girls3-e5k','dmchildage3-e5k','indi-e5k ','drought3-e5k ','state1-e5k ','state2-e5k ','state3-e5k ','state4-e5k ','state5-e5k ','state6-e5k'};
% C8={'constant-e5m','dmednkids3-e5m','treated-e5m','dmeduchead-e5m','dmeducspouse-e5m','dmagehead3-e5m','dmagespouse3-e5m','dmshare-girls3-e5m','dmchildage3-e5m','indi-e5m ','drought3-e5m ','state1-e5m ','state2-e5m ','state3-e5m ','state4-e5m ','state5-e5m ','state6-e5m'};
% C9={'constant-e5k','dmednkids3-e5k','treated-e5k','dmeduchead-e5k','dmeducspouse-e5k','dmagehead3-e5k','dmagespouse3-e5k','dmshare-girls3-e5k','dmchildage3-e5k','indi-e5k ','drought3-e5k ','state1-e5k ','state2-e5k ','state3-e5k ','state4-e5k ','state5-e5k ','state6-e5k'};
C10={'sf3hat','sm3hat','sk3hat','sf4hat', 'sm4hat', 'sk4hat', 'sf5hat', 'sm5hat', 'sk5hat', 'ef3', 'em3','ef4','em4','ef5','em5','ek3', 'ek4', 'ek5', 'folio'};


xlswrite(filename,C1,1,'A1');
xlswrite(filename,C4,1,'AZ1');
xlswrite(filename,C7,1,'CY1');
xlswrite(filename,C10,1,'EX1');




duree=toc ;
disp(['Duration = ',num2str(duree),' secondes']);