
libname work2  "O:\desktop_pc_office\projects\jmpaperrevisiondata";
run;


proc model data=work2.full2; /*Third order polynomial for reader demand*/
parms a0 a1 a2 a3 b t0 t1 t2 g;
eq.reader=log((1-nr)/nr)-(a0+a1*na2+a2*(na2**2)+a3*(na2**3)+b*dailyprice);
eq.advertiser=log((1-na2)/na2)-(t0+t1*nr+t2*(nr**2)+g*m_peri);

retail2=log(Retail_sales)**2;
retailpera=Retail_sales/Land_area;
retail3=log(retail_sales)**3;



fit reader advertiser / gmm outest=regres1 out=est1 /*outresid*/;

instruments (reader, c Retail_sales Land_area per_square_mile wpaper  Female  White_alone Retail_sales_per_capita Homeownership_rate  Housing_units wage_in_printing  retail2 retailpera retail3)  
(advertiser, c wage_in_printing below_poverty Land_area wprinting Female under_18  Retail_sales_per_capita White_alone Asian_alone per_square_mile  Homeownership_rate  High_school_or_higher);

phihat=a0+(a1*na2)+a2*(na2**2)+a3*(na2**3);
psihat=t0+(t1*nr)+t2*(nr**2);
outvars paper psihat phihat;
run;
quit;

proc model data=work2.full2; /*linear model*/
parms a0 a1 a2 a3 b t0 t1 t2 g;
eq.reader=log((1-nr)/nr)-(a0+a1*na2+b*dailyprice);
eq.advertiser=log((1-na2)/na2)-(t0+t1*nr+g*m_peri);


fit reader advertiser / gmm  out=est2 outresid;

instruments (reader, c Retail_sales Land_area per_square_mile wpaper  Female  White_alone Retail_sales_per_capita) 
(advertiser, c wage_in_printing below_poverty Land_area wprinting Female under_18  Retail_sales_per_capita White_alone Asian_alone  per_square_mile Homeownership_rate);
quit;


proc model data=work2.full2; /*Robustness with added explanatory variables*/
parms a0 a1 a2 a3 b t0 t1 t2 g;
eq.reader=log((1-nr)/nr)-(a0+a1*na2+a2*(na2**2)+a3*(na2**3)+b*dailyprice+a4*avr_page_number_per_issue_wd);
eq.advertiser=log((1-na2)/na2)-(t0+t1*nr+t2*(nr**2)+g*m_peri+t3*Female);

retail2=log(Retail_sales)**2;
retailpera=Retail_sales/Land_area;
retail3=log(retail_sales)**3;
landh=Land_area/Households;
landhu=Land_area/Housing_units;
retailf=Retail_sales/Female;
wpaper2=wpaper**2;
wagep2=wage_in_printing**2;
wageplog=log(wage_in_printing);

fit reader advertiser / gmm  out=est3 outresid;

instruments (reader, c Retail_sales Land_area per_square_mile wpaper  Female  White_alone Retail_sales_per_capita Homeownership_rate  Housing_units wage_in_printing  retail2 retailpera retail3 landh wpaper2 wagep2 )  
(advertiser, c wage_in_printing below_poverty Land_area wprinting Female under_18  Retail_sales_per_capita White_alone Asian_alone per_square_mile  Homeownership_rate  High_school_or_higher  );

run;
quit;

proc model data=work2.full2; /*Robustness with added explanatory variables no added varaible to reader demand eqn*/
parms a0 a1 a2 a3 b t0 t1 t2 g;
eq.reader=log((1-nr)/nr)-(a0+a1*na2+a2*(na2**2)+a3*(na2**3)+b*dailyprice);
eq.advertiser=log((1-na2)/na2)-(t0+t1*nr+t2*(nr**2)+g*m_peri+t3*Female);

retail2=log(Retail_sales)**2;
retailpera=Retail_sales/Land_area;
retail3=log(retail_sales)**3;
landh=Land_area/Households;
landhu=Land_area/Housing_units;
retailf=Retail_sales/Female;
wpaper2=wpaper**2;
wagep2=wage_in_printing**2;
wageplog=log(wage_in_printing);

fit reader advertiser / gmm  out=est3 outresid;

instruments (reader, c Retail_sales Land_area per_square_mile wpaper  Female  White_alone Retail_sales_per_capita Homeownership_rate  Housing_units wage_in_printing  retail2 retailpera retail3 landh wpaper2 wagep2 )  
(advertiser, c wage_in_printing below_poverty Land_area wprinting Female under_18  Retail_sales_per_capita White_alone Asian_alone per_square_mile  Homeownership_rate  High_school_or_higher  );

run;
quit;
