%  This program generates Data Set for Simar and Zelenyuk (2003)
%  assuming same truncated normal dist for inefficiencies for both groups

close all
clear all

% Define the sub-sample sizes
na=100;     nb=100;     n=na+nb;    nobs=[1:n]';

% Define the parameters for distributions of X (inputs) (beta dist)
alfa_XA = 1;    beta_XA = 1;
alfa_XB = 1;    beta_XB = 1;

% Generate the Data for both subsamples
XA = betarnd(alfa_XA, beta_XA, na, 1) ;    
XB = betarnd(alfa_XB, beta_XB, nb, 1) ;    

Yt1A = unifrnd(0.2, 1, na, 1) ;       Yt1B = unifrnd(0.2, 1, nb, 1) ;      

% xa=sort(XA(:,1));       fua=betapdf(xa, alfa_XA, beta_XA);
% xb=sort(XB(:,1));       fub=betapdf(xb, alfa_XB, beta_XB);
%     figure 
%         plot(xa, fua, '-', xb, fub, ':');
%             title('Densities of X1 for both groups');

Yt1 = [Yt1A ; Yt1B];            X = [XA ;  XB] ;

% *******************************************************************************
% computation of efficient outputs (PRODUCTION FUNCTION)
% *******************************************************************************
    Y1=X(:,1) .^ 0.5 ;
% *******************************************************************************
            
Y1A = Y1(1 : na);               Y1B = Y1(na+1 : na+nb);     

% *******************************************************************************
% generation of inefficiency for both groups 
% ********************************************************************************

% Generate eff for Group B  
mu2 = 0;                        s2 = 1.4*(1-XB).^2;    % heteroskedastic
        
[u2, fu2] = TruncNormGenerator(nb,mu2,s2);
    vB = 1+u2;    

    [u2sort, i2] = sort(u2);     
        fu2sort=fu2(i2);  

% Generate eff for Group A  
mu1 = 0.25;                 s1 = 0.2*ones(na,1)  %*(XA(:,1));    

[u1, fu1] = TruncNormGenerator(na,mu1,s1);
    vA = 1+u1;    


% *******************************************************************************
 % Estimation of densities of TRUE efficiencies given above (with reflection)
% *******************************************************************************
 
nx=na;      ny=nb;
ref_x= sort([vA ; 2-vA]) ;  ref_y= sort([vB ; 2-vB]) ;         

    hx = Sh_J_Run(ref_x) ; 
    hy = Sh_J_Run(ref_y) ; 

    Kxx = Nkernel_Li(ref_x,ref_x,hx);       Kyy = Nkernel_Li(ref_y,ref_y,hy);
    fhatx = sum(Kxx,2)/(nx*hx);             fhaty = sum(Kyy,2)/(ny*hy);
        

    % projecting inside the output set: to get ineff. level of outputs, according to 
        % the assigned distriutions of inefficiency

YA = Y1A ./ vA ;          YB = Y1B ./ vB ;


Y = [YA ; YB];

% *********************************************************************
%   Plot the observations production function and its DEA estimate
% *********************************************************************

x= sort(X(:,1));

y= x .^ 0.5;
    figure 
        plot(XA,YA,'gd', XB,YB,'x', x,y, '-');    



% % *********************************************************************
% % DEA with the original data set
%************************************************************************

rts='VRS';      ori='O';        prdl='D';

eff = deasel(X,Y,ori,rts,prdl);
    eff1 = eff(1 : na);         eff2 = eff(na+1 : na+nb);


% *******************************************************************************    
% Estimation of densities of ESTIMATED (with DEA) efficiencies
    % REFLECTION
% DELETE ones, many of which might be spureous    
    eff1m=eff1(eff1>1);                    eff2m=eff2(eff2>1);
    [nx,pm]=size(eff1m);                   [ny,pm]=size(eff2m);
    
 ref_x_dea= sort([eff1m ; 2-eff1m]) ;        ref_y_dea= sort([eff2m ; 2-eff2m]) ;         
 
  %  ref_x_dea= sort(eff1) ;        ref_y_dea= sort(eff2) ;    % No REFLECTION


     hx = Sh_J_Run(ref_x_dea) ; 
     hy = Sh_J_Run(ref_y_dea) ;

% Ploting Est densities of DEA-ESTIMATED efficiencies

        Kxx = Nkernel_Li(ref_x_dea,ref_x_dea,hx);   Kyy = Nkernel_Li(ref_y_dea,ref_y_dea,hy);
        
        fhatx_dea = sum(Kxx,2)/(nx*hx);             fhaty_dea = sum(Kyy,2)/(ny*hy);
        
        figure
             subplot(2,2,1), plot(ref_x, fhatx, '-' , ref_y, fhaty, '-.');            
                 title('EST densities of Eff in A and Z')
                    axis([1.00  2  0  max(max(fhatx), max(fhaty))*1.1])
             subplot(2,2,2), plot(ref_x_dea, fhatx_dea, ref_y_dea, fhaty_dea);
                 title('EST densities of DEA-EST efficiencies')
                    axis([1  2  0  max(max(fhatx_dea), max(fhaty_dea))*1.5]);
             subplot(2,2,3), plot(ref_x, fhatx, '-' , ref_x_dea, fhatx_dea, '-.');    
                 title('Est Dens of TRUE vs Est of DEA eff of A')
                    axis([1  2  0  max(max(fhatx_dea), max(fhaty_dea))*1.5]);
             subplot(2,2,4), plot(ref_y, fhaty, '-' , ref_y_dea, fhaty_dea, '-.');            
                 title('Est Dens of TRUE vs Est of DEA eff of Z ')
                    axis([1  2  0  max(max(fhatx_dea), max(fhaty_dea))*1.5]);
                    

% *********************************************************************
% Computation of weights and of Ag Efficiencies 
% *********************************************************************


        %     FOR GROUP 1
        %   **************    
    [S1, S1k] = P_indep_weights(Y, YA);

    AgEff1=eff1'*S1k;
        
    TrueAgEff1=vA'*S1k;

    disp(' Aggregate Technical Efficiency for Group 1: Est. and True ')
    disp([AgEff1 TrueAgEff1]);
    
        %     FOR GROUP 2
        %   **************    
 
    [S2, S2k] = P_indep_weights(Y, YB);
    
    AgEff2=eff2'*S2k;
    
    TrueAgEff2=vB'*S2k;
     
    disp(' Aggregate Technical Efficiency for Group 2: Est. and True ')
    disp([AgEff2   TrueAgEff2]);

   
EntAgEff = AgEff1*S1 + AgEff2*S2

    %  for check
    % [S, Sk] = P_indep_weights(Y, Y);
    % EntAgEff_check = eff'*Sk

EntTrueAgEff = TrueAgEff1*S1 + TrueAgEff2*S2;

        disp('weights are')
        disp([S1, S2])

        
% *********************************************************************
%  Compare estimation to the truth and display the results

EstMeans =  [mean(eff1), mean(eff2), mean(eff)];
    disp('EstMeans')
    disp([EstMeans])

TruMeans =  [mean(vA), mean(vB), mean([vA ; vB]) ];
    disp('TruMeans')
    disp([TruMeans])

EstAgEff = [AgEff1 ; AgEff2; EntAgEff];
    disp('EstAgEff')
    disp([EstAgEff'])

TrueAgEff = [TrueAgEff1 ; TrueAgEff2; EntTrueAgEff];
    disp('TrueAgEff')
    disp([TrueAgEff'])

                    
         save Data_Ex_Ag_Boot_Het2 X Y vA vB na nb mu1 mu2 s1 s2
