%  this program estimates the Sheather and Jones (1991, J.R. Stat. Soc. B) bandwidth
%  While programmed we used the 2002 Gauss code of Prof. Carlos Martins as a reference

function F = Sheth_Jones_h(h)

% READ the data (temporary; to be changed to better ways)
    load Ex_Sh_J;

[n, ppp] = size(y);             s1=std(y);          

lambda=iqr(y);

dy = kron(ones(1,n),y);

% cosnstruction of Shat_D with a as the argument (for computation of alfa_hat_2(h))
a = (n^(-1/7))*0.92*lambda;   
z = (dy-dy')/a;
k4 = (3*ones(n,n)-6*(z.^2)+(z.^4)).*exp(-0.5*(z.^2))*(sqrt(pi)^-1);
f4 = (n^-1)*(a^-5)*sum(k4,2);
    sd = sum(f4,1)/(n-1);

% cosnstruction of That_D with b as the argument (for computation of alfa_hat_2(h))
b = (n^(-1/9))*0.912*lambda;
z1 = (dy-dy')/b;
	k6 = (-15*ones(n,n)+45*(z1.^2)-15*(z1.^4)+(z1.^6)).*(sqrt(pi)^-1).* exp(-0.5*(z1.^2));
f6 = (n^-1)*(b^-7)*sum(k6,2);
    td = - sum(f6,1)/(n-1);

% cosnstruction of Shat_D with alfa_hat_2(h) as the argument, for final
    % expression (eq. 12) to be solved
alfa2 = 1.357 * ((sd/td)^(1/7)) * (h^(5/7));    % h is the bandwidth to be solved for
zalf = (dy-dy')/alfa2;
k4alf = (3*ones(n,n)-6*(zalf.^2)+(zalf.^4)).*(sqrt(pi)^(-1)).* exp(-0.5*(zalf.^2));
f4alf = (n^-1)*(alfa2^-5)*sum(k4alf,2);
    s = sum(f4alf,1)/(n-1);

rk = 1/(2*sqrt(pi));    % expression for R(K) for the Gaussian kernel

% Final expression to be solved (eq. 12 of Sheather and Jones, 1991)
 % Note: sigma4_K is 1 for Gaussian kernel

F = (h - ((rk/s)^0.2)/(n^0.2));  




