% this function computes the Sheather and Jones bandwidth (1991, J. Roy.Stat.Soc.)
% calls for function    Sheth_Jones_h.m, which codes the equation to be solved 
% using fsolve.m
% coded by by Simar and Zelenyuk (2003)

function hy = Sh_J_Run(y)

    save Ex_Sh_J y;
    
    y = sort(y);

    [n, ppp] = size(y);
    
    s2 = std(y) ;          r2 = iqr(y) ;
 % starting value is Silverman rule of thumb   
    hy0 = 1.06*s2*n^(-1/5); 
    
    
    options=optimset('Display','iter');   % Option to display output
% Call 'fsolve' solver to solve nl-equation in file Sheth_Jones_h 
    % using hy0 as starting value
    [hy, fval] = fsolve(@Sheth_Jones_h, hy0, options);  

 
% plot the resullts comparing to true density and the one estimated with 
%   Silverman rule of thumb
%          Kxx = Nkernel_Li(y,y,hy);       Kyy = Nkernel_Li(y,y,hy0);
%          
%          fhatx = sum(Kxx,2)/(n*hy);             fhaty = sum(Kyy,2)/(n*hy0);
%         
%          plot(y, fhatx, '-.', y, fhaty, '--');
                 

             