%  This function computes values of gaussian kernel: for density of x evaluated at y
%  this could be used for regular density estimation or, as designed, for Li-1996 test
%  Simar and Zelenyuk, 2003. Can handle different sample sizes

function [k]=Nkernel_Li(x,y,h)

[nx,px]=size(x);            [ny,py]=size(y);

dx=kron(ones(1,ny),x);      dy=kron(ones(1,nx),y);

a = (dx-dy')/h;
k = (1/sqrt(2*pi))*exp(-0.5*(a.^2));

    % fhat = sum(k,2)/(nx*h);       % might be needed for future
