function [XS,YS,IS] = fdhsel(X,Y,rts)
% ======
% fdhsel
% ======
%
% Selection of nondominated observations IS
% 
%         Usage
%         [XS,YS,IS] = fdhsel(X,Y,rts)
%         IN   :
%         ------
%            X   : Matrix of input(s)  (n x p)
%            Y   : Matrix of output(s) (n x k)
%            rts : Assumption on returns to scale (text)
%                     'NIRS' = Non increasing rts
%                     'NDRS' = Non decreasing rts
%                     'CRS'  = Constant rts
%                     'VRS'  = Variable rts
%         OUT  :
%         ------
%	          XS    : Matrix of input(s) of nondominated observations
%		       YS    : Matrix of output(s) of nondominated observations
%            IS    : Indices of nondominated observations
%
% Called by : DEASEL and DEAXnewYnew
% Proposed by L. Simar
% Adapted by P. Vanden Eeckaut (June 1998), D. Mitrut (August 2001)
% up-dated and checked by L. Simar (december 2002)
% INSTITUT DE STATISTIQUE - UNIVERSITE CATHOLIQUE DE LOUVAIN


% Identify dimensions

[n,p] = size(X);
[n,q] = size(Y);
IS = [1:n]';
a=0;
i=1;
j=2;
XS=X;
YS=Y;


%  TO  avoid ZEROS



% % ----------
% % NIRS model
% % ----------
% if strcmp('NIRS',rts)
%    while i <= n
%    while j <= n
%       if (min(XS(j,:)'./XS(i,:)')>=max(YS(j,:)'./YS(i,:)'))&(1>=max(YS(j,:)'./YS(i,:)'));
%          XS = [XS([1:j-1],:);XS([j+1:n],:)];
%          YS = [YS([1:j-1],:);YS([j+1:n],:)];
%          IS=IS([[1:j-1]';[j+1:n]']);
%          n=n-1;
%       elseif (min(XS(i,:)'./XS(j,:)')>=max(YS(i,:)'./YS(j,:)'))&(1>=max(YS(i,:)'./YS(j,:)'))
%          XS = [XS([1:i-1],:);XS([i+1:n],:)];
%          YS = [YS([1:i-1],:);YS([i+1:n],:)];
%          IS=IS([[1:i-1]';[i+1:n]']);
%          n=n-1;
%          j=i+1;
%       else
%          j=j+1;
%       end
%    end
%    i=i+1;
%    j=i+1;
%    end
%    return
% end
% 
% % ----------
% % NDRS model
% % ----------
% if strcmp('NDRS',rts)
%    while i <= n
%    while j <= n
%       if (min(XS(j,:)'./XS(i,:)')>=1)&(min(XS(j,:)'./XS(i,:)')>=max(YS(j,:)'./YS(i,:)'));
%          XS = [XS([1:j-1],:);XS([j+1:n],:)];
%          YS = [YS([1:j-1],:);YS([j+1:n],:)];
%          IS=IS([[1:j-1]';[j+1:n]']);
%          n=n-1;
%       elseif (min(XS(i,:)'./XS(j,:)')>=1)&(min(XS(i,:)'./XS(j,:)')>=max(YS(i,:)'./YS(j,:)'))
%          XS = [XS([1:i-1],:);XS([i+1:n],:)];
%          YS = [YS([1:i-1],:);YS([i+1:n],:)];
%          IS=IS([[1:i-1]';[i+1:n]']);
%          n=n-1;
%          j=i+1;
%       else
%          j=j+1;
%       end
%    end
%    i=i+1;
%    j=i+1;
%    end
%    return
% end
% 
% % ----------
% % CRS model
% % ----------
% if strcmp('CRS',rts)
%    while i <= n
%    while j <= n
%       if (min(XS(j,:)'./XS(i,:)')>=max(YS(j,:)'./YS(i,:)'));
%          XS = [XS([1:j-1],:);XS([j+1:n],:)];
%          YS = [YS([1:j-1],:);YS([j+1:n],:)];
%          IS=IS([[1:j-1]';[j+1:n]']);
%          n=n-1;
%       elseif (min(XS(i,:)'./XS(j,:)')>=max(YS(i,:)'./YS(j,:)'))
%          XS = [XS([1:i-1],:);XS([i+1:n],:)];
%          YS = [YS([1:i-1],:);YS([i+1:n],:)];
%          IS=IS([[1:i-1]';[i+1:n]']);
%          n=n-1;
%          j=i+1;
%       else
%          j=j+1;
%       end
%    end
%    i=i+1;
%    j=i+1;
%    end
%    return
% end
% 
% % ----------
% % VRS model
% % ----------
% if strcmp('VRS',rts)
%    while i <= n
%    while j <= n
%       if (min(XS(j,:)'./XS(i,:)')>=1)&(1>=max(YS(j,:)'./YS(i,:)'));
%          XS = [XS([1:j-1],:);XS([j+1:n],:)];
%          YS = [YS([1:j-1],:);YS([j+1:n],:)];
%          IS=IS([[1:j-1]';[j+1:n]']);
%          n=n-1;
%       elseif (min(XS(i,:)'./XS(j,:)')>=1)&(1>=max(YS(i,:)'./YS(j,:)'))
%          XS = [XS([1:i-1],:);XS([i+1:n],:)];
%          YS = [YS([1:i-1],:);YS([i+1:n],:)];
%          IS=IS([[1:i-1]';[i+1:n]']);
%          n=n-1;
%          j=i+1;
%       else
%          j=j+1;
%       end
%    end
%    i=i+1;
%    j=i+1;
%    end
%    return
% end
% disp('Incorrect asssumption on RTS')
% return



      
         