function effNew = deaXNewYNew(XN,YN,X,Y,ori,rts,prdl)
%
% =======================================
% deaXNewYNew: useful for bootstrap loops
% =======================================
%
% Selection of a DEA model and computation of the efficiency
% for New observations XN,YN, with X,Y as reference set
% computation after selection nondominated observation
% 
%         Usage
%         [effNew]=deaxkyk(xk,yk,X,Y,ori,rts,prdl)
%         IN   :
%         ------
%            XN  : matrix (nn x p) of inputs
%            YN  : natrix (nn x q) of outputs
%            X   : Reference set Matrix of input(s)  (n x p)
%            Y   : Reference set Matrix of output(s) (n x k)
%            ori : Orientation of the computation
%                     'I'    = Input orientation
%                     'O'    = output orientation
%            rts : Assumption on returns to scale (text)
%                     'NIRS' = Non increasing rts
%                     'NDRS' = Non decreasing rts
%                     'CRS'  = Constant rts
%                     'VRS'  = Variable rts
%            prdl: Selection of primal or dual approach
%                     'P'    = Primal
%                     'D'    = Dual
%         OUT  :
%         ------
% effNew    : Efficiency scores of units (XN,YN)
% 
% Use : LP, dea_i_p, dea_o_p, dea_i_d, dea_o_d, fdhsel
% Proposed by L. Simar
% Adapted by P. Vanden Eeckaut (June 1998), D. Mitrut (August 2001)
% readapted by L. SIMAR (23 november 2002)
% INSTITUT DE STATISTIQUE - UNIVERSITE CATHOLIQUE DE LOUVAIN

% Note on lp:
% Input inefficiency measures using the DUAL
% Need to input f,A,b
% for solving in x minf'x s.t. Ax<=b
% then call x = lp(f,A,b)
% equality constraints must be writen in first N rows
% then call x=lp(f,A,b,Vlb,Ulb,[],N)


% X matrix n,p of inputs
% Y matrix n,q of outputs
[n,p] = size(X);
[n,q] = size(Y);
[nn,p]=size(XN);
[nn,q]=size(YN);


[XS,YS,IS] = fdhsel(X,Y,rts);ns=length(IS);
%XS=X;YS=Y;ns=n;IS=[1:n]';

t0=cputime;
eff=[];
%
% test for orientation
%
p = [strcmp('I', ori),strcmp('O', ori)];
if sum(p)==0
	disp( ' !!! ori option is not correct use I or O !!!');
	return
end
% ------------------------
% test for return to scale
% ------------------------
p = [strcmp('CRS', rts),strcmp('NIRS', rts),strcmp('NDRS', rts),strcmp('VRS', rts),strcmp('VRS2', rts)];
if sum(p)==0
	disp( ' !!! rts option is not correct use CRS, NIRS, NDRS or VRS !!!');
	return
end
% --------------------
% test for primal dual
% --------------------
p = [strcmp('P', prdl),strcmp('D', prdl)];
if sum(p)==0
	disp( ' !!! prdl option is not correct use P or D !!!');
	return
end
%
%
% Primal
%
if strcmp('P',prdl)
   %fprintf('\n * Primal approach \n')
   % Input orientation
	if strcmp('I',ori)
		%disp(' * Input orientation');
      %disp('   -----------------');
      t0=cputime;
		for k = 1:nn
			xeff=dea_i_p(XN(k,:)',YN(k,:)',XS,YS,rts);
         eff=[eff;xeff];
         %fprintf(' Unit : %5.0f Eff. : %6.4f \n',[k,xeff]);
      end
      t=cputime-t0;
	end
   % output orientation
   if strcmp('O',ori)
      %disp(' * Output orientation');
      %disp('   ------------------');
      t0=cputime;
		for k = 1:nn
			xeff=dea_o_p(XN(k,:)',YN(k,:)',XS,YS,rts);
         eff=[eff;xeff];
         %fprintf(' Unit : %5.0f Eff. : %6.4f \n',[k,xeff]);
      end
      t=cputime-t0;
	end
end
% Dual
if strcmp('D',prdl)
   %fprintf('\n * Dual approach \n')
   % Input orientation
   if strcmp('I',ori)
		%disp(' * Input orientation');
      %disp('   -----------------');
      t0=cputime;
		for k = 1:nn
			xeff=dea_i_d(XN(k,:)',YN(k,:)',XS,YS,rts);
         eff=[eff;xeff];
         %fprintf(' Unit : %5.0f Eff. : %6.4f \n',[k,xeff]);
      end
      t=cputime-t0;
	end
	% Output orientation
   if strcmp('O',ori)
		%disp(' * Output orientation')
      %disp('   ------------------')
      t0=cputime;
		for k = 1:nn
	 		xeff=dea_o_d(XN(k,:)',YN(k,:)',XS,YS,rts);
         eff=[eff;xeff]; 
         %fprintf(' Unit : %5.0f Eff. : %6.4f \n',[k,xeff]);
      end
      t=cputime-t0;
	end
end
effNew=eff;
%fprintf('\n Necessary time to compute: %10.4f seconds \n',t);
return
