%    Group-Wise Heterogeneous Sub-sampling Bootstrap for DEA with 2 SUB-group Aggregation 
%   (can be extended for more groups)
%   adapted by L.Simar and V.Zelenyuk from and compatible with other programs of L. Simar.
%***************************************************************************************
% uses the function resample.m  for EACH (of two) sub-groups !!!
%***************************************************************************************
% uses the function deaXNewYNew.m for the DEA reestimation with bootstrapped (x,y)
%***************************************************************************************
% uses the function P_indep_weights.m for computation of price indep. weights
%***************************************************************************************

function effkb=DEA_SubSampl_Ag_2_Smpl(B,X,Y,h1,h2,eff,rts,ori,prdl, group1, group2, kapa1, kapa2)

    % SUB-GROUPING
eff1=eff(group1,:);                 eff2=eff(group2,:);


X1=X(group1,:);                     X2=X(group2,:);
Y1=Y(group1,:);                     Y2=Y(group2,:);

[n1,p]=size(X1);                    [n2,p]=size(X2);
[n1,q]=size(Y1);                    [n2,q]=size(Y2);

nobs1=[1:n1]';                      nobs2=[1:n2]';

sigma1=std(eff1);                   sigma2=std(eff2);

effkb=[];   

m1 = floor(n1^kapa1);                m2 = floor(n2^kapa2);

for iboot=1:B       %  start the Bootstrap Loop
    
% **************************************************************
    % generate bootstrap samples by resampling
% **************************************************************
    
    %     FOR GROUP 1 
    %   **************    
    
Z1b = resample([X1,Y1], m1);

Xb1 = Z1b(:, 1:p);
Yb1 = Z1b(:, (p+1):(p+q));

    %     FOR GROUP 2 
    %   **************    
    
Z2b = resample([X2,Y2], m2);

Xb2 = Z2b(:, 1:p);
Yb2 = Z2b(:, (p+1):(p+q));


% **************************************************************
    %  POOLING the new ('bootstrapped') data
% **************************************************************

    Xb = [Xb1 ; Xb2];                Yb = [Yb1 ; Yb2];
        
% **************************************************************
%  Estimating the bootstrap estimates (on new, bootstraped sample)
%  of technical efficiency scores
% **************************************************************

    efb=deaXNewYNew(Xb,Yb,Xb,Yb,ori,rts,prdl);       

% **************************************************************
    %  SUB-GROUPING
% **************************************************************

    efb1=efb(1:m1,:);     efb2=efb(m1+1:m1+m2,:);

% **************************************************************
    % Computation of Aggregate efficiencies using price independent weights
    %  see Simar and Zelenyuk (2003) and Fare and Zelenyuk (2003, EJOR) 
% **************************************************************
        %     FOR GROUP 1
        %   **************    

% Check if input or output oriented!!!!!
    if strcmp('I',ori)   % input oriented case
        %  computation of price independent weights (as in Fare and Zelenyuk 2003, EJOR)

        [S1, S1k] = P_indep_weights(Xb, Xb1);

    else      %output oriented case
        %  computation of price independent weights (as in Fare and Zelenyuk 2003, EJOR)
 
        [S1, S1k] = P_indep_weights(Yb, Yb1);    
    end
        % Computation Aggregate score for Group 1
    AgEffb1=efb1'*S1k;
    meaneffb1=mean(efb1);
    
        %     FOR GROUP 2
        %   **************    
% Check if input or output oriented!!!!!
    if strcmp('I',ori)   % input oriented case
        %  computation of price independent weights 
        
        [S2, S2k] = P_indep_weights(Xb, Xb2);
            
    else                 %output oriented case
        %  computation of price independent weights 

        [S2, S2k] = P_indep_weights(Yb, Yb2);
    end
        % Computation Aggregate score for Group 2
    AgEffb2 = efb2'*S2k;
    meaneffb2=mean(efb2);

        % Computation Aggregate score for Entire Industry
    EntAgEffb = AgEffb1*S1 + AgEffb2*S2 ;
    overallmeaneffb = mean([efb1; efb2]);
    
        % Computation of the Comparison statistics (the RD statistic)
    CompAgEfb = AgEffb1 / AgEffb2;
    CompMeanb = mean(efb1) / mean(efb2) ;
    

AgEffb=[AgEffb1 ; AgEffb2 ; EntAgEffb];

MeanEffb = [meaneffb1; meaneffb2; overallmeaneffb];

Results = [AgEffb ; MeanEffb; CompAgEfb; CompMeanb];

    % save the result of the bootstrap iteration 
effkb=[effkb Results];  

end
