/***************************************************************/
/*                                                             */
/*     VAR analysis: generate draws from VAR posterior         */
/*                                                             */
/*                                                             */
/*                       Frank Schorfheide                     */
/*                                                             */
/***************************************************************/

/* Filename:  varmh.g
** created:   05/14/97
*/
library pgraph;
cls;


/* Import data on output growth and inflation: series (nobs,2)
** observations from 1950:I to 1997:IV
*/
nobs   = rows(series);
p      = 4;                  /* number of lags                       */
k      = 1 + 2*p;            /* number of coefficients per equation  */
lagmax = 4;
T0     = 1+2*lagmax+2;
nblocks= 8;
nsim   = 1000;

T0 = 16;

nobs   = rows(series);      
ti     = seqa(1950.0,0.25,nobs);
YY     = series[1+lagmax:nobs,.];
XX     = ones(nobs-lagmax, 1+2*p);
ti     = ti[1+lagmax:nobs,.];

i = 1;
do until i > p;
   XX[.,2+(i-1)*2:1+i*2] = series[lagmax-i+1:nobs-i,.];
   i = i+1;
endo;

nobs = nobs - lagmax;

opath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lmodel = "m01";
lprior = "2";
mhrun  = "1";
npara  = 2*k+3;

/* Initialize Output files
*/
ostat = opath  $+ lmodel $+ lprior $+ "sta" $+ mhrun;
opara = opath  $+ lmodel $+ lprior $+ "par" $+ mhrun;
statname = { POST LIKE PROP PROPPOST REJECT };

create fhstat=^ostat with ^statname, 5, 8;
create fhpara=^opara with PARAM, npara, 8;

/*************************************************************
**           Posterior Simulator
*/

/* Compute OLS estimates
*/
CC_hat  = inv(XX'*XX)*XX'*YY;
C_hat   = vec(CC_hat);
SIG_hat = (YY-XX*CC_hat)'*(YY-XX*CC_hat)/nobs;
nu      = nobs-k;

/* Compute prior parameters from sample 1...T0
*/
CCprior  = inv(XX[1:T0,.]'*XX[1:T0,.])*XX[1:T0,.]'*YY[1:T0,.];
HHprior = (YY[1:T0,.]-XX[1:T0,.]*CCprior)'*(YY[1:T0,.]-XX[1:T0,.]*CCprior);
nup = T0-k;

iblock = 1;
do until iblock > nblocks;

   parasim = zeros(nsim,npara);
   likesim = zeros(nsim,1);
   postsim = zeros(nsim,1);
   rej     = zeros(nsim,1);
   propsim = zeros(nsim,1);
   proppostsim = zeros(nsim,1);

   j = 1;
   do until j > nsim;

      /* draw from the marginal posterior of SIG
      */
      H = nobs*Sig_hat;
      Z = chol(inv(H))'*rndn(2,nu);
      Sig_sim = inv(Z*Z');

      /* draw from the conditional posterior of C
      */
      VC     = Sig_sim.*.inv(XX'*XX);
      C_sim  = C_hat + chol(VC)'*rndn(2*k,1);
      CCt_sim= reshape(C_sim,2,k);

      parasim[j,.] = C_sim'~Sig_sim[1,1]~Sig_sim[1,2]~Sig_sim[2,2];  

      /* Evaluate likelihood function
      */
      likesim[j] = -((nobs-T0))*ln(2*pi) - ((nobs-T0)/2)*ln(det(Sig_sim)) 
                 - 0.5*sumc(diag(  inv(Sig_sim)*( (YY[T0+1:nobs,.]-XX[T0+1:nobs,.]*CCt_sim')'*(YY[T0+1:nobs,.]-XX[T0+1:nobs,.]*CCt_sim'))));


      /* Evaluate the prior at parameter draws
      */

      lnprior = -k*ln(2*pi)-0.5*ln(det(Sig_sim.*.inv(XX[1:T0,.]'*XX[1:T0,.]))) 
             -0.5*sumc(diag( inv(Sig_sim)*(CCt_sim' - CCprior)'*(XX[1:T0,.]'*XX[1:T0,.])*(CCt_sim'-CCprior) ))
             -( nup*ln(2) + 0.5*ln(pi) + ln(gamma(nup/2)) + ln(gamma( (nup-1)/2 )) )
             +(nup/2)*ln(det(HHprior)) - ((nup+3)/2)*ln(det(Sig_sim)) - 0.5*sumc(diag( inv(Sig_sim)*HHprior ));

      postsim[j] = likesim[j] + lnprior;
      proppostsim[j] = postsim[j];

      /* Evaluate the posterior at parameter draws
      */

      propsim[j] = -k*ln(2*pi)-0.5*ln(det(Sig_sim.*.inv(XX'*XX))) 
                   -0.5*sumc(diag( inv(Sig_sim)*(CCt_sim' - CC_hat)'*(XX'*XX)*(CCt_sim'-CC_hat) ))
                   -( nu*ln(2) + 0.5*ln(pi) + ln(gamma(nu/2)) + ln(gamma( (nu-1)/2 )) )
                   +(nu/2)*ln(det(nobs*SIG_hat)) - ((nu+3)/2)*ln(det(Sig_sim)) - 0.5*sumc(diag( inv(Sig_sim)*nobs*SIG_hat ));

      rej[j] = 0;

      locate 1,1;
      "Block" iblock "of" nblocks;
      "Simulation step" j "of" nsim;
      "Likelihood     " likesim[j,1];
      "Posterior      " postsim[j,1];
      "Proposal Dens  " propsim[j,1];
      "Estimated Score" 1250+ln(1/(sumc(1/exp(likesim[1:j,1]-1250))/j));
      "Parameters     "; parasim[j,.]; 

     j = j+1;
    endo;

    wr = writer(fhstat,postsim~likesim~propsim~proppostsim~rej);
    wr = writer(fhpara,parasim);

    iblock = iblock+1;
endo;  

closeall fhstat, fhpara;
end;

