/***************************************************************/
/*                                                             */
/*     VAR analysis: sampling from the posterior,              */
/*                   Blanchard and Quah Decomposition          */
/*                                                             */
/*                       Frank Schorfheide                     */
/*                                                             */
/***************************************************************/

/* Filename:  varbq.g
** created:   11/12/98
*/

closeall;
library pgraph;

_FIX1 = 0;
_FIX2 = 0;
__output = 0;


goto plotres;


/* Import data on output growth and inflation: series (nobs,2)
** observations from 1950:I to 1997:IV
*/
nobs   = rows(series);
nvar   = 2;
p      = 3;                     /* number of lags                       */
k      = 1 + nvar*p;            /* number of coefficients per equation  */
lagmax = 3;
T0     = 1+2*lagmax+2;
nirf   = 40;
ncovout= 4;
nblocks= 10;
nsim   = 5000;
nvard  = 100;
nma    = 350;

T0 = 17;

nobs   = rows(series);      
ti     = seqa(1950.0,0.25,nobs);
YY     = series[1+lagmax:nobs,.];
XX     = ones(nobs-lagmax, 1+2*p);
ti     = ti[1+lagmax:nobs,.];

i = 1;
do until i > p;
   XX[.,2+(i-1)*2:1+i*2] = series[lagmax-i+1:nobs-i,.];
   i = i+1;
endo;

nobs = nobs - lagmax;

/* Initialize Output files
*/

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lprior = "1";
lmodel = "m0";
mhrun  = "2";
lpath = lpath $+ "\\mhrun" $+ mhrun $+ "\\";

oir11 = lpath $+ lmodel $+ lprior $+ "r11" $+ mhrun;
oir12 = lpath $+ lmodel $+ lprior $+ "r12" $+ mhrun;
oir21 = lpath $+ lmodel $+ lprior $+ "r21" $+ mhrun;
oir22 = lpath $+ lmodel $+ lprior $+ "r22" $+ mhrun;

ogamm = lpath $+ lmodel $+ lprior $+ "gam" $+ mhrun;
ocorr = lpath $+ lmodel $+ lprior $+ "cor" $+ mhrun;
ovard = lpath $+ lmodel $+ lprior $+ "vd"   $+ mhrun;

create fhir11 = ^oir11 with IR11, nirf, 8;
create fhir12 = ^oir12 with IR12, nirf, 8;
create fhir21 = ^oir21 with IR21, nirf, 8;
create fhir22 = ^oir22 with IR22, nirf, 8;

create fhgamm = ^ogamm with GAMM, 4*(ncovout+1), 8;
create fhcorr = ^ocorr with CORR, 4*(ncovout+1), 8; 
create fhvard = ^ovard with VARD, 2,    8;

cls;

/*************************************************************
**           Posterior Simulator
*/

/* Compute OLS estimates
*/
CC_hat  = inv(XX'*XX)*XX'*YY;
C_hat   = vec(CC_hat);
SIG_hat = (YY-XX*CC_hat)'*(YY-XX*CC_hat)/nobs;
nu      = nobs-k;

iblock = 1;
do until iblock > nblocks; 

  Asim11 = zeros(nsim,nirf); 
  Asim12 = zeros(nsim,nirf);
  Asim21 = zeros(nsim,nirf);
  Asim22 = zeros(nsim,nirf);

  GAMMsim   = zeros(nsim,4*(ncovout+1));
  CORRsim   = zeros(nsim,4*(ncovout+1));
  vardsim   = zeros(nsim,2);

  j = 1;
  do until j > nsim;
   
   val = 0;
   do until val == 1;

      /* draw from the marginal posterior of SIG
      */
      H = nobs*Sig_hat;
      Z = chol(inv(H))'*rndn(2,nu);
      Sig_sim = inv(Z*Z');

      /* draw from the conditional posterior of C
      */
      VC     = Sig_sim.*.inv(XX'*XX);
      C_sim  = C_hat + chol(VC)'*rndn(2*k,1);
      CCt_sim= reshape(C_sim,2,k);

     /* Check for stationarity
     */
     CCtilde =  CCt_sim[.,1+1:k] |
                (eye(nvar*(p-1)) ~ zeros(nvar*(p-1),nvar));
     {laCCtil, vCCtil} = eigv(CCtilde);
     if maxc(abs(laCCtil)) < 1; 
        val = 1;
     endif;

   endo; 

   /* Compute moving average coefficients
   */
   THE1 = eye(nvar);
   THE  = eye(nvar);
   sumTHE = THE*Sig_sim*THE';
   l = 1;
   do until l > nma;
      s = 1;
      THEl = zeros(nvar,nvar);
      do until s > minc( l|p );
         THEl = THEl + CCt_sim[.,1+1+(s-1)*nvar:1+s*nvar]*THE[.,1+(l-s)*nvar:2+(l-s)*nvar];
         s = s+1;
      endo;
      sumTHE = sumTHE + THEl*Sig_sim*THEl';
      THE = THE ~ THEl;
      THE1 = THE1 + THEl;
      l = l+1;
   endo;

   /* Calculate the coefficients of AA0-matrix
   */

   kap  = -THE1[1,2]/THE1[1,1];
   gam1 = SIG_sim[1,1] - kap*SIG_sim[1,2];
   gam2 = SIG_sim[1,2] - kap*SIG_sim[2,2];
   c2   = gam2^2/(gam1-gam2*kap);

   c    = sqrt(c2);

   if (gam2/c + kap*c) > 0;
      a = gam2/c + kap*c;
   else;
      c = -c;
      a = gam2/c + kap*c;
   endif;

   d = sqrt( (SIG_sim[1,2] - gam2 - kap*c2)/kap );
   b = kap*d;

   tst = SIG_sim[1,1] - a^2 - b^2 |
         SIG_sim[1,2] - a*c - b*d |
         SIG_sim[2,2] - c^2 - d^2 |
         THE1[1,1]*b + THE1[1,2]*d;

   AA0 = (a~b)|(c~d);

   /* Convert the THE coefficients into AA coefficients,
   ** and compute impulse response functions
   */
   sumAA2 = AA0*AA0';
   sumAAsq = AA0^2;
   A11 = AA0[1,1];
   A12 = AA0[1,2];
   A11c = AA0[1,1];  /* cumulated IRF for output */
   A12c = AA0[1,2];  /* cumulated IRF for output */
   A21 = AA0[2,1];
   A22 = AA0[2,2];
   AAlc = AA0;

   l = 2;
   do until l > nvard;
      AAl = THE[.,(l-1)*2+1:l*2]*AA0;
      AAlc = AAlc + AAl;
      sumAA2 = sumAA2 + AAl*AAl';
      sumAAsq = sumAAsq + AAl^2;
      A11 = A11 ~ AAl[1,1];
      A12 = A12 ~ AAl[1,2];
      A11c = A11c ~ AAlc[1,1];
      A12c = A12c ~ AAlc[1,2];
      A21 = A21 ~ AAl[2,1];
      A22 = A22 ~ AAl[2,2];
      l = l+1;
   endo;

   /* Variance Decomposition
   */
   vardsim[j,1] = sumAAsq[1,1]/(sumAAsq[1,1] + sumAAsq[1,2]);
   vardsim[j,2] = sumAAsq[2,1]/(sumAAsq[2,1] + sumAAsq[2,2]);


   /* Screen output
   */
   locate 1,1;
   "Block          " iblock "out of" nblocks;
   "Simulation step" j "out of" nsim;
   "Coefficients";
   CCt_sim;
   "Variance Decomposition" vardsim[j,.];

   /* Save impulse response functions
   */
   Asim11[j,.] = A11c[1,1:nirf];   /* use cumulated IRF for output */
   Asim12[j,.] = A12c[1,1:nirf];   /* use cumulated IRF for output */
   Asim21[j,.] = A21[1,1:nirf];
   Asim22[j,.] = A22[1,1:nirf];

   /* Compute Autocovariance/-autocorrelation function
   */

   CCtilde =  CCt_sim[.,1+1:k] |
              (eye(2*(p-1)) ~ zeros(2*(p-1),2));
   Sigtilde = (Sig_sim ~ zeros(nvar,nvar*(p-1)) )| zeros(nvar*(p-1),nvar*p);
   GA0tilde = inv(eye(4*p^2) - CCtilde.*.CCtilde)*vec(Sigtilde);
   GA0tilde = reshape(GA0tilde,nvar*p,nvar*p);

   /* Test Accuracy of Riccatti Equation
   */
   /*
   tst = vec(GA0tilde) - (CCtilde.*.CCtilde)*vec(GA0tilde) - vec(Sigtilde);
   tst = sqrt(tst'*tst);
   locate 24,1;
   "Inaccuracy in Riccatti Equation" tst;
   if tst > 1E-8;
      _FIX1 = CCtilde.*.CCtilde;
      _FIX2 = Sigtilde;
     {GAnlsys,retc} = eqSolve( &riccatti,lowtrvec(GA0tilde) );
     GA0tilde = lowtrmat(GAnlsys);
     tst = vec(GA0tilde) - (CCtilde.*.CCtilde)*vec(GA0tilde) - vec(Sigtilde);
     tst = sqrt(tst'*tst);
     "Corrected value" tst;
   endif;
   */

   CCtildel = CCtilde;
   
   GAMM0   = zeros(4,ncovout+1);
   CORR0   = zeros(4,ncovout+1);

   GA0     = GA0tilde[1:2,1:2];
   GA0star = (GA0[1,1] ~ sqrt(GA0[1,1]*GA0[2,2]) )|
             (sqrt(GA0[1,1]*GA0[2,2]) ~ GA0[2,2] );
   
   GAMM0[.,1] = vecr(GA0);
   CORR0[.,1] = vecr(GA0./GA0star);

   /* Compare Gamma(0) matrix of VAR and MA representation
   */
   
   {laCCtil, vCCtil} = eigv(CCtilde);
   locate 16,1; "Largest eigenvalue" maxc(abs(laCCtil));   
   
   locate 17,1; "Approximation Error Cov [Percent]"; 100*(sumAA2-GA0)./GA0;
   if GA0[2,2] < 0; end; endif;

   l = 1;
   do until l > ncovout;
      GAltilde = CCtildel*GA0tilde;
      GAl      = GAltilde[1:2,1:2];
      GAMM0[.,l+1] = vecr(GAl);
      CORR0[.,l+1] = vecr(GAl./GA0star);
      CCtildel = CCtildel*CCtilde;
      l = l+1;                          
   endo;

   GAMMsim[j,.] = vec(GAMM0[.,1:1+ncovout])';
   CORRsim[j,.] = vec(CORR0[.,1:1+ncovout])';
       
   j = j+1;
  endo;
  
  /* Save the results
  */
  wr = writer(fhir11,Asim11);
  wr = writer(fhir12,Asim12);
  wr = writer(fhir21,Asim21);
  wr = writer(fhir22,Asim22);
  wr = writer(fhvard,vardsim);
  wr = writer(fhgamm,gammsim);
  wr = writer(fhcorr,corrsim);

  iblock = iblock+1;
endo;

closeall fhir11, fhir12, fhir21, fhir22,
         fhgamm, fhcorr, fhvard;

outfile = lpath $+ lmodel $+ "pre.log";
output file = ^outfile reset;

"filename           contents";
"--------------------------------------------------";
"varirf11.out       each row: IRF dY/eps";
"varirf12.out       each row: IRF dY/eta";
"varirf21.out       each row: IRF dP/eps";
"varirf22.out       each row: IRF dP/eta";
" ";
"vargamm.out        each row contains autocovariance fcn";
"varcorr.out        The matrices                        ";
"                   g0(11) g0(12)           g1(11) g1(12)";                    
"                   g0(21) g0(22)           g1(21) g1(22)";
"                   are stored as                        ";
"                   g0(11) g0(12) g0(21) g0(22)  g1(11) g1(12) g1(21) g1(22)";
" ";
output off;


/* Plot the Impulse response functions
**************************************
*/
plotres:

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1";
lmodel = "m0";
lprior = "1";
mhrun  = "2";
nirf   = 40;
ti    = seqa(1,1,nirf);

lpath = lpath $+ "\\mhrun" $+ mhrun $+ "\\";
oir11 = lpath $+ lmodel $+ lprior $+ "r11" $+mhrun;
oir12 = lpath $+ lmodel $+ lprior $+ "r12" $+mhrun;
oir21 = lpath $+ lmodel $+ lprior $+ "r21" $+mhrun;
oir22 = lpath $+ lmodel $+ lprior $+ "r22" $+mhrun;

open fhir11 = ^oir11 for read;
open fhir12 = ^oir12 for read;
open fhir21 = ^oir21 for read;
open fhir22 = ^oir22 for read;

eofloop = 0;
nread   = 100;
ndraws  = 0;

varirf11 = 0;
varirf12 = 0;
varirf21 = 0;
varirf22 = 0;


do until eofloop; 

   irf11sim = readr( fhir11, nread);
   irf12sim = readr( fhir12, nread);
   irf21sim = readr( fhir21, nread);
   irf22sim = readr( fhir22, nread);

   varirf11 = varirf11 + irf11sim./irf11sim[.,nirf];
   varirf21 = varirf21 + irf21sim./irf11sim[.,nirf];
   varirf12 = varirf12 + irf12sim./sumc(irf22sim');
   varirf22 = varirf22 + irf22sim./sumc(irf22sim');

   ndraws = ndraws + rows(irf11sim);

   eofloop = eof(fhir11);

endo;
closeall fhir11, fhir12, fhir21, fhir22;

varirf11 = varirf11/ndraws;
varirf12 = varirf12/ndraws;
varirf21 = varirf21/ndraws;
varirf22 = varirf22/ndraws;

graphset;
begwind;
margin(0.5,0.6,0.5,0.6);
window(2,2,0);
fonts("microb");
_ptitlht = 0.3;
_paxht = 0.25;
_pnumht = 0.2;
_protate = 0;
_pcolor =2 ;
_pltype = {6 1 2};

_plctrl = 4;
_plwidth = 1.8;


   title("Output / Permanent Shock");
   xy( ti,100*meanc(varirf11) );
   nextwind;

   title("Output / Transitory Shock");
   xy( ti,100*meanc(varirf12) );
   nextwind;

   title("Inflation / Permanent Shock");
   xy( ti,100*meanc(varirf21) );
   nextwind;

   title("Inflation / Transitory Shock");
   xy( ti,100*meanc(varirf22) );
   endwind;

clear varirf11;    
clear varirf12;
clear varirf21;
clear varifr22;


/*************************************************************************/

proc (1) = riccatti(bb);
local aa, val;
   aa = lowtrmat(bb);
   val = lowtrvec (reshape( vec(aa) - _FIX1*vec(aa) - vec(_FIX2) ,rows(aa),rows(aa)) );
retp(val);
endp;

