/***************************************************************/
/*                                                             */
/*            Convert Impulse Response Functions               */
/*                                                             */
/*                       Frank Schorfheide                     */
/*                                                             */
/***************************************************************/

/* Filename:  irfconv.g
** created:   11/12/98
*/

closeall;
library pgraph;
cls;

/* Initialize Output files
*/

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lprior = "1";
lmodel = "m2";
mhrun  = "1";

lpath = lpath $+ "mhrun" $+ mhrun $+ "\\";

oir11 = lpath $+ lmodel $+ lprior $+ "r11" $+mhrun;
oir12 = lpath $+ lmodel $+ lprior $+ "r12" $+mhrun;
oir21 = lpath $+ lmodel $+ lprior $+ "r21" $+mhrun;
oir22 = lpath $+ lmodel $+ lprior $+ "r22" $+mhrun;

open fhir11 = ^oir11 for read;
open fhir12 = ^oir12 for read;
open fhir21 = ^oir21 for read;
open fhir22 = ^oir22 for read;

irfrow = readr(fhir11,1);
nirf   = cols(irfrow);
irfrow = seekr(fhir11,1);

oic11 = lpath $+ lmodel $+ lprior $+ "c11" $+ mhrun;
oic12 = lpath $+ lmodel $+ lprior $+ "c12" $+ mhrun;
oic21 = lpath $+ lmodel $+ lprior $+ "c21" $+ mhrun;
oic22 = lpath $+ lmodel $+ lprior $+ "c22" $+ mhrun;

create fhic11 = ^oic11 with IR11, nirf, 8;
create fhic12 = ^oic12 with IR12, nirf, 8;
create fhic21 = ^oic21 with IR21, nirf, 8;
create fhic22 = ^oic22 with IR22, nirf, 8;


eofloop = 0;
nread   = 10000;
ndraws  = 0;

do until eofloop; 

   irf11sim = readr( fhir11, nread);
   irf12sim = readr( fhir12, nread);
   irf21sim = readr( fhir21, nread);
   irf22sim = readr( fhir22, nread);

   mult1 = irf11sim[.,nirf];
   mult2 = sumc(irf22sim') ;

   irf11sim = irf11sim./mult1;
   irf21sim = irf21sim./mult1;
   irf12sim = irf12sim./mult2;
   irf22sim = irf22sim./mult2;

   wr = writer(fhic11,irf11sim);
   wr = writer(fhic12,irf12sim);
   wr = writer(fhic21,irf21sim);
   wr = writer(fhic22,irf22sim);

   "*";
   eofloop = eof(fhir11);

endo;

closeall fhir11, fhir12, fhir21, fhir22,
         fhic11, fhic12, fhic21, fhic22;

