/* filename: testcia.g
** created:  5/10/00
** Description: test the CIA model
**
*/
library pgraph, cialib;
cls;

nvard = 40;
nirf  = 40;

/* Define model parameters
*/
alp = 0.33;
bet = 0.99;
gam = 0.003;
mst = 1.011;
rho = 0.7;
psi = 0.787;
del = 0.02;

sigeps = 0.014;
sigeta = 0.005;

alp1 = 1;
alp2 = 100;

para   = alp | bet | gam   | mst | rho   | psi | del | 
         sigeps | sigeta | alp1 | alp2;

mspec = 2;

{TTT, RRR, valid} = ciasolv( para,mspec );
nstate = rows(TTT);


/* create system matrices for state space model
*/

/* composition of state vector
** [dm(t-1), dp(t-1), dy(t-1), dm(t), dp(t), dk(t+1), dh(t), dy(t) ,... ]
*/

ZZ = zeros(5,nstate);
ZZ[1,8] = 1; ZZ[1,3] = -1;
ZZ[2,5] = 1; ZZ[2,2] = -1; ZZ[2,1] = 1;
ZZ[3,4] = 1;
ZZ[4,4] = 9;
ZZ[5,7] = 1;

HH = (( sigeps^2 ~ -sigeps^2 )|( -sigeps^2 ~ sigeps^2));
QQ = ( sigeps^2 ~ 0          )|( 0         ~ sigeta^2); 
VV = ( sigeps^2 ~ -sigeps^2  )|( 0         ~ 0       );


/* compute impulse responses for output and inflation
*/

IRFeps = zeros(5,nvard);
IRFeta = zeros(5,nvard); 
  
/* Define initial state vector vector 
*/
alpeps = zeros(nstate,1);
alpeta = zeros(nstate,1);

/* Total Factor Productivity Shocks
*/
u_eps   = (1|-1|0|0|0)*sigeps ~ zeros(5,nvard-1);
v_eps   = (1|0 )*sigeps ~ zeros(2,nvard-1);
u_eta   = zeros(5,nvard);
v_eta   = (0|1 )*sigeta ~ zeros(2,nvard-1);

/* Initialize Loop variable t 
*/
t=1;

DO UNTIL t > nvard;

      /* update the vector of state variables alpha
      */
      alpeps = TTT*alpeps + RRR*v_eps[.,t];
      irfeps[.,t] = ZZ*alpeps + u_eps[.,t];

      alpeta = TTT*alpeta + RRR*v_eta[.,t];
      irfeta[.,t] = ZZ*alpeta + u_eta[.,t];

      t=t+1;

ENDO;
     
/* Variance Decomposition for output growth and inflation
*/
vardsim = zeros(2,1);
vardsim[1] = irfeps[1,.]*irfeps[1,.]'/( irfeps[1,.]*irfeps[1,.]' + irfeta[1,.]*irfeta[1,.]');
vardsim[2] = irfeps[2,.]*irfeps[2,.]'/( irfeps[2,.]*irfeps[2,.]' + irfeta[2,.]*irfeta[2,.]');

"Variance Decomposition [Percent of var due to technology]";
"Output growth" vardsim[1];
"Inflation    " vardsim[2];

/* Convert the growth rate IRF for output into level irf
*/
t=2;
do until t > nirf;
    irfeps[1,t] = irfeps[1,t-1]+irfeps[1,t];
    irfeta[1,t] = irfeta[1,t-1]+irfeta[1,t];
    t = t+1;
endo;

irf11= 100*irfeps[1,1:nirf]';
irf12= 100*irfeta[1,1:nirf]';
irf21= 100*irfeps[2,1:nirf]';
irf22= 100*irfeta[2,1:nirf]';
irf31= 100*irfeps[3,1:nirf]';
irf32= 100*irfeta[3,1:nirf]';
irf41= 100*irfeps[4,1:nirf]';
irf42= 100*irfeta[4,1:nirf]';
irf51= 100*irfeps[5,1:nirf]';
irf52= 100*irfeta[5,1:nirf]';


/* Plot Impulse Response Functions
*/

pltirf:   
   graphset;
   begwind;
   margin(0,0,0.2,0.2);
   window(5,2,0);
   fonts("microb");
   _ptitlht = 0.3;
   _paxht = 0.3;
   _pnumht = 0.25;
   _pcolor =2 ;
   _pltype = {6 1 2 2 1 3};
   _protate = 1;
   _plctrl = 0;
   _plwidth = 5.5;
   _psymsiz = 5;

   _plegstr = "CIA Model";
   _plegctl = {2 4 2.7 5.2};
   ylabel("Percent");   
ymin = -1;
ymax =  1;
/*
ytics(ymin,ymax,(ymax-ymin)/10,1);
*/

ti = seqa(1,1,nirf);

   title("Output / Perm Shock");
   xy(ti,irf11);
   nextwind;

/*   _plegctl = {2 4 2.7 3.5}; */

   title("Output / Trans Shock");
   xy(ti,irf12);
   nextwind;

   title("Inflation / Perm Shock");
   xy(ti,irf21);
   nextwind;

   title("Inflation / Trans Shock");
   xy(ti[1:12],irf22[1:12]);
   nextwind;

   title("Money growth / Perm Shock");
   xy(ti,irf31);
   nextwind;

   title("Money Growth / Trans Shock");
   xy(ti,irf32);
   nextwind;

   title("Deposit Dev / Perm Shock");
   xy(ti,irf41);
   nextwind;

   title("Deposit Dev / Trans Shock");
   xy(ti,irf42);
   nextwind;

   title("Hours / Perm Shock");
   xy(ti,irf51);
   nextwind;

   title("Hours / Trans Shock");
   xy(ti,irf52);
   endwind;


end;

