/* filename:    ciapmom.g
** description: Compute posterior mean and std and CI based on
**              output of posterior simulator
*/

new;
library user, cialib, pgraph;
cls;
outwidth 128;

/******************************************************************
**         Load Parameter Draws from MH Output
*/

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lmodel = "m2";
lprior = "1";
mhrun  = "1";
lpath  = lpath $+ "mhrun" $+ mhrun $+ "\\";
opara  = lpath $+ lmodel $+ lprior $+ "cor" $+ mhrun;
oparas = lpath $+ lmodel $+ lprior $+ "co3" $+ mhrun $+ "s";
momsel = 3;


open fhdraws = ^opara for read;

nburn       = 10001;       /* Number of initial draws to be discarded */
hpdprob     = 0.90;
densgridmin = -0.2;
densgridmax =  0.2;
ngrid1      =  100;
densgrid1   = seqa(densgridmin,(densgridmax - densgridmin)/(ngrid1-1),ngrid1);
ngrid2      =  5;
densgrid2   = seqa(densgridmin,(densgridmax - densgridmin)/(ngrid2-1),ngrid2);


drawrow = seekr( fhdraws, nburn); 

if momsel == 1;
   drawdim = 2;
elseif momsel == 2;
   drawdim = 4;
else;
   drawdim = 5;
endif;


/* Part 1: Compute the mean of x(i) and x^2(i)
*/
drawmean   = zeros(1,drawdim);
drawsqmean = zeros(1,drawdim);
drawcross  = zeros(drawdim,drawdim);

eofloop = 0;
nblock  = 1000;
ndraws  = 0;

do until eofloop; 

   drawblock = readr( fhdraws, nblock );

   if momsel == 1;
      drawblock = drawblock[.,1 2];
   elseif momsel == 2;
      drawblock = drawblock[.,8 12 16 20];
   else;
      drawblock = drawblock[.,10 6 2 7 11];
   endif;   

   drawmean  = drawmean    + sumc(drawblock)';
   drawsqmean = drawsqmean + sumc(drawblock^2)';
   drawcross  = drawcross  + drawblock'*drawblock;  

   ndraws = ndraws + rows(drawblock);

   locate 1,1;
   "Part 1";
   "Draws " ndraws;

   eofloop = eof(fhdraws);

endo;

drawmean   = drawmean/ndraws;
drawsqmean = drawsqmean/ndraws;
drawstdd   = sqrt(drawsqmean - (drawmean)^2);
drawcov    = drawcross/ndraws - drawmean'*drawmean;


/* Part 2: HPD Interval and Modes of Marginals
*/
cls;
drawrow     = seekr( fhdraws, nburn); 

drawci      = zeros(2,drawdim);
drawmode    = zeros(1,drawdim);
drawmodeval = zeros(1,drawdim);

j = 1;
do until j > drawdim;

   /* Read only the j'th column
   */
   drawrow   = seekr( fhdraws, nburn); 
   drawblock = readr( fhdraws, 1);
   if momsel == 1;
        drawblock = drawblock[.,1 2];
   elseif momsel == 2;
        drawblock = drawblock[.,8 12 16 20];
   else;
        drawblock = drawblock[.,10 6 2 7 11];
   endif;   

   drawcol = drawblock[1,j];
   eofloop = 0;
   ndraws  = 1;
   
   do until eofloop; 

      drawblock = readr( fhdraws, nblock );
      if momsel == 1;
        drawblock = drawblock[.,1 2];
      elseif momsel == 2;
        drawblock = drawblock[.,8 12 16 20];
      else;
        drawblock = drawblock[.,10 6 2 7 11];
      endif;   

      drawcol   = drawcol | drawblock[.,j];
      ndraws    = ndraws + rows(drawblock);
      eofloop   = eof(fhdraws);
      locate 1,1;
      "Part 2";
      "ndraws" ndraws;
      "Column" j;
         
   endo;
   
   drawci[.,j] = hpdint(drawcol,hpdprob);
   drawgrid    = densgrid1*drawstdd[j] + drawmean[j];
   densest     = kern(drawgrid,drawcol,drawstdd[j]^2);
   drawmode[j] = drawgrid[maxindc(densest)];
   drawmodeval[j] = densest[maxindc(densest)];

   j = j+1;

endo;
clear drawcol;



/* Part 3: Mode of Joint... 
*/
cls;
drawrow    = seekr( fhdraws, nburn); 
drawmodej  = zeros(1,drawdim);
maxdens    = 0;

/*
goto nojointmode;
*/

drawrow   = seekr( fhdraws, nburn); 
drawblock = readr( fhdraws, 1);
if momsel == 1;
    drawcol = drawblock[.,1 2];
elseif momsel == 2;
    drawcol = drawblock[.,8 12 16 20];
else;
    drawcol = drawblock[.,10 6 2 7 11];
endif;   

eofloop = 0;
ndraws  = 1;
   
do until eofloop; 

   drawblock = readr( fhdraws, nblock );
   if momsel == 1;
      drawblock = drawblock[.,1 2];
   elseif momsel == 2;
      drawblock = drawblock[.,8 12 16 20];
   else;
      drawblock = drawblock[.,10 6 2 7 11];
   endif;   

   drawcol   = drawcol | drawblock;
   ndraws    = ndraws + rows(drawblock);
   eofloop   = eof(fhdraws);
         
endo;

/* Create grid
*/
crgrid:




j = 0;
do until j == ngrid2^drawdim;

   /* calculate grid point
   */
   counter   = j;
   gridpoint = zeros(1,drawdim);
   gridindx  = zeros(1,drawdim);
   s = 1;
   do until s == drawdim;
      gridindx[1,s]  = floor(counter/ngrid2^(drawdim-s) );
      gridpoint[1,s] = densgrid2[1+gridindx[1,s]];
      counter = counter % ngrid2^(drawdim-s);
      s = s+1;
   endo;
   gridindx[1,drawdim]  = counter;
   gridpoint[1,drawdim] = densgrid2[1+counter];
   
   drawgrid  = gridpoint*chol(drawcov) + drawmean;
   densest   = kern(drawgrid,drawcol,drawcov);

   if densest > maxdens;
      maxdens = densest;
      drawmodej = drawgrid;
   endif;

   locate 1,1;
   "Part 3";
   "Grid point" j;
   "Max Dens  " maxdens;
   "Mode Est  " drawmodej;

   j = j+1;
endo;

/*
drawgrid = (((ones(ngrid2,1).*.ones(ngrid2,1)).*.ones(ngrid2,1) ).*.densgrid2  )~
           (( ones(ngrid2,1).*.ones(ngrid2,1)).*.(densgrid2.*.ones(ngrid2,1))  )~
           (  ones(ngrid2,1).*.( densgrid2 .*. (ones(ngrid2,1) .*. ones(ngrid2,1) ) ) )~
           ( densgrid2 .*. ones(ngrid2^3,1));

drawgrid  = drawgrid*chol(drawcov) + drawmean;
densest   = kern(drawgrid,drawcol,drawcov);
drawmodej = drawgrid[maxindc(densest),.];
*/

nojointmode:

closeall fhdraws;


/* Report Posterior Mean and stderror
** Parameters: alp bet gam mst rho 
**             psi del sig_eps sig_eta alp1rt alp2rt
**
*/


"MODEL   " lmodel;
"PRIOR   " lprior;
"MH-Run  " mhrun;
"MOM-SEL " momsel;
"=============================================";
"Structural Parameters";
"alp | bet  | gam     | mst    | rho  |      ";
"psi | del  | sigeps  | sigeta | siga | sigb ";
" " ;

"Mean / S.E.";
drawmean'~drawstdd';
"C.I.";
drawci';
"Mode";
drawmode';
"Modeval";
drawmodeval';
"Joint Mode";
drawmodej';
"Joint Mode Val";
maxdens;
"Cov";
drawcov;


"=============================================";

create fhparas = ^oparas with DRAWSUM, drawdim, 8;

writer(fhparas, real(drawmean | drawstdd  | drawcov     | 
                     drawci   | drawmode  | drawmodeval | 
                    drawmodej | maxdens*ones(1,drawdim) | ndraws*ones(1,drawdim) ) );
closeall fhparas; 


end;

/**************************************************************/
/*                         Procedures                         */
/**************************************************************/

proc(1) = hpdint(draws,percent);
local     ndraws, drawdim, hpdband, nwidth, i, drawcoli,
          bup, minwidth, newwidth, j;

drawdim   = cols(draws);
ndraws    = rows(draws);
hpdband   = zeros(2,drawdim);
nwidth    = int(percent*ndraws);

i = 1;
do until i > drawdim;
   drawcoli = draws[.,i];
   /* sort response for period i, element 1 is max
   */
   drawcoli = rev(sortc(drawcoli,1));
   bup   = 1;
   minwidth  = drawcoli[1] - drawcoli[nwidth];
   j = 2;
   do until j > (ndraws-nwidth+1);
      newwidth = drawcoli[j] - drawcoli[j+nwidth-1];
      if newwidth < minwidth;
         bup = j;
         minwidth = newwidth;
      endif;
      j = j+1;
   endo;
   hpdband[2,i] = drawcoli[bup];
   hpdband[1,i] = drawcoli[bup+nwidth-1];
   i = i+1;
endo;
retp(hpdband);
endp;

proc(1) = kern(grid,xdraw,drawcov);
/* Univariate Kernel Estimate
** Evaluate density for each row of grid
*/
local ndraws,sigdraws,h,dens,j,ngrid,ndim,scale;

ndraws   = rows(xdraw);
ndim     = cols(xdraw);
ngrid    = rows(grid);
sigdraws = stdc(xdraw);
dens     = zeros(ngrid,1);
h = ( 4/(ndim+2) )^( 1/(ndim+4) )*ndraws^( -1/(ndim+4) );
j = 1;
do until j > ngrid;
  dens[j] = (2*pi)^(-ndim/2)*det(drawcov)^(-0.5)/(ndraws*h^ndim)
            *sumc( exp( -sumc( ( inv(chol(drawcov)')*(ones(1,ndraws).*grid[j,.]'-xdraw') )^2 )/(2*h^2) ));
  j=j+1;
endo;
retp(dens);
endp;
