/* filename:    ciapm.g
** description: The program maximizes the posterior density of the CIA models
**              with respect to the model parameters
** created:     05/04/00
*/

library pgraph, user, cialib;
cls;
/* Global defaults for NLSYS procedure
*/
  __output = 0;
  _FIX1 = 0;
  _FIX2 = 0;


/* Import data on output growth and inflation: series (nobs,2)
** observations from 1950:I to 1997:IV
*/

nobs  = rows(series);       /* number of observations          */
p     = 4;                  /* number of lags in VAR(p) model  */
YY    = series[1:nobs,.];   /* Note that YY is defined defined over the entire series */
k     = 1 + 2*p;
T0    = p+k+2;

T0 = 4 +16;

/* Set path and import the information for the prior density
**
** Models: CIA1 and CIA2
** Priors: 1 and 2
**
*/

lpath = "c:\\projects\\active\\dsgesel\\gauss\\para";
lmodel = "m1";
lprior = "1";
npara  = 10;
mspec  = 1;

priorfile = lmodel $+ lprior $+ "pri.out";
load path=^lpath prior[npara,3] = ^priorfile;

pmean  = prior[.,1];
pstdd  = prior[.,2];
pshape = prior[.,3];


/* Define Starting values for maximization
**
*/

/* Nason Cogley
*/
                                        
alp = 0.38037345;
bet = 0.99;
gam = 0.002;
lnmst = 0.01269;
rho = 0.63;
psi = 0.7472;
del = 0.005;

sig_eps = 0.026;
sig_eta = 0.005;

/* Starting Values
*/

/*
alp = 0.72; 
bet = 0.98;
gam = 0.002321;
lnmst = 0.01366;
rho = 0.8621;
psi = 0.7727;
del = 0.0102;
sig_eps = 0.0309;
sig_eta = 0.00223;
alp1 = 50;
*/

/*
alp = 0.80;
bet = 0.95;
gam = 0.00232;
lnmst = 0.0136;
rho = 0.899;
psi = 0.77;
del = 0.01;

sig_eps = 0.0829;
sig_eta = 0.0018;
*/

alp1= 20;

para   = alp | bet | gam   | lnmst | rho   | psi | del | 
         sig_eps | sig_eta | alp1;


/* Define Transformation Scheme for Model Parameters
**
*/

_trspec =
    (1 ~ 1E-5 ~ 0.99999 ~ 1)|
    (1 ~ 0.90 ~ 0.99999 ~ 1)|
    (0 ~ 1E-5 ~ 0       ~ 1)|
    (0 ~ 1E-5 ~ 0       ~ 1 )|
    (1 ~ 1E-5 ~ 0.99    ~ 1)|
    (1 ~ 1E-5 ~ 0.99    ~ 1)|
    (1 ~ 1E-5 ~ 0.99    ~ 1)|
    (2 ~ 1E-5 ~ 0       ~ 1   )|
    (2 ~ 1E-5 ~ 0       ~ 1  )|
    (2 ~ 1E-5 ~ 0       ~ 1  );

loglh = objfcn(invtrans(para));
"Posterior" loglh;
"Prior Density evaluated at prior mean" priodens(para,pmean,pstdd,pshape);


x0= invtrans(para)+ 0.05*rndn(npara,1);
H0= 1E-3*eye(npara);
nit = 1000;
crit= 1E-8;

/* Use personal optimization procedure
*/

{fh,xh,g,H,itct,fcount,retcode} = csminwel(x0,H0,crit,nit,&objfcn);

paraest = trans(xh);

/* Compute gradient in terms of model parameters
*/
locate 24,1;

"Parameter Estimates";
paraest';

"Gradient in terms of Model Parameters";
gradmod = g./ diag(gradp(&invtrans,paraest));
gradmod';

"Gradient in terms of Maxim Parameters";
g';

end;


/****************************************************/
/*                 PROCEDURES                       */
/****************************************************/

proc (1) = objfcn(para);
local lnpY, lnprio, obsmean, obsvar;

/* likelihood 
*/

{lnpY,obsmean,obsvar} = evalcia(trans(para),mspec,T0,YY);

/* Evaluate the Prior distribution
*/
lnprio = priodens(trans(para), pmean, pstdd, pshape);

locate 25,1;
"Likelihood" lnpY;

retp(real(-lnpY-lnprio));  /* We minize the inverse of the likelihood fcn */
endp;


