/* filename:    ciapirf.g
** description: Compute posterior mean and std and CI based on
**              output of posterior simulator for IRF's
*/

new;
library user, cialib, pgraph;
cls;
outwidth 128;

/******************************************************************
**         Load Parameter Draws from MH Output
*/

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lmodel = "m0";
lprior = "1";
mhrun  = "2";
lirf   = "22";
lpath  = lpath $+ "mhrun" $+ mhrun $+ "\\";
oirf   = lpath $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun;
open fhdraws = ^oirf for read;

nburn  = 1;          /* Number of initial draws to be discarded */
qq     = 1000;       /* Number of lags used to compute simulation standard errors */
hpdprob= 0.90;

draws   = readr( fhdraws,1 );
drawdim = cols(draws);
drawrow = seekr( fhdraws, nburn); 

/* Initialization of output
*/
drawmean   = zeros(1,drawdim);
drawsqmean = zeros(1,drawdim);
drawmeanerror = zeros(1,drawdim);
drawstdderror = zeros(1,drawdim);
drawci      = zeros(2,drawdim);

/* Part 1: Compute the mean of x(i) and x^2(i)
*/

eofloop = 0;
nblock  = 10000;
ndraws  = 0;

do until eofloop; 

   drawblock = readr( fhdraws, nblock );

   drawmean   = drawmean   + sumc(drawblock)';
   drawsqmean = drawsqmean + sumc(drawblock^2)';

   ndraws = ndraws + rows(drawblock);

   locate 1,1;
   "Part 1";
   "Draws " ndraws;

   eofloop = eof(fhdraws);

endo;

drawmean = drawmean/ndraws;
drawsqmean = drawsqmean/ndraws;
drawstdd   = sqrt(drawsqmean - (drawmean)^2);

/*
goto eofeval;
*/

/* Part 2: Compute the autocovariances of of x(i) and x^2(i)
*/
cls;

drawrow     = seekr( fhdraws, nburn); 
drawlags    = zeros(2*(qq+1),2*drawdim);
drawmom     = zeros(2*(qq+1),2*drawdim);

eofloop = 0;
nblock  = 500;
ndraws  = 0;

do until eofloop; 

   drawblock = readr( fhdraws, nblock );

   i = 1;
   do until i > rows(drawblock);

       drawrow = drawblock[i,.];    /* y x */
       drawrow = (drawrow - drawmean) | (drawrow^2 - drawsqmean) ;

       drawlags = drawlags[1:2*qq,.];
       drawlags = ( drawrow .*. ones(1,2) ) | drawlags;

       drawrow = vec(drawrow)';   /* y y^2 x x^2 */
       drawmom = drawmom + (drawlags .* drawrow);
       
       i = i+1;
   endo;

   ndraws = ndraws + rows(drawblock);

   locate 1,1;
   "Part 2";
   "Draws " ndraws;

   eofloop = eof(fhdraws);

endo;


drawmom = drawmom/ndraws;

i = 1;
do until i > drawdim;
   
   selmean = 1 | 0;
   selstdd = 0.5/sqrt(drawsqmean[1,i] - drawmean[1,i]^2)*(- 2*drawmean[1,i] | 1);

   ss0 = drawmom[1:2, 1+2*(i-1):2*i];
   
   h   = 2;
   do until h > (qq+1);

      gamh = drawmom[1+2*(h-1):2*h , 1+2*(i-1):2*i] ;
      ss0  = ss0 + (1- (h-1)/(qq+1) )*(gamh + gamh');
      h = h + 1;
   
   endo;

   ss0 = ss0/ndraws;
  
   drawmeanerror[1,i] = sqrt( selmean'*ss0*selmean );
   drawstdderror[1,i] = sqrt( selstdd'*ss0*selstdd );

   i = i + 1;

endo;

/* Part 3: HPD Interval
*/
cls;
drawrow     = seekr( fhdraws, nburn); 

j = 1;
do until j > drawdim;

   /* Read only the j'th column
   */
   drawrow = seekr( fhdraws, nburn); 
   drawrow = readr( fhdraws, 1);
   drawcol = drawrow[1,j];
   eofloop = 0;
   ndraws  = 1;
   
   do until eofloop; 

      drawblock = readr( fhdraws, nblock );
      drawcol   = drawcol | drawblock[.,j];
      ndraws    = ndraws + rows(drawblock);
      eofloop   = eof(fhdraws);
         
   endo;
   
   drawci[.,j] = hpdint(drawcol,hpdprob);
   locate 1,1;
   "Part 3";
   "Column" j;
   j = j+1;

endo;


eofeval:
closeall fhdraws;


/* Report Posterior Mean and stderror
** Parameters: alp bet gam mst rho 
**             psi del sig_eps sig_eta alp1rt alp2rt
**
*/


"MODEL   " lmodel;
"PRIOR   " lprior;
"IRF     " lirf;
"MH-Run  " mhrun;
"=============================================";
"Impulse Response function";
" " ;

drawmean'~drawstdd';
drawci';
drawmeanerror'~drawstdderror';


"=============================================";

osummary = oirf $+ "s";
create fhsummary = ^osummary with IRFSUM, drawdim, 8;

writer(fhsummary, drawmean | drawstdd | real(drawmeanerror) | real(drawstdderror) | drawci | ndraws*ones(1,drawdim)  );
closeall fhsummary; 


end;

/**************************************************************/
/*                         Procedures                         */
/**************************************************************/

proc(1) = hpdint(draws,percent);
local     ndraws, drawdim, hpdband, nwidth, i, drawcoli,
          bup, minwidth, newwidth, j;

drawdim   = cols(draws);
ndraws    = rows(draws);
hpdband   = zeros(2,drawdim);
nwidth    = int(percent*ndraws);

i = 1;
do until i > drawdim;
   drawcoli = draws[.,i];
   /* sort response for period i, element 1 is max
   */
   drawcoli = rev(sortc(drawcoli,1));
   bup   = 1;
   minwidth  = drawcoli[1] - drawcoli[nwidth];
   j = 2;
   do until j > (ndraws-nwidth+1);
      newwidth = drawcoli[j] - drawcoli[j+nwidth-1];
      if newwidth < minwidth;
         bup = j;
         minwidth = newwidth;
      endif;
      j = j+1;
   endo;
   hpdband[1,i] = drawcoli[bup];
   hpdband[2,i] = drawcoli[bup+nwidth-1];
   i = i+1;
endo;
retp(hpdband);
endp;