/* filename:    ciapd.g
** description: Compute posterior mean and std for structural parameters
**              based on MH output
*/

new;
library user, cialib, pgraph;
cls;
outwidth 128;

/******************************************************************
**         Load Parameter Draws from MH Output
*/

npara = 11;

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lmodel = "m1";
lprior = "1";
ostat = lpath $+ lmodel $+ lprior $+ "sta";
opara = lpath $+ lmodel $+ lprior $+ "par";
open fhpara = ^opara for read;
open fhstat = ^ostat for read;

parasim = readr( fhpara,1 );
statsim = readr( fhstat,1 );

eofloop = 0;
ndraws = 1000;
do until eofloop; 

   parasim = parasim | readr( fhpara, ndraws );
   statsim = statsim | readr( fhstat, ndraws );
   eofloop = eof(fhpara);

endo;
closeall fhpara, fhstat;

nsim = rows(parasim);

/* Compute Posterior Mean and stderror
** Parameters: alp bet gam mst rho 
**             psi del sig_eps sig_eta alp1rt alp2rt
**
*/


"MODEL   " lmodel;
"PRIOR   " lprior;
"=============================================";
"Structural Parameters";
"alp | bet  | gam     | mst    | rho  |      ";
"psi | del  | sigeps  | sigeta | siga | sigb ";
" " ;
postm = meanc(parasim);
posts = stdc(parasim);

postm~posts;
"=============================================";

/* Analyze the simulation statistics
** POST LIKE REJECT
*/
"Simulation Statistics";
"Number of Draws    " nsim; 
"Rejection Frequency" meanc(statsim[.,3]);

pym = 1250+ln(1/(meanc(1/exp(statsim[.,2]-1250))));
"Marginal Density   " pym;

"=============================================";


end;