/******************************************************************/
/*                                                                */
/*         loss function estimator / impulse response functions   */
/*                                                                */
/*                        Frank Schorfheide                       */
/*                                                                */
/******************************************************************/

/* filename: cialoss.g
** created:  10/13/99
** 
*/


library user, cialib, pgraph;
cls;


nirf  = 40;                 /* number of impulse responses */
ti    = seqa(1,1,nirf);

/* Read Posterior Summary Files Simulation
*/
lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";

/* VAR 
*/
lmodel = "m0";
lprior = "1";
mhrun  = "1";
lpath  = lpath $+ "mhrun" $+ mhrun $+ "\\";

lirf   = "11";
osummary       = lpath $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+ "s";
open fhsummary = ^osummary for read;
seekr(fhsummary,1);
m0ir11 = readr(fhsummary,1)';
seekr(fhsummary,5);
band11 = readr(fhsummary,2)';
closeall fhsummary;

lirf   = "12";
osummary       = lpath $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+ "s";
open fhsummary = ^osummary for read;
seekr(fhsummary,1);
m0ir12 = readr(fhsummary,1)';
seekr(fhsummary,5);
band12 = readr(fhsummary,2)';
closeall fhsummary;

lirf   = "21";
osummary       = lpath $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+ "s";
open fhsummary = ^osummary for read;
seekr(fhsummary,1);
m0ir21 = readr(fhsummary,1)';
seekr(fhsummary,5);
band21 = readr(fhsummary,2)';
closeall fhsummary;

lirf           = "22";
osummary       = lpath $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+ "s";
open fhsummary = ^osummary for read;
seekr(fhsummary,1);
m0ir22 = readr(fhsummary,1)';
seekr(fhsummary,5);
band22 = readr(fhsummary,2)';
closeall fhsummary;

/* DSGE Model M2
*/
lmodel = "m2";
lprior = "1";
mhrun  = "2";
lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";

lirf   = "11";
osummary       = lpath $+ "mhrun" $+ mhrun $+ "\\" $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+"s";
open fhsummary = ^osummary for read;
m2ir11 = readr(fhsummary,1)';
closeall fhsummary;

lirf   = "12";
osummary       = lpath $+ "mhrun" $+ mhrun $+ "\\" $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+"s";
open fhsummary = ^osummary for read;
m2ir12 = readr(fhsummary,1)';
closeall fhsummary;

lirf   = "21";
osummary       = lpath $+ "mhrun" $+ mhrun $+ "\\" $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+"s";
open fhsummary = ^osummary for read;
m2ir21 = readr(fhsummary,1)';
closeall fhsummary;

lirf   = "22";
osummary       = lpath $+ "mhrun" $+ mhrun $+ "\\" $+ lmodel $+ lprior $+ "c" $+ lirf $+ mhrun $+"s";
open fhsummary = ^osummary for read;
m2ir22 = readr(fhsummary,1)';
closeall fhsummary;

/* Define model parameters
*/

alp   = 0.4193;
bet   = 0.9856;
gam   = 0.0041;
lnmst = 0.0136;
rho   = 0.8610;
psi   = 0.6558;
del   = 0.0029;

/*
alp   = 0.69;
bet   = 0.96;
gam   = 0.0026;
lnmst = 0.012;
rho   = 0.72;
psi   = 0.79;
del   = 0.015;
*/

sig_eps = 0.02;
sig_eta = 0.005;

alp1= 10;

mspec = 2;

para  = alp1;
npara = rows(para);

_trspec = (2 ~ 1E-5 ~ 0  ~ 10  );

/*
goto irfpred;
*/

x0= invtrans(para)+0*rndn(npara,1);
H0= 1E-4*eye(npara);
nit = 1000;
crit= 1E-9;

{fh,xh,g,H,itct,fcount,retcode} = csminwel(x0,H0,crit,nit,&lossfcn);
"Parameters";
alp1est = trans(xh);
paraest = alp | bet | gam |lnmst | rho | psi | del | sig_eps | sig_eta | alp1est;

hessian:
cls;

_trspec = (0 ~ 1E-5 ~ 0  ~ 1  );

ndx = 12;
dx =  exp(-seqa(6,1,ndx));
hesse = zeros( ndx*npara, npara );
gradx = zeros(ndx,1);
grady = zeros(ndx,1);
gradxy = zeros(ndx,1);
hessdiag = zeros(ndx,1);
dxscale = 1;


seli = 1;
do until seli > npara;
   selj = seli;
   do until selj > npara;
     "Hessian Element    (" seli selj ")";
     i=1;
     do until i > ndx;
      paradx = alp1est;
      parady = alp1est;
      paradx[seli] = paradx[seli] + dx[i]*dxscale[seli];
      parady[selj] = parady[selj] - dx[i]*dxscale[selj];
      paradxdy = paradx;
      paradxdy[selj] = paradxdy[selj] - dx[i]*dxscale[selj];
      fx  = lossfcn(alp1est);
      fdx = lossfcn(paradx);
      fdy = lossfcn(parady);
      fdxdy = lossfcn(paradxdy);
      gradx[i] = -( fx - fdx )/ (dx[i]*dxscale[seli]);
      grady[i] = ( fx - fdy )/ (dx[i]*dxscale[selj]);
      gradxy[i] = -(fx -fdxdy)/ sqrt( (dx[i]*dxscale[selj])^2 + (dx[i]*dxscale[seli])^2 );
      hessdiag[i] = -( 2*fx - fdx - fdy)/(dx[i]*dxscale[seli])^2; 
      hessdiag[i] = -( fx - fdx - fdy + fdxdy )/(dx[i]*dx[i]*dxscale[seli]*dxscale[selj]);
      i = i+1;
     endo;
     "Values";
     hessdiag;
     "-----------------------------------------------";
     selj=selj+1;
   endo;
   seli = seli+1;
endo;

"Parameters";
paraest;


irfpred:
{irfeps, irfeta, valid} = dsgeirf( paraest,mspec,nirf );

   graphset;
   begwind;
   margin(0,0,0.2,0.2);
   window(2,2,0);
   fonts("microb");
   _ptitlht = 0.3;
   _paxht = 0.3;
   _pnumht = 0.25;
   _pcolor =2 ;
   _pltype = {3 1  4 2 2};
   _protate = 1;
   _plctrl = 0;
   _plwidth = 5.5;
   _psymsiz = 5;

   _plegstr = "M2 (Loss)\000M2 (Bayes)\000Posterior Mean\00090% Interval (U)\00090% Interval (L)";

   _plegctl = {2 4 2.7 5.2};
   ylabel("Percent");   

   title("Output / Trans Shock");
   xy(ti,irfeta[1,.]'~ m2ir12 ~ m0ir12 ~ band12);
   nextwind;

/*   _plegctl = {2 4 2.7 3.5}; */

   title("Inflation / Trans Shock");
   xy(ti,irfeta[2,.]'~ m2ir22 ~ m0ir22 ~ band22);
   endwind;



/*                  PROCEDURES                   */
/*************************************************/

proc(1) = lossfcn(para);
/* Evaluate the loss function, penalize deviation from prior
*/
local util12, util22, util, tloss, valid,
      irfeps, irfeta, modpara;

   modpara =  alp | bet | gam |lnmst | rho | psi | del | sig_eps | sig_eta | trans(para);

 
   {irfeps, irfeta, valid} = dsgeirf( modpara,mspec,nirf );
   
   if valid == 1;
 
   /* Normalize
   */
   util12 = -sumc( (m0ir12[1:40] - irfeta[1,1:40]')^2);
   util22 = -sumc( (m0ir22[1:40] - irfeta[2,1:40]')^2);

   util   =  util12+util22;
   tloss =  -util;
    
   else;

    tloss = 1E6;

   endif;

retp(tloss);
endp;      


proc (3) = dsgeirf( para,mspec,nirf );
/* This procedure generates impulse response functions
*/
local valid, TTT, RRR, retcode, irfeps, irfeta, t, nstate, ZZ,
      alpeps, alpeta, u_eps, v_eps, u_eta, v_eta;
      

valid = 1;

IRFeps = zeros(2,nirf);
IRFeta = zeros(2,nirf); 

/* Call procedure to solve the model
*/
{TTT, RRR, retcode} = ciasolv( para, mspec);
if retcode < 1;
   valid = 0;
   goto eoirf;
endif;


nstate = rows(TTT);

/* create system matrices for state space model
*/

/* composition of state vector
** [dm(t-1), dp(t-1), dy(t-1), dm(t), dp(t), dk(t+1), dh(t), dy(t) ,... ]
*/

ZZ = zeros(2,nstate);
ZZ[1,8] = 1; ZZ[1,3] = -1;
ZZ[2,5] = 1; ZZ[2,2] = -1; ZZ[2,1] = 1;

/* compute impulse responses for output and inflation
*/
  
/* Define initial state vector vector 
*/
alpeps = zeros(nstate,1);
alpeta = zeros(nstate,1);

/* Total Factor Productivity Shocks
*/
u_eps   = (1|-1) ~ zeros(2,nirf-1);
v_eps   = (1|0 ) ~ zeros(2,nirf-1);
u_eta   = zeros(2,nirf);
v_eta   = (0|1 ) ~ zeros(2,nirf-1);

/* Initialize Loop variable t 
*/
t=1;

DO UNTIL t > nirf;

/* update the vector of state variables alpha
*/
   alpeps = TTT*alpeps + RRR*v_eps[.,t];
   irfeps[.,t] = ZZ*alpeps + u_eps[.,t];

   alpeta = TTT*alpeta + RRR*v_eta[.,t];
   irfeta[.,t] = ZZ*alpeta + u_eta[.,t];

   t=t+1;

ENDO;

/* Convert the growth rate IRF for output into level irf
*/
t=2;
do until t > nirf;
   irfeps[1,t] = irfeps[1,t-1]+irfeps[1,t];
   irfeta[1,t] = irfeta[1,t-1]+irfeta[1,t];
   t = t+1;
endo;

/* Restandardize
*/
irfeps = irfeps / irfeps[1,nirf];
irfeta = irfeta / sumc(irfeta[2,.]');

eoirf:
retp(irfeps, irfeta, valid);
endp;

/*************************************************************************/

