/* filename:    ciahess.g
** description: The program computes the hessian at the posterior mode 
** created:     05/05/00
*/

library user, pgraph, cialib;
cls;

/* Import data on output growth and inflation: series (nobs,2)
** observations from 1950:I to 1997:IV
*/

nobs  = rows(series);       /* number of observations          */
p     = 4;                  /* number of lags in VAR(p) model  */
YY    = series[1:nobs,.];   /* Note that YY is defined defined over the entire series */
k     = 1 + 2*p;
T0    = p+k+2;

T0 = 4+16;

/* Load Model parameters, Posterior Mode
*/

lpath = "c:\\projects\\active\\dsgesel\\gauss\\para";
lmodel = "m2";
lprior = "1";
npara  = 10;
mspec  = 2;

parafile  = lmodel $+lprior $+ "mod.out";
priorfile = lmodel $+lprior $+ "pri.out";
load path=^lpath para[npara,1] = ^parafile;
load path=^lpath prior[npara,3]= ^priorfile;

pmean  = prior[.,1];
pstdd  = prior[.,2];
pshape = prior[.,3];


goto evalhess;


/* Compute Hessian, element by element, fine tune with dxscale
*/
comphess:

ndx = 6;
dx =  exp(-seqa(6,2,ndx));
hesse = zeros( ndx*npara, npara );
gradx = zeros(ndx,1);
grady = zeros(ndx,1);
gradxy = zeros(ndx,1);
hessdiag = zeros(ndx,1);
dxscale = 1 | 1| 1 | 1 | 1 | 1 | 1 | 1 | 1 | 10 ;

seli = 1;
do until seli > npara;
   selj = seli;
   do until selj > npara;
     "Hessian Element    (" seli selj ")";
     i=1;
     do until i > ndx;
      paradx = para;
      parady = para;
      paradx[seli] = paradx[seli] + dx[i]*dxscale[seli];
      parady[selj] = parady[selj] - dx[i]*dxscale[selj];
      paradxdy = paradx;
      paradxdy[selj] = paradxdy[selj] - dx[i]*dxscale[selj];
      fx  = fcn(para);
      fdx = fcn(paradx);
      fdy = fcn(parady);
      fdxdy = fcn(paradxdy);
      gradx[i] = -( fx - fdx )/ (dx[i]*dxscale[seli]);
      grady[i] = ( fx - fdy )/ (dx[i]*dxscale[selj]);
      gradxy[i] = -(fx -fdxdy)/ sqrt( (dx[i]*dxscale[selj])^2 + (dx[i]*dxscale[seli])^2 );
      hessdiag[i] = -( 2*fx - fdx - fdy)/(dx[i]*dxscale[seli])^2; 
      hessdiag[i] = -( fx - fdx - fdy + fdxdy )/(dx[i]*dx[i]*dxscale[seli]*dxscale[selj]);
      i = i+1;
     endo;
     "Values";
     -hessdiag';
     "-----------------------------------------------";
     selj=selj+1;
   endo;
   seli = seli+1;
endo;
end;
/*******************************************************************************
*/

/* Load Hessian, compute penalty
*/
evalhess:

hessfile  = lmodel $+ lprior $+ "hes.out";
load path=^lpath hhm[npara,npara]= ^hessfile;

/* Method 1: Eliminate zero rows and columns
*/
/*
if mspec == 1;
   HHm = HHM[1:9, 1:9];
endif;
npara = rows(HHM);
*/   

/* Method 2: Keep zero rows and columns and do SVD
*/
if mspec == 1;
   rankHHm = 9;
else;
   rankHHm = 10;
endif;

/* Create Inverse by Singular Value Decomposition
*/
{u , s, v} = svd1(HHM);
invHHMdet = 1;


i = 1;
do until i > npara;
   if i > rankHHM;
      s[i,i] = 0;
   else;
      s[i,i]    = 1/s[i,i];
      invHHMdet = invHHMdet*s[i,i];
   endif;
   i = i+1;
endo;

invHHM  = u*s*u';
sigmult = u*sqrt(s);

"Determinant of minus Hessian";
invHHMdet;
"sqrt(Diagonal of Inverse Hessian)";
sqrt(diag(invHHM));

"Post Mode Penalty";
penalt = (rankHHM/2)*ln(2*pi) + 0.5*ln(invHHMdet);
penalt;

/* Initialize Output files
*/
opath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
omult = opath $+ "\\" $+ lmodel $+ lprior $+ "mul";
create fhmult=^omult with MULT, npara, 8;
wr = writer(fhmult,sigmult);

closeall fhmult;
end;


/****************************************************/
/*                 PROCEDURES                       */
/****************************************************/

proc (1) = fcn(para);
local lnpY, lnprio, obsmean, obsvar;

/* likelihood 
*/
{lnpY,obsmean,obsvar} = evalcia(para,mspec,T0,YY);

/* Evaluate the Prior distribution
*/
lnprio = priodens(para, pmean, pstdd, pshape);

retp(real(lnpY+lnprio));  /* We minize the inverse of the likelihood fcn */
endp;





