/* filename:    ciadd.g
** description: Computes numerical approximations to the data density
**              based on MH output
*/

new;
closeall;
library user, cialib, pgraph;
cls;
outwidth 128;

/******************************************************************
**         Load Parameter Draws from MH Output
*/

npara = 10;
mspec = 1 ;

/*
npara = 21;
*/

lpath = "c:\\projects\\active\\dsgesel\\results\\analys1\\";
lmodel = "m1";
lprior = "1";
mhrun  = "2";


lpath = lpath $+ "mhrun" $+ mhrun $+ "\\";
ostat  = lpath $+ lmodel $+ lprior $+ "sta" $+ mhrun;
opara  = lpath $+ lmodel $+ lprior $+ "par" $+ mhrun;
open fhpara = ^opara for read;
open fhstat = ^ostat for read;

nburn   = 10001;
nblock  = 500;
densfac = 1250;
hmax    = 3200;

pararow = seekr(fhpara,nburn);
statrow = seekr(fhstat,nburn);

/* Method 1: simple harmonic mean
** Method 2: importance sampling based on MH output
** Method 3: modified harmonic mean
*/

goto m3;

/********************************************************
** Method 1
*/
M1:

eofloop = 0;
ndraws  = 0;
suminvlike = 0;

do until eofloop; 

   statsim = readr( fhstat, nblock );
   ndraws  = ndraws + rows(statsim) ;
   suminvlike = suminvlike + sumc(1/exp(statsim[.,2]-densfac));
   eofloop = eof(fhstat);

endo;
closeall fhpara, fhstat;


meaninvlike = suminvlike/ndraws;
pym1        = densfac+ln(1/meaninvlike);

"Marginal Data Density" pym1;
end;

/*********************************************************
** Method 2
*/
M2:

eofloop   = 0;
ndraws    = 0;
sumweight = 0;

do until eofloop; 

   statsim = readr( fhstat, nblock );
   ndraws  = ndraws + rows(statsim) ;
   sumweight = sumweight + sumc(exp(statsim[.,4]-statsim[.,3]-densfac));
   eofloop = eof(fhstat);

endo;
closeall fhpara, fhstat;

meanweight = sumweight/ndraws;
pym2       = densfac+ln(meanweight);

"Marginal Data Density" pym2;
end;

/*********************************************************
** Method 3
*/
M3:

p = seqa(0.1,0.1,9);

if mspec == 1;
   nparastar = 9;
else;
   nparastar = npara;
endif;
  
pcrit = cdfchii(p,ones(rows(p),1)*nparastar);

/* Part 1: Compute posterior moments for parameters
*/

eofloop = 0;
ndraws  = 0;
sumtheta  = zeros(nparastar,1);
sumtheta2 = zeros(nparastar,nparastar);

do until eofloop; 

   thetasim = readr( fhpara, nblock );
   thetasim = thetasim[.,1:nparastar];
   sumtheta  = sumtheta + sumc(thetasim);
   sumtheta2 = sumtheta2 + thetasim'*thetasim;
   ndraws  = ndraws + rows(thetasim);

   eofloop = eof(fhpara);

endo;

thetahat      = sumtheta / ndraws;
thetasig      = sumtheta2 / ndraws - thetahat*thetahat';
thetasiginv   = inv(thetasig);
thetasiglndet = ln(det(thetasig));


/* Part 2:  Compute Density estimate
*/

pararow = seekr(fhpara,nburn);
statrow = seekr(fhstat,nburn);

eofloop = 0;
ndraws  = 0;
suminvlike = zeros(rows(p),1);
laginvlike = zeros(hmax,rows(p));
gaminvlike = zeros(hmax,rows(p));

do until eofloop;

   statsim  = readr( fhstat, nblock);
   thetasim = readr( fhpara, nblock);

   i = 1;
   do until i > rows(thetasim);
    
      lnftheta = -ln(p) - 0.5*nparastar*ln(2*pi) - 0.5*thetasiglndet
                 -0.5*(thetasim[i,1:nparastar] - thetahat')*thetasiginv*(thetasim[i,1:nparastar]' - thetahat);
      indtheta = ((thetasim[i,1:nparastar] - thetahat')*thetasiginv*(thetasim[i,1:nparastar]' - thetahat) .< pcrit );
      invlike  = exp(lnftheta - statsim[i,1] + densfac).*indtheta;

      laginvlike = invlike' | laginvlike[1:hmax-1,.];
      gaminvlike = gaminvlike + laginvlike.*invlike';

      suminvlike = suminvlike + invlike;
      i = i+1;
   endo;

   ndraws = ndraws + rows(thetasim);
   locate 1,1;
   ndraws;
   eofloop = eof(fhpara);

endo;
closeall fhpara, fhstat;

meaninvlike = suminvlike/ndraws;
gaminvlike = gaminvlike/ndraws - (meaninvlike^2)';

/* Compute Standard Errors
*/
suminvlikeerror = gaminvlike[1,.];
j = 2;
do until j > hmax;
   suminvlikeerror = suminvlikeerror + 2*gaminvlike[j,.]*(1- (j-1)/hmax);
   j = j+1;
endo;
suminvlikeerror = 100*sqrt(suminvlikeerror/ndraws)./meaninvlike' ;

pym3        = densfac-ln(meaninvlike);
"Marginal Data Density" pym3;
"Average Across p     " meanc(pym3);
"Simulation Error [Percent]" suminvlikeerror';

end;


