/* filename: loaddata.g
** description: reads time series data from ASCII data set into
** Gauss variable SERIES
** created:  05/03/00
*/
new;
cls;
/* Time series, extracted 05/04/00
** GDPD = GROSS DOMESTIC PRODUCT:IMPLICIT PRICE DEFLATOR (INDEX,92=100)(T7.1)
** GDPQ = GROSS DOMESTIC PRODUCT
** GPOP = POPULATION, NIPA basis (THOUS.,NSA)
** Quarterly Data from 1949:IV to 1997:IV
*/

library pgraph;
load data_q[193,3]="c:/projects/active/dsgesel/data/data.prn";

series      = zeros(193,2);
series[.,2] = data_q[.,1];
series[.,1] = 1000*data_q[.,2] ./ data_q[.,3];
series      = ln(series);

/* Compute growth rates: from 1950:I to 1997:IV
*/

series = series[2:193,.] - series[1:192,.];
ti     = seqa(1950,0.25,192);

end;

