//use file's folder as working directory
insheet using "dat_pan_all.csv"
tsset idn time

//PMG estimation with lag order selected by BIC from a maximum of 4

gen p=0
gen q=0
gen s=0
gen bicmin=0
gen bic=0

// EMU 1975:2 - 2011:2 (maximum lag length is 2)
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/2{
forvalues y=1/3{
forvalues z=1/2{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn<=10), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn<=10), lr(l.ta l.nfl) replace pmg


// nonEMU 1975:2 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==11|idn==12|idn==13|idn==15), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==11|idn==12|idn==13|idn==15), lr(l.ta l.nfl) replace pmg


// EMU 1975:2 - 1996:4
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn<=10) & (time<93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn<=10) & (time<93), lr(l.ta l.nfl) replace pmg


// EMU 1997:1 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn<=10) & (time>=93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn<=10) & (time>=93), lr(l.ta l.nfl) replace pmg


// nonEMU 1975:2 - 1996:4
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(0/`z')(d.tdd d.reeru) if (idn==11|idn==12|idn==13|idn==15) & (time<93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==11|idn==12|idn==13|idn==15) & (time<93), lr(l.ta l.nfl) replace pmg


// nonEMU 1997:1 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==11|idn==12|idn==13|idn==15) & (time>=93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==11|idn==12|idn==13|idn==15) & (time>=93), lr(l.ta l.nfl) replace pmg


// North
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6), lr(l.ta l.nfl) replace pmg


// South
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==7|idn==8|idn==9|idn==10), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==7|idn==8|idn==9|idn==10), lr(l.ta l.nfl) replace pmg


// North 1975:2 - 1996:4
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time<93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time<93), lr(l.ta l.nfl) replace pmg


// North 1997:1 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time>=93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time>=93), lr(l.ta l.nfl) replace pmg


// South 1975:2 - 1996:4
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=0/3{
forvalues y=1/4{
forvalues z=1/3{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==7|idn==8|idn==9|idn==10) & (time<93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==7|idn==8|idn==9|idn==10) & (time<93), lr(l.ta l.nfl) replace pmg


// South 1997:1 - 2011:2 (maximum lag length is 2 (and 1 for nfl), minimum is also 2 (and 1 for nfl), as it does not work otherwise)
quietly replace p=0
quietly replace q=0
quietly replace s=0
quietly replace bicmin=0
forvalues x=2/2{
forvalues y=2/2{
forvalues z=2/2{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl l(1/`z')(d.tdd d.reeru) if (idn==7|idn==8|idn==9|idn==10) & (time>=93), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace s = `z' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl l(1/`=s')(d.tdd d.reeru) if (idn==7|idn==8|idn==9|idn==10) & (time>=93), lr(l.ta l.nfl) replace pmg


