//use file's folder as working directory
insheet using "dat_pan_all.csv"
tsset idn time

//PMG estimation with lag order selected by BIC from a maximum of 4

gen p=0
gen q=0
gen bicmin=0
gen bic=0

// EMU 1975:2 - 1993:4
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/4{
forvalues y=1/5{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn<=10) & (time<81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn<=10) & (time<81), lr(l.ta l.nfl) replace pmg


// EMU 1994:1 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/4{
forvalues y=1/5{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn<=10) & (time>=81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn<=10) & (time>=81), lr(l.ta l.nfl) replace pmg


// nonEMU 1975:2 - 1993:4
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/4{
forvalues y=1/5{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn==11|idn==12|idn==13|idn==15) & (time<81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn==11|idn==12|idn==13|idn==15) & (time<81), lr(l.ta l.nfl) replace pmg


// nonEMU 1994:1 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/4{
forvalues y=1/5{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn==11|idn==12|idn==13|idn==15) & (time>=81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn==11|idn==12|idn==13|idn==15) & (time>=81), lr(l.ta l.nfl) replace pmg


// North 1975:2 - 1993:4
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/4{
forvalues y=1/5{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time<81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time<81), lr(l.ta l.nfl) replace pmg


// North 1994:1 - 2011:2
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/4{
forvalues y=1/5{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time>=81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn==1|idn==2|idn==3|idn==4|idn==5|idn==6) & (time>=81), lr(l.ta l.nfl) replace pmg


// South 1975:2 - 1993:4 (max. lag order only 2 since otherwise it does not work)
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/2{
forvalues y=1/2{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn==7|idn==8|idn==9|idn==10) & (time<81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn==7|idn==8|idn==9|idn==10) & (time<81), lr(l.ta l.nfl) replace pmg


// South 1994:1 - 2011:2 (max. lag order only 1 since otherwise it does not work)
quietly replace p=0
quietly replace q=0
quietly replace bicmin=0
forvalues x=0/1{
forvalues y=1/2{
quietly xtpmg l(0/`x')d.ta l(1/`y')d.nfl if (idn==7|idn==8|idn==9|idn==10) & (time>=81), lr(l.ta l.nfl) replace pmg
quietly estat ic
quietly matrix b = r(S)
quietly replace bic = b[1,6]
quietly replace p = `x' if bic < bicmin
quietly replace q = `y' if bic < bicmin
quietly replace bicmin = bic if bic < bicmin
}
}
xtpmg l(0/`=p')d.ta l(1/`=q')d.nfl if (idn==7|idn==8|idn==9|idn==10) & (time>=81), lr(l.ta l.nfl) replace pmg


