% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{probit_break}
\alias{probit_break}
\title{probit break specification model with probit link}
\usage{
probit_break(stateVariable, theta, ...)
}
\arguments{
\item{stateVariable}{state variable}

\item{theta}{parameter}

\item{...}{...}
}
\value{
numeric level
}
\description{
All specification models can be used as parameter in \code{\link{estimate.functional}}.
Specification models are used to denote the quantile or expectile level
(depending on the identification function).
The probit break specification model depends has a break at zero and a constant level above and below.
It applies the probit link function.
}
\examples{
# plot break probit specification model with constant quantile/expectile level
plot(function(x) probit_break(x,theta=c(0,0)), xlim=c(-1,1))


# plot linear break specification model with state-dependent quantile/expectile level
plot(function(x) probit_break(x,theta=c(0,5)), xlim=c(-1,1))
}
\seealso{
Other specification models: 
\code{\link{constant}()},
\code{\link{logistic_linear}()},
\code{\link{probit_linear}()},
\code{\link{probit_spline2}()},
\code{\link{probit_spline3}()}
}
\concept{specification models}
