#Module for Auxiliary model
module auxmod
  using LinearAlgebra

#Get data
  using Main.data

#Simple regression function
  function reg(X,Y)
    b=inv(X'*X)*X'*Y
    return b
  end

#Weighted Regression Function
  function wreg(X,Y,W)
      b=inv(X'*Diagonal(W)*X)*X'*Diagonal(W)*Y
      return b
  end

#Calculated Auxiliary Parametes
  function aux(X,D)
    (NN,k)=size(X)
    b1=reg(X,D[:,2])
    Xbig=zeros(NN,2*k)
    Xbig[:,1:k]=X.*((ones(NN)-D[:,2])*ones(1,k))
    Xbig[:,k+1:2*k]= X.*(D[:,2]*ones(1,k))
    b2=reg(Xbig,D[:,3])
    return [b1;b2]
  end

#Derivative of Auxiliary Parameters
  function dauxdD(X,D,dD)
    (NN,k)=size(X)
    db1=inv(X'*X)*X'*dD[:,2,:]
    Xbig=zeros(NN,2*k)
    Xbig[:,1:k]=X.*((ones(NN)-D[:,2])*ones(1,k))
    Xbig[:,k+1:2*k]= X.*(D[:,2]*ones(1,k))
    dxbdd=[-X X]
    b2=reg(Xbig,D[:,3])
    db2=inv(Xbig'*Xbig)*Xbig'*dD[:,3,:]+
      inv(Xbig'*Xbig)*(dxbdd'*Diagonal(D[:,3]-Xbig*b2)-Xbig'*Diagonal(dxbdd*b2))*dD[:,2,:]
    return [db1;db2]
  end

# Weighted Version of Auxiliary Parameters
  function waux(X,D,W)
    (NN,k)=size(X)
    b1=wreg(X,D[:,2],W)
    Xbig=zeros(NN,2*k)
    Xbig[:,1:k]=X.*((ones(NN)-D[:,2])*ones(1,k))
    Xbig[:,k+1:2*k]= X.*(D[:,2]*ones(1,k))
    b2=wreg(Xbig,D[:,3],W)
    return [b1;b2]
  end


# Derivative of weighted Version of Auxiliary Parameters
  function dwauxdb(X,D,W,dW)
    (NN,k)=size(X)
    b1=wreg(X,D[:,2],W)
    e1=D[:,2]-X*b1
    db1=inv(X'*Diagonal(W)*X)*(X'*Diagonal(e1)*dW)
    Xbig=zeros(NN,2*k)
    Xbig[:,1:k]=X.*((ones(NN)-D[:,2])*ones(1,k))
    Xbig[:,k+1:2*k]= X.*(D[:,2]*ones(1,k))
    b2=wreg(Xbig,D[:,3],W)
    e2=D[:,3]-Xbig*b2
    db2=inv(Xbig'*Diagonal(W)*Xbig)*(Xbig'*Diagonal(e2)*dW)
    return[db1;db2]
  end



#Calculate auxiliary model on data
  bdat=aux(X,D)

  export aux,waux,bdat,dwauxdb,dauxdD
end
