!!!!!!  Main Code

use ggg  ! module for global variables
use mpi


!! Define Everything we will use
IMPLICIT NONE
integer :: id,iempt,mart,nklt18t,nklt7t,nkidt,anykidt,ayt,dat,babyt,iwavet
double precision :: wgt,edt,pet
double precision ::  potexp(nmax,maxsp),ed(nmax),b(npar),bscale(npar)
integer :: nobs(nmax),j,i
double precision :: bm(0:1,4),bw(0:1,4),bk(10),bhc(0:1,3),gam(5),th_sim(nsim,2)
double precision :: bexpw(0:1,ncell),bexpm(0:1,ncell),bexpk(ncell),dlam,xhbar,sigeps
double precision :: xbw(0:1),xbm(0:1),xbk,tend,z,dstart,drnor,xbtemp
real :: u(nsim),uu(4)
integer :: iwork,imar,nkid,iseed,lid,i_index,isim,k,icell,idiv
integer :: nkidlt7,nkidlt18,ioldlt7,ioldlt18,iobs,ireas,nspell,nkgt18t
double precision :: inthazinv,timew,timem,timek(3),bdkid(85),tbeg,timekmin
double precision :: start,ihazw,ihazk,ihazm,hazw,hazk,hazm,bdold,tlen
double precision :: tempprod,f,ssig12
integer :: isp,nf,uip(1),naux,iv(60),liv=60,lv=5000
external :: drnor,f2
integer :: njj,istop,itag,jj,ierr,nfe
integer :: status(mpi_status_size)
double precision :: parvec(npar),auxmom(numaux),bfe(38),bbase(4),vv(4000)
double precision :: fp,fm,ddd,bp(npar),bbm(npar)
double precision :: ftol,f2,WW(numaux),objective_function
double precision :: scale(1), work(1000),psim(nauxp),psimp(nauxp),psimm(nauxp)
integer :: iww(1000),mode,iflag,itmax,l,iage,ikid
double precision :: blam(2),blsi(3),bxh(2),pw0,pwb,blb(3)


call MPI_INIT( ierr )
call MPI_COMM_RANK( MPI_COMM_WORLD, myid, ierr )
call MPI_COMM_SIZE( MPI_COMM_WORLD, numprocs, ierr )
head=0
k=81

if (myid>0) then  !These are all worker nods


!define cutoff for hazards
 cut(1)=5.0d0
 cut(2)=10.0d0
 cut(3)=15.0d0
 cut(4)=20.0d0
 cut(5)=25.0d0
 cut(6)=30.0d0
 cut(7)=1.0d40
 potexp=0.0d0

!Load data
 open(24,file='fordatw.raw')
 lid=-100
 i_index=0
 do i=1,726484
  read(24,*) id,pet,iempt,edt,mart,nklt18t,nklt7t,wgt,nkidt,nkgt18t,anykidt,ayt,dat,babyt,iwavet
  if (id>lid) then
   i_index=i_index+1
   nobs(i_index)=1
   ed(i_index)=max(edt,8.0)
   lid=id
  else
   nobs(i_index)=nobs(i_index)+1
  endif
  potexp(i_index,nobs(i_index))=pet
  iwave(i_index,nobs(i_index))=iwavet
 enddo
 nn=i_index


! Now we simulate the data within each worker
 iseed=109328423+23232*myid
 call uniran(nsim,iseed,U)
 ilink=1+int(dble(NN)*dble(U))
 iseed=320948234+23232*myid
 z=dstart(iseed)
 do isim=1,nsim
  inseed(isim,1)=int(abs(33122399.3d0*drnor()))
  inseed(isim,2)=int(abs(3298473.22d0*drnor()))
 enddo

!get most recent version of parameters-we use that for base simulation
 open(25,file='parin')
 do j=1,k
  read(25,*) b(j)
 enddo

!define all of the relevant parameters
 bm(0,1:3)=b(1:3) !marriage parameters
 bm(1,:)=b(4:7)
 bw(0,:)=b(8:11) !work parameters
 bw(1,:)=b(12:15)
 bk=b(16:25)  !children parameters
 bhc(0,:)=b(26:28) !Human capital parameters
 bhc(1,:)=b(29)
 gam=b(30:34) ! wage parameters
 bexpw(0,:)=b(35:41) ! for work hazard
 bexpw(1,:)=b(42:48)
 bexpm(0,:)=b(49:55) !for marriage hazard
 bexpm(1,:)=b(56:62)
 bexpk=b(63:69) !for children hazard
 blam=b(70:71) ! parameters for lambda part of human capital
 bxh=b(72:73) ! parameters for xhbar part of human capital
 sigeps=dexp(b(74)) !standard deviation of measurement error
 ssig12=-1.0d0+2.0d0*(1.0d0/(1.0d0+dexp(b(75)))) !governs correlation between random effects
 blsi=b(76:78) !initial work parameters
 blb=b(79:81) ! work right after baby parameters

 numka=0.0d0 ! intialize number of kids


! draw theta-the random effects
 do isim=1,nsim
  z_sim(isim,1)=drnor()
  z_sim(isim,2)=drnor()
  th_sim(isim,1)=z_sim(isim,1)
  th_sim(isim,2)=ssig12*z_sim(isim,1)+dsqrt(1.0d0-ssig12**2.0d0)*z_sim(isim,2)
 enddo

! Initiate variables to zero
 potexp_sim=0.0d0
 hvbaby_sim=0
 nk_sim=0
 icell=0
 nsp_sim=0
 nk2_sim=-9

 !!!!Now main iteration across people
 do isim=1,nsim

   ! Normalize some things to zero
  imar=0
  idiv=0
  nkid=0
  nkidlt7=0
  nkidlt18=0
  tend=0.0d0
  bdkid=0.0d0
  iobs=1
  nspell=0
  !for rinitiating rand variables
  z=dstart(inseed(isim,1))
  iseed=inseed(isim,2)
  call uniran(4,iseed,uu)

  ! from the data we connect to an observation determines education
  !   and data when we observe them
  ed_simn(isim)=ed(ilink(isim))-12.0d0
  nobs_sim(isim)=nobs(ilink(isim))
  iobs_sim(isim)=ilink(isim)
  ispind_sim(isim)=icell+1

  ! draw initial work
  pw0=dexp(blsi(1)+blsi(2)*ed_simn(isim)+blsi(3)*th_sim(isim,2))
  pw0=pw0/(1.0d0+pw0)
  if (pw0>uu(1)) then
   iwork=1
  else
   iwork=0
  endif

  !Initiate a number of things we will use
  pwb=dexp(blb(1)+blb(2)*ed_simn(isim)+blb(3)*th_sim(isim,2))
  pwb=pwb/(1.0d0+pwb)
  iwk0_sim(isim)=iwork
  potexp_sim(isim,1:maxsp)=potexp(ilink(isim),1:maxsp)
  do j=0,1
   xbw(j)=bw(j,1)*ed_simn(isim)+bw(j,2)*th_sim(isim,2)
   xbm(j)=bm(j,1)*ed_simn(isim)+bm(j,2)*th_sim(isim,1)+bm(j,3)*th_sim(isim,2)
  enddo
  xbk=bk(1)*ed_simn(isim)+bk(2)*th_sim(isim,1)+bk(3)*th_sim(isim,2)

  ! now start the main iteration, we stop when we are past the sampling frame
  !  each iteration goes until an event-marriage, kid, or job
  do while(tend<potexp_sim(isim,nobs_sim(isim)))
   call uniran(4,iseed,uu)

   ! calculate time until work status changes
   xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
   timew=inthazinv(tend,-dlog(dble(uu(1))),xbtemp,bexpw(iwork,:))

   ! calculate time until marriage status changes
   if (imar==1) then
    xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
   else
    xbtemp=xbm(0)
   endif
   timem=inthazinv(tend,-dlog(dble(uu(2))),xbtemp,bexpm(imar,:))
   !calculate time until have kid
   xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
   if (nkid==1) then
    xbtemp=xbtemp+bk(6)
   elseif (nkid==2) then
    xbtemp=xbtemp+bk(7)
   elseif (nkid>2) then
    xbtemp=xbtemp+bk(8)+bk(9)*dble(ed_simn(isim))
   endif
   if (nkid>=1) then
    xbtemp=xbtemp+bk(10)*(tend-bdkid(1))
   endif
   timek(1)=inthazinv(tend,-dlog(dble(uu(3))),xbtemp,bexpk)
    ! Time until kid turns 7 or 18
  if (nkidlt18.eq.0) then
   timek(2:3)=1.0d10
  elseif (nkidlt7==nkidlt18) then
   timek(2)=1.0d10
   timek(3)=bdkid(ioldlt7)+7.0d0-tend
  elseif(nkidlt7>0) then
   timek(2)=bdkid(ioldlt18)+18.0d0-tend
   timek(3)=bdkid(ioldlt7)+7.0d0-tend
  else
   timek(2)=bdkid(ioldlt18)+18.0d0-tend
   timek(3)=1.0d10
  endif
  timekmin=minval(timek)
  tbeg=tend
  tend=tend+min(timew,timem,timekmin)
 !simulate data for whichever of these three is minimum
  do while ((tend>potexp_sim(isim,min(iobs,maxsp))).and.(iobs<=nobs_sim(isim)))

  ! save current state variables
   lstat_sim(isim,iobs)=iwork
   mstat_sim(isim,iobs,1)=imar
   mstat_sim(isim,iobs,2)=idiv
   nklt7_sim(isim,iobs)=nkidlt7
   nklt18_sim(isim,iobs)=nkidlt18
   nkgt18_sim(isim,iobs)=nkid-nkidlt18
   nk_sim(isim,iobs)=nkid
   if (nkid>0) then
    ay_sim(isim,iobs)=potexp_sim(isim,iobs)-bdkid(nkid)
    akid_sim(isim)=1.0d0
   else
    akid_sim(isim)=0.0d0
   endif
   do ikid=1,nkid
    iage=floor(potexp_sim(isim,iobs)-bdkid(ikid))
    if (iage<7) then
     numka(isim,iobs,iage)=numka(isim,iobs,iage)+1
    else
     numka(isim,iobs,7)=numka(isim,iobs,7)+1
    endif
   enddo
   if (iobs==1) then
    if (nkid>2) then
     da_sim(isim)=bdkid(nkid)-bdkid(1)
    else
     da_sim(isim)=-9.0d0
    endif
   endif
   if (iwave(ilink(isim),iobs)==2) then
    ip2_sim(isim)=int(potexp_sim(isim,iobs))
    nk2_sim(isim)=nkid
   endif
   if (iobs>1) then
    if (nkid>nk_sim(isim,iobs-1)) then
     hvbaby_sim(isim,iobs)=1
    endif
   endif
   if (nkidlt7>0) then
    alt7_sim(isim,iobs)=1.0d0
   else
    alt7_sim(isim,iobs)=0.0d0
   endif
   if (iwork==1) then
    eps_sim(isim,iobs)=drnor()
   endif
   iobs=iobs+1
  enddo
  if ((timew<timem).and.(timew<timekmin)) then !work status changes
   iwork=1-iwork
   ireas=1
  elseif (timem<timekmin) then ! marriage status changes
   if (imar==1) then
    idiv=1
    imar=0
   else
    idiv=0
    imar=1
   endif
   ireas=2
  elseif ((timek(1)<timek(2)).and.(timek(1)<timek(3))) then !birth
   nkid=nkid+1
   bdkid(nkid)=tend
   ireas=3
   if (nkidlt7==0) then
    ioldlt7=nkid
   endif
   if (nkidlt18==0) then
    ioldlt18=nkid
   endif
   nkidlt7=nkidlt7+1
   nkidlt18=nkidlt18+1
   if (iwork==1) then
    call uniran(1,iseed,uu)
    if (pwb<uu(1)) then
     iwork=0
    endif
    iwkb_sim(isim,nkid)=iwork
   endif
  elseif (timek(2)<timek(3)) then !Kid reaches 18
   ireas=4
   nkidlt18=nkidlt18-1
   if (nkidlt18>0) then
    ioldlt18=ioldlt18+1
   endif
  else  !Kid reaches 7
   ireas=5
   nkidlt7=nkidlt7-1
   if (nkidlt7>0) then
    ioldlt7=ioldlt7+1
   endif
  endif
  nspell=nspell+1
  if (tend<potexp_sim(isim,Nobs_sim(isim))) then
   icell=icell+1
   tdate_sim(icell)=tend
   iend_sim(icell)=ireas
  endif
  enddo
  nsp_sim(isim)=nspell
 enddo



!Now given data calucate base likelihood
 f0=1.0d0
 do isim=1,nsim

  !intial things we will use
  pw0=dexp(blsi(1)+blsi(2)*ed_simn(isim)+blsi(3)*th_sim(isim,2))
  pw0=pw0/(1.0d0+pw0)
  pwb=dexp(blb(1)+blb(2)*ed_simn(isim)+blb(3)*th_sim(isim,2))
  pwb=pwb/(1.0d0+pwb)
  iwork=iwk0_sim(isim)
  f0(isim)=dble(iwork)*pw0+dble((1-iwork))*(1.0-pw0)
  imar=0
  idiv=0
  nkidlt18=0
  nkidlt7=0
  nkid=0
  start=0.0d0
  bdold=0.0d0
  do j=0,1
   xbw(j)=bw(j,1)*ed_simn(isim)+bw(j,2)*th_sim(isim,2)
   xbm(j)=bm(j,1)*ed_simn(isim)+bm(j,2)*th_sim(isim,1)+bm(j,3)*th_sim(isim,2)
  enddo
  xbk=bk(1)*ed_simn(isim)+bk(2)*th_sim(isim,1)+bk(3)*th_sim(isim,2)
  ! Now iterate across all of the spells (a spell is a time period between state variables changing)
  do isp=1,Nsp_sim(isim)-1
    ireas=iend_sim(ispind_sim(isim)-1+isp)
    tlen=tdate_sim(ispind_sim(isim)-1+isp)-start
    !hazard work
    xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
    call inthaz(start,tlen,xbtemp,bexpw(iwork,:),ihazw,hazw)
    !hazard marital status
    if (imar==1) then
     xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
    else
     xbtemp=xbm(0)
    endif
    call inthaz(start,tlen,xbtemp,bexpm(imar,:),ihazm,hazm)
    !hazard have kid
    xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
    if (nkid==1) then
     xbtemp=xbtemp+bk(6)
    elseif (nkid==2) then
     xbtemp=xbtemp+bk(7)
    elseif (nkid>2) then
     xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
    endif
    if (nkid>=1) then
     xbtemp=xbtemp+bk(10)*(tdate_sim(ispind_sim(isim)-2+isp)-bdold)
    endif
    call inthaz(start,tlen,xbtemp,bexpk,ihazk,hazk)
    tempprod=dexp(-ihazw-ihazk-ihazm)
    ireas=iend_sim(ispind_sim(isim)-1+isp)
    if (ireas==1) then
     f0(isim)=f0(isim)*tempprod*hazw
     iwork=1-iwork
    elseif (ireas==2) then
     f0(isim)=f0(isim)*tempprod*hazm
     imar=1-imar
    elseif (ireas==3) then
     f0(isim)=f0(isim)*tempprod*hazk
     nkid=nkid+1
     nkidlt7=nkidlt7+1
     nkidlt18=nkidlt18+1
     if (iwork==1) then
      if (iwkb_sim(isim,nkid)==0) then
       f0(isim)=f0(isim)*(1.0d0-pwb)
       iwork=0
      else
       f0(isim)=f0(isim)*pwb
      endif
     endif
     if (nkid==1) then
      bdold=start+tlen
     endif
    elseif (ireas==4) then
     f0(isim)=f0(isim)*tempprod
     nkidlt18=nkidlt18-1
    else
     f0(isim)=f0(isim)*tempprod
     nkidlt7=nkidlt7-1
    endif
    start=start+tlen
  enddo
  tlen=potexp_sim(isim,Nobs_sim(isim))-start
  xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
  call inthaz(start,tlen,xbtemp,bexpw(iwork,:),ihazw,hazw)
  if (imar==1) then
   xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
  else
   xbtemp=xbm(0)
  endif
  call inthaz(start,tlen,xbtemp,bexpm(imar,:),ihazm,hazm)
  xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
  if (nkid==1) then
   xbtemp=xbtemp+bk(6)
  elseif (nkid==2) then
   xbtemp=xbtemp+bk(7)
  elseif (nkid>2) then
   xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
  endif
  if (nkid>=1) then
   xbtemp=xbtemp+bk(10)*(tdate_sim(ispind_sim(isim)-2+isp)-bdold)
  endif
  call inthaz(start,tlen,xbtemp,bexpk,ihazk,hazk)
  f0(isim)=f0(isim)*dexp(-ihazw-ihazm-ihazk)
 enddo

 !Now wait from commands from head
 njj=2
 istop=0
 itag=0
 jj=0
 head=0
 do while(istop==0) ! when we are done head sends message to stop
  call MPI_RECV(jj, njj, MPI_integer, head, &
        MPI_ANY_TAG, MPI_COMM_WORLD, status, ierr)
  if (status(mpi_tag)==0) then
   istop=1
  else
  ! get parameter values
  call MPI_BCAST(parvec, npar, MPI_DOUBLE_PRECISION, head, &
 MPI_COMM_WORLD, ierr)
   call calclik(parvec)
!  call simdat(parvec)  !if not using importance weights, uncomment and comment the calclik

! First calculate fixed effects moments and send to head
  call femom(auxmom)
   call MPI_SEND(auxmom, numaux, MPI_DOUBLE_PRECISION, head, &
      itag,MPI_COMM_WORLD, ierr)
   nfe=82
   call MPI_BCAST(bfe, nfe, MPI_DOUBLE_PRECISION, head, &
      MPI_COMM_WORLD, ierr)
! receive parameters from fixed effect estimation and caluclate rest of fixed effect estimtaion
   call calth(auxmom,bfe)
   call MPI_SEND(auxmom, numaux, MPI_DOUBLE_PRECISION, head, &
      itag,MPI_COMM_WORLD, ierr)
   nfe=4
   call MPI_BCAST(bbase, nfe, MPI_DOUBLE_PRECISION, head, &
      MPI_COMM_WORLD, ierr)
      !having received intermediate global parameters, calculate rest of auxiliary parameters
   call calc_aux(auxmom,bbase)
   itag=0
   ! send result to head
   call MPI_SEND(auxmom, numaux, MPI_DOUBLE_PRECISION, head, &
      itag,MPI_COMM_WORLD, ierr)
  endif
 enddo


else ! done with worker, next  is the head

! get main parameters
 open(25,file='parin')
 do j=1,k
  read(25,*) b(j)
 enddo

! read auxiliary parameters
 naux=402
 open(144,file='data_moments')
 do j=1,naux
  read(144,*) pstat(j),sepstat(j)
 enddo

 Now maximize function
 call fsii(k,b,nf,f,uip,psim,drnor)
 write(6,*) 'f',f



 call deflt(2,iv,liv,lv,vv)
 iv(17)=10000
 iv(18)=10000
 iv(18)=100
 iv(18)=30
 vv(26)=0.0d0
 bscale=1.0d0
 uip(1)=1

call fsii(k,b,nf,f,uip,psim,drnor)

!Calculate Gradient-comment out if running estimation
ddd=1.0d-6
do j=1,k
bp=b
bp(j)=bp(j)+ddd
call fsii(k,bp,nf,fp,uip,psimp,drnor)
write(6,*) (psimp(1:402)-psim(1:402))/ddd
enddo




! This is the gradient free optimization (comment out if not using)
ftol=1.0d-7
itmax=50
itmax=500000
mode=0
scale(1)=-1.0d-3

id=1
call subplx (f2,k,ftol,itmax,mode,scale,b,f,nfe, &
        work,iww,iflag)
 f=f2(k,b)
write(6,*) 'last f',f


! This is the gradient optimiation (comment out if not using)
call smsno(k,bscale,b,fsii,iv,liv,lv,vv,uip,psim,drnor)

! Save estimates
open(33,file='parout')
do j=1,k
 write(33,*) b(j)
enddo

endif  !head/worker


 end
