subroutine calclik(b)

! Calculate the likelihood for base model under parameter b

use ggg ! global variables

! Declare key variables
implicit none
double precision :: b(npar)
integer :: isim,iwork,imar,nkidlt18,nkidlt7,nkid,isp,ireas,j,iobs
double precision :: xbw(0:1),xbm(0:1),xbk,xbtemp,tlen,start
double precision :: bm(0:1,4),bw(0:1,4),bk(10),bhc(0:1,3),gam(5)
double precision ::  bexpw(0:1,ncell),bexpm(0:1,ncell),bexpk(ncell),dlam,xhbar,sigeps
double precision :: ihazw,ihazk,ihazm,hazw,hazm,hazk,bdold,tempprod
double precision :: xbhc(0:1), hcstat(nsim,maxsp),xhct,ahc,delta,xhc
double precision :: th_sim(nsim,2),ssig12
double precision :: blam(2),blsi(3),bxh(2),pw0,blb(3),pwb


! parameters
 bm(0,1:3)=b(1:3) ! marriate
 bm(1,:)=b(4:7)
 bw(0,:)=b(8:11) ! work
 bw(1,:)=b(12:15)
 bk=b(16:25) ! having kids
 bhc(0,:)=b(26:28) ! human capital
 bhc(1,:)=b(29)
 gam=b(30:34)
 bexpw(0,:)=b(35:41) ! work hazard
 bexpw(1,:)=b(42:48)
 bexpm(0,:)=b(49:55) ! marriage hazard
 bexpm(1,:)=b(56:62)
 bexpk=b(63:69) ! children marriate
 blam=b(70:71) ! parameters for lambda part of human capital
 bxh=b(72:73) ! parameters for xhbar part of human capital
 sigeps=dexp(b(74)) ! standard deviation of measurement error
 ssig12=-1.0d0+2.0d0*(1.0d0/(1.0d0+dexp(b(75))))  ! correlation between random effects
 blsi=b(76:78) ! initial work
 blb=b(79:81) ! work right after kids



! Initialize some things
hcstat=0.0d0
fdens=1.0d0

! go across individuals
do isim=1,nsim

 ! keep track of things constant across iterations
 th_sim(isim,1)=z_sim(isim,1)
 th_sim(isim,2)=ssig12*z_sim(isim,1)+dsqrt(1.0d0-ssig12**2.0d0)*z_sim(isim,2)
 xhc=1.0d-10
 pw0=dexp(blsi(1)+blsi(2)*ed_simn(isim)+blsi(3)*th_sim(isim,2))
 pw0=pw0/(1.0d0+pw0)
 pwb=dexp(blb(1)+blb(2)*ed_simn(isim)+blb(3)*th_sim(isim,2))
 pwb=pwb/(1.0d0+pwb)
 iwork=iwk0_sim(isim)
 fdens(isim)=dble(iwork)*pw0+dble((1-iwork))*(1-pw0)
 iobs=1
 imar=0
 nkidlt18=0
 nkidlt7=0
 nkid=0
 start=0.0d0
 bdold=0.0d0
 do j=0,1
  xbw(j)=bw(j,1)*ed_simn(isim)+bw(j,2)*th_sim(isim,2)
  xbm(j)=bm(j,1)*ed_simn(isim)+bm(j,2)*th_sim(isim,1)+bm(j,3)*th_sim(isim,2)
  xbhc(j)=bhc(j,1)
 enddo
 xbk=bk(1)*ed_simn(isim)+bk(2)*th_sim(isim,1)+bk(3)*th_sim(isim,2)
 dlam=dexp(blam(1)+blam(2)*ed_simn(isim))
 xhbar=dexp(bxh(1)+bxh(2)*ed_simn(isim))

 ! Go across spells
 do isp=1,Nsp_sim(isim)-1
   ireas=iend_sim(ispind_sim(isim)-1+isp)
   tlen=tdate_sim(ispind_sim(isim)-1+isp)-start
   ! hazard work
   xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
   call inthaz(start,tlen,xbtemp,bexpw(iwork,:),ihazw,hazw)
   !hazard marital status
   if (imar==1) then
    xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
   else
    xbtemp=xbm(0)
   endif
   call inthaz(start,tlen,xbtemp,bexpm(imar,:),ihazm,hazm)
   !hazard have kid
   xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
   if (nkid==1) then
    xbtemp=xbtemp+bk(6)
   elseif (nkid==2) then
    xbtemp=xbtemp+bk(7)
   elseif (nkid>2) then
    xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
   endif
   if (nkid>=1) then
    xbtemp=xbtemp+bk(10)*(tdate_sim(ispind_sim(isim)-2+isp)-bdold)
   endif
   call inthaz(start,tlen,xbtemp,bexpk,ihazk,hazk)

   !construct density
   if (iwork==1) then
    xbtemp=xbhc(0)+bhc(0,2)*ed_simn(isim)+bhc(0,3)*dble(imar)
    ahc=dexp(xbtemp)
   else
     xbtemp=xbhc(1)
     delta=dexp(xbtemp)
   endif
   do while ((start+tlen>potexp_sim(isim,min(iobs,maxsp))).and.(iobs<=nobs_sim(isim)))
    if (iwork==0) then
     xhct=xhc*dexp(-delta*(potexp_sim(isim,iobs)-start))
    else
     xhct=xhbar+dexp(ahc*(dexp(-dlam*potexp_sim(isim,iobs))-dexp(-dlam*start))/dlam)*(xhc-xhbar)
    endif
    hcstat(isim,iobs)=xhct
    iobs=iobs+1
  enddo
  if (iwork==0) then
   xhc=xhc*dexp(-delta*tlen)
  else
   xhc=xhbar+dexp(ahc*(dexp(-dlam*(start+tlen))-dexp(-dlam*start))/dlam)*(xhc-xhbar)
  endif
   tempprod=dexp(-ihazw-ihazk-ihazm)
   ireas=iend_sim(ispind_sim(isim)-1+isp)
   if (ireas==1) then
    fdens(isim)=fdens(isim)*tempprod*hazw
    iwork=1-iwork
   elseif (ireas==2) then
    fdens(isim)=fdens(isim)*tempprod*hazm
    imar=1-imar
   elseif (ireas==3) then
    fdens(isim)=fdens(isim)*tempprod*hazk
    nkid=nkid+1
    nkidlt7=nkidlt7+1
    nkidlt18=nkidlt18+1
    if (iwork==1) then
     if (iwkb_sim(isim,nkid)==0) then
      fdens(isim)=fdens(isim)*(1.0d0-pwb)
      iwork=0
     else
      fdens(isim)=fdens(isim)*pwb
     endif
    endif
    if (nkid==1) then
     bdold=start+tlen
    endif
   elseif (ireas==4) then
    fdens(isim)=fdens(isim)*tempprod
    nkidlt18=nkidlt18-1
   else
    fdens(isim)=fdens(isim)*tempprod
    nkidlt7=nkidlt7-1
   endif
   start=start+tlen
 enddo
 tlen=potexp_sim(isim,Nobs_sim(isim))-start
 xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
 call inthaz(start,tlen,xbtemp,bexpw(iwork,:),ihazw,hazw)
 if (imar==1) then
  xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
 else
  xbtemp=xbm(0)
 endif
 call inthaz(start,tlen,xbtemp,bexpm(imar,:),ihazm,hazm)
 xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
 if (nkid==1) then
  xbtemp=xbtemp+bk(6)
 elseif (nkid==2) then
  xbtemp=xbtemp+bk(7)
 elseif (nkid>2) then
  xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
 endif
 if (nkid>=1) then
  xbtemp=xbtemp+bk(10)*(tdate_sim(ispind_sim(isim)-2+isp)-bdold)
 endif
 call inthaz(start,tlen,xbtemp,bexpk,ihazk,hazk)
 fdens(isim)=fdens(isim)*dexp(-ihazw-ihazm-ihazk)
 do while (iobs<=nobs_sim(isim))
  if (iwork==0) then
   xhct=xhc*dexp(-delta*(potexp_sim(isim,iobs)-start))
  else
   xhct=xhbar+dexp(ahc*(dexp(-dlam*potexp_sim(isim,iobs))-dexp(-dlam*start))/dlam)*(xhc-xhbar)
  endif
  hcstat(isim,iobs)=xhct
  iobs=iobs+1
 enddo
enddo

! This part is for outputting some data and is used to produce some of the figures
w_sim=0.0d0
do isim=1,nsim
 do isp=1,Nobs_sim(isim)
  w_sim(isim,isp)=gam(1)*ed_sim(isim)+gam(2)*th_sim(isim,1)+gam(3)*dble(mstat_sim(isim,isp,1))+ &
  gam(4)*dble(nklt18_sim(isim,isp))+gam(5)*dble(nklt7_sim(isim,isp))+ hcstat(isim,isp)+sigeps*eps_sim(isim,isp)
!write(6,*) myid,isim,iobs_sim(isim),potexp_sim(isim,isp),lstat_sim(isim,isp),ed_sim(isim),mstat_sim(isim,isp,:), &
!        nklt18_sim(isim,isp),nklt7_sim(isim,isp),w_sim(isim,isp),nk2_sim(isim),akid_sim(isim),ay_sim(isim,isp), &
!        da_sim(isim),hvbaby_sim(isim,isp),ip2_sim(isim),nk_sim(isim,nobs_sim(isim)),nkgt18_sim(isim,isp),numka(isim,isp,:)

!  write(6,*) myid,isim,isp,lstat_sim(isim,isp),potexp_sim(isim,isp),nklt7_sim(isim,isp),nklt18_sim(isim,isp), &
!      w_sim(isim,isp),hcstat(isim,isp),mstat_sim(isim,isp,1)
  enddo

enddo



return
end
