subroutine calc_aux(auxmom,bbase)

use ggg  !global variables


!declare variables
implicit none
double precision :: auxmom(numaux)
integer :: isim,isp,indaux
double precision ::  hcstat(nsim,maxsp)
double precision, dimension(:), allocatable :: x,xl,x2,xl2
double precision, parameter :: zeros(36)=0.0d0,zerosd(35)=0.0d0
double precision :: bbase(4),ababy,ww,wtemp
integer :: lisp,insamp
double precision :: wagel,dpe,pel,xhcl

integer :: ierr

!Auxiliary Moments

indaux=0
auxmom=0.0d0

! construct estimates of fixed effects
do isim=1,nsim
 if (never_worked(isim)<0.5d0) then
  thhat(isim,1)=thhat(isim,1)-bbase(1)-ed_sim(isim)*bbase(2)
 endif
 thhat(isim,2)=thhat(isim,2)-bbase(3)-ed_sim(isim)*bbase(4)
enddo


!fixed effect regression
allocate(x(2),xl(3))
do isim=1,Nsim
 if (never_worked(isim)<0.5d0) then
  x=(/1.0d0,thhat(isim,2)/)
  call outlng(2,x,xl)
  auxmom(indaux+1:indaux+3)=auxmom(indaux+1:indaux+3)+fdens(isim)*xl/f0(isim)
  auxmom(indaux+4:indaux+5)=auxmom(indaux+4:indaux+5)+fdens(isim)*x*thhat(isim,1)/f0(isim)
 endif
enddo
indaux=indaux+5
deallocate(x,xl)

!Marriage/Divorce
allocate(x(36),xl(666))
do isim=1,Nsim
 x=0.0d0
 x(int(potexp_sim(isim,1))+1)=1.0d0
 call outlng(36,x,xl)
 auxmom(indaux+1:indaux+666)=auxmom(indaux+1:indaux+666)+fdens(isim)*xl/f0(isim)
 auxmom(indaux+667:indaux+702)=auxmom(indaux+667:indaux+702)+fdens(isim)*x*dble(mstat_sim(isim,1,1))/f0(isim)
 auxmom(indaux+703:indaux+738)=auxmom(indaux+703:indaux+738)+fdens(isim)*x*dble(mstat_sim(isim,1,2))/f0(isim)
enddo
indaux=indaux+738


deallocate(x,xl)

!Marriage Transition

allocate(x(6),xl(21))
do isim=1,Nsim
 do isp=4,nobs_sim(isim)
  if (lstat_sim(isim,isp-3)==0) then
   wtemp=0.0d0
  else
   wtemp=w_sim(isim,isp-3)
  endif
  x=(/1.0d0,potexp_sim(isim,isp),potexp_sim(isim,isp)*potexp_sim(isim,isp), &
     ed_sim(isim),wtemp,dble(lstat_sim(isim,isp-3))/)
  call outlng(6,x,xl)
  if (mstat_sim(isim,isp-1,1)==0) then
   auxmom(indaux+1:indaux+21)=auxmom(indaux+1:indaux+21)+fdens(isim)*xl/f0(isim)
   auxmom(indaux+22:indaux+27)=auxmom(indaux+22:indaux+27)+fdens(isim)*x*dble(mstat_sim(isim,isp,1))/f0(isim)
  else
   auxmom(indaux+28:indaux+48)=auxmom(indaux+28:indaux+48)+fdens(isim)*xl/f0(isim)
   auxmom(indaux+49:indaux+54)=auxmom(indaux+49:indaux+54)+fdens(isim)*x*dble(mstat_sim(isim,isp,2))/f0(isim)
  endif
 enddo
enddo

indaux=indaux+54

!Have Baby While Married
do isim=1,nsim
 do isp=2,nobs_sim(isim)
   if (hvbaby_sim(isim,isp)==1) then
    auxmom(indaux+1)=auxmom(indaux+1)+fdens(isim)/f0(isim)
    auxmom(indaux+2)=auxmom(indaux+2)+fdens(isim)*dble(mstat_sim(isim,isp-1,1))/f0(isim)
   endif
  enddo
enddo
indaux=indaux+2


!Have Baby and Wage
deallocate(x,xl)
allocate(x(9),xl(45))
do isim=1,nsim
 ababy=0.0d0
 insamp=0
 do isp=2,nobs_sim(isim)
  if (potexp_sim(isim,isp)>=potexp_sim(isim,1)+0.99d0) then
   insamp=1
   if (hvbaby_sim(isim,isp)==1) then
    ababy=1.0d0
   endif
  endif
 enddo
 if (lstat_sim(isim,1)==1) then
  ww=w_sim(isim,1)
 else
  ww=0.0d0
 endif
 if (insamp==1) then
  x=(/1.0d0,ww,dble(lstat_sim(isim,1)),ed_sim(isim),dble(mstat_sim(isim,1,1)),dble(nklt7_sim(isim,1)), dble(nklt18_sim(isim,1)), &
    potexp_sim(isim,1)/10.0d0,potexp_sim(isim,1)*potexp_sim(isim,1)/100.0d0 /)
  call outlng(9,x,xl)
  auxmom(indaux+1:indaux+45)=auxmom(indaux+1:indaux+45)+fdens(isim)*xl/f0(isim)
  auxmom(indaux+46:indaux+54)=auxmom(indaux+46:indaux+54)+fdens(isim)*x*ababy/f0(isim)
 endif
enddo

indaux=indaux+54

!Age Difference Youngest and Oldest
do isim=1,Nsim
 if (da_sim(isim)>-1.0d0) then
  auxmom(indaux+1)=auxmom(indaux+1)+fdens(isim)/f0(isim)
  auxmom(indaux+2)=auxmom(indaux+2)+fdens(isim)*da_sim(isim)/f0(isim)
 endif
enddo

indaux=indaux+2

!Having Kids
deallocate(x,xl)
allocate(x(37),xl(703))
do isim=1,nsim
 if (nk2_sim(isim)>=0) then
  x=(/zeros,ed_sim(isim) /)
  x(ip2_sim(isim)+1)=1.0d0
  call outlng(37,x,xl)
  auxmom(indaux+1:indaux+703)=auxmom(indaux+1:indaux+703)+fdens(isim)*xl/f0(isim)
  if (nk2_sim(isim)>0) then
   auxmom(indaux+704:indaux+740)=auxmom(indaux+704:indaux+740)+fdens(isim)*x/f0(isim)
  endif
  if (nk2_sim(isim)==2) then
   auxmom(indaux+741:indaux+777)=auxmom(indaux+741:indaux+777)+fdens(isim)*x/f0(isim)
  endif
  auxmom(indaux+778:indaux+814)=auxmom(indaux+778:indaux+814)+fdens(isim)*x*dble(nk2_sim(isim))/f0(isim)
 endif
enddo
indaux=indaux+814




!Work Transition
deallocate(x,xl)
allocate(x(39),xl(780))
do isim=1,nsim
 do isp=1,nobs_sim(isim)-1
  x=(/zerosd,ed_sim(isim),dble(mstat_sim(isim,isp,1)),dble(nklt7_sim(isim,isp)), &
    thhat(isim,2)/)
  x(int(potexp_sim(isim,isp))+1)=1.0d0
  call outlng(39,x,xl)
  if (lstat_sim(isim,isp)==0) then
   auxmom(indaux+1:indaux+780)=auxmom(indaux+1:indaux+780)+fdens(isim)*xl/f0(isim)
   auxmom(indaux+781:indaux+819)=auxmom(indaux+781:indaux+819)+fdens(isim)*x*dble(lstat_sim(isim,isp+1))/f0(isim)
  else
   auxmom(indaux+820:indaux+1599)=auxmom(indaux+820:indaux+1599)+fdens(isim)*xl/f0(isim)
   auxmom(indaux+1600:indaux+1638)=auxmom(indaux+1600:indaux+1638)+fdens(isim)*x*dble(lstat_sim(isim,isp+1))/f0(isim)
  endif
 enddo
enddo
indaux=indaux+1638

! Working Kid
do isim=1,nsim
 do isp=2,nobs_sim(isim)
  if (hvbaby_sim(isim,isp)==1) then
   if (isp>2) then
    auxmom(indaux+1)=auxmom(indaux+1)+fdens(isim)/f0(isim)
    auxmom(indaux+2)=auxmom(indaux+2)+fdens(isim)*dble(lstat_sim(isim,isp-2))/f0(isim)
   endif
  endif
 enddo
enddo
indaux=indaux+2



!Wage Growth
deallocate(x,xl)
allocate(x(41),xl(861))


do isim=1,nsim
 lisp=0
 do isp=1,nobs_sim(isim)
  if ((lisp>0).and.(lstat_sim(isim,isp)==1)) then
   if (lisp==isp-1) then
    x=(/zeros,ed_sim(isim),dble(mstat_sim(isim,lisp,1)),dble(nkgt18_sim(isim,isp)), &
         ed_sim(isim)*potexp_sim(isim,isp),ed_sim(isim)*dble(nkgt18_sim(isim,isp))/)
    x(int(potexp_sim(isim,isp))+1)=1.0d0
    call outlng(41,x,xl)
    auxmom(indaux+1:indaux+861)=auxmom(indaux+1:indaux+861)+fdens(isim)*xl/f0(isim)
    auxmom(indaux+862:indaux+902)=auxmom(indaux+862:indaux+902)+fdens(isim)*x*(w_sim(isim,isp)-wagel)/f0(isim)
   elseif (lstat_sim(isim,isp-1)==0) then
    dpe=potexp_sim(isim,isp)-pel
    auxmom(indaux+903)=auxmom(indaux+903)+fdens(isim)*dpe*dpe/f0(isim)
    auxmom(indaux+904)=auxmom(indaux+904)+fdens(isim)*dpe*(w_sim(isim,isp)-wagel)/f0(isim)
   endif
  endif
  if (lstat_sim(isim,isp)==1) then
   lisp=isp
   wagel=w_sim(isim,isp)
   xhcl=hcstat(isim,isp)
   pel=potexp_sim(isim,isp)
  endif
 enddo
enddo

indaux=indaux+821




return
end
