* Initial Data Manipulation
capture log close
log using fordatw, replace
use femdat
gen date=12*(calyr-80)+calmn
gen bdate=12*(brthyr-1980)+brthmn
gen agemn=date-bdate
gen gradyr=.
replace gradyr=brthyr+16 if ed<12
replace gradyr=brthyr+18 if ed==12 
replace gradyr=brthyr+20 if ed>12 & ed < 16 
replace gradyr=brthyr+22 if ed>=16  
gen gradmn=12*(gradyr-1980)+6
gen potexp=(date-gradmn)/12
keep if race==1

gen married=0 if ms==6
replace married=1 if ms==1 | ms==2
replace married=2 if ms==3 | ms==4 | ms==5

gen curmar= married==1
gen divorced= married==2

drop if potexp<=0
drop if potexp>35
gen pe=floor(potexp)

gen lid=id[_n-1]
gen nklt18 =0
gen nklt7=0
gen nkid=0
gen baby=0
gen nk0=0
gen nk1=0
gen nk2=0
gen nk3=0
gen nk4=0
gen nk5=0
gen nk6=0
gen nk7=0


sort id wave

forv ikid=1/11{
gen agec`ikid'=trunc(calyr+(calmn-1)/12-kid_yr`ikid'+1900-(kid_mn`ikid'-1)/12)
replace agec`ikid'=. if agec`ikid'<0
replace nklt18=nklt18+1 if agec`ikid'~=. & agec`ikid'<18
replace nklt7=nklt7+1 if agec`ikid'~=. & agec`ikid'<7
replace nk0=nk0+1 if agec`ikid'~=. & agec`ikid'==0
replace nk1=nk1+1 if agec`ikid'~=. & agec`ikid'==1
replace nk2=nk2+1 if agec`ikid'~=. & agec`ikid'==2
replace nk3=nk3+1 if agec`ikid'~=. & agec`ikid'==3
replace nk4=nk4+1 if agec`ikid'~=. & agec`ikid'==4
replace nk5=nk5+1 if agec`ikid'~=. & agec`ikid'==5
replace nk6=nk6+1 if agec`ikid'~=. & agec`ikid'==6
replace nk7=nk7+1 if agec`ikid'~=. & agec`ikid'>=7

replace nkid=nkid+1 if agec`ikid'~=. 
replace baby=1 if (agec`ikid'~=. & agec`ikid'<0.5) & (agec`ikid'[_n-1]==. & lid==id)
gen agew2t`ikid'=calyr+(calmn-1)/12-kid_yr`ikid'+1900-(kid_mn`ikid'-1)/12 if wave==2
}
gen kgt18t=tmomchl-nklt18 if wave==2
by id: egen kgt18=mean(kgt18t)


forv ikid=1/11{
by id: egen agew2`ikid'=mean(agew2t`ikid')
replace kgt18=kgt18-1 if agew2`ikid'>=18 & agec`ikid'<18 & agec`ikid'~=.
replace kgt18=kgt18+1 if agew2`ikid'<18 & agec`ikid'>=18 & agec`ikid'~=.
}
replace kgt18=0 if kgt18<0

replace rwage=. if rwage<1
replace rwage=. if rwage>300
gen lwage=log(rwage)
replace lwage=-999 if lwage==.

replace tfbrthyr=. if tfbrthyr==-1
replace tfbrthyr=tfbrthyr-1900
replace tlbirtyr=. if tlbirtyr==-1
replace tlbirtyr=tlbirtyr-1900
gen anykid=tmomchl>0
gen ayoung=0 if anykid==0
replace ayoung=floor(calyr+(calmn-1)/12-tlbirtyr-(elbirtmo-1)/12) if tmomchl>1
replace ayoung=. if tlbirtyr==-1 & tmomchl>1
replace ayoung=floor(calyr+(calmn-1)/12-tfbrthyr-(efbrthmo-1)/12) if tmomchl==1
replace ayoung=. if tfbrthyr==-1 & tmomchl==1
replace ayoung=0 if ayoung<0 & ayoung~=.
gen ay2=ayoung*ayoung
gen aold=floor(calyr+(calmn-1)/12-tfbrthyr-(efbrthmo-1)/12) if tmomchl>1
gen difage=aold-ayoung


sort id potexp
drop if id*potexp*emp_c==.
format id %12.0g
sum id potexp emp_c curmar  nklt18 nklt7
replace ayoung=-999 if ayoung==.
replace tmomchl=-999 if tmomchl==.
replace kgt18=-999 if kgt18==.
replace difage=-999 if difage==.

*Output Data for Further Analysis
outfile id potexp emp_c ed married  nklt18 nklt7 lwage tmomchl kgt18 anykid ayoung difage baby wave nk0-nk7  using fordatw, wide replace



replace lwage=. if lwage<-10
replace ayoung=. if ayoung<-900
replace tmomchl=. if tmomchl<-900
replace kgt18=. if kgt18<-900
replace lwage=. if emp_c==0
replace difage=. if difage<-900

*Generate Summary Statistics
sutex potexp emp_c ed curmar divorced  nklt18 nklt7 lwage tmomchl anykid ayoung difage baby wave  


gen pe2=potexp*potexp
*Fixed Effect Wage Regression
xi: xtreg lwage i.pe nklt18 nklt7 curmar if emp_c==1, fe i(id) cluster(id)
predict lwu, ue
replace lwu=lwu+_b[_cons]

*Fixed Effect Employment Regression
xi: xtreg emp_c i.pe nk0-nk7 curmar, fe i(id) cluster(id)
predict worku, ue
replace worku=worku+_b[_cons]

sort id
by id: egen theta1=mean(lwu)
by id: egen theta2=mean(worku)

*Within and Between Variances
gen Vw=(lwu-theta1)*(lwu-theta1)
reg Vw, cluster(id)
egen mtheta1=mean(theta1) if lwu~=.
egen mtheta2=mean(theta2) if worku~=.
gen Vb1=(theta1-mtheta1)*(theta1-mtheta1)
gen Vb2=(theta2-mtheta2)*(theta2-mtheta2)
replace Vb1=. if lwu==.
replace Vb2=. if worku==.
reg Vb1, cluster(id)
reg Vb2, cluster(id)
by id: egen it=rank(potexp)

*Regression of wage and employment fixed effects on education
reg theta1   ed  if it==1, robust
predict thetar1, resid
gen thrm1=thetar1==.
reg theta2  ed  if it==1, robust
predict thetar2, resid
gen thrm2=thetar2==.
replace thetar2=0 if thrm2==1

* reg wage fixed effect on work fixed effect
reg thetar1 thetar2 if it==1, robust
replace thetar1=0 if thrm1==1



sort id potexp
replace lid=id[_n-1]
gen ptel=potexp[_n-1]
gen ptel2=ptel*ptel
gen pel=pe[_n-1]
gen n7l=nklt7[_n-1]
gen n18l=nklt18[_n-1]
gen aklt7=nklt7>0
gen akl=aklt7[_n-1]
gen lmar=curmar[_n-1] if id[_n-1]==id
gen lemp=emp_c[_n-1] if lid==id
sort lemp
* Regression of working on experience and other things conditional on previous employment
xi, noomit: reg emp_c i.pel  ed lmar   n7l thetar2  if lemp==0,nocon cluster(id)
xi, noomit : reg emp_c i.pel  ed lmar  n7l  thetar2 if lemp==1 ,nocon cluster(id)
sort id wave
by id: egen empmn=mean(emp_c)
replace thetar1=. if thrm1==1 & empmn>0

* Regression of marriage/divorce on experience and other things
xi, noomit: reg curmar i.pe  if  lid~=id, nocon cluster(id)
xi, noomit: reg divorced i.pe if lid~=id, nocon cluster(id)
gen lyemp=emp_c[_n-3] if id[_n-3]==id
gen lywage=lwage[_n-3] if id[_n-3]==id
replace lywage=0 if lyemp==0


* Regression of marriage/divorce conditoinal on previous marrital status
reg curmar potexp pe2 ed lyemp lywage  if  lid==id & lmar==0,  cluster(id)
reg divorced potexp pe2 ed lyemp lywage  if  lid==id & lmar==1, cluster(id)



gen llwork=emp_c[_n-2] if id[_n-2]==id
reg lmar  if baby==1, cluster(id)
reg llwork if baby==1, cluster(id)
by id: egen mbaby=mean(baby)
gen ababy=mbaby>0 if mbaby~=.
gen potexp2=potexp*potexp
gen lww=lwage
replace lww=0 if emp_c==0
gen pe0=potexp if lid~=id
by id: egen pe00=mean(pe0)
gen baby1=baby if potexp>=pe00+0.95
by id: egen mbaby1=mean(baby1)
* Regression of Had a Baby on state variables
gen ababy1=mbaby1>0 if mbaby1~=.
reg ababy1 lww ed curmar nklt7 nklt18  potexp potexp2 emp_c if lid~=id, robust

* difference in ages between siblings
reg difage if difage>0 & lid~=id


*Regression of fertility variables on potential experience
gen any=tmomchl>0 if tmomchl~=.
gen two=tmomchl==2 if tmomchl~=.
xi, noomit: reg any i.pe  ed  if wave==2, nocon cluster(id)
xi, noomit: reg two i.pe  ed  if wave==2, nocon cluster(id)
xi, noomit: reg tmomchl i.pe  ed if wave==2, nocon cluster(id)

replace lwage=. if lwage<-10
replace lwage=. if emp_c==0
sort id
by id: egen spmn=mean(curmar)
sort id potexp
gen nid=id[_n+1]
gen estat=emp_c
replace estat=2 if emp_c==1  & lwage==.

sort id potexp
replace lid=id[_n-1]
gen lestat=estat[_n-1] if id==lid
gen stay=1 if estat==1 & lestat==1
replace stay=0 if estat==1 & lestat==0
keep if estat==1
sort id potexp
replace lid=id[_n-1]
gen lpot=potexp[_n-1] if id==lid
gen lkid=nklt18[_n-1] if id==lid
gen lkid7=nklt7[_n-1] if id==lid
gen lsps=curmar[_n-1] if id==lid
gen layoung=ayoung[_n-1] if id==lid
gen dwage=lwage-lwage[_n-1] if id==lid
gen dpe=potexp-potexp[_n-1] if id==lid
tab estat lestat
sort stay


* wage gain regression for continuously employed
gen edpe=ed*potexp
gen edk18=ed*kgt18
xi, noomit: reg dwage i.pe   ed lsps  kgt18 edpe edk18   if stay==1, nocon cluster(id)
test kgt18 edk18

* wage gain regression for for women with nonemployment spell
xi, noomit: reg dwage dpe  if stay==0, nocon cluster(id)

