* This program:
*   Load files pseudo1_loglik`type' and from pseudo_loglik`type'_IND_`type' from fortran program
*   Find values of g_coef and gamma that maximize the PLL and, 
*   when possible (the maximum correspond to an internal point of the grid with at least two +- values for each parameter)
*   calculates robust standard errors

Autor: Graciela Sanroman
This version: September, 15 2012

* 

global ruta4 "C:\cuadros_graficos\"

set more 1
pause off
local edu=5
matrix Table4=J(4,8,.)

matrix GRAPHI=J(10,1,.)

forvalues  type=1(1)4{
clear

infile  ccrra gg gamma0 g_coef G1-G13 using "C:\resultados\educ`edu'\type`type'\pseudo1_loglik`type'.TXT"
g aux=_n
sort aux
save f15, replace


matrix resultados=J(13,13,.)
matrix colname resultados= pll1 g_coef se_g gamma se_gamma gg crra Ni pll2 p11 p00 p11b p00b
forvalues aa=1(1)13{
egen c`aa'=max(G`aa')
sum G`aa' if G`aa'==c`aa'
matrix resultados[`aa',1]=r(sum)
sum g_coef if G`aa'==c`aa'
matrix resultados[`aa',2]=r(sum)

sum gamma if G`aa'==c`aa'
matrix resultados[`aa',4]=r(sum)

sum gg if G`aa'==c`aa'
matrix resultados[`aa',6]=r(sum)
sum ccrra if G`aa'==c`aa'
matrix resultados[`aa',7]=r(sum)
}


matrix list resultados
matrix rownames resultados = Total SOUTH NORTH BLUE WHITE YOUNG OLD NOHOUS HOUSE BMEDIANW AMEDIANW BMEDIANR1 AMEDIANR1 
pause

clear
* Z1 SOUTH
* Z2 DOCCUP
* Z3 Young
* Z4 NoHouse
* Z5 Dw
* Z6 Dr1
infile  ccrra gg  id time age Z1-Z6 alpha3 Lalpha3 gamma0 g_coef lli using "C:\resultados\educ`edu'\type`type'\pseudo_loglik`type'_IND_`type'.TXT"

g I=(alpha3>0)
g plli=ln(lli)

forvalues aa=1(1)6 {
local aa2=`aa'*2
g Zi`aa2'=Z`aa'
local aa3=`aa2'+1
g Zi`aa3'=1-Z`aa'
} 

g ccrra0=.
g gg0=.

save fvari1, replace
pause off
forvalues aa=1(1)1{
use fvari1, clear
if `aa'>=2 {
keep if Zi`aa'==1
}

save fvari10, replace
replace ccrra0=el(resultados,`aa',7)
replace gg0=el(resultados,`aa',6)

scalar sccrra0=el(resultados,`aa',7)
scalar sgg0=el(resultados,`aa',6)

sum ccrra
scalar minccrra=r(min)+1
scalar maxccrra=r(max)-1

sum gg 
scalar mingg=r(min)+1
scalar maxgg=r(max)-1

if ( (sccrra0 > minccrra) & (sccrra0 < maxccrra) & (sgg0> mingg) & (sgg0 < maxgg) ) {  

save fvari10, replace
* GRADIENT AND HESSIAN WRT G_COEF
keep if ccrra==ccrra0
g aux=_n
bys id time: g auxid=aux if _n==1
bys id time: egen id2=min(auxid)
xtset id2 gg

g out_g=(F.plli-L.plli)/(F.g_coef-L.g_coef)
g hess_g=(F.out_g-L.out_g)/(F.g_coef-L.g_coef)
keep if gg==gg0
keep id time id2 gg g_coef out_g hess_g plli lli I
sort id time
save fv10, replace
pause

* GRADIENT AND HESSIAN WRT CCRRA
use fvari10, clear
keep if gg==gg0
g aux=_n
bys id time: g auxid=aux if _n==1
bys id time: egen id2=min(auxid)
xtset id2 ccrra
g out_crra=(F.plli-L.plli)/(F.gamma0-L.gamma0)
g hess_crra=(F.out_crra-L.out_crra)/(F.gamma0-L.gamma0) 
keep if ccrra==ccrra0
keep id time id2 ccrra gamma0 out_crra hess_crra
sort id time
merge 1:1 id time using fv10
drop _merge
sort id time
save fv10, replace

* HESSIAN WRT G_COEF, CCRRA
use fvari10, clear
replace ccrra0=ccrra0+1
keep if ccrra==ccrra0
g aux=_n
bys id time: g auxid=aux if _n==1
bys id time: egen id2=min(auxid)
xtset id2 gg
g out_gplus1=(F.plli-L.plli)/(F.g_coef-L.g_coef)
keep if gg==gg0
rename gamma0 gamma0_plus1
keep id time out_gplus1 gamma0_plus1
sort id time 
save fv11, replace
use fvari10, clear
replace ccrra0=ccrra0-1
keep if ccrra==ccrra0
g aux=_n
bys id time: g auxid=aux if _n==1
bys id time: egen id2=min(auxid)
xtset id2 gg
g out_g_1=(F.plli-L.plli)/(F.g_coef-L.g_coef)
keep if gg==gg0
rename gamma0 gamma0_1
keep id time out_g_1 gamma0_1
sort id time 
merge 1:1 id time using fv11
drop _merge
g hess_g_crra=(out_gplus1-out_g_1)/(gamma0_plus1-gamma0_1)

keep id time hess_g_crra
sort id time
merge 1:1 id time using fv10 
drop _merge
sort id time
save fv10, replace


* HESSIAN WRT CCRRA G_COEF
use fvari10, clear
replace gg0=gg0+1
keep if gg==gg0
g aux=_n
bys id time: g auxid=aux if _n==1
bys id time: egen id2=min(auxid)
xtset id2 ccrra
g out_crraplus1=(F.plli-L.plli)/(F.gamma0-L.gamma0)
keep if ccrra==ccrra0
rename g_coef g_coef_plus1
keep id time out_crraplus1 g_coef_plus1
sort id time 
save fv11, replace

use fvari10, clear
replace gg0=gg0-1
keep if gg==gg0
g aux=_n
bys id time: g auxid=aux if _n==1
bys id time: egen id2=min(auxid)
xtset id2 ccrra
g out_crra_1=(F.plli-L.plli)/(F.gamma0-L.gamma0)
keep if ccrra==ccrra0
rename g_coef g_coef_1
keep id time out_crra_1 g_coef_1
sort id time  
merge 1:1 id time using fv11
drop _merge
g hess_crra_g=(out_crraplus1-out_crra_1)/(g_coef_plus1-g_coef_1)

keep id time hess_crra_g
sort id time
merge 1:1 id time using fv10, 


matrix OUTER=J(2,2,.)
g sq_out_g=out_g^2
g sq_out_crra=out_crra^2
g out_g_crra=out_crra*out_g

sum sq_out_g
matrix OUTER[1,1]=r(mean)
sum sq_out_crra
matrix OUTER[2,2]=r(mean)
sum out_g_crra
matrix OUTER[1,2]=r(mean)
matrix OUTER[2,1]=r(mean)


matrix HESSIAN=J(2,2,.)
sum hess_g
matrix HESSIAN[1,1]=r(mean)
sum hess_crra 
matrix HESSIAN[2,2]=r(mean)
sum hess_g_crra
matrix HESSIAN[1,2]=r(mean)
sum hess_crra_g
matrix HESSIAN[2,1]=r(mean)
scalar Ni=r(N)

matrix invHESSIAN=-inv(HESSIAN)

matrix varcovar=1/Ni*invHESSIAN*OUTER*invHESSIAN
matrix list varcovar

matrix resultados[`aa',3]=el(varcovar,1,1)^.5
matrix resultados[`aa',5]=el(varcovar,2,2)^.5
matrix resultados [`aa',8]=Ni
sum plli
matrix resultados[`aa',9]=r(sum)


* Godness of fit
use fvari10, clear
keep if ccrra==ccrra0
keep if gg==gg0
g pr=lli if I==1
replace pr=1-lli if I==0
g IP=(pr>0.5)
sum I if IP==1
matrix resultados[`aa',10]=r(mean)
sum I if IP==0
matrix resultados[`aa',11]=1-r(mean)
egen temp6=mean(I)
g temp7=1-temp6
g IP2=(pr>temp7)
pause
sum I if IP2==1
matrix resultados[`aa',12]=r(mean)
sum I if IP2==0
matrix resultados[`aa',13]=1-r(mean)

sum I 
local i = 6-`edu'
matrix GRAPHI[9, `i']=r(mean)
matrix GRAPHI[10,`i']=r(N)
sum IP 
matrix GRAPHI[`type',`i']=r(mean)
sum IP2
local type2=4+`type'
matrix GRAPHI[`type2',`i']=r(mean)


}
else {
bys id time: keep if _n==1
sum id
scalar Ni=r(N)
matrix resultados [`aa',8]=Ni
}
}
matrix Table4[`type',1]=resultados[1,1]
matrix Table4[`type',2]=resultados[1,2]
matrix Table4[`type',3]=resultados[1,3]
matrix Table4[`type',4]=resultados[1,4]
matrix Table4[`type',5]=resultados[1,5]
matrix Table4[`type',6]=resultados[1,12]
matrix Table4[`type',7]=resultados[1,13]
matrix Table4[`type',8]=resultados[1,8]


matrix list Table4
