* Program to 
*    a) estimate the parameters of the labor income process, 
*    b) produce tables 1,2, 3 and Figures 1,2,3
*    c) export data and other inputs to the Fortran program

* Author: Graciela Sanroman
* Dataset: SHIW Bank of Italy: 1987 to 2010

* INPUT:
*            $ruta1\datainc_20120725 GENERATED BY do_paneldata_cpi_20120725


* NOTE:            `edu' split the sample into 4 categories given by the education level of the household head
                                          * 2. Elementary
					  * 3. Middle School
					  * 4. High School 
					  * 5. more than High School
*                    (category  1. Less than elementary is ignored)
* OUTPUTS 
*    Matrix tsample is 4 x 1
*                        Rows: 4 (each edu group)
*                        Column: sample size
*    Matrix BETA : is 4 x 3// also saved as text fortran input file in ruta6
*                        Rows: 4 (each edu group)
*                        Colums: 1. Betaage 2. Betasqage 3. ln(YM) 

*    Matrix MINMAXY : is 4 x 3 // also saved as text fortran input file in ruta6
*                        Rows: 4 (each edu group)
*                        Colums: 1. LOWER LIMIT FOR PERM SHOCK GRID 
*				 2. UPPER LIMIT FOR PERM SHOCK GRID
*				 3. UPPER LIMIT FOR PERM SHOCK GRID

*    Matrix COEFINDINF 


*   MATRIX DESCALPHA3: DESCRIPTIVES ALPHA3 4*4
    * ROWS: iALPH3A, MEAN ALPHA GIVEN PART, PERSISTENCE AT 0, PERSISTENCE AT 1 
*    Matrix SHOCKSRENTA 4*2
*         Rows: 4 (each edu group) 
*        Columns: 1. Sigma2permanentshock 2. Sigma2transitory shock

*    Data sets and fortran inputs file in ruta6
*             DATA_INC_A_`edu'.txt dataset, 
*                   Rows: each individual with EDU=`edu' in SAMPLE1 at each time
*                   Columns:   wit r1 r2 alpha Lalpha (fin=1235678 para terminar linea) 

*             DATA_INC_B_`edu'.txt , 
*                   Rows: each individual with EDU=`edu' in SAMPLE1 at each time
*                   Columns: 
*                           id time age SOUTH Doccup C_age House_own

*			  DATA_INC_BB_`edu'.txt , 
*                   Rows: each individual with EDU=`edu' in SAMPLE1 at each time
*                   Columns: 
*                           id time age SOUTH Doccup C_age House_own I4 (I4=Indicator of participation using a narrow definition which does not include Corporate Bonds) 
*   PAPER TABLES
*                 MIT: ESTIMATION OF MIT OVER AGE, TIME AND SQUARES FOR EACH EDUCATION GROUP  "$ruta4/TABLE2 $depvar _AGE_t GEDUC`edu'"
*			      VARIANCE OF SHOCKS IN SPECIF. 1, 2 AND 3 FOR ALL EDUCATION GROUP "$ruta4\TSHOCKSRENTA.txt"
*



/* Estimation of the model:
    y(i,t)=y(i,0)+eta(i)+x(i,t)Beta+u(i,t)
Differents specification for u(i,t):	
	Specification 1: h(i,t)= psi(i,t) + D.v(i,t);
    Specification 2: h(i,t)=psi(i,t)+D.(v(i,t)+theta1*v(i,t-1))
	Specification 3: h(i,t)=b(i)+psi(i,t) + D.v(i,t)
*/	
 
#delimit;
pause off;
clear all;
set more 1;
set memory 400m;
set matsize 800;



* 1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1;
* 1.1 DEFINITION OF ROUTES AND WAVES' YEARS;


global ruta "C:\SHIW";
global ruta1 "C:\SHIW";
global ruta4 "C:\SHIW";
global ruta5 "C:\SHIW";
global ruta6 "C:\SHIW";


global anios "1991 1993 1995 1998 2000 2002 2004 2006 2008 2010";

* 1.2 DEFINITION OF THE DEPENDENT VARIABLE (non-financial income or labor income);
global depvar "lnylab"; //lab";
if "$depvar"=="lny1" {; global labely "Net disposable income in logs(exc. Inc. from finan. assets))"; };
if "$depvar"=="lnylab" {; global labely "Labor income in logs"; };
if "$depvar"=="lnylabba2" {; global labely "Labor income + imputed rents for real assets in logs"; };


* 1.3 DEFINITION OF STATA OUTPUTS;

capture log close ;
log using $ruta5/process_$depvar.log, replace;
capture log close;
global loggeneral "log using "$ruta5/process_$depvar.log", append";

log using "$ruta5\gmm_$depvar.log", replace;
capture log close;
global loggmm "log using "$ruta5/gmm_$depvar.log", append";


* 1.4  DEFINITION OF MATRIX TO STORE RESULTS;
matrix tsample=J(4,1,.);
matrix colnames tsample = SAMPLESIZE;
matrix MINMAXY=J(4,3,.);
matrix BETA=J(4,3,.);
matrix SHOCKSRENTA=J(4,2,.);
matrix DESCALPHA3=J(5,4,.);
 matrix colnames DESCALPHA3 = "Elementary"	"Secondary"	"High_School"	"College or Post-graduated";
 matrix rownames DESCALPHA3 = "Participants"	"E(a!a>0)"	"sigma(a!a>0)" "Persistence at 0" "Persistence at 1";

matrix GRAPHIALPHA3=J(20,6,.);
 matrix colnames GRAPHIALPHA3 = "Edu2"	"Edu3"	"Edu4"	"Edu5" "Type" "Year";
 matrix rownames GRAPHIALPHA3 = 1991 1991 1993 1993 1995 1995 1998 1998 2000 2000 2002 2002 2004 2004 2006 2006 2008 2008 2010 2010;    
#delimit;

forvalues ee= 1(2)19 {;
local ee2=`ee'+1;
matrix GRAPHIALPHA3[`ee',6]=1990+`ee';
matrix GRAPHIALPHA3[`ee2',6]=1990+`ee';
matrix GRAPHIALPHA3[`ee',5]=1;
matrix GRAPHIALPHA3[`ee2',5]=2;
};


matrix GRAPHIALPHA4=J(20,6,.);
 matrix colnames GRAPHIALPHA4 = "Edu2"	"Edu3"	"Edu4"	"Edu5" "Type" "Year";
 matrix rownames GRAPHIALPHA4 = 1991 1991 1993 1993 1995 1995 1998 1998 2000 2000 2002 2002 2004 2004 2006 2006 2008 2008 2010 2010;    
#delimit;

forvalues ee= 1(2)19 {;
local ee2=`ee'+1;
matrix GRAPHIALPHA4[`ee',6]=1990+`ee';
matrix GRAPHIALPHA4[`ee2',6]=1990+`ee';
matrix GRAPHIALPHA4[`ee',5]=1;
matrix GRAPHIALPHA4[`ee2',5]=2;
};

matrix TABLE2=J(20,12,.);

matrix INCOME=J(10,5,.);
matrix P25INCOME=J(10,4,.);
matrix P75INCOME=J(10,4,.);
matrix SDINCOME=J(10,4,.);
matrix SAMPLE=J(10,4,.);


matrix ALPHA3=J(10,5,.);
matrix P25ALPHA3=J(10,4,.);
matrix P75ALPHA3=J(10,4,.);

matrix FINANCIALWEALTH=J(10,5,.);
matrix P25FW=J(10,4,.);
matrix P75FW=J(10,4,.);
matrix SDFINANCIALW=J(10,4,.);



/* 2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2
* 2. LOOP OVER EDUCATION GROUPS TO :
*									- ESTIMATE COMPONENTS OF LABOR INCOME PROCESS
*									- GENERATE DATA TO EXPORT TO FORTRAN PROGRAM
*                                                                       - CREATE MATRIX TO MAKE TABLES AND FIGURES 
 */;

forvalues edu = 2 (1) 5 {;
$loggeneral; 
*qui {;
local i = `edu'-1;

  matrix TSHOCKSRENTA`edu'=J(9,3,.);
  matrix colnames TSHOCKSRENTA`edu' = Spec_1 Spec_2 Spec_3;    
  matrix rownames TSHOCKSRENTA`edu' = sigma2e se_sigma2e sigma2v se_sigma2v theta1 se_theta1 sigma2b se_sigma2b p_value; 
  

/* 2.1 PART I: Estimation MCO estimation of 
              -BETA`edu' for MIT component of Permanent income
              - wit r1 and r2
			  */;
#delimit;			  
use $ruta1\data_JAE_20130113, clear;
 keep if age<61 & Deduc`edu'==1 & (occup==1 | occup==2);


g age2=.;
local at=1;

forvalues aa=20(2)60 {;
replace age2		=	`at'	if age>=	`aa'	;	
local at= `at'+1;
};	
drop age;
rename age2 age;
g t=time;
g sqage=age^2;
g sqt=t^2;
 
* Compute initial condition and average income level for each id;

* Dependent variable (non-financial income or labor income);
g y=$depvar;

* Computing log(Ym), etayi, y(ti) and h(i,t), r1, r2, wit (see Appendix B);
   qui sum y;
   matrix BETA[`i',3]=r(mean);

    egen meany=mean(y); label variable meany "Avg. of $labely in the panel";
    egen etay_i=mean(y), by(id);  label variable etay_i "Avg of $labely0 minus y_ti";
    egen ti=min(t), by(id);  label variable ti "First period of HH i in the panel";
	
	g c1=y-etay_i if t==ti;
	egen f_ti=min(c1), by(id); label variable f_ti "$labely0 in the first period of HH i in the panel";
                      drop c1;

	gen y_1=y-f_ti-etay_i;  label variable y_1 "$labely0 minus y_ti minus etay_i";
	g dy=y-L.y;
	

* Estimation of Z_{it}'=Beta1*age{it}+Beta2*sqage{it}+Beta3*t (see Appendix B);

                  

disp "educ=" `edu'; 
            reg dy age, nocons;
			
			 matrix eb=e(b);
			 matrix eV=e(V);
			 local ppp=(`edu'-2)*5+1;
			 matrix TABLE2[`ppp',1]=`edu';
			 matrix TABLE2[`ppp',2]=e(N);
			 matrix TABLE2[`ppp',3]=e(r2);
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',3]=el(eb,1,1);
			 matrix TABLE2[`ppp',4]=el(eV,1,1)^.5;
			
			 
			 reg dy age, r;
			 matrix eb=e(b);
			 matrix eV=e(V);
			 local ppp=(`edu'-2)*5+1;
			 matrix TABLE2[`ppp',5]=e(r2);
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',5]=el(eb,1,1);
			 matrix TABLE2[`ppp',6]=el(eV,1,1)^.5;
			 local ppp=`ppp'+3;
			 matrix TABLE2[`ppp',5]=el(eb,1,2);
			 matrix TABLE2[`ppp',6]=el(eV,2,2)^.5;
			 
			 reg dy age sqage, r nocons;
			 matrix eb=e(b);
			 matrix eV=e(V);
			 local ppp=(`edu'-2)*5+1;
			 matrix TABLE2[`ppp',7]=e(r2);
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',7]=el(eb,1,1);
			 matrix TABLE2[`ppp',8]=el(eV,1,1)^.5;
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',7]=el(eb,1,2);
			 matrix TABLE2[`ppp',8]=el(eV,2,2)^.5;
			 
			 			 
		  	 reg dy age sqage, r; 
			 matrix eb=e(b);
			 matrix eV=e(V);
			 local ppp=(`edu'-2)*5+1;
			 matrix TABLE2[`ppp',9]=e(r2);
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',9]=el(eb,1,1);
			 matrix TABLE2[`ppp',10]=el(eV,1,1)^.5;
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',9]=el(eb,1,2);
			 matrix TABLE2[`ppp',10]=el(eV,2,2)^.5;
			 local ppp=`ppp'+2;
			 matrix TABLE2[`ppp',9]=el(eb,1,3);
			 matrix TABLE2[`ppp',10]=el(eV,3,3)^.5;
						
			 reg dy age sqage t, r; 
			 matrix eb=e(b);
			 matrix eV=e(V);
			 local ppp=(`edu'-2)*5+1;
			 matrix TABLE2[`ppp',11]=e(r2);
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',11]=el(eb,1,1);
			 matrix TABLE2[`ppp',12]=el(eV,1,1)^.5;
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',11]=el(eb,1,2);
			 matrix TABLE2[`ppp',12]=el(eV,2,2)^.5;
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',11]=el(eb,1,3);
			 matrix TABLE2[`ppp',12]=el(eV,3,3)^.5;
			 local ppp=`ppp'+1;
			 matrix TABLE2[`ppp',11]=el(eb,1,4);
			 matrix TABLE2[`ppp',12]=el(eV,4,4)^.5;
			

* ESTIMATE THE FINAL MODEL AND STORE RESULTS TO EXPORT TO FORTRAN;
 reg dy age sqage, nocons robust;
  predict resi, resid;

			 matrix eb=e(b);
			 matrix BETA[`i',1]=el(eb,1,1);
			 matrix BETA[`i',2]=el(eb,1,2);
			 
			
save f11, replace;		     
			 


 matrix MIT`edu'=J(20,2,1);
  matrix colnames MIT`edu'= Lc1_`edu' Lc2_`edu';  
  sum age;
  local ma=r(min);
  g ymage=exp(meany) if age==`ma';
  sum ymage;
  scalar inc0=r(mean);
  

          scalar coefa=el(eb,1,1);
		  scalar coefa2=el(eb,1,2);
			forvalues at = 2 (1) 20 {;
			local at2=`at'-1;
			  sum meany if age==`at';
			       scalar coefa=el(eb,1,1);
		            scalar coefa2=el(eb,1,2);
			           matrix MIT`edu'[`at',1]=r(mean)/inc0;
					   matrix MIT`edu'[`at',2]=MIT`edu'[`at2',2]*exp(coefa*`at'+coefa2*`at'^2);
			 };

 *};
 
g control=id +time+ age + v_af+ etay_i+y +alpha;
keep if Deduc`edu'==1 & control!=.;
keep if SAMPLE1==1 & age<21;

sum age;
local ma=r(min);
forvalues at = `ma' (1) 20 {;
local at2=`at'-1;
		   replace ymage=exp(meany)*MIT`edu'[`at',1] if age==`at';
 };

g r1=exp(etay_i)/ymage;
g r2=exp(y)/exp(etay_i);
g wit=(v_af)/ymage;


centile r1 if SAMPLE1==1, c(1 99);
matrix MINMAXY[`i',1]=r(c_1);
matrix MINMAXY[`i',2]=r(c_2);

centile r2 if SAMPLE1==1 & r2!=., c(1 99);
matrix MINMAXY[`i',3]=r(c_2);
centile wit if SAMPLE1==1, c(2 99.5);
drop if wit>r(c_2) & alpha==0;
drop if r1<MINMAXY[`i',1] | r1>MINMAXY[`i',2];
drop if r2>MINMAXY[`i',3];

g I=alpha>0;


* ELIMINATION OF OUTLIERS (if individual weight in LL is greater than 10 times her weight in the sample); 
forvalues elimino = 1(1) 4 {;
logit I r1 r2 wit;
predict pr;
g ll=I*ln(pr)+(1-I)*ln(1-pr);
sum ll;
g par=ll/r(sum);
g par2=1/r(N);
sum par par2;
drop if par>par2*10;
drop pr ll par par2;  
}; 
logit I r1 r2 wit;
predict pr;
g ll=I*ln(pr)+(1-I)*ln(1-pr);
sum ll;
g par=ll/r(sum);
g par2=1/r(N);
sum par par2;

g fin=1235678;

* alpha2 is equal to the proportion of bonds and equities wrt to financial assets;
g alpha2=v_af2/v_af if v_af!=. &  v_af2!=.;
g I2=alpha2>0 & alpha2!=.;

* alpha3 is equal to the proportion of corporate bonds and equities wrt to financial assets;
g alpha3=v_af3/v_af if v_af!=. &  v_af3!=.;
g I3=alpha3>0 & alpha3!=.;
g Lalpha3=L.alpha3;
sum alpha3 Lalpha3;
replace Lalpha3=-99 if Lalpha3==.; 
g LI3=L.I3;
tab I3;
tab I3 if LI3!=.;
tab I3 LI3, col;

g I23=(I2==1 & I3==1);

tabstat I*, s(mean median count);

sum I3;
matrix DESCALPHA3[1,`i']=r(mean);
dis "table 3";
pause;
g sqr1=r1^2;
g sqr2=r2^2;
g sqwit=wit^2;
reg I3 wit r1 r2 sqr1 sqr2 sqwit age sqage;
reg alpha3 wit r1 r2 sqr1 sqr2 sqwit age sqage;
reg alpha3 wit r1 r2 sqr1 sqr2 sqwit age sqage if I3==1;
pause;


* I4 is an indicator variable equal to 1 if HH owns equities, mutual funds, managed savings or foregein securities ;
g a4=(pazi==1)+(pqfc==1)+(pgp==1)+(pte==1);
g I4=(a4>=1) if a4!=.;

*qui;


* STORE RESULTS FOR FIGURES 3 AND A1;
local ani=1;
foreach anios in 1991 1993 1995 1998 2000 2002 2004 2006 2008 2010{;
dis `anios';
local ani2=`ani'+1;
sum I3 if year==`anios';
matrix GRAPHIALPHA3[`ani',`i']=r(mean);
matrix GRAPHIALPHA3[`ani2',`i']=r(N);
sum I4 if year==`anios';
matrix GRAPHIALPHA4[`ani',`i']=r(mean);
matrix GRAPHIALPHA4[`ani2',`i']=r(N);

local ani=`ani'+2;
};
*pause;

* STORE RESULTS FOR TABLE 3;
sum alpha3 if I3==1;
matrix DESCALPHA3[2,`i']=r(mean);
matrix DESCALPHA3[3,`i']=r(sd);
sum I3 if LI3==0;
matrix DESCALPHA3[4,`i']=1-r(mean);
sum I3 if LI3==1;
matrix DESCALPHA3[5,`i']=r(mean);

* DEFINE ADDITIONAL VARIBLES: House owners, Young, Above/below median permanent income and ratio FW to permanent income;
*pause;
count;
matrix tsample[`i',1]=r(N);

g NoHouse=(House_own==0);
replace NoHouse=-99 if House_own==.;

g Young=(C_age==0);
replace Young=-99 if House_own==.;

xtile xwit=wit, nq(2);

g xw2=.;
forvalues ta=3(1)12{;
xtile xwit2=wit, nq(2), if t==`ta';
replace xw2=xwit2 if t==`ta';
drop xwit2;
};


g xr2=.;
forvalues ta=3(1)12{;
xtile xrit2=r1, nq(2), if t==`ta';
replace xr2=xrit2 if t==`ta';
drop xrit2;
};


xtile xr1=r1, nq(2);
g Dw=xwit-1;
g Dr1=xr1-1;
g uno=1;


#delimit;

* Matrix for Figures 1 and 2 ;
egen meany_y=mean(exp(y)), by(year);
egen sdy_y=sd(exp(y)), by(year);
egen p25li_y=pctile(exp(y)), p(25) by(year);
egen p75li_y=pctile(exp(y)), p(75) by(year);
egen meanaf_y=mean(v_af), by(year);
egen p25af_y=pctile(v_af), p(25) by(year);
egen sdaf_y=sd(v_af), by(year);
egen p75af_y=pctile(v_af), p(75) by(year);
g alpha3b=alpha3;
replace alpha3b=. if alpha3==0;
egen meanalpha3_y=mean(alpha3b), by(year);
egen p25al3_y=pctile(alpha3b), p(25) by(year);
egen p75al3_y=pctile(alpha3b), p(75) by(year);
local ani=1;
foreach anios in 1991 1993 1995 1998 2000 2002 2004 2006 2008 2010{;
dis `anios';
sum meany_y if year==`anios';
matrix INCOME[`ani',`i']=r(mean);
matrix INCOME[`ani',5]=`anios';
sum sdy_y if year==`anios';
matrix SDINCOME[`ani',`i']=r(mean);

sum p25li_y if year==`anios';
matrix P25INCOME[`ani',`i']=r(mean);
sum p75li_y if year==`anios';
matrix P75INCOME[`ani',`i']=r(mean);

sum meanaf_y if year==`anios';
matrix FINANCIALWEALTH[`ani',`i']=r(mean);
matrix FINANCIALWEALTH[`ani',5]=`anios';
sum p25af_y if year==`anios';
matrix P25FW[`ani',`i']=r(mean);
sum p75af_y if year==`anios';
matrix P75FW[`ani',`i']=r(mean);
sum sdaf_y if year==`anios';
matrix SDFINANCIALW[`ani',`i']=r(mean);


sum meanalpha3_y if year==`anios';
matrix ALPHA3[`ani',`i']=r(mean);
matrix ALPHA3[`ani',5]=`anios';
sum p25al3_y if year==`anios';
matrix P25ALPHA3[`ani',`i']=r(mean);
sum p75al3_y if year==`anios';
matrix P75ALPHA3[`ani',`i']=r(mean);

matrix SAMPLE[`ani',`i']=r(N);
local ani=`ani'+1;
};


* EXPORT DATA SETS TO FORTRAN PROGRAM
*outsheet id time age SOUTH Doccup Young NoHouse Dw Dr1 using "$ruta6\DATA_INC_B_`edu'.txt",  nonames replace;
*outsheet wit r1 r2 alpha3 Lalpha3 fin using "$ruta6\DATA_INC_A_`edu'.txt", delimiter(";") nonames replace;

*outsheet id time age SOUTH Doccup Young NoHouse Dw Dr1 I4 using "$ruta6\DATA_INC_BB_`edu'.txt",  nonames replace; 

*qui {;


use f11, clear;

* 3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3.3;
*PART II ;
* ESTIMATION OF  covariance structure;
keep resi id time; 

g h=resi; label variable h "First difference of residuals";


keep h id time; 
reshape wide h, i(id) j(time);
save $ruta/h1`edu', replace;


* PART II A: Estimation of Specification 1: D.[y*(i,t)-sum(z(i,t)] = psi(i,t) + D.v(i,t);
use $ruta/h1`edu', clear;    
#delimit;
* Next loop define CO conditions related with the variance of h
Variables 
      -   h`t' (square of h, h(i,t)= [y*(i,t)-sum(z(i,t)] )
Global
      -  CO_0_`t' CO associated with sqh`t';
  	   
			forvalues t = 3 (1) 12 {;
				g sqh`t'=h`t'^2;
				global CO_0_`t' "(sqh`t'-{sigma2e}-2*{sigma2v})";
				};	


			* Next loop define  CO conditions related with the covariance h(t), h(t-1)
			Variables 
				  -   C1h`t' (covariance h(t),h(t-1))
			Global
				  -  CO_1_`t' CO associated with C1h`t';
					  
			forvalues t = 4 (1) 12 {;
				  local t_1= `t'-1;
				  g C1h`t'=h`t'*h`t_1';
				  global CO_1_`t'  "(C1h`t'+{sigma2v})";
			 }		 ;


			* Declaring Moment conditions of specification 1;
			global u;
			forvalues  t= 3 (1) 12 {;
			global u $u ${CO_0_`t'};
			};

			forvalues  t=  4 (1) 12 {;
			global u $u ${CO_1_`t'};
			};


capture log close;
$loggmm;

* EDUCATION GROUP=; 
dis "`edu'";
* SPECIFICATION 1: D.[y*(i,t)-sum(z(i,t)] = psi(i,t) + D.v(i,t);
* DEPENDENT VARIABLE OF THE LEVEL EQUATION $depvar;
gmm $u,  
nocommonesample winitial(identity) two nolog;
estat overid;

 matrix eb=e(b);
 matrix ev=e(V);
 matrix SHOCKSRENTA[`i',1]=el(eb,1,1);
 matrix SHOCKSRENTA[`i',2]=el(eb,1,2);
 
 matrix TSHOCKSRENTA`edu'[1,1]=el(eb,1,1);
 matrix TSHOCKSRENTA`edu'[2,1]=el(ev,1,1)^0.5;
 matrix TSHOCKSRENTA`edu'[3,1]=el(eb,1,2);
 matrix TSHOCKSRENTA`edu'[4,1]=el(ev,2,2)^0.5;
 matrix TSHOCKSRENTA`edu'[9,1]=chi2tail(e(J_df),e(J));
log close;
$loggeneral;
******************************************************************************************************************************************
******************************************************************************************************************************************

#delimit;
* Part II b: Estimation of the model:
    Estimation of Specification 2: D.[y*(i,t)-sum(z(i,t)] = psi(i,t) + D.v(i,t)+theta1*D.v(i,t-1);

use $ruta/h1`edu', clear;    

* 
* Next loop define CO conditions related with the variance of h
Variables 
      -   h`t' (square of h, h(i,t)= [y*(i,t)-sum(z(i,t)] )
Global
      -  CO2_0_`t' CO associated with sqh`t';


			forvalues t = 3 (1) 12 {;
				g sqh`t'=h`t'^2;
				global CO2_0_`t' "(sqh`t'-{sigma2e}-2*(1+{theta1}^2-{theta1})*{sigma2v})";
				};	


			* Next loop define  CO conditions related with the covariance h(t), h(t-1)
			Variables 
				  -   C1h`t' (covariance h(t),h(t-1))
			Global
				  -  CO2_1_`t' CO associated with C1h`t';

					  
			forvalues t = 4 (1) 12 {;
				  local t_1= `t'-1;
				  g C1h`t'=h`t'*h`t_1';
				  global CO2_1_`t'  "(C1h`t'+{sigma2v}*((1-{theta1})^2) )";
			 }		 ;



			* Next loop define  CO conditions related with the covariance h(t), h(t-2)
			Variables 
				  -   C2h`t' (covariance h(t),h(t-2))
			Global
				  -  CO2_2_`t' CO associated with C1h`t';
					  
			forvalues t = 5 (1) 12 {;
				  local t_2= `t'-2;
				  g C2h`t'=h`t'*h`t_2';
				  global CO2_2_`t'  "(C2h`t'+{sigma2v}*{theta1} )";
			 }		 ;


			#delimit;
			global u;


			* Declaring Moment conditions of specification 2;
			global u;
			forvalues  t= 3 (1) 12 {;
			global u $u ${CO2_0_`t'};
			};

			forvalues  t=  4 (1) 12 {;
			global u $u ${CO2_1_`t'};
			};


			forvalues  t=  5 (1) 12 {;
			global u $u ${CO2_2_`t'};
			};

#delimit;
log close;
$loggmm;
* SPECIFICATION 2: 
   D.[y*(i,t)-sum(z(i,t)] = psi(i,t) + D.v(i,t)+theta1*D.v(i,t-1);
* DEPENDENT VARIABLE OF THE LEVEL EQUATION $variable;
 local s2e =el(TSHOCKSRENTA`edu',1,1);
 local s2v =el(TSHOCKSRENTA`edu',3,1);
 
gmm $u,  nocommonesample winitial(identity) from(sigma2e `s2e' sigma2v `s2v' theta1 0.00) ;
estat overid;
log close;
 matrix eb=e(b);
 matrix ev=e(V);
 matrix TSHOCKSRENTA`edu'[1,2]=el(eb,1,1);
 matrix TSHOCKSRENTA`edu'[2,2]=el(ev,1,1)^0.5;
 matrix TSHOCKSRENTA`edu'[3,2]=el(eb,1,3);
 matrix TSHOCKSRENTA`edu'[4,2]=el(ev,3,3)^0.5;
 matrix TSHOCKSRENTA`edu'[5,2]=el(eb,1,2);
 matrix TSHOCKSRENTA`edu'[6,2]=el(ev,2,2)^0.5;
 matrix TSHOCKSRENTA`edu'[9,2]=chi2tail(e(J_df),e(J));


$loggeneral;


******************************************************************************************************************************************
******************************************************************************************************************************************

#delimit;
* Part II C: Estimation of specification 3:
     D.[y*(i,t)-sum(z(i,t)] = etad(i)+psi(i,t) + D.v(i,t);

use $ruta/h1`edu', clear;    
*Next loop define CO conditions related with the variance of h
Variables 
      -   h`t' (square of h, h(i,t)= [y*(i,t)-sum(z(i,t)] )
Global
      -  CO3_0_`t' CO associated with sqh`t';
	  	   
			forvalues t = 3 (1) 12 {;
				g sqh`t'=h`t'^2;
				global CO3_0_`t' "(sqh`t'-{sigma2e}-2*{sigma2v}-{sigma2b})";
				};	


			* Next loop define  CO conditions related with the covariance h(t), h(t-1)
			Variables 
				  -   C1h`t' (covariance h(t),h(t-1))
			Global
				  -  CO3_1_`t' CO associated with C1h`t';
					  
			forvalues t = 4 (1) 12 {;
				  local t_1= `t'-1;
				  g C1h`t'=h`t'*h`t_1';
				  global CO3_1_`t'  "(C1h`t'+{sigma2v}-{sigma2b})";
			 }		 ;


             * Next loop define  CO conditions related with the covariance h(t), h(t-j)
			Variables 
				  -   Ch_`tj' (covariance h(t),h(t-j))
			Global
				  -  CO3_`tj' CO associated with Cov`t'_`tj';
					 
               forvalues ss = 2 (1) 6 {;
			       g Ch_`ss'=.;  
			   forvalues t = 5 (1) 12 {;
			      local t_j= max(2,`t'-`ss');
				  replace Ch_`ss'=h`t'*h`t_j' if h`t'!=. & h`t_j'!=.;
				  global CO3_`ss'  "(Ch_`ss'-{sigma2b})";
			    }		 ;
			};
			
			* Declaring Moment conditions of specification 3;
			global u;
			forvalues  t= 3 (1) 12 {;
			global u $u ${CO3_0_`t'};
			};

			forvalues  t=  4 (1) 12 {;
			global u $u ${CO3_1_`t'};
			};
			#delimit;
		
				   forvalues ss =  2(1)6 {;
				    count if Ch_`ss' !=.;
				    local obs=r(N);
				    if  `obs' != 0 {;    global u $u ${CO3_`ss'} ; };
				   };
			
log close;
$loggmm;

* SPECIFICATION 3: 
   D.[y*(i,t)-sum(z(i,t)] = etad(i)+psi(i,t) + D.v(i,t);
* DEPENDENT VARIABLE OF THE LEVEL EQUATION $variable;
local s2e =el(TSHOCKSRENTA`edu',1,1);
 local s2v =el(TSHOCKSRENTA`edu',3,1);
 
gmm $u,  
from(sigma2e `s2e' sigma2v `s2v' sigma2b 0.00) 
nocommonesample
winitial(identity) nolog  ;
estat overid;
matrix eb=e(b);
 matrix ev=e(V);
 matrix TSHOCKSRENTA`edu'[1,3]=el(eb,1,1);
 matrix TSHOCKSRENTA`edu'[2,3]=el(ev,1,1)^0.5;
 matrix TSHOCKSRENTA`edu'[3,3]=el(eb,1,2);
 matrix TSHOCKSRENTA`edu'[4,3]=el(ev,2,2)^0.5;
 matrix TSHOCKSRENTA`edu'[7,3]=el(eb,1,3);
 matrix TSHOCKSRENTA`edu'[8,3]=el(ev,3,3)^0.5;
 matrix TSHOCKSRENTA`edu'[9,3]=chi2tail(e(J_df),e(J));

 log close;
pause;

};  //END LOOP ESTIMATIONS OVER EDU;
*}; // END QUI;
****************************************************************************************************;

* 4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4;
* TABLES, FIGURES AND INPUTS FOR THE STRUCTURAL ESTIMATION ;
*
#delimit;
clear;
clear;
svmat SHOCKSRENTA;
outfile using "$ruta6\SHOCKSRENTA.txt", replace;

clear;
svmat TSHOCKSRENTA2, names(col);
g tipo=1 ;
replace tipo=2 if _n==2 | _n==4 | _n==6 | _n==8 ;
g var=1;
replace var=2 if _n==3 | _n==4;
replace var=3 if _n==5 | _n==6;
replace var=4 if _n==7 | _n==8;
replace var=5 if _n==9;
reshape wide Spec_1 Spec_2 Spec_3, i(var) j(tipo); 
g vari=		"sigma2e"	if _n==1	;
replace vari=		"sigma2v"	if _n==2	;
replace vari=		"theta1"	if _n==3	;
replace vari=		"sigma2b"	if _n==4	;
replace vari=		"p_value"	if _n==9	;
g edu=2;
save cuadro7, replace;

forvalues edu = 3 (1) 5 {;
clear;
svmat TSHOCKSRENTA`edu', names(col);
g tipo=1 ;
replace tipo=2 if _n==2 | _n==4 | _n==6 | _n==8 ;	
g var=1;
replace var=2 if _n==3 | _n==4;
replace var=3 if _n==5 | _n==6;
replace var=4 if _n==7 | _n==8;
replace var=5 if _n==9;
reshape wide Spec_1 Spec_2 Spec_3, i(var) j(tipo); 
g vari=		"sigma2e"	if _n==1	;
replace vari=		"sigma2v"	if _n==2	;
replace vari=		"theta1"	if _n==3	;
replace vari=		"sigma2b"	if _n==4	;
replace vari=		"p_value"	if _n==9	;
g edu=`edu';
append using cuadro7;
save cuadro7, replace;
};
mvencode _all, mv(-99);
outsheet edu vari  Spec_11 Spec_12 Spec_21 Spec_22 Spec_31 Spec_32 using "$ruta4\TSHOCKSRENTA.txt", replace;

#delimit;
clear;
svmat TABLE2, names(col);
g vari="Age" if _n==2 | _n==7 | _n==12 | _n==17; 
replace vari="Age Squared" if _n==3 | _n==8 | _n==13 | _n==18;
replace vari="Time Trend" if _n==4 | _n==9 | _n==14 | _n==19;
replace vari="Constant" if _n==5 | _n==10 | _n==15 | _n==20; 
mvencode _all, mv(-99);
outsheet vari  c1-c12 using "$ruta4\BETARENTA.txt", replace;  


global ruta6 "c:\portfolio15\INPUTS\";
svmat BETA;
outfile using "$ruta6\BETA.txt", replace;


clear;
svmat MINMAXY;
outfile using "$ruta6\MINMAXY.txt", replace;
clear;

#delimit;
matrix list DESCALPHA3;

matrix list GRAPHIALPHA3;



* FIGURE 1;

#delimit;
clear;
svmat INCOME;
svmat SAMPLE;
svmat SDINCOME;
svmat P25INCOME;
svmat P75INCOME;
rename INCOME5 Year;
reshape long INCOME SDINCOME P25INCOME P75INCOME SAMPLE, i(Year) j(Educ);
g valort=invttail(SAMPLE-1,0.025);
rename INCOME Labor_income;
g LL_CI=Labor_income-valort*SDINCOME;
replace LL_CI=0 if LL_CI<0;
g UL_CI=Labor_income+valort*SDINCOME;
replace Educ=4-Educ;
label define Educ 3 "Elementary" 2 "Secondary" 1 "High_School" 0 "College";
label value Educ Educ;
tab Educ;
label variable Labor_income "Avg Labor Income";
label variable P25 "Percentile 25";
label variable P75 "75";
twoway (rarea P25 P75 Year, xlabel(1993(4)2009) ylabel(10(10)50) fcolor(gs14) lcolor(gs14) 
yscale(range(10 50)) ) (line Labor_income Year, sort xlabel(1993(4)2009) 
lcolor(black) lwidth(medium) lpattern(solid) cmissing(n)), ytitle("thousand euros") yscale(range(10 50)) ylabel(10(10)50) 
by(, legend(on)) by(Educ);



* FIGURE 2;
#delimit;
clear;
svmat FINANCIALWEALTH;
svmat SAMPLE;
svmat SDFINANCIALW;
svmat P25FW;
svmat P75FW;
rename FINANCIALWEALTH5 Year;
reshape long FINANCIALWEALTH SDFINANCIALW P25FW P75FW SAMPLE, i(Year) j(Educ);
g valort=invttail(SAMPLE-1,0.025);
rename FINANCIALWEALTH Avg_F_W;
g LL_CI=Avg_F_W-valort*SDFINANCIALW;
replace LL_CI=0 if LL_CI<0;
g UL_CI=Avg_F_W+valort*SDFINANCIALW;
replace Educ=4-Educ;
label define Educ 3 "Elementary" 2 "Secondary" 1 "High_School" 0 "College";
label value Educ Educ;
tab Educ;
label variable Avg_F_W "Avg Financial Wealth";
label variable P25FW "Percentile 25";
label variable P75FW "75";
twoway (rarea P25FW P75FW Year, xlabel(1993(4)2009) ylabel(0(25)75) fcolor(gs14) lcolor(gs14) 
yscale(range(0 75)) ) (line Avg_F_W Year, sort xlabel(1993(4)2009) 
lcolor(black) lwidth(medium) lpattern(solid) cmissing(n)), ytitle("thousand euros") yscale(range(0 75)) ylabel(0(25)75) 
by(,  legend(on)) by(Educ);


* FIGURE 3;
#delimit;
clear;
svmat GRAPHIALPHA3, names(col);
replace Year=Year+1 if Year>1995;
 reshape wide  Edu*, j(Type) i(Year);

forvalues g=2(1)5{;
local nn_1=Edu`g'2;
replace Edu`g'1=. if Edu`g'1==0;
g ee`g'=(Edu`g'1*(1-Edu`g'1)/`nn_1')^.5;

g valort`g'=invttail(`nn_1',0.025);
g LL_CI`g'=Edu`g'1-valort`g'*ee`g';
g UL_CI`g'=Edu`g'1+valort`g'*ee`g';
rename Edu`g'1 Participants`g';
drop Edu`g'2;
};

keep Participants* LL* UL* Year;
reshape long Participants LL_CI UL_CI, j(Educ) i(Year) ;
replace Participants=100*Participants;
replace LL_CI=100*LL_CI;
replace UL_CI=100*UL_CI;
replace Educ=5-Educ;
label define Educ 3 "Elementary" 2 "Secondary" 1 "High_School" 0 "College";
label value Educ Educ;
label variable Participants "% of Participants";


twoway (rarea LL_CI UL_CI Year, xlabel(1993(4)2009) ylabel(25(25)75) fcolor(gs14) lcolor(gs14) 
yscale(range(0 75)) ) (line Participants Year, sort xlabel(1993(4)2009) 
lcolor(black) lwidth(medium) lpattern(solid) cmissing(n)), yscale(range(0 75)) ylabel(25(25)75) 
by(, legend(on)) by(Educ);


save "$ruta4/graph4", replace;
*/


* FIGURE A1;
#delimit;
clear;
svmat GRAPHIALPHA4, names(col);

replace Year=Year+1 if Year>1995;
drop if Type==2;
reshape long Edu, i(Year) j(Educ) ;
replace Edu=. if Edu==0;
g Participants_2=100*Edu;
drop Edu Type;
label variable Participants "% of Participants /1";
label variable Participants_2 "% of Participants /2";
replace Educ=5-Educ;
sort Year Educ;
label value Educ Educ;
merge 1:1 Year Educ using "$ruta4/graph4";


twoway (line Participants Participants_2 Year, sort xlabel(1993(4)2009) 
lcolor(black black) lwidth(medium) lpattern(solid dash) cmissing(n)), yscale(range(0 100)) ylabel(0(50)100) 
by(, legend(on)) by(Educ);


