

* Creates the panel of SHIW (from 1987 to 2010) with variables of interest 
* Author: Graciela Sanroman
* First version: 20020824
* This version: 20120725

/* Files:
     Waves used  
	   `anio'= 1987 1989 1991 1993 1995 1998 2000 2002 2004 2006 2008 2010   
	 
	 
	 Input files 
	              $ruta1/base`anio'  each wave database done with /income/do income/do_eachwavedata_20120725

*   Transitory files f10

*   Output files: $ruta1\datainc_20120725


* Tables: ruta4/SAMPLE.XLS "structure of diferent samples"
          ruta4/Table1.XLS "descriptive statistics for the whole Sample of Males"
		  ruta4/Table2.XLS "descriptive statistics for Final Sample Type1"
		  ruta4/Table3.XLS "descriptive statistics for Final Sample Type2";
		 
*/



*qui {
cd "C:\"
global ruta "C:\SHIW\"
global ruta1 "C:\SHIW\"
global ruta2 "C:\SHIW\"
global ruta3 "C:\SHIW\"
global ruta4 "C:\SHIW\cuadros_graficos\"
global ruta5 "C:\SHIW\salidas_STAT\"


capture log close


capture log close
#delimit;
clear;
pause on;

log using "$ruta5\BASEPANEL.log",  replace;
global loggeneral "log using "$ruta5\BASEPANEL.log", append";
set more 1;

global listaanios 1987 1989 1991 1993 1995 1998 2000 2002 2004 2006 2008 2010;
local p_anio = 1987;

* 1. CREATION OF THE PANEL DATASET ;

use $ruta1/base`p_anio';
foreach anio in $listaanios {;
  if "`anio'">"`p_anio'" {;
    qui append using $ruta1/base`anio' ;
  };
};

sort anno;
merge m:1 anno using "$ruta1/cpi";
drop _merge;
* Change id identificator;
rename nquest id;


* Generate time variable (increase +1 instead of +2(or +3 between 1995 and 1998);
g time=0;
foreach anio in $listaanios {;
  qui replace time=time+1 if anno>=`anio';
};

*Dummy year 1998;
g D98=(anno==1998);
label variable D98 "Dummy 1998";

* Panel declaration;
xtset id time;


* Adjustments due questionnarie changes 
* convert all values to the equivalent in thousands euros if anio<2002;
foreach var in  
    af af1 af2 af3 af11 af12 ar ar1 ar2 ar3 ar11 
	c cd cd1 cd2 cn cn1 cn2 
	comfis divid part01 part12 pf pf1 pf2 pf3 pfo
	w  wo
	y1 y2 yc yca yca1 yca2 ycf ycf1 ycf2 ycf3 ycf4 yl yl1 yl2 ym ym1 ym2 ym3 yt yta ytp ytp1 ytp2 { ;
qui replace `var'=`var'*CPI/1000;
qui replace `var'=`var'/1.93627 if anno<2002;
rename `var' v_`var';
};

* Before 2004 ym3: entrepreneurial income ym2: depreciation. From 2004 ym3 net
qui replace v_ym3=v_ym3-v_ym2 if anno<2004;
save "$ruta1/f10", replace;

#delimit;
use "$ruta1/f10", clear;

g area3=area5<=2;
replace area3=2 if area5==3;
replace area3=3 if area5>3;
* 2. FILTERS;

				g uno=1;
				matrix SAMPLE=J(13,14,.); //matrix to describe panel structural of diferent samples and postfilters;
                matrix rownames SAMPLE  = "THHi=1" "THHi=2" "THHi=3" "THHi=4" "THHi=5" "THHi=6" "THHi=7" "THHi=8" "THHi=9" "THHi=10" "THHi=11" "THHi=12" "TOTAL N_HH";
                 egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
                g N_HH=1/THHi; label variable N_HH "Number of Households";
                matrix SAMPLEB=J(13,14,.);
                matrix rownames SAMPLEB  = $listaanios Total ;
                
				global S2 "All_Sample";
				forvalues jj=1(1)12 {;
					qui sum N_HH if THHi==`jj';
					matrix SAMPLE[`jj',1]=`jj';
					matrix SAMPLE[`jj',2]=floor(r(sum));
				};
				qui sum N_HH ;
				matrix SAMPLE[13,2]=floor(r(sum));
				matrix SAMPLEB[13,2]=floor(r(sum));
				
				local jj = 0;
                                foreach anio in $listaanios {;
					local jj = `jj'+1;
					qui count if anno==`anio';
					matrix SAMPLEB[`jj',1]=`anio';
					matrix SAMPLEB[`jj',2]=r(N);
				};
				drop THHi N_HH;
				
				
*  2.1 SAMPLE SELECTION step 1: Households where: Head is male,   ;

log close;
log using "$ruta5\tables_sample.log", replace;
global logsample "log using "$ruta5\tables_sample.log", append";
tab anno Sex, row nof;
log close;

$loggeneral;

keep if Sex==1; //Males;

		egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
		g N_HH=1/THHi; label variable N_HH "Number of Households";
		
		
		    global S3 "Males";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj';
				matrix SAMPLE[`jj',3]=floor(r(sum));
			};
			    qui sum N_HH ;
				matrix SAMPLE[13,3]=floor(r(sum));
				matrix SAMPLEB[13,3]=r(N);
				
				local jj = 0;
                foreach anio in $listaanios {;
					local jj = `jj'+1;
					qui count if anno==`anio';
					matrix SAMPLEB[`jj',3]=r(N);
				};
	
*  2.2 APPLY FILTERS 1 TO 3:  
*                  Filter 1: The hh head has no change among waves;   
*                  Filter 2: older than 25 at the last observation in the panel and without measure errors in age;
*                  Filter 3: Total nonfinancial income in the window panel is non-negative ;

* Filter 1: The hh head has no change among waves & there are not "evitables" evident measurements errors in education;
* Hh head has change;
		g filter1a=(nordp-L.nord)!=0 if L.nord!=. & nordp!=. & anno>1989 & THHi>3;
         tab filter1a;

*Education;
			bys id: g c1=educ if _n==_N;
			egen c2=max(educ) if educ!=., by(id); 
			egen c3=mode(educ), by(id);
			egen F_educ1=min(c1), by(id); label var F_educ "Highest level of education of Household Head";
			egen F_educ2=min(c2), by(id);

			g F_educ=F_educ1;
			replace F_educ=c3 if F_educ1<F_educ2;
         g filter1b=1 if F_educ!=.;
		 drop c1 c2 c3;
drop if filter1a==1 & filter1b==1;
	    
		drop THHi N_HH;
        egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
		g N_HH=1/THHi; label variable N_HH "Number of Households";
		
		
		global S4 "Post_filter1";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj';
				matrix SAMPLE[`jj',4]=floor(r(sum));
			};
			    qui sum N_HH ;
				matrix SAMPLE[13,4]=floor(r(sum));
				matrix SAMPLEB[13,4]=r(N);
				
				local jj = 0;
                foreach anio in $listaanios {;
					local jj = `jj'+1;
					qui count if anno==`anio';
					matrix SAMPLEB[`jj',4]=r(N);
				};
	

* Filter 2: older than 25 at the last observation in the panel and without measure errors in age;

		egen Max_age=max(age) if age!=., by(id);
        egen Min_age=min(age) if age!=., by(id);



log close;
$logsample;

g Less25=Max_age<25;
g More65=Min_age>=65;  

tab anno Less25, row nof;
tab anno More65, row nof;
log close;

$loggeneral;


drop if Max_age<25 | Min_age>=60;  

		g c1=age-L.age;
		qui replace c1=0 if c1==.;
		egen difage=max(abs(c1)), by(id);
		drop c1;
drop if abs(difage)>4 & anno!=1998;
drop if abs(difage)>5 & anno==1998;

		drop THHi N_HH;
        egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
		g N_HH=1/THHi; label variable N_HH "Number of Households";
		
		
			global S5 "Post_filter2";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj';
				matrix SAMPLE[`jj',5]=floor(r(sum));
			};
            qui sum N_HH ;
			matrix SAMPLE[13,5]=floor(r(sum));
            matrix SAMPLEB[13,5]=r(N);
				
				local jj = 0;
                foreach anio in $listaanios {;
					local jj = `jj'+1;
					qui count if anno==`anio';
					matrix SAMPLEB[`jj',5]=r(N);
				};


* Filter 3: Total nonfinancial income in the window panel is non-negative ;
		egen c1=sum(v_y1) if v_y1!=., by(id);
		egen c2=min(c1), by(id);
        
        g filter3=(c2<0);
		drop c1 c2;

log close;
$logsample;

tab anno filter3, row nof;
log close;

$loggeneral;		
drop if filter3==1;
		

		drop THHi N_HH;
        egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
		g N_HH=1/THHi; label variable N_HH "Number of Households";
		
		
			global S6 "Post_filter3";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj';
				matrix SAMPLE[`jj',6]=floor(r(sum));
			};
            qui sum N_HH ;
			matrix SAMPLE[13,6]=floor(r(sum));
			matrix SAMPLEB[13,6]=r(N);
				
				local jj = 0;
                foreach anio in $listaanios {;
					local jj = `jj'+1;
					qui count if anno==`anio';
					matrix SAMPLEB[`jj',6]=r(N);
				};

*  2.1 SAMPLE SELECTION step 2:  TWO OPTIONS  ;

/* Parte  GEN VAR SAMPLE1 AND SAMPLE2 :  
*               * HH HEAD MALE, 
*				* THHI>=3, 
*				* MARRIED (AT LEAST IN ONE WAVE), 
*				* mean of HHH_mainincome dummy by id greater than 0.75 (HH head is the main income earner AT least 3 of 4 times);

				* LABOR INCOME MAIN SOURCE OF NON-FINANCIAL INCOME:
						OPTION1 (SAMPLE1): M_entrepreneur!=1 & MAIN OCUPPATION IS blue-collar worker or similar | office worker or school teacher ";
*                       OPTION2 (SAMPLE2): M_entrepreneur!=1 & RATIO AVERAGE LABOR_INCOME TO AVERAGE(NON_FINANCIAL INCOME MINUS IMPUTED RENTS) GREATER THAN 0.7";
*/		;

          
                egen DMarried=min(Married);
                egen avg_HHH_maininc=mean(HHH_maininc), by(id);

* SAMPLE 1**************;


g SAMPLE1=( Sex==1 & THHi>=3 & DMarried==1 & occup<3 & age<66);

        	
			global S9 "SAMPLE1";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj' & SAMPLE1==1;
				matrix SAMPLE[`jj',9]=floor(r(sum));
			};
            qui sum N_HH if SAMPLE1==1;
			matrix SAMPLE[13,9]=floor(r(sum));
			
			
* SAMPLE2 ****************;

                 egen ratio_lincome=mean(v_yl/(v_y1-v_yca2)), by(id);
                 g lincomeearner=(ratio_lincome>0.75)*(ratio_lincome!=.);

  
			
g SAMPLE2=( Sex==1 & THHi>=3 & DMarried==1 & lincomeearner==1 & avg_HHH_main>0.75 & M_entrepreneur!=1 & age<66);

        	
			global S10 "SAMPLE2";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj' & SAMPLE2==1;
				matrix SAMPLE[`jj',10]=floor(r(sum));
			};
            qui sum N_HH if SAMPLE2==1;
			matrix SAMPLE[13,10]=floor(r(sum));


#delimit;
matrix HetSAMPLE1=J(4,6,.);
matrix colnames HetSAMPLE1 = "North_NHowner" "North_Howner" "Center_NHowner" "Center_Howner" "South_NHowner" "South_Howner";
matrix rownames HetSAMPLE1 = "EDU2" "EDU3" "EDU4" "EDU5";
local jj=1;
forvalues edu = 2(1)5 {;
  local ii=1;
  forvalues area = 1(1)3 {;
      forvalues Hous= 0(1)1{;
	   count if SAMPLE1==1 & THHi>3 & educ==`edu' & area3==`area' & House_own==`Hous';
	   matrix HetSAMPLE1[`jj',`ii']=r(N); 
      local ++ii;
};
};
     local ++jj;
};

log close;
$logsample;
tab anno SAMPLE1, row nof;
tab anno SAMPLE2, row nof;
tab SAMPLE1 SAMPLE2, m;
matrix list HetSAMPLE1;


log close;

$loggeneral;		
**********;
/*;
*generar employees pensioners, renters and entrepreneurs NOT USED IN THIS VERSION;
* total net disposable income in the panel (imputed house rent excluded) ;
egen totaly1=sum(y1-yca2), by(id);

*Employee (total wages over total net income greater than 0.8);
egen totalyl=sum(yl), by(id);
g employee=(totalyl/totaly1>0.8);


*Self-mployee (total wages over total net income greater than 0.8);
egen totalyml=sum(ym1), by(id);
g self_employee=(totalyml/totaly1>0.8);


*Pensioner (total pensions and other transfer over total net income greater than 0.8);
egen totalyt=sum(yt), by(id);
g pensioner=(totalyt/totaly1>0.8);

*Renter (total rents over total net income greater than 0.6);
egen totalyca1=sum(yca1), by(id);
g renter=(totalyca1/totaly1>0.8);

*ENTREPRENEURS WHEN ENTREPRENEURIAL INCOME (greater than 50%);
egen totalym=sum(ym3), by(id);
gen abstotalym=abs(totalym);
g entrepreneur=abstotalym/totaly1>.50
;
*/;

* 2.4 APPLY Filter 4; 
*             Exclude HH in SAMPLE1 .or. SAMPLE2 With big jumps in total net wealth;
*                 we first compute the deciles of neath wealth at each year and find the decil that HHi belong;
*                 afterwards compute the diference between positions at t and t-1;
*                 finally we exclude those for whom the minimum or maximum change (in abs terms) is greater than 5 ;
*                 also create two dummy variables FILTER4m=1 if  the minimum change (in abs terms) is 4;
*                 also create two dummy variables FILTER4M=1 if  the maximum change (in abs terms) is 4;
		    g decil_w=.; label var decil_w	"Decil of hhi net wealth";
			foreach anio in $listaanios {;
			  if `anio' >=1991 {;
			         xtile c1=v_w if anno==`anio' & v_w!=., nq(10);
			         qui replace decil_w=c1 if anno==`anio';
			         capture drop c1;
					 };
			  if `anio' <1991 {;
			         xtile c1=v_wo if anno==`anio' & v_wo!=., nq(10);
			         qui replace decil_w=c1 if anno==`anio';
			         capture drop c1;
					 };
			};
           
           g dif_decil_w=D.decil_w if decil_w!=. & L.decil_w!=.; label var dif_decil "First Difference of decil of hhi net wealth";
        
              egen mchanw=min(dif_decil_w), by(id);
			   
drop if abs(mchanw)>5 & mchanw!=.;


g Filter4m=(abs(mchanw)==4); 

			drop THHi N_HH;
			egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
			g N_HH=1/THHi; label variable N_HH "Number of Households";
			
			global S7 "Post_Filter4m";
			forvalues jj=1(1)12 {;
			qui sum N_HH if THHi==`jj';
			matrix SAMPLE[`jj',7]=floor(r(sum));
			};
            qui sum N_HH;
			matrix SAMPLE[13,7]=floor(r(sum));
		    
			
			global S11 "SAMPLE1_F4m";
			global S12 "SAMPLE2_F4m";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj' & SAMPLE1==1;
				matrix SAMPLE[`jj',11]=floor(r(sum));
				qui sum N_HH if THHi==`jj' & SAMPLE2==1;
				matrix SAMPLE[`jj',12]=floor(r(sum));
			};
            qui sum N_HH if SAMPLE1==1;
			matrix SAMPLE[13,11]=floor(r(sum));
            qui sum N_HH if SAMPLE2==1;
			matrix SAMPLE[13,12]=floor(r(sum));


           egen Mchanw=max(dif_decil_w), by(id);


drop if abs(Mchanw)>5 & Mchanw!=.;
pause;


g Filter4M=(abs(Mchanw)==4); 
 
  
			drop THHi N_HH;
			egen THHi=sum(uno), by(id); label variable THHi "Number of observation per Household";
			g N_HH=1/THHi; label variable N_HH "Number of Households";
						
			global S8 "Post_Filter_4M";
			forvalues jj=1(1)12 {;
			qui sum N_HH if THHi==`jj';
			matrix SAMPLE[`jj',8]=floor(r(sum));
			};
            qui sum N_HH;
			matrix SAMPLE[13,8]=floor(r(sum));
		    
		    global S13 "SAMPLE1_F4M";
			global S14 "SAMPLE2_F4M";
			forvalues jj=1(1)12 {;
				qui sum N_HH if THHi==`jj' & SAMPLE1==1;
				matrix SAMPLE[`jj',13]=floor(r(sum));
				qui sum N_HH if THHi==`jj' & SAMPLE2==1;
				matrix SAMPLE[`jj',14]=floor(r(sum));
			};
            qui sum N_HH if SAMPLE1==1;
			matrix SAMPLE[13,13]=floor(r(sum));
            qui sum N_HH if SAMPLE2==1;
			matrix SAMPLE[13,14]=floor(r(sum));



log close;
$logsample;
tab anno Filter4m, row nof;
tab anno Filter4M, row nof;

log close;

$loggeneral;		


drop  forgiu  nord par Sex mesilav numadd oretot  uno filter1* filter3 difage DMarried avg_HHH_maininc dif_decil_w mchanw Mchanw;
rename anno year;
label variabl year "Year of the wave";

matrix colnames SAMPLE = "THHi"  "$S2" "$S3" "$S4" "$S5" "$S6" "$S7" "$S8" "$S9" "$S10" "$S11" "$S12" "$S13" "$S14"  ;

*matrix list SAMPLE;
*pause;
* GENERATE VARIABLES;
xtset id time;

* VARIABLES FOR GOV. SECURITIES HOLDINGS AND OTHER SECURITY HOLDINGS;
* .1 DUMMIES;
g RA1=(v_af2>0);
replace RA1=. if v_af2==.; label variable RA1 "Dummy HH has Gov. Securities";


g RA2=(v_af3>0);
replace RA2=. if v_af3==.; label variable RA2 "Dummy HH has Other Securities";

save "$ruta1/f10", replace;

g Dalpha=(v_af2>0 | v_af3>0); label variable RA2 "Dummy HH has Securities";
replace Dalpha=. if v_af3==. & v_af3==.;  


#delimit;
g Dalpha2=(v_af2>0)*(v_af3>0); label variable RA2 "Dummy HH has Gov and Other Securities";
replace Dalpha2=. if v_af3==. | v_af3==.;  

*notice that missings for v_af2 and v_af3 are jointly defined
     . sum v_af2 v_af3

    Variable |       Obs        Mean    Std. Dev.       Min        Max
-------------+--------------------------------------------------------
       v_af2 |     29322    4.728341    26.55796          0   1939.104
       v_af3 |     29322    9.548048    54.43803          0       245
;

* .1 proportions;
g pRA1=(v_af2/v_af) if v_af!=.; label variable pRA1 "% of FA in Gov_Securities";

g pRA2=(v_af3/v_af) if v_af!=.; label variable RA2 "% of FA in Other Securities";


g alpha=(v_af2+v_af3)/v_af if v_af!=.; label variable Dalpha "% of FA in Securities";

#delimit;


* Education dummies;

g Deduc1=(educ==1);				label variable Deduc1 "Less than elemen";
g Deduc2=(educ==2);				label variable Deduc2 "Elementary school";
g Deduc3=(educ==3); 			label variable Deduc3 "Middle School";
g Deduc4=(educ==4);				label variable Deduc4 "High school";			
g Deduc5=(educ==5 | educ==6);   label variable Deduc5 "Bachelor degree/post_graduated";

g DF_educ1=(F_educ==1);				label variable DF_educ1 "Less than elemen";
g DF_educ2=(F_educ==2);				label variable DF_educ2 "Elementary school";
g DF_educ3=(F_educ==3); 			label variable DF_educ3 "Middle School";
g DF_educ4=(F_educ==4);				label variable DF_educ4 "High school";			
g DF_educ5=(F_educ==5 | F_educ==6);   label variable DF_educ5 "Bachelor degree/post_graduated";


* Size_Municip Dummies;
g DSize1=(Size_Munic==1);			label variable DSize1 "up to 20000 inhabitants"				;
g DSize2=(Size_Munic==2);			label variable DSize2 "from 20000 to 40000"				;
g DSize3=(Size_Munic==3);			label variable DSize3 "from 40000 to 500000"				;
g DSize4=(Size_Munic==4);			label variable DSize4 "more than 500000"				;
			
							
* "Region";							
							
g Dregion1=(area5==1);			 label variable Dregion1 "NorthWest"			;	
g Dregion2=(area5==2);			 label variable Dregion2 "NorthEast"			;	
g Dregion3=(area5==3);			 label variable Dregion3 "Centre"			;	
g Dregion4=(area5==4);			 label variable Dregion4 "South"			;	
g Dregion5=(area5==5);			 label variable Dregion5 "Islands"			;	
							
*"Occupation";
g Doccup1=(occup==1);			 label variable Doccup1 "blue_collar worker or similar" 				;
g Doccup2=(occup==2);			 label variable Doccup2 "office worker or school teacher" 				;
g Doccup3=(occup==3);			 label variable Doccup3 "junior manager/cadre"				;
g Doccup4=(occup==4);			 label variable Doccup4 "manager/self_employed" 				;
g Doccup5=(occup==5);			 label variable Doccup5 "member of the arts/professions" 				;
g Doccup6=(occup==6);			 label variable Doccup6 "sole_proprietor/freelance/unpaid"				;
g Doccup7=(occup==7);			 label variable Doccup7 "not employed" 				;

* Generate dataset to estimate the income process;


*Non Financial Income (logs(var));
g lny1=ln(v_y1);   label variable lny1 " Net disposable income in logs(exc. Inc. from finan. assets))";

*Labor Income (logs(var+1));
g lnylab=ln(v_yl); label variable lnylab " Labor income in logs";
g lnylabyca2=ln(v_yl+v_yca2); label variable lnylabyca2 " Labor income + imputed rents from real assets in logs";
* Cash on hand;
g lncoh=ln(v_c+v_af)-lny1; label variable lncoh "Ratio cash-on-hand to net disposable income";
g lncoh2=ln(v_c+v_af)-lnylab; label variable lncoh "Ratio cash-on-hand to labor income";
g lncoh3=ln(v_c+v_af)-lnylabyca2; label variable lncoh "Ratio cash-on-hand to labor income";
* 3) EXPLANATORY VARIABLES;
#delimit;
*se cambian edades a "biannuales" con 25=0; 

g SOUTH=(area5==4 | area5==5);
replace SOUTH=-99 if area5==.;
g Doccup=(occupation==1);
replace Doccup=-99 if occupation==.;
g C_age=0;
replace C_age=1 if age>44;
replace C_age=-99 if age==.;
replace House_own=-99 if House_own==.;

g Lalpha=L.alpha;
replace Lalpha=-99 if Lalpha==.;

save "$ruta1/f10", replace;

keep id time year lny1 lnylab* area3 House_own age Deduc* DF_educ* occup SAMPLE* SOUTH Doccup C_age v_af v_af2 v_af3 alpha Lalpha;
save $ruta1\datainc_20120725, replace;

* Obtain Samples and Tables 1, 2 and 3 stored in matrix Table1, Table2 and Table3;
clear;
svmat SAMPLE, names(col);
outsheet using "$ruta4/SAMPLE.xls", delimiter(";") replace;


do "$ruta3/do_Tables1&2&3" ;
do "$ruta3/do_Tables1&2&3_iweight" ;
#delimit;
/*
clear;
use  "$ruta1/f10";

g control=y1+nperl+ncomp+eta+AREA+studio+D98+acom5;

keep id control age2 DEDU* AREA _Iacom5_* time ln*
ncomp nperl settp9 qualp9 cohort
yl yl yl1 yl2 yt ytp ytp1 ytp2 yta  ym ym1 ym3 yc yca yca1 yca2 ycf ycf1 ycf2 ycf3 ycf4 w wr af c ast abo;
save $ruta2\bases\data_20120716, replace;
 
capture log close;



