* Creates one dataset for each wave of SHIW (from 1987 to 2010) with variables of interest 
* Author: Graciela Sanroman
* First version: 20020824
* This version: 20120725



cd "C:\"
global ruta "C:\SHIW\"

capture log close

/* Files:
     Waves used  
	   `anio'= 1987 1989 1991 1993 1995 1998 2000 2002 2004 2006 2008 2010   
	 
	 
	 Input files 
         ricf`anio' fami`anio' cons`anio' rfam`anio' immp`anio' comp`anio' linc`anio' from the historical SHIW   
	 	
		 Note: see changes in ricf`anio' and linc`anio' 1987 and 1989
     Temporary files: f1, f2
	 
	 Output files: "$ruta/base`anio'"
	 
	 Variables in Output files:
		variable name   variable label
	---------------------------------------------------------------------------
	nquest          HH id
	nord            HH head id number
	M_entrepreneur  (min) M_entrepreneur
	mesilav         (min) mesilav
	numadd          (min) numadd
	forgiu          (min) forgiu
	oretot          (min) oretot
	part12          (min) part12
	divid           (min) divid
	comfis          (min) comfis
	ncomp            Number of household members
	Year_birth       Year of birth
	Married         STACIV
	nordp           HH head id in the previous wave
	area5           Italy five geographical areas
	age             ETA
	nperc            Number of income earners in the household
	anno            ANNO
	Sex             SESSO
	par              Household position
	occupation       Main employment, work status employee
	Industry         Main employment, branch of activity
	not_employed    NONOC
	Size_Munic       Division of municipalities by resident population (four                 groups)
	HHH_mainincome   Head of household main income earner
	nperl            Number of employment income earners in the household
	educ             Educational qualification level
	House_own       Owner of Principal residence
	yc              Property income
	ycf             Income from financial assets
	ycf1            Interest on bank and postal deposits
	ycf2            Interest on government securities
	ycf3            Income from other securities
	ycf4            Interest payable (-)
	y1              Net disposable income (exc. Inc. from finan. assets)
	y2              Net disposable income
	yl              Compensation of employees
	yl1             Net wages and salaries
	yl2             Fringe Benefits
	yt              Pensions and other transfers
	ytp             Pensions and arrears
	ytp1            Pensions
	ytp2            Arrears
	yta             Other transfers (**)
	ym              Net income from self-employment and entrepreneurial 
	ym1             Income from self-employment
	ym2             Depreciation (-)
	ym3             Entrepreneurial income
	yca             Income from buildings
	yca1            Actual rents
	yca2            Imputed rents
	cn2             Consumption of imputed non-durables (YL2+YCA2)
	c               Total consumption
	cd1             Consumption of transport equipment (net of sales earnings)
	cd2             Consumption of other durables
	cd              Consumption of durables
	cn              Consumption of non-durables
	cn1             Consumption of monetary non-durables
	D_entrep        Dummy HH has some Entrepreneurial wealth
	w_entrep        Entrepreneurial wealth
	w_coop          Loans to cooperatives
	ar1             Real estate
	ar11            AR11
	ar2             Businesses
	ar3             Valuables
	ar              Real assets
	af11            AF11
	af12            AF12
	af2             Government securities
	af3             Other securities
	pf1              Liabilities to banks and f. companies
	pf2             Trade debt
	af1             Deposits
	af              Financial assets
	pf3             Liabilities to other households
	pf              Financial liabilities
	w               Net wealth


*/

/*datos ao `anio'*/

#delimit;
/*rutina preparada para recuperar desde una base 
que incluya variables de interes de la SHIW `anio'*/;

clear;
set more 1;
pause on ;


foreach anio in 1987 1989 1991 1993 1995 1998 2000 2002 2004 2006 2008 2010 {; 
tempfile f1 f2 f3;
tempvar c1 c2 c3 c4;
capture log close;
clear;
log using "$ruta/base`anio'.log",  replace;

display "This version: $S_DATE $S_TIME";


* Parte 1 importar desde formato ASCII los datos de la bases que incluyen
la informacin sobre tenencias de activos de los hogares, ARCHIVOS RICFXX AND FAMIXXX;


insheet
 using ricf`anio'.csv,  names comma;

label variable	nquest	"Household ID";

if `anio'<=1989 {;
  drop ar11;
 label variable	ar	"Real assets	";	
 label variable	ar1	"Real estate	"	;
 label variable	ar2	"Businesses	"	;
 label variable	ar3	"Valuables	"	;
 label variable	wo	"Net wealth previous 1991";
 label variable	pfo	"Financial liabilities previous 1991"	;
 }; 

if `anio'>=1991 {; 
label variable	w	"Net wealth	"	;
label variable	ar	"Real assets	"	;
label variable	ar1	"Real estate	"	;
label variable	ar2	"Businesses	"	;
label variable	ar3	"Valuables	"	;
label variable	af	"Financial assets	"	;
label variable	af1	"Deposits	"	;
if anno<2006  {;
  label variable	af11	"Bank deposits	"	;
  label variable	af12	"Postal deposits and savings certificates	" ;
};

label variable	af2	"Government securities	"	;
label variable	af3	"Other securities 	"	;
if anno>=1991 {;
label variable	pf	"Financial liabilities 	"	;
label variable	pf1	" Liabilities to banks and f. companies	";
label variable	pf2	"Trade debt	";

label variable	pf3	"Liabilities to other households	";
};

};

sort nquest;
save f1, replace;
clear;


*FAMI`anio': PARA DESAGREGAR RIQUEZA EMPRESARIAL Y PRESTAMOS A COOPERATIVAS;

insheet
 using fami`anio'.csv,  names comma;
if anno>=1995{;
* se reemplaza por 0 los importes de participacin en empresas (srl o sociedades de personas) si dicen que no poseen;
replace lsrl=0 if psrl==0 & lsrl==.;
replace lper=0 if pper==0 & lper==.;
replace lcoop=0 if pcoop==0 & lcoop==.;
g D_entrep=1 if psrl==1 | pper==1;
label variable D_entrep "Dummy HH has some Entrepreneurial wealth";
egen missam=rmiss( 
lsrl lper lcoop);

* Entrepreneurial wealth;
g w_entrep=lsrl+lper;
label variable w_entrep "Entrepreneurial wealth";

* Cooperative loans;
g w_coop=lcoop;
label variable w_coop "Loans to cooperatives";


keep nquest anno w_* D_*;

sort nquest;
merge 1:1 nquest anno using f1;

drop _merge;
sort nquest;
save f1, replace;
};
clear;
/* Parte 2 importar desde formato ASCII los datos de la bases que incluyen
la informacin sobre consumo delos hogares, ARCHIVOS CONSXX */;
insheet
using cons`anio'.csv,  names comma;

label variable c   "Total consumption";
label variable cn   "Consumption of non-durables";
label variable cn1 "Consumption of monetary non-durables";
label variable cn2 "Consumption of imputed non-durables (YL2+YCA2)";
label variable cd   "Consumption of durables";
label variable cd1 "Consumption of transport equipment (net of sales earnings)";
label variable cd2 "Consumption of other durables";

keep nquest c*;
sort nquest;

merge nquest using f1;
tab _merge;
drop _merge;
sort nquest;
save f1, replace;




clear;
insheet
using rfam`anio'.csv,  names comma;


label variable	anno	"Year	" ;
label variable	nquest	"Household ID	";
label variable	y1	"Net disposable income (exc. Inc. from finan. assets)	";
label variable	y2	"Net disposable income	";
label variable	yl	"Compensation of employees	";
label variable	yl1	"Net wages and salaries	";
label variable	yl2	"Fringe Benefits	";
label variable	yt	"Pensions and other transfers	";
label variable	ytp	"Pensions and arrears	";
label variable	ytp1	"Pensions	";
label variable	ytp2	"Arrears	";
label variable	yta	"Other transfers (**)	";
label variable	ym	"Net income from self-employment and entrepreneurial income	";
label variable	ym1	"Income from self-employment	";
label variable	ym2	"Depreciation (-)	";
label variable	ym3	"Entrepreneurial income	";
label variable	yc	"Property income	";
label variable	yca	"Income from buildings	";
label variable	yca1	"Actual rents	";
label variable	yca2	"Imputed rents	";
label variable	ycf	"Income from financial assets	";
label variable	ycf1	"Interest on bank and postal deposits	";
label variable	ycf2	"Interest on government securities	";
label variable	ycf3	"Income from other securities	";
label variable	ycf4	"Interest payable (-)	";


if anno<2006 {;
replace ym3=ym3-ym2;
};
sort nquest;
merge nquest using f1;
tab _merge;
drop _merge;


sort nquest;
save f1, replace;
clear;

insheet
using immp`anio'.csv,  names comma;
rename resi House_own;
label variable House "Owner of Principal residence";
label define HOUSE 0  No 1  Yes.;
label value House HOUSE;
keep if House_ow==1;
keep nquest House_ow ;
sort nquest;
merge nquest using f1;
tab _merge;
drop _merge;
replace House_own=0 if House_own==.;
sort nquest;
save f1, replace;

clear;

/* Parte 2: importar desde formato ASCII los datos de la base 2002 que incluyen
informacin sobre caracteristicas del cabeza de hogar, ARCHIVO COMP2002
*/;
#delimit;
clear;
 insheet
using comp`anio'.csv,  names comma;


label variable area5 "Italy five geographical areas ";
label define AREA5
1   NorthWest
2   NorthEast
3   Centre
4   South
5   Islands;

label value area5 AREA5;

rename acom4c Size_Munic;
label variable Size_Munic " Division of municipalities by resident population (four groups)" ;
label define ACOM4C
1   "up to 20,000 inhabitants"
2   "from 20,000 to 40,000"
3   "from 40,000 to 500,000"
4   "more than 500,000";

label value Size_Munic ACOM4C;

rename cfred HHH_mainincome;
label variable HHH_mainincome " Head of household main income earner" ;
label define CFRED
1  "Head of household"
0  "Other members";
label value HHH_mainincome CFRED;

label variable ncomp  "  Number of household members"  ;
label variable nperc  "  Number of income earners in the household"  ;
label variable nperl  "  Number of employment income earners in the household" ;

label variable par " Household position"  ;
label define PAR
1 "   Head of household (H.H)"  
2 "   Spouse/partner of H.H" 
3 "   Son/daughter of H.H." 
4 "   Other " ;



if anno>1989 {;
		rename anasc Year_birth;
		label variable Year_birth " Year of birth"  ; 
};
if anno>1987 {;
		rename staciv Married;
		label define STACIV
		1 married
		2  single
		3  divorced
		4  widow;
		label value Married STACIV;
};


rename studio educ;
label variable edu " Educational qualification level"  ;
label define STUDIO 
1 "   none" 
2 "   elementary school" 
3 "   middle school" 
4 "   high school"
5 "bachelors degree"
6 "post-graduate qualification";
label value educ STUDIO ;


rename sesso Sex;
label define SEX 
1  male
2  female; 
label value Sex SEX;

rename eta age;



rename settp9 Industry ;
label variable Industry "  Main employment, branch of activity" ;
label define SETTP9
1  "  agriculture" 
2  "  manufacturing" 
3  "  building and construction" 
4  "  wholesale and retail trade, lodging and catering services" 
5  "  transport and communication" 
6  "  services of credit and insurance institutions" 
7  "  real estate and renting services, other professional, business activities" 
8  "  general government and other private and public services" 
9  "  not employed" ;

label value Industry SETTP9;

rename  qualp7n occupation;
label variable occupation " Main employment, work status employee" ;
label define QUALP7N
1  "  blue-collar worker or similar" 
2  "  office worker or school teacher" 
3  "  junior manager/cadre" 
4  "  manager/self-employed" 
5  "  member of the arts or professions" 
6  "  sole proprietor, freelance and unpaid family member" 
7  "  not employed" ;
label value occupation QUALP7N;

rename nonoc not_employed;
label define NONOC
0  "  employed" 
1  "  first-job seeker" 
2  "  homemaker" 
3  "  well off" 
4  "  pensioner" 
5  "  unemployed" 
6  "  student" 
7  "  other not employed" ;
label value not_employed NONOC;

replace not_em=. if anno <1991;

if anno > 1989 { ;
		keep nquest nord nordp anno area5 Size HHH ncomp nperc nperl par Year_birth age Sex Married educ Industry occupation not_employed;
		label variable nord "HH head id";
		label variable nordp "HH head id in the previous wave";
};

if anno == 1989 { ;
		keep nquest nord nordp anno area5 Size HHH ncomp nperc nperl par age Sex educ Industry occupation not_employed;
};


if anno == 1987 { ;
		keep nquest nord anno area5 Size HHH ncomp nperc nperl par age Sex educ Industry occupation not_employed;
};

sort nquest nord;
save f2, replace;
clear;


**DATOS DE EMPRESARIOS;

#delimit;
clear;
insheet
using linc`anio'.csv,  names comma;


if anno>=1991 {;
label variable	mesilav	" Number of months of the year in which the hh head worked" ;
label variable	oretot	" Number of hh head hours worked on average per week (including overtime)" ;
label variable	numadd	" Number of employees of hh head entrerprise" ;
};


if anno>=1995 {;
label variable	qprosoc	" Ownership share of hh in the firm" ;
};


if anno>=1989 {;
label variable	forgiu	" Legal form of the hh head firm" ;
};
if anno<1993 {;
label variable	part01	" Market value of total hh shares in firms at the beginning of the year" ;
};

label variable	part12	" Market value of total hh shares in firms the end of the year" ;
label variable	divid	" Total hh Dividends and profits received net of tax" ;
label variable	comfis	" Total hh compensation for work in the firm net of tax" ;


* Se genera una base que combina las variables para el jefe de hogar y las sumas de los importes de las variables monetarias;
if anno<1993 {;
egen c1=sum(part01), by(nquest);
replace	part01=c1 ;
drop c1;
};

egen c2=sum(part12), by(nquest);
replace	part12=c2 ;
drop c2;

if anno>1989 {;
rename attivp M_entrepreneur;
label variable M_entrepreneur "Firm is the main activity";
label define ATTIVP 
0  Secondary
1  Main;
label value M_entrepreneur ATTIVP;
collapse (min) M_entrepreneur mesilav numadd forgiu oretot part12 divid comfis , by(nquest nord);
};
capture drop partean;

sort nquest nord;
merge nquest nord using f2;

tab _merge;
drop _merge;
keep if par==1;

sort nquest;
merge nquest using f1;

drop _merge;

sort nquest;
save f1, replace;

**Sample Weights ;

#delimit;
clear;
insheet
using peso`anio'.csv,  names comma;
sort nquest;
merge nquest using f1;
drop _merge;


save "$ruta/base`anio'", replace;
};

