clear all
set more off

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates
global Results C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Results

/*
STATIC TREATMENT EFFECTS

This do-file computes static treatment effects
1. Overall ATE and TT across periods and possible choices
2. ATE and TT across the support of ability

*/


******************************************************************************
*TABLE 9: STATIC TREATMENT EFFECTS: JORGE
******************************************************************************
use $IN/simdata.dta, clear

xtile theta_pc = f_prod, nq(100)
egen theta_std = std(f_prod)
xtile f1_4 = f_prod, nq(4)

gen D_1 = I2_1>=0 /*period t=2 indicator*/

*ATEs
gen ate_1 = w1 - w0
gen tt_1 = w1 - w0 if D1 == 1

gen ate_2_0 = w01 - w00 if D1 == 0
gen tt_2_0 = w01 - w00 if D1 == 0 & D2_0 == 1

gen ate_2_1 = w11 - w10 if D1 == 1
gen tt_2_1 = w11 - w10 if D1 == 1 & D2_1 == 1

*Pr negative returns
gen d_ate_all = ate_1 < 0
gen d_tt_all = tt_1<0 
replace d_tt_all = . if tt_1==.

forvalues x = 0/1 {
	gen d_ate_all_n`x' = ate_2_`x' < 0
	replace d_ate_all_n`x' = . if ate_2_`x'==.

	gen d_tt_all_n`x' = tt_2_`x' < 0
	replace d_tt_all_n`x' = . if tt_2_`x'==.
}





*ATE
qui: ttest w1==w0
local ate_all = string(round((r(mu_1) - r(mu_2))*100,0.01),"%9.2f")
local ate_se_all = string(round(r(se)*100,0.01),"%9.3f")
local lb_ate_all = string(round(((r(mu_1) - r(mu_2)) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
local ub_ate_all = string(round(((r(mu_1) - r(mu_2)) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")

qui: ttest d_ate_all=0
local pr_ate_all = string(round(r(mu_1)*100,0.01),"%9.2f")
local lb_pr_ate_all = string(round((r(mu_1) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
local ub_pr_ate_all = string(round((r(mu_1) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")

*TT
qui: ttest w1==w0 if D1 == 1 
local tt_all = string(round((r(mu_1) - r(mu_2))*100,0.01),"%9.2f")
local tt_se_all = string(round(r(se),0.01),"%9.3f")
local lb_tt_all = string(round(((r(mu_1) - r(mu_2)) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
local ub_tt_all = string(round(((r(mu_1) - r(mu_2)) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")

qui: ttest d_tt_all=0 if D1 == 1 
local pr_tt_all = string(round(r(mu_1)*100,0.01),"%9.2f")
local lb_pr_tt_all = string(round((r(mu_1) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
local ub_pr_tt_all = string(round((r(mu_1) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")


*ATE
forvalues x=0/1{
	qui: ttest w`x'1==w`x'0 if D1==`x'
	local ate_all_n`x' = string(round((r(mu_1) - r(mu_2))*100,0.01),"%9.2f")
	local ate_se_all_n`x' = string(round(r(se)*100,0.01),"%9.3f")
	local lb_ate_all_n`x' = string(round(((r(mu_1) - r(mu_2)) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	local ub_ate_all_n`x' = string(round(((r(mu_1) - r(mu_2)) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	
	qui: ttest d_ate_all_n`x'=0
	local pr_ate_all_n`x' = string(round(r(mu_1)*100,0.01),"%9.2f")
	local lb_pr_ate_all_n`x' = string(round((r(mu_1) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	local ub_pr_ate_all_n`x' = string(round((r(mu_1) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")

}


*TT
forvalues x=0/1{
	qui: ttest w`x'1==w`x'0 if D_1==`x' & D2_`x' == 1
 	local tt_all_n`x' = string(round((r(mu_1) - r(mu_2))*100,0.01),"%9.2f")
	local tt_se_all_n`x' = string(round(r(se)*100,0.01),"%9.3f")
	local lb_tt_all_n`x' = string(round(((r(mu_1) - r(mu_2)) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	local ub_tt_all_n`x' = string(round(((r(mu_1) - r(mu_2)) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	
	qui: ttest d_tt_all_n`x'=0
	local pr_tt_all_n`x' = string(round(r(mu_1)*100,0.01),"%9.2f")
	local lb_pr_tt_all_n`x' = string(round((r(mu_1) - invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	local ub_pr_tt_all_n`x' = string(round((r(mu_1) + invttail(r(df_t),0.025)*r(se))*100,0.01),"%9.2f")
	
	

		
}

file open sta using "$Results/static_2w.tex", write replace
file write sta "\begin{tabular}{lcccccc}" _n
file write sta "\hline" _n
file write sta "\multicolumn{1}{l}{Treatment effect} && \$t=1\$ && \$t=2\$ (\$D_1=0\$) && \$t=2\$ (\$D_1=1\$) \bigstrut\\" _n
file write sta "\cline{1-1}\cline{3-7}      &       &       &       &       &       &  \bigstrut[t]\\" _n

file write sta "\$ATE\$ (percentage points)     &&  `ate_all'     &&   `ate_all_n0'    &&   `ate_all_n1'     \bigstrut[t]\\" _n
file write sta "        && [`lb_ate_all',`ub_ate_all']    &&   [`lb_ate_all_n0',`ub_ate_all_n0']    &&  [`lb_ate_all_n1',`ub_ate_all_n1']   \\" _n
file write sta "&       &       &       &       &       &  \\" _n

file write sta "\$TT\$ (percentage points)    &&  `tt_all'     &&   `tt_all_n0'    &&   `tt_all_n1'     \bigstrut[t]\\" _n
file write sta "        && [`lb_tt_all',`ub_tt_all']    &&   [`lb_tt_all_n0',`ub_tt_all_n0']    &&  [`lb_tt_all_n1',`ub_tt_all_n1']   \\" _n
file write sta "&       &       &       &       &       &  \\" _n

file write sta "\$Pr(ATE<0)\times 100\$     &&  `pr_ate_all'     &&   `pr_ate_all_n0'    &&   `pr_ate_all_n1'     \bigstrut[t]\\" _n
file write sta "        && [`lb_pr_ate_all',`ub_pr_ate_all']    &&   [`lb_pr_ate_all_n0',`ub_pr_ate_all_n0']    &&  [`lb_pr_ate_all_n1',`ub_pr_ate_all_n1']   \\" _n
file write sta "&       &       &       &       &       &  \\" _n

file write sta "\$Pr(TT<0)\times 100\$     &&  `pr_tt_all'     &&   `pr_tt_all_n0'    &&   `pr_tt_all_n1'     \bigstrut[t]\\" _n
file write sta "        && [`lb_pr_tt_all',`ub_pr_tt_all']    &&   [`lb_pr_tt_all_n0',`ub_pr_tt_all_n0']    &&  [`lb_pr_tt_all_n1',`ub_pr_tt_all_n1']   \\" _n
file write sta "\hline" _n
file write sta "\end{tabular}%" _n
file close sta

*
/*Figure: ATE1 (after first choice)*/
twoway (lpolyci ate_1 theta_std if theta_pc>1 & theta_pc<100, fitplot(line,lwidth(medthick)  lcolor(black) )),/*
*/ ytitle("Change in log earnings")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
*/ legend(off) /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) scale(1.7) ylabel(0(0.01)0.04)
graph export "$Results/ate_1_theta_2w.pdf", replace

twoway (lpolyci tt_1 theta_std if theta_pc>1 & theta_pc<100, fitplot(line,lwidth(medthick)  lcolor(black) )),/*
*/ ytitle("Change in log earnings")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
*/ legend(off) /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) scale(1.7) ylabel(0(0.01)0.04)
graph export "$Results/tt_1_theta_2w.pdf", replace

forvalues x = 0/1{
	twoway (lpolyci ate_2_`x' theta_std if theta_pc>1 & theta_pc<100, fitplot(line,lwidth(medthick)  lcolor(black) )),/*
	*/ yline(0,lpattern(dash) lcolor(black)) /*
	*/ ytitle("Change in log earnings")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
	*/ legend(off) /*
	*/ xlabel( , noticks) ylabel(, nogrid) /*
	*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
	*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
	*/ scheme(s2mono) scale(1.7) ylabel(-0.01(0.02)0.06)
	graph export "$Results/ate_2_`x'_theta_2w.pdf", replace

	twoway (lpolyci tt_2_`x' theta_std if theta_pc>1 & theta_pc<100, fitplot(line,lwidth(medthick)  lcolor(black) )),/*
	*/ yline(0,lpattern(dash) lcolor(black)) /*
	*/ ytitle("Change in log earnings")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
	*/ legend(off) /*
	*/ xlabel( , noticks) ylabel(, nogrid) /*
	*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
	*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
	*/ scheme(s2mono) scale(1.7) ylabel(-0.01(0.02)0.06)
	graph export "$Results/tt_2_`x'_theta_2w.pdf", replace

}

