clear all
set more off

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates


/*
This do-file computes dynamic treatment effects and dynamic complementarities

1. Shows DATE and its decomposition into direct effects and continuation values
2. Dynamic complementarities across the support  of ability

*/


************************************************************
/*DYNAMIC TE and DYNAMIC COMPLEMENTARITIES*/
************************************************************
*Testing DTT vs DTUT
use $IN/simdata.dta, clear

xtile theta_pc = f_prod, nq(100)
egen theta_std = std(f_prod)

*discount factor
local beta = 1/(1+0.05)

*To levels

replace w0 = exp(w0)
replace w1 = exp(w1)
replace w10 = exp(w10)
replace w01 = exp(w01)
replace w00 = exp(w00)
replace w11 = exp(w11)

*DTE: impact of training in t=1 on earnings in t=3.

*NPV of Earnings for a given choice (direct effect + continuation value)
gen E_1 = w1 +`beta'*(D2_1*w11 + (1-D2_1)*w10 )
gen E_0 = w0 +`beta'*(D2_0*w01 + (1-D2_0)*w00 )

*baseline
qui: sum E_0
local baseline_mean = r(mean)


gen ATE = (E_1 - E_0)/E_0
gen TT = (E_1 - E_0)/E_0 if D1==1
gen TUT = (E_1 - E_0)/E_0 if D1==0


*direct effect (short-term)  + (next period)
gen deffect_st = (w1 - w0)/E_0
gen deffect_lt = `beta'*(w10 - w00)/E_0

*continuation value
gen cv  = `beta'*(D2_1*(w11-w10) - D2_0*(w01 - w00))/E_0


*Statistics
local i =1
foreach vars of varlist ATE TT TUT{
	qui: mean `vars'
	mat beta_aux=e(b)
	mat se_aux=e(V)
	local mean_`vars'=string(round((beta_aux[1,1])*100,0.01),"%9.2f")
	local sd_`vars'=string(round((se_aux[1,1]^.5)*100,0.01),"%9.2f")

	preserve

	if `i'==2{
		keep if D1==1
	}
	else if `i'==3{
		keep if D1==0
	}
	
	*Decomposing the treatment effect
	foreach vars2 of varlist deffect_st deffect_lt cv{
		qui: mean `vars2'
		mat beta_aux=e(b)
		mat se_aux=e(V)
		local mean_`vars2'_`vars'=string(round((beta_aux[1,1])*100,0.01),"%9.2f")
		local sd_`vars2'_`vars'=string(round((se_aux[1,1]^.5)*100,0.01),"%9.2f")

		*Contributions
		local cont_`vars2'_`vars' = string(round((`mean_`vars2'_`vars'' / `mean_`vars'')*100),"%9.0f")

	}
	

	restore


	local i = `i' + 1

}




*TABLE 11: Dynamic TE table
file open des using "$Results/dynamic_2w.tex", write replace
file write des
file write des "\begin{tabular}{llccccc}" _n
file write des "\hline" _n
file write des "       &       & DATE &       & DTT &       & DTUT \bigstrut\\" _n
file write des "\cline{1-1}\cline{3-7}\bigstrut[t]\\" _n
file write des "Direct effect (short-term) &       & `mean_deffect_st_ATE'   &       & `mean_deffect_st_TT'   &       & `mean_deffect_st_TUT' \\" _n
file write des "      &       & (`sd_deffect_st_ATE') &       & (`sd_deffect_st_TT') &       & (`sd_deffect_st_TUT') \\" _n
file write des "      &       & [`cont_deffect_st_ATE'\%]  &       & [`cont_deffect_st_TT'\%]  &       & [`cont_deffect_st_TUT'\%] \\" _n
file write des "      &       &       &       &       &       &  \\" _n
file write des "Direct effect (medium-term) &       & `mean_deffect_lt_ATE'   &       & `mean_deffect_lt_TT'   &       & `mean_deffect_lt_TUT' \\" _n
file write des "      &       & (`sd_deffect_lt_ATE') &       & (`sd_deffect_lt_TT') &       & (`sd_deffect_lt_TUT') \\" _n
file write des "      &       & [`cont_deffect_lt_ATE'\%]  &       & [`cont_deffect_lt_TT'\%]  &       & [`cont_deffect_lt_TUT'\%] \\" _n
file write des "      &       &       &       &       &       &  \\" _n
file write des "Continuation value &       & `mean_cv_ATE'   &       & `mean_cv_TT'   &       & `mean_cv_TUT' \\" _n
file write des "      &       & (`sd_cv_ATE') &       & (`sd_cv_TT') &       & (`sd_cv_TUT') \\" _n
file write des "      &       & [`cont_cv_ATE'\%]  &       & [`cont_cv_TT'\%]  &       & [`cont_cv_TUT'\%] \\" _n
file write des "      &       &       &       &       &       &  \\" _n
file write des "Total &       & `mean_ATE'   &       & `mean_TT'   &       & `mean_TUT' \\" _n
file write des "      &       & (`sd_ATE') &       & (`sd_TT') &       & (`sd_TUT') \\" _n
file write des "      &       &       &       &       &       &  \bigstrut[b]\\" _n
file write des "\hline" _n
file write des "\end{tabular}" _n
file close des

*Graph: treatment effects across theta-deciles
xtile f1_5 = f_prod, nq(10)


local i = 1
foreach vars of varlist ATE TT TUT{
	preserve
	
	if `i'==2{
		keep if D1==1
	}
	else if `i'==3{
		keep if D1==0
	}
	
	collapse (mean) `vars' deffect_st deffect_lt cv, by(f1_5)

	*Change collors, scatter, and xticks
	twoway (bar  cv f1_5, lwidth(medthick)  lcolor(black) fcolor(none))  /*
	*/ (bar deffect_st f1_5,barwidth(0.7) bargap(-100) lwidth(medium) lcolor(black) fcolor(ltgray%80) )/*
	*/ (bar deffect_lt  f1_5,barwidth(0.4) bargap(-100) lcolor(black) fcolor(ltblue)  ) /*
	*/(scatter `vars' f1_5, msymbol(circle) mcolor(black)),/*
	*/ ytitle("Change in earnings (%)")  xtitle("Deciles of ability ({&theta})") /*
	*/ legend(order(1 "Continuation value" 2 /*
	*/ "Direct effect (short-term)" 3 "Direct effect (medium-term)" /*
	*/4 "`vars' (DE+CV)") region(lcolor(white))) /*
	*/ xlabel( 1(2)10, noticks) ylabel(, nogrid) /*
	*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
	*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
	*/ scheme(s2mono) scale(1.2)
	
	graph export "$Results/`vars'_DE_CV_2w.pdf", as(pdf) replace
	restore
	local i = `i' + 1
}


*FIGURE - DYNAMIC COMPLEMENTARITIES*

gen dc = ((w11-w10) - (w01 - w00))/E_0


twoway (lpolyci dc theta_std if theta_pc>1 & theta_pc<100, fitplot(line,lwidth(medthick)  lcolor(black) )),/*
*/ yline(0,lpattern(dash) lcolor(black)) /*
*/ ytitle("Change in earnings (%)")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
*/ legend(off) /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) scale(1.7) ylabel(-0.035(0.005)-0.01)
graph export "$Results/DC_theta_2w.pdf", as(pdf) replace



*FIGURE - DYNAMIC SORTING GAINS*
gen dsorting = ((D2_1*(w11-w10) - D2_0*(w01 - w00))/E_0) - dc

twoway (lpolyci dsorting theta_std if theta_pc>1 & theta_pc<100, /*
*/fitplot(line,lwidth(medthick)  lcolor(black) )),/*
*/ yline(0,lpattern(dash) lcolor(black)) /*
*/ ytitle("Change in earnings (%)")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
*/ legend(off) /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) scale(1.7) ylabel(0.01(0.005)0.035)
graph export "$Results/Dsorting_theta_2w.pdf", as(pdf) replace






