clear all
set more off

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates
global Results C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Results

use $IN/simdata.dta, clear


xtile theta_pc = f_prod, nq(100)
egen theta_std = std(f_prod)

*discount factor
local beta = 1/(1+0.05)

*To levels
replace w0 = exp(w0)
replace w1 = exp(w1)
replace w10 = exp(w10)
replace w01 = exp(w01)
replace w00 = exp(w00)
replace w11 = exp(w11)

drop W_1 W_2
qui gen W_1 = D1*w1 + (1-D1)*w0
qui gen W_2 = D1*D2_1*w11 + D1*(1-D2_1)*w10+(1-D1)*D2_0*w01+(1-D1)*(1-D2_0)*w00

*Baseline Earnings*
gen Y_tilde = W_1 + `beta'*W_2

*Considering 50% Expansion as Relevant Policy*
cap gen D1_z = D1_prte2

*DPRTEs
qui gen W_1_Z = D1_z*w1 + (1-D1_z)*w0
qui gen W_2_Z = D1_z*D2_1*w11 + D1_z*(1-D2_1)*w10+(1-D1_z)*D2_0*w01+(1-D1_z)*(1-D2_0)*w00

*Define PDV (Wages)*
gen Y_tilde_Z = W_1_Z + `beta'*W_2_Z

*Define Dynamic Policy-Relevant Treatment Effects*
gen DPRTE = (Y_tilde_Z - Y_tilde)/Y_tilde


*Generate Response Types*
gen co = (D1_z == 1 & D1 == 0)

gen co_at = (D1_z == 1 & D1 == 0 & D2_1 == 1 & D2_0 == 1)
gen co_co = (D1_z == 1 & D1 == 0 & D2_1 == 1 & D2_0 == 0)
gen co_nt = (D1_z == 1 & D1 == 0 & D2_1 == 0 & D2_0 == 0)
gen co_df = (D1_z == 1 & D1 == 0 & D2_1 == 0 & D2_0 == 1)

******************************************************************************************
*Figures*
******************************************************************************************
twoway (lpolyci DPRTE theta_std if theta_pc>1 & theta_pc<100  & co == 1, fitplot(line,lwidth(medthick)  lcolor(black) )),/*
*/ yline(0,lpattern(dash) lcolor(black)) /*
*/ ytitle("Change in earnings (%)")  xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}") /*
*/ legend(off) /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) ylabel(0(0.01)0.06) scale(1.2)

graph export "$Results/DPRTE_theta_2w.pdf", replace 

twoway (kdensity f_prod if co_at == 1,lcolor(black)  lwidth(medthick) )/*
*/(kdensity f_prod if co_co == 1, lcolor(black)  lwidth(medthick)) /*
*/(kdensity f_prod if co_nt == 1, lcolor(black)  lwidth(medthick)) /*
*/(kdensity f_prod if co_df == 1, lcolor(black)  lwidth(medthick)), /*
*/ legend(order(1 "Compliers - Always-Takers" 2 "Compliers - Compliers" 3 "Compliers - Never-Takers" 4 "Compliers - Defiers")) /*
*/ xtitle("Latent Productivity ({&theta}{subscript:2}) in {&sigma}")/*
*/ ytitle("Density")/*
*/ ylabel(, nogrid) xlabel( , noticks) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono)

graph export "$Results/response_types_density_2w.pdf", replace 

******************************************************************************************
*Test Score Heterogeneity*
******************************************************************************************
twoway (kdensity f_test if co_at == 1,lcolor(black)  lwidth(medthick) )/*
*/(kdensity f_test if co_co == 1, lcolor(black)  lwidth(medthick)) /*
*/(kdensity f_test if co_nt == 1, lcolor(black)  lwidth(medthick)) /*
*/(kdensity f_test if co_df == 1, lcolor(black)  lwidth(medthick)), /*
*/ legend(order(1 "Compliers - Always-Takers" 2 "Compliers - Compliers" 3 "Compliers - Never-Takers" 4 "Compliers - Defiers")) /*
*/ xtitle("Latent Ability ({&theta}{subscript:1}) in {&sigma}")/*
*/ ytitle("Density")/*
*/ ylabel(, nogrid) xlabel( , noticks) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono)

graph export "$Results/response_types_density_2w_test.pdf", replace 



cap rename D1_prte2 D1_prte5

foreach y in 1 5{

	qui gen W_1_prte`y' = D1_prte`y'*w1 + (1-D1_prte`y')*w0
	qui gen W_2_prte`y' = D1_prte`y'*D2_1*w11 + D1_prte`y'*(1-D2_1)*w10+(1-D1_prte`y')*D2_0*w01+(1-D1_prte`y')*(1-D2_0)*w00

}
	
foreach y in 1 5{
local beta = 1/(1+0.05)
	
	*Define PDV (Wages)*
	gen Y_tilde_prte`y' = W_1_prte`y' + `beta'*W_2_prte`y'

	*Define Dynamic Policy-Relevant Treatment Effects*
	gen DPRTE_`y' = (Y_tilde_prte`y' - Y_tilde)/Y_tilde


	*Generate Response Types*
	gen co_`y' = (D1_prte`y' == 1 & D1 == 0)

	gen co_at_`y' = (D1_prte`y' == 1 & D1 == 0 & D2_1 == 1 & D2_0 == 1)
	gen co_co_`y' = (D1_prte`y' == 1 & D1 == 0 & D2_1 == 1 & D2_0 == 0)
	gen co_nt_`y' = (D1_prte`y' == 1 & D1 == 0 & D2_1 == 0 & D2_0 == 0)
	gen co_df_`y' = (D1_prte`y' == 1 & D1 == 0 & D2_1 == 0 & D2_0 == 1)


}

foreach y in 1 5{

	qui sum co_`y'
	local co`y' = r(mean)
	local co_`y' = string(round(r(mean)*100,0.001),"%9.2f")

	foreach x in co co_at co_co co_nt co_df {
		qui ci means DPRTE_`y' if `x'_`y' == 1 
		local DPRTE_`x'_`y' = string(round(r(mean)*100,0.01),"%9.2f")
		local DPRTE_`x'_`y'_lb = string(round(r(lb)*100,0.01),"%9.2f")
		local DPRTE_`x'_`y'_ub = string(round(r(ub)*100,0.01),"%9.2f")
		
		qui ci means `x'_`y'
		local share_`x'_`y' = string(round(r(mean)/`co`y'',0.001),"%9.3f")

				

		
		}
		
}

*Panel A Weights TEs*
file open des using "$Results/prte_2w_A.tex", write replace
file write des
file write des "\begin{tabular}{lcc}" _n
file write des "\hline" _n
file write des " \multicolumn{3}{c}{Share Compliers} \bigstrut[t]\\" _n
file write des " \hline" _n
file write des " & Policy: \$+10\%\$  & Policy: \$+50\%\$ \bigstrut[t]\\" _n
file write des " & (1)    & (2) \\" _n
file write des " \hline" _n
file write des "Compliers (CO) & `co_1'\%    & `co_5'\% \\" _n
file write des " \hline" _n
file write des "& \multicolumn{2}{c}{Weights by Type}\bigstrut[t]\\" _n
file write des " \hline" _n
file write des "Compliers-Always Takers (\$CO,AT\$) &        `share_co_at_1'      & `share_co_at_5' \\" _n
file write des "Compliers-Compliers (\$CO,CO\$) &        `share_co_co_1'      & `share_co_co_5' \\" _n
file write des "Compliers-Never Takers (\$CO,NT\$) &        `share_co_nt_1'      & `share_co_nt_5' \\" _n
file write des "Compliers-Defiers (\$CO,DF\$) &        `share_co_df_1'      & `share_co_df_5' \\" _n
file write des " \hline" _n
file write des "\end{tabular}" _n
file close des

*Panel B: PRTEs*
file open des using "$Results/prte_2w_B.tex", write replace
file write des
file write des "\begin{tabular}{lcc}" _n
file write des "\hline" _n
file write des " \multicolumn{3}{c}{Dynamic Policy Relevant Treatment Effects} \bigstrut[t]\\" _n
file write des " \hline" _n
file write des " & Policy: \$+10\%\$  & Policy: \$+50\%\$ \bigstrut[t]\\" _n
file write des " & (1)    & (2) \\" _n
file write des " \hline" _n
file write des "Compliers & `DPRTE_co_1'\%    & `DPRTE_co_5'\% \\" _n
file write des " & [`DPRTE_co_1_lb',`DPRTE_co_1_ub']    & [`DPRTE_co_5_lb',`DPRTE_co_5_ub'] \\ [1ex]" _n
file write des " \hline" _n
file write des "Compliers-Always Takers (\$CO,AT\$) &     `DPRTE_co_at_1'\%    & `DPRTE_co_at_5'\% \\" _n
file write des "&  [`DPRTE_co_at_1_lb',`DPRTE_co_at_1_ub']    & [`DPRTE_co_at_5_lb',`DPRTE_co_at_5_ub'] \\ [0.5ex]" _n
file write des "Compliers-Compliers (\$CO,CO\$) &     `DPRTE_co_co_1'\%    & `DPRTE_co_co_5'\% \\" _n
file write des "&  [`DPRTE_co_co_1_lb',`DPRTE_co_co_1_ub']    & [`DPRTE_co_co_5_lb',`DPRTE_co_co_5_ub'] \\ [0.5ex]" _n
file write des "Compliers-Never Takers (\$CO,NT\$) &     `DPRTE_co_nt_1'\%    & `DPRTE_co_nt_5'\% \\" _n
file write des "&  [`DPRTE_co_nt_1_lb',`DPRTE_co_nt_1_ub']    & [`DPRTE_co_nt_5_lb',`DPRTE_co_nt_5_ub'] \\ [0.5ex]" _n
file write des "Compliers-Defiers (\$CO,DF\$) &     `DPRTE_co_df_1'\%    & `DPRTE_co_df_5'\% \\" _n
file write des "&  [`DPRTE_co_df_1_lb',`DPRTE_co_df_1_ub']    & [`DPRTE_co_df_5_lb',`DPRTE_co_df_5_ub'] \\ [0.5ex]" _n
file write des " \hline" _n
file write des "\end{tabular}" _n
file close des
