clear all
set more off

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates
global Results C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Results

/*
This code produces
1. Tree of Possible choices 
2. Descriptive stats of estimation sample (two tables)
*/


******************************************************************************
*FIGURE: TRAINING TREE
******************************************************************************
use "$IN/sample_3wages_comuna.dta", clear

gen d_t_1 = treeobs==10 | treeobs==11
qui: sum d_t_1
local tr1_1 = round(r(mean),0.01)*100
local tr0_1 = round(1 - r(mean),0.01)*100

gen d_t_1_1 = treeobs==11
replace d_t_1_1 =. if d_t_1 == 0
qui: sum d_t_1_1
local tr1_2_1 = round(r(mean),0.01)*100
local tr0_2_1 = round(1 - r(mean),0.01)*100

gen d_t_1_0 = treeobs==1
replace d_t_1_0 =. if d_t_1 == 1
qui: sum d_t_1_0
local tr1_2_0 = round(r(mean),0.01)*100
local tr0_2_0 = round(1 - r(mean),0.01)*100

file open tree using "$Results/tree.tex", write replace
file write tree "\begin{tikzpicture}[grow=right, sloped]" _n
file write tree "\node[bag] {First Year Training}" _n
file write tree "    child {" _n
file write tree "        node[bag] {Second Year Training} " _n
file write tree "            child {" _n
file write tree "                node[end, label=right:" _n
file write tree "                    {\$Y_{(0,0)}\$}] {}" _n
file write tree "                edge from parent" _n
file write tree "                node[below]" _n
file write tree "            }" _n
file write tree "            child {" _n
file write tree "                node[end, label=right:" _n
file write tree "                    {\$Y_{(0,1)}\$}] {}" _n
file write tree "                edge from parent" _n
file write tree "                node[above] " _n
file write tree "           }" _n
file write tree "            edge from parent " _n
file write tree "                node[below]" _n
file write tree "    }" _n
file write tree "    child {" _n
file write tree "        node[bag] {Second Year Training} " _n
file write tree "        child {" _n
file write tree "                node[end, label=right:" _n
file write tree "                    {\$Y_{(1,0)}\$}] {}" _n
file write tree "                edge from parent" _n
file write tree "                node[below]" _n
file write tree "            }" _n
file write tree "            child {" _n
file write tree "                node[end, label=right:" _n
file write tree "                    {\$Y_{(1,1)}\$}] {}" _n
file write tree "                                    edge from parent" _n
file write tree "                node[above]" _n
file write tree "            }" _n
file write tree "        edge from parent" _n
file write tree "                node[above]" _n
file write tree "    };" _n
file write tree "\end{tikzpicture}" _n
file close tree


******************************************************************************
*TABLES: SUMMARY STATISTICS of estimation sample (overall and by training nodes)
******************************************************************************
use "$IN/sample_3wages_comuna.dta", clear


la var d_sexo "Male"
la var ageatgrad "Age at Graduation"
la var mate "Math PSU (Standardized)"
la var verbal "Verbal PSU (Standardized)"
la var ptje_nem "High School GPA (Standardized)"
la var mosal_t1 "Initial Monthly Salary (USD)"
la var mosal_t2 "Monthly Salary after First Year (USD)"
la var mosal_t3 "Monthly Salary after Second Year (USD)"
la var hours_t1 "Average Hours Trained (First Year)"
la var hours_t2 "Average Hours Trained (Second Year)"


format d_sexo ageatgrad mate verbal ptje_nem  %9.2g
format mosal_t1 mosal_t2 mosal_t3 %9.0g
format hours_t1 hours_t2 %9.1g

*TABLE 1*
sutex d_sexo ageatgrad mate verbal ptje_nem mosal_t1 mosal_t2 mosal_t3, lab key(table1_v1) replace ///
file("$Results/table1_v2.tex") title("Summary Statistics") digits(2) par

*TABLE 2*
eststo clear
bys treeobs: eststo: qui estpost summarize d_sexo ageatgrad mate verbal ptje_nem mosal_t1 mosal_t2 mosal_t3 hours_t1 hours_t2, meanonly
esttab using "$Results/table2_v2.tex", replace cells(mean(fmt(2))) lab key(table2_v1)  nodepvar collabels(none) title("Summary Statistics by Training Node") nonumbers mtitles("Tree = 0,0" "Tree = 0,1" "Tree = 1,0" "Tree = 1,1")

