%OLSTable6.m
%OLS project, sept. 2007
%
% Runs a Monte Carlo Experiment for adj. OLS 
% IPV Vickrey Auction with asymmetric distributions
% 3 types bidders:
%      v1 ~ N(10 + X beta, 1)
%      v2 ~ N(11 + X beta, 2^2)
%      v3 ~ N(12 + X beta, 3^2)
% each auction has ni bidders of type i
% ni i.i.d U{1,2}
%
% X ~ U[0,5]

mus = [10 11 12];
sigmas = [1 2 3];
beta = 1;

randn('state',4567)
rand('twister',4567)

S = 1000; %number of samples

T = 100; %number of auctions in each sample

b= zeros(S,9);


for R = 1:S;
X = 5*rand(T,1);
n = 1+(rand(T,3)>.5);
means = ones(T,1)*mus+X*beta*ones(1,3);
stdevs = ones(T,1)*sigmas;

V1 = means+ stdevs.*randn(T,3);
V2 = means+ stdevs.*randn(T,3);
W = zeros(T,1);
for t = 1:T,
    sv = sort([V1(t,:),V2(t,find(n(t,:)>1))],2,'descend');
    W(t) = sv(2);
end
nn = (n-1)*[4 2 1]';
D = zeros(T,8);
for i = 0:7,
    D(:,i+1) = nn==i;
end

b(R,:) = regress(W,[X,D])'; 
end

% b: sample of OLS estimates
% first column: estimates for beta
% second column: estimates for participation dummies (not meaningful) 

% calculation of statistics
means = mean(b);
vars = var(b);
skew = skewness(b);
kurt = kurtosis(b);
JB = S/6*(skew.^2+(kurt-3).^2/4);
pJB = cdf('chi2',JB,2);

sb = sort(b);
median = (sb(S/2,:)+sb(S/2+1,:))/2;
LQ = (sb(S/4,:)+sb(S/4+1,:))/2;
UQ = (sb(3*S/4,:)+sb(3*S/4+1,:))/2;

stats = [means;vars;JB;pJB]

