/*

If you have questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde

*/

new;
output file=c:\research\garchbreak\Insam_us.out reset;
load data[6453,1]=c:\research\garchbreak\Data_us_d.txt;
rex=ln(data[2:6453]./data[1:6452])*100; @ US continuous returns @
rex2=rex^2; @ squared returns @
v1=seqa(1980,1/255,rows(rex));
library cml,pgraph;
#include c:\gauss6.0\src\icss.src;
#include c:\gauss6.0\src\variance.src;

/* Calculating summary stats--see West and Cho (1995, pp. 377-378) */

e=rex;
x=e~e^2~e^3~e^4;
m=cols(x);
theta=meanc(x);
g=x-theta';
p=rows(e);
n=round(4*(p/100)^(2/9));
w=ones(m,1);
s0sum=w'((1/p)*g'g)*w;
s1sum=0;
iter=1;
do until iter>n;
   {gg,gglags}=varlags(g,iter);
   s0new=2*w'((1/p)*(gg'gglags[.,((iter-1)*m+1):iter*m]))*w;
   s0sum=s0sum+s0new;
   s1sum=s1sum+iter*s0new;
   iter=iter+1;
endo;
k=round(1.1447*(s1sum/s0sum)^(2/3));
if k==1;
   s=(1/p)*g'g;
else;
   gamsum=(1/p)*g'g;
   iter=1;
   do until iter>k-1;
      {gg,gglags}=varlags(g,iter);
      gamnew=(1/p)*(gg'gglags[.,((iter-1)*m+1):iter*m]+
             gglags[.,((iter-1)*m+1):iter*m]'gg);
      gamsum=gamsum+(1-(iter/((k-1)+1)))*gamnew;
      iter=iter+1;
   endo;
   s=gamsum;
endif;
s=s/p;
sd=standdev(theta);
deriv_sd=gradp(&standdev,theta);
v_sd=deriv_sd*s*deriv_sd';
se_sd=sqrt(v_sd);
sk=skewness(theta);
deriv_sk=gradp(&skewness,theta);
v_sk=deriv_sk*s*deriv_sk';
se_sk=sqrt(v_sk);
ek=excesskur(theta);
deriv_ek=gradp(&excesskur,theta);
v_ek=deriv_ek*s*deriv_ek';
se_ek=sqrt(v_ek);
proc standdev(theta);
   local sig;
   sig=(theta[2]-theta[1]^2)^0.5;
   retp(sig);
endp;
proc skewness(theta);
   local sig,sk;
   sig=(theta[2]-theta[1]^2)^0.5;
   sk=(theta[3]-3*theta[2]*theta[1]+4*theta[1]^3)*sig^(-3);
   retp(sk);
endp;
proc excesskur(theta);
   local sig,ek;
   sig=(theta[2]-theta[1]^2)^0.5;
   ek=((theta[4]-4*theta[3]*theta[1]+5*theta[1]^4)*sig^(-4))-3;
   retp(ek);
endp;
"Summary stats--returns (robust standard error)";?;
"Newey and West (1994) k = " k;?;
"Mean                    = " theta[1]~sqrt(s[1,1]);
"Standard deviation      = " sd~se_sd;
"Skewness                = " sk~se_sk;
"Excess kurtosis         = " ek~se_ek;
"Minimum                 = " minc(e);
"Maximum                 = " maxc(e);?;

/* Modified Ljung-Box--see West and Cho (1995, p. 378) */

r=20;
e2=e^2;
e2m=meanc(e2);
sig0=(1/p)*e'e;
int_mlb=0;
int_lb=0;
iter=1;
do until iter>r;
   {ee,eelags}=varlags(e,iter);
   sig=(1/p)*ee'eelags[.,iter];
   {ee2,ee2lags}=varlags(e2,iter);
   kappa=(1/p)*ee2'ee2lags[.,iter];
   auto2=((ee2-e2m)'(ee2lags[.,iter]-e2m))/((e2-e2m)'(e2-e2m));
   rho=sig/sig0;
   int_mlb=int_mlb+(1/(p-iter))*(rho^2/kappa);
   int_lb=int_lb+(1/(p-iter))*auto2^2;
   iter=iter+1;
endo;
mlbstat=p*(p+2)*sig0^2*int_mlb;
pval_mlb=cdfchic(mlbstat,r);
lbstat=p*(p+2)*int_lb;
pval_lb=cdfchic(lbstat,r);
"Number of autocorrelations                 = " r;?;
"Modified Ljung-Box stat--returns (p-value) = " mlbstat~pval_mlb;?;
"Ljung-Box stat--squared returns (p-value)  = " lbstat~pval_lb;?;

"ARCH tests";?;

q=2;
{lm,pval}=archtest(e2,q);
"q                 = " q;
"LM stat (p-value) = " lm~pval;?;
q=10;
{lm,pval}=archtest(e2,q);
"q                 = " q;
"LM stat (p-value) = " lm~pval;?;

/* Estimating GARCH(1,1) model */

{b,f,g,vcv,ret,hhat_fs}=garch11(rex,(.01|.1|.8));
seb=sqrt(diag(vcv));
proc(1)=uncvariance(b);
local uncvar;
   uncvar=b[1]/(1-b[2]-b[3]);
   retp(uncvar);
endp;
uncvar=uncvariance(b);
deriv_uncvar=gradp(&uncvariance,b);
v_uncvar=deriv_uncvar*vcv*deriv_uncvar';
se_uncvar=sqrt(v_uncvar);
xx=ones(rows(rex),1);
bb=rex2/xx;
{sse,vv}=nw(rex2,xx,bb,20);
uncvar2=bb;
se_uncvar2=sse[.,1];
"GARCH(1,1) (parameter, standard error)";?;
"Return code            = " ret;
"Log-likelihood         = " f;
"omega                  = " b[1]~seb[1];
"alpha                  = " b[2]~seb[2];
"beta                   = " b[3]~seb[3];
"omega/[1-(alpha+beta)] = " uncvar~se_uncvar;
"Unconditional variance = " uncvar2~se_uncvar2;?;

/* Computing GARCH(1,1) diagnostics */

{LM_RA,pv_RA,LM_HOA,pv_HOA,LM_HOG,pv_HOG,LM_SB,pv_SB,LM_NSB,pv_NSB,
LM_PSB,pv_PSB,LM_SSB,pv_SSB,LM_QG,pv_QG,LM_LSTG,pv_LSTG,LM_PCc,pv_PCc,
LM_PCa,pv_PCa,LM_PCca,pv_PCca,LM_PCg,pv_PCg,LM_PCchu,k_PCchu}=
EVALGRCH(rex,b,1,1,1,1,1,1,0.10,1,1);
"GARCH(1,1) diagnositcs (test statistics and p-values)";?;
"Higher-order ARCH    = " LM_HOA[1]~pv_HOA[1];
"Higher-order GARCH   = " LM_HOG[1]~pv_HOG[1];
"Parameter stability  = " LM_PCg[1]~pv_PCg[1];
"Chu (1995) statistic = " LM_PCchu;?;

/* Applying modified ICSS break test, squared returns */

"Squared returns";?;
cri=0|1|4;
"kappa_2 test";?;
{cpr,nbr}=icss(rex,2,cri);
"Number of breaks = " nbr;?;
"Break positions  = " cpr';?;
"Break dates      = " v1[cpr]';?;
vbreak_sr={};
fbreak=0;
iter=1;
do until iter>nbr+1;
   if iter==1;
      rrex=rex[cpr[1]:cpr[2]];
      {b,f,g,vcv,ret,hhat}=garch11(rrex,(.01|.1|.8));
   else;
      rrex=rex[cpr[iter]+1:cpr[iter+1]];
      {b,f,g,vcv,ret,hhat}=garch11(rrex,(.01|.1|.8));
   endif;
   if b[2]>0.00000000001;
      seb=sqrt(diag(vcv));
      uncvar=uncvariance(b);
      deriv_uncvar=gradp(&uncvariance,b);
      v_uncvar=deriv_uncvar*vcv*deriv_uncvar';
      se_uncvar=sqrt(v_uncvar);
      xx=ones(rows(rrex),1);
      bb=rrex^2/xx;
      {sse,vv}=nw(rrex^2,xx,bb,20);
      uncvar2=bb;
      se_uncvar2=sse[.,1];
   else;
      y2=rrex^2;
      x2=ones(rows(y2),1);
      b2=y2/x2;
      {se2,v}=nw(y2,x2,b2,0);
      b=b2|0|0;
      seb=se2[.,1]|0|0;
      uncvar=b[1];
      se_uncvar=seb[1];
      uncvar2=uncvar;
      se_uncvar2=se_uncvar;
   endif;
   vbreak_sr=vbreak_sr|meanc(rrex^2)*ones(rows(rrex),1);
   fbreak=fbreak+f;
   "Subsample " iter;?;
   {lm,pval}=archtest(rrex^2,2);
   "q                 = " 2;
   "LM stat (p-value) = " lm~pval;?;
   {lm,pval}=archtest(rrex^2,10);
   "q                 = " 10;
   "LM stat (p-value) = " lm~pval;?;
   "GARCH(1,1) parameters";?;
   "Return code              = " ret;
   "Cumulated log-likelihood = " fbreak;
   "omega                    = " b[1]~seb[1];
   "alpha                    = " b[2]~seb[2];
   "beta                     = " b[3]~seb[3];
   "omega/[1-(alpha+beta)]   = " uncvar~se_uncvar;
   "unconditional variance   = " uncvar2~se_uncvar2;?;
   iter=iter+1;
endo;

"Returns and +/- 3 stan err bands";

Data_fig1_ca=v1~-3*sqrt(vbreak_sr)~rex~3*sqrt(vbreak_sr);
save path=c:\research\garchbreak Data_fig1_ca;
Data_fig1_ca;?;

/* Procedure definition area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/*****************************************************************
PROC: ARCHTEST

This procedure calculates the Engel (1982) LM statistic to test
for ARCH. The procedure requires the procedure VARLAGS (provided
above).

Input:

y = vector of squared residuals
q = lag for squared residual regression

Output:

lm   = LM statistic
pval = p-value
*****************************************************************/
proc(2)=archtest(y,q);
   local y0,y0lags,n,x,b,ybar,tss,ess,lm,pval;
   {y0,y0lags}=varlags(y,q);
   n=rows(y0);
   x=ones(n,1)~y0lags;
   b=y0/x;
   ybar=meanc(y0);
   tss=y0'y0-n*ybar^2;
   ess=b'x'x*b-n*ybar^2;
   lm=n*(ess/tss);
   pval=cdfchic(lm,q);
   retp(lm,pval);
endp;

/*****************************************************************
PROC: GARCH11

This procedure estimates the GARCH(1,1) model,

h(t) = omega + alpha*e^2(t-1) + beta*h(t-1).

It calls the procedures GARCH11_LOGLIKE and GARCH11_HHAT
(provided below) and uses the GAUSS application CML.

Format: {b,f,g,vcv,ret,hhat}=GARCH11(depvar,startvalues)

Input:

depvar      = T-vector, dependent variable
startvalues = vector of inital values

Output:

b    = 3-vector of parameter estimates (omega,alpha,beta)
f    = scalar, log-likelihood function at minimum
g    = 3-vector, gradient at minimum
vcv  = variance-covariance matrix for parameters
ret  = scalar, CML return code
hhat = T-vector of conditional variance estimates at
       each point in time
*****************************************************************/
proc(6)=garch11(depvar,startvalues);
   local b,f,g,vcv,ret,hhat;
   cmlset;
   _cml_DirTol=0.001;
   _cml_Bounds={0.0000001 10,
                0         10,
                0         10};
   __output=0;
   {b,f,g,vcv,ret}=cml(depvar,0,&garch11_loglike,startvalues);
   hhat=garch11_hhat(b,depvar);
   retp(b,f,g,vcv,ret,hhat);
endp;

/*****************************************************************
proc: GARCH11_LOGLIKE
*****************************************************************/
proc garch11_loglike(x,e);
   local bigt,mean_e2,alphapart,h;
   bigt=rows(e);
   mean_e2=meanc(e^2);
   alphapart=x[1]+x[2]*missrv(lagn(e^2,1),mean_e2);
   h=recserar(0|alphapart,mean_e2,x[3]);
   h=h[2:bigt+1];
   retp(-(bigt/2)*ln(2*pi)-(1/2)*sumc(ln(h)+(e^2)./h));
endp;

/*****************************************************************
proc: GARCH11_HHAT
*****************************************************************/
proc garch11_hhat(x,e);
   local bigt,mean_e2,alphapart,h;
   bigt=rows(e);
   mean_e2=meanc(e^2);
   alphapart=x[1]+x[2]*missrv(lagn(e^2,1),mean_e2);
   h=recserar(0|alphapart,mean_e2,x[3]);
   h=h[2:bigt+1];
   retp(h);
endp;

/*************   Newey-West (Bartolini & Kramer, Jun95) *******************/
/*                                                                        */
/*                       NEWEY - WEST errors                              */
/*                                                                        */
/**************************************************************************/
/*
                 authors: Leonardo Bartolini
                          Charles Kramer

                          Research Department, IMF
                          700, 19th St. NW,
                          Washington, D.C. 20431, USA

                 correspondence to: LBARTOLINI@IMF.ORG
/**************************************************************************/

Notes:

 The routine is written as a procedure NW(y,X,b,lag);
 It arguments are:

       - a vector y[n,1] of dependent variables;
       - a matrix X[n,k] of independent variables;
       - a vector b[k,1] of the associated OLS coefficients,
       - an integer lag-truncation ("lag");

 The procedures returns a matrix (k x 2), with

       - in the first column the Newey-West errors;
       - in the second column the OLS errors,
       
 and V, the Newey-West variance-covariance matrix.

 The program is written following the treatment and notation of
 Gallant, R. (1987), "Nonlinear Statistical Models," pp.137-139.

 This program is for public, non commercial use.
 It was succesfully tested against the NW errors provided by TSP.
 Nevertheless, the authors disclaim any responsibility for its use.                                                                 */

/*********************************************************************/
PROC(2)=NW(y,X,b,lag);
   LOCAL sse,n,yhat,e,G,w,a,t,ga,V,F,nwerr,olserr,k,za,hhat;
   n=ROWS(X);
   k=ROWS(B);
   yhat=X*b;
   e=y-yhat;
   hhat=e'.*x';
   G=ZEROS(k,k);
   w=ZEROS(2*lag+1,1);
   a=0;
   DO UNTIL a==lag+1;
      ga=ZEROS(ROWS(b),ROWS(b));
      w[lag+1+a]=(lag+1-a)/(lag+1);
      za=hhat[.,(a+1):n]*hhat[.,1:n-a]';
      IF a==0;
         ga=ga+za;
      ELSE;
         ga=ga+za+za';
      ENDIF;
      G=G+w[lag+1+a]*ga;
      a=a+1;
   ENDO;
   F=X'*X;
   V=INV(F)*G*INV(F);
   nwerr=(DIAG(V))^.5;
   olserr=(DIAG(INV(X'X)*e'e/(n-k)))^.5;
   RETP(nwerr~olserr,V);
ENDP;

/*
**  EVALGRCH
**
**  Purpose : compute several misspecification tests for GARCH(p,q) models:
**              - LM test against remaining ARCH in standardized residuals
**                   (Lundbergh and Terasvirta, 1998)
**              - LM test against higher order ARCH/GARCH (Bollerslev, 1986)
**              - Sign Bias test (Engle and Ng, 1993)
**              - Negative Size Bias test (Engle and Ng, 1993)
**              - Positive Size Bias test (Engle and Ng, 1993)
**              - Joint test for Sign and Size Bias (Engle and Ng, 1993)
**              - LM test against QGARCH (Hagerud, 1997)
**              - LM test against LSTGARCH (Hagerud, 1997)
**              - LM test for parameter constancy
**                   (Lundbergh and Terasvirta, 1998)
**              - LM test for parameter constancy (Chu, 1995)
**
**  Format  :  {LM_RA,pv_RA,LM_HOA,pv_HOA,LM_HOG,pv_HOG,LM_SB,pv_SB,LM_NSB,pv_NSB,
**              LM_PSB,pv_PSB,LM_SSB,pv_SSB,LM_QG,pv_QG,LM_LSTG,pv_LSTG,LM_PCc,pv_PCc,
**              LM_PCa,pv_PCa,LM_PCca,pv_PCca,LM_PCg,pv_PCg,LM_PCchu,k_PCchu}=
**              EVALGRCH(e,param,q,p,m_RA,m_HOA,m_HOG,m_PC,pi_chu,ortho,stdz);
**
**  Input   : e     : (T x 1) vector, residuals
**            theta : (1+q+p x 1) vector, parameters in GARCH(p,q) model
**            q     : scalar, "ARCH order", i.e., number of lagged squared
**                    residuals in GARCH model
**            p     : scalar, "GARCH order", i.e., number of lagged conditional
**                    variances in GARCH model
**            m_RA  : (nm_RA x 1) vector, containing orders of remaining ARCH
**                    to test against
**            m_HOA : (nm_HOA x 1) vector, containing INCREMENTS in ARCH order
**                    to test against
**            m_HOG : (nm_HOG x 1) vector, containing INCREMENTS in GARCH order
**                    to test against
**            m_PC  : scalar, maximum order of time-variation to test against
**            pi_chu: scalar, trimming fraction in test of Chu
**            ortho : 0-1, indicating whether or not to perform preliminary
**                    orthogonalization regression
**            stdz  : 0-1, indicating whether or not to standardize variables
**                    in computation of LM statistics
**
**  Output  : LM_RA   : (2 x nm_RA) vector, LM test against remaining ARCH
**            LM_HOA  : (2 x nm_HOA) vector, LM test against higher order ARCH
**            LM_HOG  : (2 x nm_HOG) vector, LM test against higher order GARCH
**            LM_SB   : (2 x 1), Size Bias test
**            LM_NSB  : (2 x 1), Negative Sign Bias test
**            LM_PSB  : (2 x 1), Positive Sign Bias test
**            LM_SSB  : (2 x 1), joint test for Size and Sign Bias
**            LM_QG   : (2 x 1), LM test against QGARCH
**            LM_LSTG : (2 x 1), LM test against LSTGARCH
**            LM_PCi  : (2 x m_PC), LM test for parameter constancy
**                        "i" indicates which parameters are allowed to be
**                        time-varying under the alternative:
**                        i=c: only constant
**                        i=a: only "ARCH" parameters (i.e., parameters
**                             corresponding with lagged squared residuals)
**                        i=ca: constant and ARCH parameters
**                        i=g: all parameters
**            LM_PCchu: scalar, LM test for parameter constancy
**            pv_.    : corresponding p-values
**            k_PCchu : scalar, location of break-point suggested by LM_PCchu
**
**  Globals : _vtol  : scalar, tolerance for determining whether conditional
**                     variance is zero
**
**  Remarks : The GARCH(p,q) model is specified as (in TeX notation)
**              h_{t}^{2} = \omega + \sum_{j=1}^{q} \alpha_{j} e_{t-j}^{2} +
**                             \sum_{j=1}^{p} \beta_{j} h_{t-j}^{2}
**              with e_{t}=z_{t}\sqrt{h_{t}}
**
**            The input parameter vector should have the format
**            theta=(\omega,\alpha_{1},...,\alpha_{q},\beta_{1},...,\beta_{p})'
**
**            Both chi-square and F-variants of the test statistics are computed
**
**  Written by Dick van Dijk
**
**  First attempt on  7 April 1999
**  Last revision on 12 April 1999
**
*/
declare _vtol ?= 1E-6;
proc (28)=EVALGRCH(e,theta,q,p,m_RA,m_HOA,m_HOG,m_PC,pi_chu,ortho,stdz);
   local T,omega,alpha,beta,ee,ee_m,ee_t,ee_a,h,h_t,z_t,x,eeh_1,xh,eeh,eeh_t,
         nm_RA,mm_RA,i,t1,nm_HOA,mm_HOA,nm_HOG,mm_HOG,en,en_t,een,een_t,eep,
         eep_t,eh_t,eeeh_t,t_v,LM_RA,pv_RA,LM_HOA,pv_HOA,LM_HOG,pv_HOG,LM_SB,
         pv_SB,LM_NSB,pv_NSB,LM_PSB,pv_PSB,LM_SSB,pv_SSB,LM_QG,pv_QG,LM_LSTG,
         pv_LSTG,LM_PCc,pv_PCc,LM_PCa,pv_PCa,LM_PCca,pv_PCca,LM_PCg,pv_PCg,phit,
         sdeeh_1,sdxh,isdxh,indxh,xht,iV_T,S_k,S_nk,LM_tchu1,LM_tchu2,LM_tchu,
         k_trim,k_PCchu,LM_PCchu;
   T=rows(e);

   /* Extract parameters in conditional variance */

   omega=theta[1];
   alpha=theta[1+1:1+q];
   if (p GT 0);
     beta=theta[1+q+1:1+q+p];
   endif;

   /* Compute conditional variance */

   ee=e.^2;
   ee_m=meanc(ee);
   ee_t=shiftr(ee',seqa(1,1,q),ee_m)';
   ee_a=ee_t*alpha;
   if (p GT 0);
      h=recserar(zeros(p,1)|(omega+ee_a),ee_m.*ones(p,1),beta);
      h=h[p+1:T+p];
   else;
      h=omega+ee_a;
   endif;
   h=substute(h,h.<_vtol,_vtol);

   /* Compute partial derivatives dhdtheta */

   t_v=seqa(1/T,1/T,T);
   if (p GT 0);
      ee_t=shiftr(ee',seqa(1,1,q),ee_m)';
      h_t=shiftr(h',seqa(1,1,p),ee_m)';
      z_t=(t_v.^(seqa(0,1,m_PC+1)'))*~(ones(T,1)~ee_t~h_t);
      x=recserar(zeros(p,(m_PC+1)*(1+q+p))|z_t,zeros(p,(m_PC+1)*(1+q+p)),
        beta.*ones(1,(m_PC+1)*(1+q+p)));
      x=x[p+1:T+p,.];
   else;
      ee_t=shiftr(ee',seqa(1,1,q),ee_m)';
      x=(t_v.^(seqa(0,1,m_PC+1)'))*~(ones(T,1)~ee_t);
   endif;
   xh=x./h;
   eeh_1=ee./h-1;
   xht=xh[.,1:1+q+p];
   if ortho;
      if stdz;
         sdeeh_1=stdc(eeh_1);
         if (sdeeh_1 GT 0);
            eeh_1=(eeh_1-meanc(eeh_1))./sdeeh_1;
         endif;
         sdxh=stdc(xht);
         isdxh=indexcat((sdxh .GT 0),1);
         if not scalmiss(isdxh);
            xht[.,isdxh]=(xht[.,isdxh]-meanc(xht[.,isdxh])')./sdxh[isdxh]';
         endif;
      endif;
      phit=invpd(xht'xht)*(xht'eeh_1);
      eeh_1=eeh_1-xht*phit;
   endif;

   /* LM test for parameter constancy (Lundbergh and Terasvirta, 1998) */

   LM_PCc=zeros(2,m_PC);
   pv_PCc=zeros(2,m_PC);
   LM_PCa=zeros(2,m_PC);
   pv_PCa=zeros(2,m_PC);
   LM_PCca=zeros(2,m_PC);
   pv_PCca=zeros(2,m_PC);
   LM_PCg=zeros(2,m_PC);
   pv_PCg=zeros(2,m_PC);
   i=0;
   do until (i==m_PC);
      i=i+1;
      indxh=seqa(1,1,1+q+p)|seqa(1+q+p+1,1+q+p,i);
      {t1,LM_PCc[.,i],pv_PCc[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh[.,indxh],i,stdz);
      indxh=seqa(1,1,1+q+p)|vecr(seqa(1+q+p+1,1+q+p,i)+seqa(1,1,q)');
      {t1,LM_PCa[.,i],pv_PCa[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh[.,indxh],i*q,stdz);
      indxh=seqa(1,1,1+q+p)|vecr(seqa(1+q+p,1+q+p,i)+seqa(1,1,q+1)');
      {t1,LM_PCca[.,i],pv_PCca[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh[.,indxh],i*(1+q),stdz);
      indxh=seqa(1,1,(i+1)*(1+q+p));
      {t1,LM_PCg[.,i],pv_PCg[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh[.,indxh],i*(1+q+p),stdz);
   endo;
   xh=xh[.,1:1+q+p];

   /* LM test for parameter constancy (Chu, 1995) */

   iV_T=invpd((eeh_1.*xh[.,1:1+q+p])'(eeh_1.*xh[.,1:1+q+p])./T);
   S_k=cumsumc(eeh_1.*xh[.,1:1+q+p]);
   S_nk=S_k[T,.]-S_k;
   LM_tchu1=(S_k*iV_T)*~S_k;
   LM_tchu2=(S_nk*iV_T)*~S_nk;
   LM_tchu=(sumc(LM_tchu1')./seqa(1,1,T)+sumc(LM_tchu2')./seqa(T-1,-1,T))./2;
   k_trim=floor(pi_chu.*T);
   k_PCchu=maxindc(LM_tchu[k_trim+1:T-k_trim])+k_trim;
   LM_PCchu=LM_tchu[k_PCchu];

   /* LM test against remaining ARCH in standardized residuals (Lundbergh and Terasvirta, 1998) */

   m_RA=sortc(m_RA,1);
   nm_RA=rows(m_RA);
   mm_RA=maxc(m_RA);
   eeh=ee./h;
   eeh_t=shiftr(eeh',seqa(1,1,mm_RA),1)';
   LM_RA=zeros(2,nm_RA);
   pv_RA=zeros(2,nm_RA);
   i=0;
   do until (i==nm_RA);
      i=i+1;
      {t1,LM_RA[.,i],pv_RA[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh~eeh_t[.,1:m_RA[i]],m_RA[i],stdz);
   endo;

   /* LM test against higher order ARCH (Bollerslev, 1986) */

   m_HOA=sortc(m_HOA,1);
   nm_HOA=rows(m_HOA);
   mm_HOA=maxc(m_HOA);
   if (p GT 0);
      ee_t=shiftr(ee',seqa(q+1,1,q+mm_HOA),ee_m)';
      ee_t=recserar(zeros(p,q+mm_HOA)|ee_t,zeros(p,q+mm_HOA),beta.*ones(1,q+mm_HOA));
      ee_t=ee_t[p+1:T+p,.]./h;
   else;
      ee_t=shiftr(ee',seqa(q+1,1,q+mm_HOA),ee_m)'./h;
   endif;
   LM_HOA=zeros(2,nm_HOA);
   pv_HOA=zeros(2,nm_HOA);
   i=0;
   do until (i==nm_HOA);
      i=i+1;
      {t1,LM_HOA[.,i],pv_HOA[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh~ee_t[.,1:m_HOA[i]],m_HOA[i],stdz);
   endo;

   /* LM test against higher order GARCH (Bollerslev, 1986) */

   m_HOG=sortc(m_HOG,1);
   nm_HOG=rows(m_HOG);
   mm_HOG=maxc(m_HOG);
   if (p GT 0);
      h_t=shiftr(h',seqa(p+1,1,p+mm_HOG),ee_m)';
      h_t=recserar(zeros(p,p+mm_HOG)|h_t,zeros(p,p+mm_HOG),beta.*ones(1,p+mm_HOG));
      h_t=h_t[p+1:T+p,.]./h;
   else;
      h_t=shiftr(h',seqa(p+1,1,p+mm_HOG),ee_m)'./h;
   endif;
   LM_HOG=zeros(2,nm_HOG);
   pv_HOG=zeros(2,nm_HOG);
   i=0;
   do until (i==nm_HOG);
      i=i+1;
      {t1,LM_HOG[.,i],pv_HOG[.,i]}=
         CMPLMTG(eeh_1,1+q+p,xh~h_t[.,1:m_HOG[i]],m_HOG[i],stdz);
   endo;

   /* Sign Bias, Negative Size Bias, Positive Size Bias tests and joint test
   ** for Sign and Size bias tests (Engle and Ng, 1993) */

   en=(e .LT 0);
   en_t=shiftr(en',seqa(1,1,q),0.5)';
   een=e.*en;
   een_t=shiftr(een',seqa(1,1,q),0)';
   eep=e.*(e .GT 0);
   eep_t=shiftr(eep',seqa(1,1,q),0)';
   {t1,LM_SB,pv_SB}=CMPLMTG(eeh_1,1+q+p,xh~en_t,q,stdz);
   {t1,LM_NSB,pv_NSB}=CMPLMTG(eeh_1,1+q+p,xh~een_t,q,stdz);
   {t1,LM_PSB,pv_PSB}=CMPLMTG(eeh_1,1+q+p,xh~eep_t,q,stdz);
   {t1,LM_SSB,pv_SSB}=CMPLMTG(eeh_1,1+q+p,xh~en_t~een_t~eep_t,3*q,stdz);

   /* LM test against QGARCH (Hagerud, 1997) */

   if (p GT 0);
      eh_t=shiftr(e',seqa(1,1,q),0)';
      eh_t=recserar(zeros(p,q)|eh_t,zeros(p,q),beta.*ones(1,q));
      eh_t=eh_t[p+1:T+p,.]./h;
   else;
      eh_t=shiftr(e',seqa(1,1,q),0)'./h;
   endif;
   {t1,LM_QG,pv_QG}=CMPLMTG(eeh_1,1+q+p,xh~eh_t,q,stdz);

   /* LM test against LSTGARCH (Hagerud, 1997) */

   if (p GT 0);
      eeeh_t=shiftr((e.^3)',seqa(1,1,q),0)';
      eeeh_t=recserar(zeros(p,q)|eeeh_t,zeros(p,q),beta.*ones(1,q));
      eeeh_t=eeeh_t[p+1:T+p,.]./h;
   else;
      eeeh_t=shiftr((e.^3)',seqa(1,1,q),0)'./h;
   endif;
   {t1,LM_LSTG,pv_LSTG}=CMPLMTG(eeh_1,1+q+p,xh~eeeh_t,q,stdz);

   retp(LM_RA,pv_RA,LM_HOA,pv_HOA,LM_HOG,pv_HOG,LM_SB,pv_SB,LM_NSB,pv_NSB,
        LM_PSB,pv_PSB,LM_SSB,pv_SSB,LM_QG,pv_QG,LM_LSTG,pv_LSTG,LM_PCc,pv_PCc,
        LM_PCa,pv_PCa,LM_PCca,pv_PCca,LM_PCg,pv_PCg,LM_PCchu,k_PCchu);
endp;

proc(3)=CMPLMTG(e_0,k_0,xv_m,k_r,stdz);
   local T,sde_0,sdxv_m,isdxv_m,LM_st,LM_pv,SSR_0,invxv_m,phi_1,e_1,SSR_1;
   T=rows(e_0);
   if stdz;
      sde_0=stdc(e_0);
      if (sde_0 GT 0);
         e_0=(e_0-meanc(e_0))./sde_0;
      endif;
      sdxv_m=stdc(xv_m);
      isdxv_m= indexcat((sdxv_m .GT 0),1);
      if not scalmiss(isdxv_m);
         xv_m[.,isdxv_m]=(xv_m[.,isdxv_m]-meanc(xv_m[.,isdxv_m])')./sdxv_m[isdxv_m]';
      endif;
   endif;
   e_1=1;
   LM_st=zeros(2,1);
   LM_pv=2.*ones(2,1);
   SSR_0=e_0'e_0;
   invxv_m=invpd(moment(xv_m,0));
   if not scalmiss(invxv_m);
      phi_1=invxv_m*(xv_m'e_0);
      e_1=e_0 - xv_m*phi_1;
      SSR_1=e_1'e_1;
      LM_st[1]=T*(SSR_0 - SSR_1)/SSR_0;
      LM_pv[1]=CDFCHIC(LM_st[1],k_r);
      LM_st[2]=((SSR_0 - SSR_1)/k_r)/(SSR_1/(T-k_r-k_0));
      LM_pv[2]=CDFFC(LM_st[2],k_r,T-k_r-k_0);
   endif;
   retp(e_1,LM_st,LM_pv);
endp;
