/*

If you have questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde

*/

new;
output file=c:\research\garchbreak\Oos_no_spa_n01.out reset;
breps=2000;
"SPA statistics (p-values)";?;

"s=1";?;

q=1/1; @ smoothing parameter for stationary bootstrap @
load loss_both=c:\research\garchbreak\Data_loss_no_s1_n01.fmt;
loss_ase=loss_both[1:500,.];
loss_var=loss_both[501:1000,.];
loss_ex=loss_ase[.,1];
loss_rm=loss_ase[.,2];
loss_fi=loss_ase[.,3];
loss_50=loss_ase[.,4];
loss_25=loss_ase[.,5];
loss_wm=loss_ase[.,6];
loss_br=loss_ase[.,7];
loss_ma=loss_ase[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MSE";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MSE";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
loss_ex=loss_var[.,1];
loss_rm=loss_var[.,2];
loss_fi=loss_var[.,3];
loss_50=loss_var[.,4];
loss_25=loss_var[.,5];
loss_wm=loss_var[.,6];
loss_br=loss_var[.,7];
loss_ma=loss_var[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MVaR";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MVaR";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;

"s=20";?;

q=1/20; @ smoothing parameter for stationary bootstrap @
load loss_both=c:\research\garchbreak\Data_loss_no_s20_n01.fmt;
loss_ase=loss_both[1:481,.];
loss_var=loss_both[482:962,.];
loss_ex=loss_ase[.,1];
loss_rm=loss_ase[.,2];
loss_fi=loss_ase[.,3];
loss_50=loss_ase[.,4];
loss_25=loss_ase[.,5];
loss_wm=loss_ase[.,6];
loss_br=loss_ase[.,7];
loss_ma=loss_ase[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MSE";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MSE";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
loss_ex=loss_var[.,1];
loss_rm=loss_var[.,2];
loss_fi=loss_var[.,3];
loss_50=loss_var[.,4];
loss_25=loss_var[.,5];
loss_wm=loss_var[.,6];
loss_br=loss_var[.,7];
loss_ma=loss_var[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MVaR";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MVaR";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;

"s=60";?;

q=1/60; @ smoothing parameter for stationary bootstrap @
load loss_both=c:\research\garchbreak\Data_loss_no_s60_n01.fmt;
loss_ase=loss_both[1:441,.];
loss_var=loss_both[442:882,.];
loss_ex=loss_ase[.,1];
loss_rm=loss_ase[.,2];
loss_fi=loss_ase[.,3];
loss_50=loss_ase[.,4];
loss_25=loss_ase[.,5];
loss_wm=loss_ase[.,6];
loss_br=loss_ase[.,7];
loss_ma=loss_ase[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MSE";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MSE";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
loss_ex=loss_var[.,1];
loss_rm=loss_var[.,2];
loss_fi=loss_var[.,3];
loss_50=loss_var[.,4];
loss_25=loss_var[.,5];
loss_wm=loss_var[.,6];
loss_br=loss_var[.,7];
loss_ma=loss_var[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MVaR";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MVaR";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;

"s=120";?;

q=1/120; @ smoothing parameter for stationary bootstrap @
load loss_both=c:\research\garchbreak\Data_loss_no_s120_n01.fmt;
loss_ase=loss_both[1:381,.];
loss_var=loss_both[382:762,.];
loss_ex=loss_ase[.,1];
loss_rm=loss_ase[.,2];
loss_fi=loss_ase[.,3];
loss_50=loss_ase[.,4];
loss_25=loss_ase[.,5];
loss_wm=loss_ase[.,6];
loss_br=loss_ase[.,7];
loss_ma=loss_ase[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MSE";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MSE";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
loss_ex=loss_var[.,1];
loss_rm=loss_var[.,2];
loss_fi=loss_var[.,3];
loss_50=loss_var[.,4];
loss_25=loss_var[.,5];
loss_wm=loss_var[.,6];
loss_br=loss_var[.,7];
loss_ma=loss_var[.,8];
bench_ex=(loss_ex-loss_50)~(loss_ex-loss_25)~(loss_ex-loss_wm)~(loss_ex-loss_br)~(loss_ex-loss_ma);
bench_rm=(loss_rm-loss_50)~(loss_rm-loss_25)~(loss_rm-loss_wm)~(loss_rm-loss_br)~(loss_rm-loss_ma);
bench_fi=(loss_fi-loss_50)~(loss_fi-loss_25)~(loss_fi-loss_wm)~(loss_fi-loss_br)~(loss_fi-loss_ma);
"White (2000) reality check, MVaR";?;
{rc_ex,pval_ex}=whitestat(bench_ex,breps,q);
{rc_rm,pval_rm}=whitestat(bench_rm,breps,q);
{rc_fi,pval_fi}=whitestat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;
"Hansen (2005) SPA, MVaR";?;
{rc_ex,pval_ex}=tspastat(bench_ex,breps,q);
{rc_rm,pval_rm}=tspastat(bench_rm,breps,q);
{rc_fi,pval_fi}=tspastat(bench_fi,breps,q);
"Expanding GARCH   = " rc_ex~pval_ex;?;
"RiskMetrics       = " rc_rm~pval_rm;?;
"Expanding FIGARCH = " rc_fi~pval_fi;?;

/* Procedure definition area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/***************************************************************************
proc: WHITESTAT

The procedure calculates the White (2000) reality check statistic
for superior predictive ability using the Politis and Romano
stationary (1994) bootstrap with blocks of random lengths as
described White (2000, p. 1104).

Format: {rc,pval}=whitestat(d,b,q)

Input

d  = matrix of loss differentials relative to benchmark
b  = number of bootstrap replications
q  = smoothing parameter

Output

rc   = White (2000) reality check statistic
pval = bootstrapped p-value

References

D. Politis and J. Romano (1994), "The Stationary Bootstrap,"
Journal of the American Statistical Association 89, 1303-1313

H. White (2000), "A Reality Check for Data Snooping," Econometrica
68, 1097-1126
***************************************************************************/
proc(2)=whitestat(d,b,q);
   local n,k,rc,rcstar,iterb,theta,iter,u,zstar,pval;
   n=rows(d); @ number of obsverations @
   k=cols(d); @ number of competing models @
   rc=maxc(sqrt(n)*meanc(d));
   rcstar=zeros(b,1);
   iterb=1;
   do until iterb>b;
      theta=zeros(n,1);
      theta[1]=ceil(n*rndu(1,1));
      iter=2;
      do until iter>n;
         u=rndu(1,1);
         if u<q;
            theta[iter]=ceil(n*rndu(1,1));
         else;
            theta[iter]=theta[iter-1]+1;
            if theta[iter]>n;
               theta[iter]=1;
            endif;
         endif;
         iter=iter+1;
      endo;
      zstar=d[theta,.]-meanc(d)';
      rcstar[iterb]=maxc(sqrt(n)*meanc(zstar));
      iterb=iterb+1;
   endo;
   pval=sumc(rcstar.>=rc)/b;
   retp(rc,pval);
endp;

/***************************************************************************
proc: TSPASTAT

The procedure calculates the Hansen (2005) studentized statistic for
superior predictive ability.

Format: {tspa,pval}=tspastat(d,b,q)

Input

d  = matrix of loss differentials relative to benchmark
b  = number of bootstrap replications
q  = smoothing parameter

Output

tspa = Hansen statistic
pval = consistent p-value for Hansen statistic

Reference

P.R. Hansen (2005), "A Test for Superior Predictive Ability,"
Journal of Business and Economic Statistics 23, 365-380
***************************************************************************/
proc(2)=tspastat(d,b,q);
   local n,k,dbar,ddev,omega2k,iteri,dj,djlags,gamanew,omega2kk,
   omegak,tspa,g,iterk,tspastar,iterb,theta,iter,u,zstar,zstarbar,
   pval;
   n=rows(d); @ number of obsverations @
   k=cols(d); @ number of competing models @
   dbar=meanc(d);
   ddev=d-dbar';
   omega2k=(1/n)*sumc(ddev^2);
   iteri=1;
   do until iteri>n-1;
      {dj,djlags}=varlags(ddev,iteri);
      gamanew=(1/n)*dj'djlags[.,(iteri-1)*k+1:iteri*k];
      omega2kk=2*(((n-iteri)/n)*(1-q)^iteri+(iteri/n)*(1-q)^(n-iteri))*gamanew;
      omega2k=omega2k+diag(omega2kk);
      iteri=iteri+1;
   endo;
   omegak=sqrt(omega2k);
   tspa=maxc(sqrt(n)*dbar./omegak);
   g=zeros(k,1);
   iterk=1;
   do until iterk>k;
      if dbar[iterk]>=-sqrt((omega2k[iterk]/n)*2*ln(ln(n)));
         g[iterk]=dbar[iterk];
      endif;
      iterk=iterk+1;
   endo;
   tspastar=zeros(b,1);
   iterb=1;
   do until iterb>b;
      theta=zeros(n,1);
      theta[1]=ceil(n*rndu(1,1));
      iter=2;
      do until iter>n;
         u=rndu(1,1);
         if u<q;
            theta[iter]=ceil(n*rndu(1,1));
         else;
            theta[iter]=theta[iter-1]+1;
            if theta[iter]>n;
               theta[iter]=1;
            endif;
         endif;
         iter=iter+1;
      endo;
      zstar=d[theta,.]-g';
      zstarbar=meanc(zstar);
      tspastar[iterb]=maxc(sqrt(n)*zstarbar./omegak);
      if tspastar[iterb]<0;
         tspastar[iterb]=0;
      endif;
      iterb=iterb+1;
   endo;
   pval=sumc(tspastar.>=tspa)/b;
   retp(tspa,pval);
endp;
