/*

If you have questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde

*/

new;
format 8,6;
output file=c:\research\garchbreak\Oos_ja_pe_other.out reset;
load data[6644,1]=c:\research\garchbreak\Data_ja_d.txt;
rex=ln(data[2:6644]./data[1:6643])*100; @ Japan continuous returns @
inidate=1980; @ initial date for data @
library cml;
p=500; @ number of out-of-sample observations @
r=rows(rex)-p; @ in-sample period @
first_ms=zeros(p,1); @ for storing first ob used to estimate expanding MS-GARCH forecast @
first_gj=zeros(p,1); @ for storing first ob used to estimate expanding GJR-GARCH forecast @
pars_ms=zeros(p,8); @ for storing expanding MS-GARCH parameter estimates @
pars_gj=zeros(p,4); @ for storing expanding GJR-GARCH parameter estimates @
hhat_gj=zeros(p,1); @ for storing most recent h estimate for expanding GJR-GARCH @
ret_ms=zeros(p,1); @ for storing expanding MS-GARCH return codes @
ret_gj=zeros(p,1); @ for storing expanding GJR-GARCH return codes @
iter=0;
do until iter>p-1;

   /* Estimating parameters for MS-GARCH forecasting model */

   {b_garchm,xx,xx,xx,retcode,xx}=msgarch11(rex[1:r+iter],(0.0036|0.029|0.939|0.0299|0.110|0.943|0.861|0.298));
   ret_ms[iter+1]=retcode;
   first_ms[iter+1]=1;
   pars_ms[iter+1,.]=b_garchm';

   /* Estimating parameters for GJR-GARCH forecasting model */

   {b_garchg,xx,xx,xx,retcode,hhat_oosg}=gjr_garch11(rex[1:r+iter],(.001|.06|.04|.90));
   ret_gj[iter+1]=retcode;
   first_gj[iter+1]=1;
   pars_gj[iter+1,.]=b_garchg';
   hhat_gj[iter+1,.]=hhat_oosg[rows(hhat_oosg)];

   iter=iter+1;
endo;

/* Starting window dates and parameter estimates */

datevec=seqa(inidate,1/255,rows(rex)); @ approx sequence of dates for daily data @
Data_pe_ja_ms=datevec[r+1:rows(rex)]~datevec[first_ms]~pars_ms;
Data_pe_ja_gj=datevec[r+1:rows(rex)]~datevec[first_gj]~pars_gj~hhat_gj;
save path=c:\research\garchbreak Data_pe_ja_ms;
save path=c:\research\garchbreak Data_pe_ja_gj;
"Forecast date, expanding MS-GARCH (window start, parameter estimates)";
Data_pe_ja_ms;?;
"Forecast date, expanding GJR-GARCH (window start, parameter estimates, h-hat)";
Data_pe_ja_gj;?;

/* Procedure definition area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/****************************************************************
PROC: MSGARCH11

The procedure estimates a two-state Markov-switching
GARCH(1,1) model using the specification in Hass et al
(2004) assuming a conditional mean of zero. The procedure
calls the procedures MSGARCH11_LOGLIKE (provided below)
and the GAUSS models CML.

Format: {b,f,g,vcv,ret,rhom}=msgarch11(depvar,startvalues)

Input:

depvar      = vector of observations
startvalues = starting values

Output:

b    = estimate of (omega1,alpha1,beta1,omega2,alpha2,
       beta2,p11,p22)'
f    = value of likelihood function
g    = gradient
vcv  = variance-covariance matrix
ret  = return code
rhom = rho(M)

Reference

M. Hass et al. (2004), "A New Approach to Markov-Switching
GARCH Models," Journal of Financial Econometrics, 4, pp.
493-530
****************************************************************/
proc(6)=msgarch11(depvar,startvalues);
   local b,f,g,vcv,ret,p12,p21,bigM,va,rhom;
      _cml_DirTol=0.001;
   _cml_Bounds={0.00000000001 100,
               0             1,
               0             2,
               0.00000000001 100,
               0             1,
               0             2,
               0             1,
               0             1};
   __output=0;
   _cml_DirTol=0.001; 
   {b,f,g,vcv,ret}=cml(depvar,0,&msgarch11_loglike,startvalues);
   if b[2]==0;
      b[3]=0;
   endif;
   if b[5]==0;
      b[6]=0;
   endif;
   p12=1-b[7];
   p21=1-b[8];
   bigM=(b[7]*(b[2]+b[3])~0~p21*(b[2]+b[3])~0)|
        (b[7]*b[5]~b[7]*b[6]~p21*b[5]~p21*b[6])|
        (p12*b[3]~p12*b[2]~b[8]*b[3]~b[8]*b[2])|
        (0~p12*(b[5]+b[6])~0~b[8]*(b[5]+b[6]));
   va=eig(bigM);
   rhom=maxc(va);
   retp(b,f,g,vcv,ret,rhom);
endp;

/****************************************************************
PROC: MSGARCH11_LOGLIKE

The procedure computes the log-likelihood function for a
two-state Markov-switching GARCH(1,1) model using the
specification in Hass et al (2004) assuming a conditional
mean of zero. The likelihood function is formed using the
recursive procedure in Hamilton (1994, pp. 690-696)

Format: f=msgarch11_loglike(x,e)

Input:

x = parameter values
e = data vector

Output:

f = log-likelihood value

References

J. Hamilton (1994), Time Series Analysis (Princeton, NJ:
Princeton University Press)

M. Hass et al. (2004), "A New Approach to Markov-Switching
GARCH Models," Journal of Financial Econometrics, 4, pp.
493-530
****************************************************************/
proc(1)=msgarch11_loglike(x,e);
   local bigt,e2,omega1,alpha1,beta1,omega2,alpha2,beta2,p11,p22,
   bigp,mean_e2,alpha1part,h1,alpha2part,h2,h,eta1,eta2,eta,xit1t,
   xitt,f,iter;
   bigt=rows(e);
   e2=e^2;
   omega1=x[1];
   alpha1=x[2];
   beta1=x[3];
   omega2=x[4];
   alpha2=x[5];
   beta2=x[6];
   p11=x[7];
   p22=x[8];
   bigp=(p11~(1-p22))|((1-p11)~p22);
   mean_e2=meanc(e2);
   alpha1part=omega1+alpha1*missrv(lagn(e2,1),mean_e2);
   h1=recserar(0|alpha1part,mean_e2,beta1);
   h1=h1[2:bigt+1];
   alpha2part=omega2+alpha2*missrv(lagn(e2,1),mean_e2);
   h2=recserar(0|alpha2part,mean_e2,beta2);
   h2=h2[2:bigt+1];
   h=h1~h2;
   eta1=(1/sqrt(2*pi))*(sqrt(h1)^(-1)).*exp(-e2./(2*h1));
   eta2=(1/sqrt(2*pi))*(sqrt(h2)^(-1)).*exp(-e2./(2*h2));
   eta=eta1~eta2;
   xit1t=zeros(bigt,2);
   xitt=zeros(bigt,2);
   f=zeros(bigt,1);
   xit1t[1,.]=0.5~0.5;
   f[1]=xit1t[1,.]*eta[1,.]';
   xitt[1,.]=(xit1t[1,.].*eta[1,.])/(xit1t[1,.]*eta[1,.]');
   iter=2;
   do until iter>bigt;
      xit1t[iter,.]=xitt[iter-1,.]*bigp';
      f[iter]=xit1t[iter,.]*eta[iter,.]';
      xitt[iter,.]=(xit1t[iter,.].*eta[iter,.])/(xit1t[iter,.]*eta[iter,.]');
      iter=iter+1;
   endo;
   retp(sumc(ln(f)));
endp;

/*****************************************************************
PROC: GJR_GARCH11

This procedure estimates the GJR-GARCH(1,1) model,

h(t) = omega + alpha*e^2(t-1)*(1-I) + gamma*e^2(t-1)*I + beta*h(t-1),

where I=1 when e(t-1)>0 and 0 otherwise. It calls the procedures
GJR_GARCH11_LOGLIKE and GJR_GARCH11_HHAT (provided below) and uses
the GAUSS application CML.

Format: {b,f,g,vcv,ret,hhat}=GJR_GARCH11(depvar,startvalues)

Input:

depvar      = T-vector, dependent variable
startvalues = vector of inital values

Output:

b    = 4-vector of parameter estimates (omega,alpha,gamma,beta)
f    = scalar, log-likelihood function at minimum
g    = 4-vector, gradient at minimum
vcv  = variance-covariance matrix for parameters
ret  = scalar, CML return code
hhat = T-vector of conditional variance estimates at
       each point in time
*****************************************************************/
proc(6)=gjr_garch11(depvar,startvalues);
   local b,f,g,vcv,ret,hhat;
   cmlset;
   _cml_Bounds={0.0000001 10,
                0.0000001 10,
                0.0000001 10,
                0.0000001 10};
   /*_cml_C=0~-0.5~-0.5~-1;_cml_D=-0.999;*/
   __output=0;
   _cml_DirTol=0.001;
   {b,f,g,vcv,ret}=cml(depvar,0,&gjr_garch11_loglike,startvalues);
   hhat=gjr_garch11_hhat(b,depvar);
   retp(b,f,g,vcv,ret,hhat);
endp;

/*****************************************************************
proc: GJR_GARCH11_LOGLIKE
*****************************************************************/
proc gjr_garch11_loglike(x,e);
   local bigt,mean_e2,elag,e2lag,dv,alphapart,h;
   bigt=rows(e);
   mean_e2=meanc(e^2);
   elag=missrv(lagn(e,1),0);
   e2lag=missrv(lagn(e^2,1),mean_e2);
   dv=elag.<0;
   alphapart=x[1]+x[2]*e2lag.*dv+x[3]*e2lag.*(1-dv);
   h=recserar(0|alphapart,mean_e2,x[4]);
   h=h[2:bigt+1];
   retp(-(bigt/2)*ln(2*pi)-(1/2)*sumc(ln(h)+(e^2)./h));
endp;

/*****************************************************************
proc: GJR_GARCH11_HHAT
*****************************************************************/
proc gjr_garch11_hhat(x,e);
   local bigt,mean_e2,elag,e2lag,dv,alphapart,h;
   bigt=rows(e);
   mean_e2=meanc(e^2);
   elag=missrv(lagn(e,1),0);
   e2lag=missrv(lagn(e^2,1),mean_e2);
   dv=elag.>0;
   alphapart=x[1]+x[2]*e2lag.*(1-dv)+x[3]*e2lag.*dv;
   h=recserar(0|alphapart,mean_e2,x[4]);
   h=h[2:bigt+1];
   retp(h);
endp;
