/*

If you have questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde

*/

new;
tstart=hsec;
format 8,6;
output file=c:\research\garchbreak\Oos_ca_pe_earlier.out reset;
load data[6654,1]=c:\research\garchbreak\Data_ca_d.txt;
rex=ln(data[2:6654]./data[1:6653])*100; @ Canada continuous returns @
inidate=1980; @ initial date for data @
library cml;
#include c:\gauss6.0\src\icss.src;
#include c:\gauss6.0\src\variance.src;
p=500; @ number of out-of-sample observations @
r=rows(rex)-2*p; @ earlier in-sample period @
cri=0|1|4; @ needed for break test proc @
first_ex=zeros(p,1); @ for storing first ob used to estimate expanding GARCH forecast @
first_fi=zeros(p,1); @ for storing first ob used to estimate expanding FIGARCH forecast @
first_50=zeros(p,1); @ for storing first ob used to estimate 0.50 rolling GARCH forecast @
first_25=zeros(p,1); @ for storing first ob used to estimate 0.25 rolling GARCH forecast @
first_wm=zeros(p,1); @ for storing first ob used to estimate weighted ML GARCH forecast @
first_br=zeros(p,1); @ for storing first ob used to estimate GARCH w/breaks forecast @
pars_ex=zeros(p,3); @ for storing expanding GARCH parameter estimates @
pars_fi=zeros(p,4); @ for storing expanding FIGARCH parameter estimates @
pars_50=zeros(p,3); @ for storing 0.50 rolling GARCH parameter estimates @
pars_25=zeros(p,3); @ for storing 0.25 rolling GARCH parameter estimates @
pars_wm=zeros(p,3); @ for storing weigthed ML GARCH parameter estimates @
pars_br=zeros(p,3); @ for storing GARCH w/breaks parameter estimates @
hhat_ex=zeros(p,1); @ for storing most recent h estimate for expanding GARCH @
hhat_fi=zeros(p,1); @ for storing most recent h estimate for expanding FIGARCH @
hhat_50=zeros(p,1); @ for storing most recent h estimate for 0.50 rolling GARCH @
hhat_25=zeros(p,1); @ for storing most recent h estimate for 0.25 rolling GARCH @
hhat_wm=zeros(p,1); @ for storing most recent h estimate for weighted ML GARCH @
hhat_br=zeros(p,1); @ for storing most recent h estimate for GARCH w/breaks @
ret_ex=zeros(p,1); @ for storing expanding GARCH return codes @
ret_fi=zeros(p,1); @ for storing expanding FIGARCH return codes @
ret_50=zeros(p,1); @ for storing 0.50 rolling GARCH return codes @
ret_25=zeros(p,1); @ for storing 0.25 rolling GARCH return codes @
ret_wm=zeros(p,1); @ for storing weighted ML GARCH return codes @
ret_br=zeros(p,1); @ for storing GARCH w/breaks return codes @
nbr_br=zeros(p,1); @ for storing number of breaks @

/* Estimating parameters for forecasting models */

iter=0;
do until iter>p-1;

   /* Expanding GARCH */

   {b_garche,xx,xx,xx,retcode,hhat_oose}=garch11(rex[1:r+iter],(.01|.1|.8));
   ret_ex[iter+1]=retcode;
   first_ex[iter+1]=1;
   pars_ex[iter+1,.]=b_garche';
   hhat_ex[iter+1,.]=hhat_oose[rows(hhat_oose)];

   /* Expanding FIGARCH */

   {b_garchf,xx,xx,xx,retcode,hhat_oosf}=figarch11(rex[1:r+iter],(0.02|0.094|0.675|0.652));
   ret_fi[iter+1]=retcode;
   first_fi[iter+1]=1;
   pars_fi[iter+1,.]=b_garchf';
   hhat_fi[iter+1,.]=hhat_oosf[rows(hhat_oosf)];

   /* 0.50 rolling GARCH */
   
   rollstart=round(0.50*r)+1; @ starting obs for 0.50 rolling window @
   {b_garchr,xx,xx,xx,retcode,hhat_oosr}=garch11(rex[rollstart+iter:r+iter],(.01|.1|.8));
   ret_50[iter+1]=retcode;
   first_50[iter+1]=rollstart+iter;
   pars_50[iter+1,.]=b_garchr';
   hhat_50[iter+1,.]=hhat_oosr[rows(hhat_oosr)];

   /* 0.25 rolling GARCH */
   
   rollstart=round(0.75*r)+1; @ starting obs for 0.25 rolling window @
   {b_garchr,xx,xx,xx,retcode,hhat_oosr}=garch11(rex[rollstart+iter:r+iter],(.01|.1|.8));
   ret_25[iter+1]=retcode;
   first_25[iter+1]=rollstart+iter;
   pars_25[iter+1,.]=b_garchr';
   hhat_25[iter+1,.]=hhat_oosr[rows(hhat_oosr)];

   /* Weighted ML GARCH */

   rhoval=0.994;
   {b_garchw,xx,xx,xx,retcode,hhat_oosw}=wml_garch11(rex[1:r+iter],(.01|.05|.9),rhoval);
   ret_wm[iter+1]=retcode;
   first_wm[iter+1]=1;
   if b_garchw[2]<0.00000000001;
      {b_garchw,xx,xx,xx,retcode}=cwml_constant(rex[1:r+iter],.01,rhoval);
      pars_wm[iter+1,.]=b_garchw~0~0;
      hhat_wm[iter+1,.]=b_garchw;
   else;
      pars_wm[iter+1,.]=b_garchw';
      hhat_wm[iter+1,.]=hhat_oosw[rows(hhat_oosw)];
   endif;

   /* GARCH with breaks */

   {cpr_oos,nbr_oos}=icss(rex[1:r+iter],2,cri);
   if nbr_oos==0;
      nbr_br[iter+1]=nbr_oos;
      pars_br[iter+1,.]=pars_ex[iter+1,.];
      ret_br[iter+1]=ret_ex[iter+1];
      first_br[iter+1]=1;
      hhat_br[iter+1,.]=hhat_ex[iter+1];
   else;
      nbr_br[iter+1]=nbr_oos;
      firstob=1+cpr_oos[rows(cpr_oos)-1];
      first_br[iter+1]=firstob;
      {b_garchb,xx,xx,xx,retcode,hhat_oosb}=garch11(rex[firstob:r+iter],(.01|.1|.8));
      ret_br[iter+1]=retcode;
      if b_garchb[2]<0.00000000001;
         pars_br[iter+1,.]=meanc(rex[firstob:r+iter]^2)~0~0;
         hhat_br[iter+1,.]=meanc(rex[firstob:r+iter]^2);
      else;
         pars_br[iter+1,.]=b_garchb';
         hhat_br[iter+1,.]=hhat_oosb[rows(hhat_oosb)];
      endif;
   endif;

   iter=iter+1;
endo;

/* Starting window dates and parameter estimates */

datevec=seqa(inidate,1/255,rows(rex)); @ approx sequence of dates for daily data @
Data_pe_ca_ex_earlier=datevec[r+1:rows(rex)-p]~first_ex~pars_ex~hhat_ex;
Data_pe_ca_fi_earlier=datevec[r+1:rows(rex)-p]~first_fi~pars_fi~hhat_fi;
Data_pe_ca_50_earlier=datevec[r+1:rows(rex)-p]~first_50~pars_50~hhat_50;
Data_pe_ca_25_earlier=datevec[r+1:rows(rex)-p]~first_25~pars_25~hhat_25;
Data_pe_ca_wm_earlier=datevec[r+1:rows(rex)-p]~first_wm~pars_wm~hhat_wm;
Data_pe_ca_br_earlier=datevec[r+1:rows(rex)-p]~first_br~pars_br~hhat_br;
save path=c:\research\garchbreak Data_pe_ca_ex_earlier;
save path=c:\research\garchbreak Data_pe_ca_fi_earlier;
save path=c:\research\garchbreak Data_pe_ca_50_earlier;
save path=c:\research\garchbreak Data_pe_ca_25_earlier;
save path=c:\research\garchbreak Data_pe_ca_wm_earlier;
save path=c:\research\garchbreak Data_pe_ca_br_earlier;
"Forecast date, expanding GARCH (window start, parameter estimates, h-hat)";
Data_pe_ca_ex_earlier;?;
"Forecast date, expanding FIGARCH (window start, parameter estimates, h-hat)";
Data_pe_ca_fi_earlier;?;
"Forecast date, 0.50 rolling GARCH (window start, parameter estimates, h-hat)";
Data_pe_ca_50_earlier;?;
"Forecast date, 0.25 rolling GARCH (window start, parameter estimates, h-hat)";
Data_pe_ca_25_earlier;?;
"Forecast date, weighted ML GARCH (window start, parameter estimates, h-hat)";
Data_pe_ca_wm_earlier;?;
"Forecast date, GARCH with breaks (window start, parameter estimates, h-hat)";
Data_pe_ca_br_earlier;?;
tend=hsec-tstart;
sec_tend=tend/100;
min_tend=sec_tend/60;
hr_tend=min_tend/60;
"Time to run program = " tend;
"Seconds             = " sec_tend;
"Minutes             = " min_tend;
"Hours               = " hr_tend;?;

/* Procedure definition area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/*****************************************************************
PROC: GARCH11

This procedure estimates the GARCH(1,1) model,

h(t) = omega + alpha*e^2(t-1) + beta*h(t-1).

It calls the procedures GARCH11_LOGLIKE and GARCH11_HHAT
(provided below) and uses the GAUSS application CML.

Format: {b,f,g,vcv,ret,hhat}=GARCH11(depvar,startvalues)

Input:

depvar      = T-vector, dependent variable
startvalues = vector of inital values

Output:

b    = 3-vector of parameter estimates (omega,alpha,beta)
f    = scalar, log-likelihood function at minimum
g    = 3-vector, gradient at minimum
vcv  = variance-covariance matrix for parameters
ret  = scalar, CML return code
hhat = T-vector of conditional variance estimates at
       each point in time
*****************************************************************/
proc(6)=garch11(depvar,startvalues);
   local b,f,g,vcv,ret,hhat;
   cmlset;
   _cml_Bounds={0.0000001 10,
                0         10,
                0         10};
   __output=0;
   {b,f,g,vcv,ret}=cml(depvar,0,&garch11_loglike,startvalues);
   hhat=garch11_hhat(b,depvar);
   retp(b,f,g,vcv,ret,hhat);
endp;

/*****************************************************************
proc: GARCH11_LOGLIKE
*****************************************************************/
proc garch11_loglike(x,e);
   local bigt,mean_e2,alphapart,h;
   bigt=rows(e);
   mean_e2=meanc(e^2);
   alphapart=x[1]+x[2]*missrv(lagn(e^2,1),mean_e2);
   h=recserar(0|alphapart,mean_e2,x[3]);
   h=h[2:bigt+1];
   retp(-(bigt/2)*ln(2*pi)-(1/2)*sumc(ln(h)+(e^2)./h));
endp;

/*****************************************************************
proc: GARCH11_HHAT
*****************************************************************/
proc garch11_hhat(x,e);
   local bigt,mean_e2,alphapart,h;
   bigt=rows(e);
   mean_e2=meanc(e^2);
   alphapart=x[1]+x[2]*missrv(lagn(e^2,1),mean_e2);
   h=recserar(0|alphapart,mean_e2,x[3]);
   h=h[2:bigt+1];
   retp(h);
endp;

/*****************************************************************
PROC: FIGARCH11

This procedure estimates the FIGARCH(1,d,1) model of Baillie et
al. (1996),

h(t) = omega + beta*h(t-1) + [1-beta*L-(1-phi*L)(1-L)^d]e^2(t).

It calls the procedures FIGARCH11_LOGLIKE and FIGARCH11_HHAT
(provided below) and uses the GAUSS application CML.

Format: {b,f,g,vcv,ret,hhat}=FIGARCH11(depvar,startvalues)

Input:

depvar      = T-vector, dependent variable
startvalues = vector of inital values

Output:

b    = 4-vector of parameter estimates (omega, alpha, beta, d)
f    = scalar, log-likelihood function at minimum
g    = 4-vector, gradient at minimum
vcv  = variance-covariance matrix for parameters
ret  = scalar, CML return code
hhat = T-vector of conditional variance estimates at
       each point in time

Reference:

R.T. Baillie, T. Bollerslev, and H.O. Mikkelsen (1996),
"Fractionally Integrated Generalized Autoregressive Conditional
Heteroskedasticity," Journal of Econometrics 74, 3-30
*****************************************************************/
proc(6)=figarch11(depvar,startvalues);
   local b,f,g,vcv,ret,hhat;
   cmlset;
   _cml_DirTol=0.001;
   _cml_Bounds={0.0000001 10,
                0         10,
                0         10,
                0          1}; @ omega>0, phi,beta non-neg, 0<d<1 @
   _cml_C=(0~-2~0~-1)|(0~1~-1~1); @ non-negativity constraint @
   _cml_D=-1|0;
   __output=0;
   {b,f,g,vcv,ret}=cml(depvar,0,&figarch11_loglike,startvalues);
   hhat=figarch11_hhat(b,depvar);
   retp(b,f,g,vcv,ret,hhat);
endp;

/*****************************************************************
PROC: FIGARCH11_LOGLIKE
*****************************************************************/
proc figarch11_loglike(x,e);
   local bigt,tl,e2,h0,e3,vd,vp,vp1,kn,vp2,vw,vw1,h1,h,z;
   bigt=rows(e);
   tl=1000;
   e2=e^2;
   h0=(e'e)/bigt;
   e3=h0|e2[1:bigt-1];
   vd=x[4];
   vp=1|cumprodc(seqa(-vd,1,tl-1)./seqa(1,1,tl-1));
   vp1=conv(1|-x[2],vp,1,tl);
   kn=ones(tl,1);
   vp2=conv(vp1,kn,tl+1,2*tl-1);
   vp2=vp2|zeros(bigt-tl+1,1);
   vw=conv(vp1,e2,1,bigt);
   vw1=vw+vp2*h0;
   h1=x[1]+e2[1]-vw1[1];
   h=recserar(0|x[1]+e2-x[3]*e3-vw1,h1,x[3]);
   h=h[2:bigt+1];
   z=ln(h);
   retp(-(bigt/2)*ln(2*pi)-(1/2)*sumc(z+(e2)./h));
endp;

/*****************************************************************
PROC: FIGARCH11_HHAT
*****************************************************************/
proc figarch11_hhat(x,e);
   local bigt,tl,e2,h0,e3,vd,vp,vp1,kn,vp2,vw,vw1,h1,h,z;
   bigt=rows(e);
   tl=1000;
   e2=e^2;
   h0=(e'e)/bigt;
   e3=h0|e2[1:bigt-1];
   vd=x[4];
   vp=1|cumprodc(seqa(-vd,1,tl-1)./seqa(1,1,tl-1));
   vp1=conv(1|-x[2],vp,1,tl);
   kn=ones(tl,1);
   vp2=conv(vp1,kn,tl+1,2*tl-1);
   vp2=vp2|zeros(bigt-tl+1,1);
   vw=conv(vp1,e2,1,bigt);
   vw1=vw+vp2*h0;
   h1=x[1]+e2[1]-vw1[1];
   h=recserar(0|x[1]+e2-x[3]*e3-vw1,h1,x[3]);
   h=h[2:bigt+1];
   retp(h);
endp;

/*****************************************************************
PROC: WML_GARCH11

This procedure estimates the GARCH(1,1) model,

h(t) = omega + alpha*e^2(t-1) + beta*h(t-1),

using weighted maximum likelihood as in Mittnik and Paolella
(2000). It calls the procedures WML_GARCH11_LOGLIKE and
GARCH11_HHAT (provided below) and uses the GAUSS application CML.

Format: {b,f,g,vcv,ret,hhat}=WML_GARCH11(depvar,startvalues,rho)

Input:

depvar      = T-vector, dependent variable
startvalues = vector of inital values
rho         = parameter for geometric weighting

Output:

b    = 3-vector of parameter estimates (omega,alpha,beta)
f    = scalar, log-likelihood function at minimum
g    = 3-vector, gradient at minimum
vcv  = variance-covariance matrix for parameters
ret  = scalar, CML return code
hhat = T-vector of conditional variance estimates at
       each point in time

Reference

S. Mittnik and M.S. Paolella (2000), "Conditional Density and
Value-at-Risk Predition of Asian Currency Exchange Rates,"
Journal of Forecasting, 19(4), 313-333
*****************************************************************/
proc(6)=wml_garch11(depvar,startvalues,rho);
   local bigt,tsequence,rhovec,b,f,g,vcv,ret,hhat;
   cmlset;
   _cml_Bounds={0.0000001 10,
                0         10,
                0         10};
   __output=0;
   bigt=rows(depvar);
   tsequence=seqa(1,1,bigt);
   rhovec=rho^(bigt-tsequence);
   {b,f,g,vcv,ret}=cml(depvar~rhovec,0,&wml_garch11_loglike,startvalues);
   hhat=garch11_hhat(b,depvar);
   retp(b,f,g,vcv,ret,hhat);
endp;

/*****************************************************************
proc: WML_GARCH11_LOGLIKE
*****************************************************************/
proc wml_garch11_loglike(x,e);
   local bigt,rhovec,mean_e2,alphapart,h,loglikevec;
   bigt=rows(e);
   rhovec=e[.,2];
   e=e[.,1];
   mean_e2=meanc(e^2);
   alphapart=x[1]+x[2]*missrv(lagn(e^2,1),mean_e2);
   h=recserar(0|alphapart,mean_e2,x[3]);
   h=h[2:bigt+1];
   loglikevec=rhovec.*(-0.5*ln(2*pi)-0.5*(ln(h)+(e^2)./h));
   retp(sumc(loglikevec));
endp;

/*****************************************************************
proc: CWML_CONSTANT
*****************************************************************/
proc(5)=cwml_constant(depvar,startvalues,rho);
   local bigt,tsequence,rhovec,b,f,g,vcv,ret,hhat;
   cmlset;
   _cml_Bounds={0.0000001 10};
   __output=0;
   bigt=rows(depvar);
   tsequence=seqa(1,1,bigt);
   rhovec=rho^(bigt-tsequence);
   {b,f,g,vcv,ret}=cml(depvar~rhovec,0,&cwml_constant_loglike,startvalues);
   retp(b,f,g,vcv,ret);
endp;

/*****************************************************************
proc: CWML_CONSTANT_LOGLIKE
*****************************************************************/
proc cwml_constant_loglike(x,e);
   local rhovec,mean_e2,h,loglikevec;
   rhovec=e[.,2];
   e=e[.,1];
   mean_e2=meanc(e^2);
   h=x[1];
   loglikevec=rhovec.*(-0.5*ln(2*pi)-0.5*(ln(h)+(e^2)./h));
   retp(sumc(loglikevec));
endp;
