/*

If you have any questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde/

*/

load data[129,3]=c:\research\preg\Data.txt;
data=data[1:127,.];
/*output file=c:\research\preg\Peprmcs.out reset;*/
ny=rows(data);
p=ln(data[2:ny,1]);
d=ln(data[1:ny-1,3]);
format 10,5;
"P/E";?;
e00=p;
f00=d;
z00=e00-f00;
lagtrunc=-1;
su=100;
kmax=10;
repsboot=500;
repsmc=500;
siglev=0.10;
"Size, 10% significance level";
pvals_size=zeros(repsmc,kmax);
{e,elag}=varlags(e00,1);
de00=e-elag;
mde00=meanc(de00);
u100=de00-mde00;
{z,zlag}=varlags(z00,1);
b0=-.5;
__output=0;
{b,f,g,retcode}=sqpsolve(&ssr_est,b0);
xx=vvf_est(b);
u200=z-xx;
u00=(u100-meanc(u100))~(u200-meanc(u200));
itermc=1;
do until itermc>repsmc;
   n=rows(e00);
   mz00=meanc(z00);
   de0=zeros(n,1);
   z0=zeros(n,1);
   de0[1]=e00[1];
   z0[1]=z00[1];
   u0=psdis(u00,n);
   iter=2;
   do until iter>n;
      de0[iter]=mde00+u0[iter,1];
      z0[iter]=mz00+(exp(-0.9258*(z0[iter-1]-mz00)^2))*(z0[iter-1]-mz00)+u0[iter,2];
      iter=iter+1;
   endo;
   e0=cumsumc(de0);
   tlh=zeros(kmax,1);
   k=1;
   do until k>kmax;
      {xxx,tlh[k]}=lhreg(e0,z0,k,lagtrunc);
      k=k+1;
   endo;
   mz=meanc(z0);
   z=z0-mz;
   {e,elag}=varlags(e0,1);
   de=e-elag;
   u1=de-meanc(de);
   {z,zlag}=varlags(z,1);
   b0=-.5;
   __output=0;
   {b,f,g,retcode}=sqpsolve(&ssr_est,b0);
   xx=vvf_est(b);
   u2=z-xx;
   tt=rows(z0)+su;
   utilde=(u1-meanc(u1))~(u2-meanc(u2));
   tstar=zeros(repsboot,kmax);
   iterboot=1;
   do until iterboot>repsboot;
      ustar=psdis(utilde,tt);
      destar=meanc(de)+ustar[.,1];
      estar=cumsumc(destar);
      zstar=zeros(tt,1);
      iter=2;
      do until iter>tt;
         zstar[iter]=(exp(b[1]*zstar[iter-1]^2)).*(zstar[iter-1])+ustar[iter,2];
         iter=iter+1;
      endo;
      estar=estar[su+1:tt];
      zstar=zstar[su+1:tt]+mz;
      k=1;
      do until k>kmax;
         {xxx,tstar[iterboot,k]}=lhreg(estar,zstar,k,lagtrunc);
         k=k+1;
      endo;
      iterboot=iterboot+1;
   endo;
   k=1;
   do until k>kmax;
      tstars=sortc(tstar[.,k],1);
      criter=dummy(tstars,tlh[k]);
      pvals_size[itermc,k]=sumc(criter[.,1])/rows(tstars);
      k=k+1;
   endo;
   "itermc " itermc;
   itermc=itermc+1;
endo;
?;iter=1;
do until iter>kmax;
   pvcriter=dummy(sortc(pvals_size[.,iter],1),siglev);
   "k       = " iter;?;
   "p-value = " sumc(pvcriter[.,1])/rows(pvcriter);?;
   iter=iter+1;
endo;

/* Procedure definition area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR
**        Alan G. Isaac
**   FORMAT
**        {x,xlags} = varlags(var,lags)
**   INPUT
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/******************************************************************************
PROC: LHREG

The procedure generates the OLS slope coefficient and t-statistic for the
predictive regression:

e(t+k) - e(t) = a_k + b_k*z(t) + u(t).

The t-statistic is calculated using the Newey and West (1987) HAC standard
error. The procedure requires the procedure VARLAGS (provided above).

Format: {blh,tblh}=lhreg(e,z,horizon,lagtrunc)

Input

e        = data vector for e
z        = data vector for f
horizon  = k
lagtrunc = truncation lag for Newey and West (1987) standard error
         = 0 to select truncation lag using Andrews (1991) procedure
         = -1 for to select truncation lag to 2*(k-1)

Output

blh  = OLS slope coefficient
tblh = HAC t-statistic

References

Donald K. Andrews, "Heteroskedasticity and Autocorrelation Consistent
Covariance Matrix Estimation," Econometrica 59 (1991): 807-858

Whitney K. Newey and Kenneth D. West, "A Simple, Positive Semi-Definite,
Heteroskedastistic and Autocorrelation Consistent Covariance Matrix,"
Econometrica 55 (1987): 703-708
******************************************************************************/
proc(2)=lhreg(e,z,horizon,lagtrunc);
   local elags,zlags,de,t,x,blh,u,u1,u2,u1lag,u2lag,x1,x2,b1,rho1,b2,rho2,
   e1,e2,s21,s22,a1n,a1d,a1,a,xu,omega,v,uu,uulags,xx,xxlags,xu0,xuv,xuux,
   covblh,seblh,tblh;
   {e,elags}=varlags(e,horizon);
   {z,zlags}=varlags(z,horizon);
   de=e-elags[.,horizon];
   t=rows(de);
   x=ones(t,1)~zlags[.,horizon];
   blh=de/x;
   u=de-x*blh;
   if lagtrunc==-1;
      a=2*(horizon-1);
   elseif lagtrunc==0;
      u1=u;
      u2=u.*zlags[.,horizon];
      {u1,u1lag}=varlags(u1,1);
      {u2,u2lag}=varlags(u2,1);
      x1=ones(rows(u1),1)~u1lag;
      x2=ones(rows(u2),1)~u2lag;
      b1=u1/x1;
      rho1=b1[2,.];
      b2=u2/x2;
      rho2=b2[2,.];
      e1=u1-x1*b1;
      e2=u2-x2*b2;
      s21=e1'e1/(rows(e1)-cols(x1));
      s22=e2'e2/(rows(e2)-cols(x2));
      a1n=4*rho1^2*s21^2/(((1-rho1)^6)*((1+rho1)^2))+4*rho2^2*s22^2/(((1-rho2)^6)*((1+rho2)^2));
      a1d=s21^2/((1-rho1)^4)+s22^2/((1-rho2)^4);
      a1=a1n/a1d;
      a=1.1447*(a1*t)^(1/3);
      a=round(a);
   else;
      a=lagtrunc;
   endif;
   xu=u.*x;
   omega=xu'xu;
   v=1;
   do until v>a;
      {uu,uulags}=varlags(u,v);
      {xx,xxlags}=varlags(x,v);
      xu0=uu.*xx;
      xuv=uulags[.,v].*xxlags[.,v+v-1:v+v];
      xuux=xu0'xuv;
      omega=omega+(1-(v/(a+1)))*2*xu0'xuv;
      v=v+1;
   endo;
   covblh=invpd(x'x)*omega*invpd(x'x);
   seblh=sqrt(diag(covblh));
   tblh=blh./seblh;
   retp(blh[2],tblh[2]);
endp;

proc(1)=ssr_est(b0);
   local resid,ssr;
   resid=z-((exp(b0[1,.]*zlag[.,1]^2)).*(zlag[.,1]));
   ssr=sumc(resid^2);
   retp(ssr);
endp;

proc(1)=vvf_est(b0);
   local d;
   d=(exp(b0[1,.]*zlag[.,1]^2)).*(zlag[.,1]);
   retp(d);
endp;

proc(1)=psdis(U,ndraws);
   local T,segment,iter,s,q,w,N,Ustar,c;
   T=rows(U);
   segment=zeros(T,1);             @ interval vector @
   iter=1;                         @ initializing @
   do until iter>T;                @ begin do loop @
       segment[iter,1]=iter*(1/T); @ creating intervals along (0,1] @
       iter=iter+1;                @ new iter @
   endo;                           @ end do loop @
   s=zeros(ndraws,1);              @ integer draw vector @
   q=1;                            @ initializing @
   do until q>ndraws;              @ begin do loop @
       w=rndu(1,1);                @ draw uniform random # @
       N=1;                        @ initializing @
       do until s[q,1]>0;          @ begin do loop @
           if w<=segment[N,1];     @ assigning integer to uniform draw @
               s[q,1]=N;           @ if draw <= Nth segment value, select @
           else;                   @ otherwise, go to next segment value @
               N=N+1;              @ new N @
           endif;                  @ end if @
       endo;                       @ end do loop @
       q=q+1;                      @ new q @
   endo;                           @ end do loop @
   Ustar=zeros(ndraws,2);          @ psuedo-disturbances @
   c=1;                            @ initializing @
   do until c>ndraws;              @ begin do loop @
       w=s[c,1];                   @ integer for cth obs @
       Ustar[c,.]=U[w,.];          @ pseudo-disturbance for cth obs @
       c=c+1;                      @ new c @
   endo;
   retp(Ustar);
endp;
