/*

If you have any questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde/

*/

load data[129,3]=c:\research\preg\Data.txt;
data=data[1:127,.];
/*output file=c:\research\preg\Pepr.out reset;*/
ny=rows(data);
p=ln(data[2:ny,1]);
d=ln(data[1:ny-1,3]);
format 10,5;
"P/E";?;
e=p;
f=d;
a=0;
z=e-f;
lagtrunc=0;
k=1;
su=100;
do until k>10;
    {blh,tlh}=lhreg(e,z,k,lagtrunc);
    reps=500;
    tlhboot=zeros(reps,1);    
    iter=1;
    do until iter>reps;
        {estar,fstar}=markboot(e,f,su);
        zstar=estar-fstar;
        {xx,tlhboot[iter,.]}=lhreg(estar,zstar,k,lagtrunc);
        iter=iter+1;
    endo;
    tlhboot=sortc(tlhboot,1);    
    tlhcriter=dummy(tlhboot,tlh);
    tlhpval=sumc(tlhcriter[.,1])/rows(tlhboot);
    "k         = " k;?;
    "b_k       = " blh;
    "t(A)      = " tlh;
    "p-value   = " tlhpval;?;
    k=k+1;
endo;
"Number of bootstrap replications = " reps;?;

/* Procedure Definition Area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/***************************************************************************
PROC: AIC_LAG

The procedure selects the VAR lag order (p0) using the AIC, considering
a maximum lag order of p. The procedure calls the procedure VARLAGS
(provided above).

Format: p0=aic_lag(z,p)

Inputs

z = data matrix (z_1~z_2~...~z_M),
    where z_i is a column vector of observations for the ith endogenous
    variable
p = maximum VAR lag order

Output

p0 = VAR lag order selected using the AIC
***************************************************************************/
proc(1)=aic_lag(z,p);
    local y,M,ylags,T,i,X,j,b,e,sig,AIC,p0;
    AIC=zeros(p,1);
    y=z;
    M=cols(z);
    {y,ylags}=varlags(y,p);
    T=rows(y);
    i=1;
    do until i>p;
        X=ylags[.,1:i*M]~ones(T,1);
        j=(cols(X)-1)/M;
        b=y/X;
        e=y-X*b;
        sig=e'e/T;
        AIC[i,.]=ln(det(sig))+2*((M^2)*j+M)/T;
        i=i+1;
    endo;
    p0=minindc(AIC);
    retp(p0);
endp;

/******************************************************************************
PROC: LHREG

The procedure generates the OLS slope coefficient and t-statistic for the
predictive regression:

e(t+k) - e(t) = a_k + b_k*z(t) + u(t).

The t-statistic is calculated using the Newey and West (1987) HAC standard
error. The procedure requires the procedure VARLAGS (provided above).

Format: {blh,tblh}=lhreg(e,z,horizon,lagtrunc)

Input

e        = data vector for e
z        = data vector for f
horizon  = k
lagtrunc = truncation lag for Newey and West (1987) standard error
         = 0 to select truncation lag using Andrews (1991) procedure
         = -1 for to select truncation lag to 2*(k-1)

Output

blh  = OLS slope coefficient
tblh = HAC t-statistic

References

Donald K. Andrews, "Heteroskedasticity and Autocorrelation Consistent
Covariance Matrix Estimation," Econometrica 59 (1991): 807-858

Whitney K. Newey and Kenneth D. West, "A Simple, Positive Semi-Definite,
Heteroskedastistic and Autocorrelation Consistent Covariance Matrix,"
Econometrica 55 (1987): 703-708
******************************************************************************/
proc(2)=lhreg(e,z,horizon,lagtrunc);
   local elags,zlags,de,t,x,blh,u,u1,u2,u1lag,u2lag,x1,x2,b1,rho1,b2,rho2,
   e1,e2,s21,s22,a1n,a1d,a1,a,xu,omega,v,uu,uulags,xx,xxlags,xu0,xuv,xuux,
   covblh,seblh,tblh;
   {e,elags}=varlags(e,horizon);
   {z,zlags}=varlags(z,horizon);
   de=e-elags[.,horizon];
   t=rows(de);
   x=ones(t,1)~zlags[.,horizon];
   blh=de/x;
   u=de-x*blh;
   if lagtrunc==-1;
      a=2*(horizon-1);
   elseif lagtrunc==0;
      u1=u;
      u2=u.*zlags[.,horizon];
      {u1,u1lag}=varlags(u1,1);
      {u2,u2lag}=varlags(u2,1);
      x1=ones(rows(u1),1)~u1lag;
      x2=ones(rows(u2),1)~u2lag;
      b1=u1/x1;
      rho1=b1[2,.];
      b2=u2/x2;
      rho2=b2[2,.];
      e1=u1-x1*b1;
      e2=u2-x2*b2;
      s21=e1'e1/(rows(e1)-cols(x1));
      s22=e2'e2/(rows(e2)-cols(x2));
      a1n=4*rho1^2*s21^2/(((1-rho1)^6)*((1+rho1)^2))+4*rho2^2*s22^2/(((1-rho2)^6)*((1+rho2)^2));
      a1d=s21^2/((1-rho1)^4)+s22^2/((1-rho2)^4);
      a1=a1n/a1d;
      a=1.1447*(a1*t)^(1/3);
      a=round(a);
   else;
      a=lagtrunc;
   endif;
   xu=u.*x;
   omega=xu'xu;
   v=1;
   do until v>a;
      {uu,uulags}=varlags(u,v);
      {xx,xxlags}=varlags(x,v);
      xu0=uu.*xx;
      xuv=uulags[.,v].*xxlags[.,v+v-1:v+v];
      xuux=xu0'xuv;
      omega=omega+(1-(v/(a+1)))*2*xu0'xuv;
      v=v+1;
   endo;
   covblh=invpd(x'x)*omega*invpd(x'x);
   seblh=sqrt(diag(covblh));
   tblh=blh./seblh;
   retp(blh[2],tblh[2]);
endp;
