/*

If you have any questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde/

*/

load data[129,3]=c:\research\preg\Data.txt;
data=data[1:127,.];
/*output file=c:\research\preg\Pdpr_bias.out reset;*/
ny=rows(data);
p=ln(data[2:ny,1]);
d=ln(data[1:ny-1,2]);
format 10,5;
"P/D";?;
e=p;
f=d;
z=e-f;
{e,elag}=varlags(e,1);
{z,zlag}=varlags(z,1);
de=e-elag;
t=rows(de);
x=ones(t,1)~zlag;
bpr=de/x;
epsilon=de-x*bpr;
bz=z/x;
mu=z-x*bz;
sigma=vcx(epsilon~mu);
rho=(t*bz[2]+1)/(t-3);
bias=-(sigma[1,2]/sigma[2,2])*(1+3*rho)/t;
"Bias  = " bias;?;
"Ratio = " bias/bpr[2];?;

/* Procedure Definition Area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;
