/*

If you have any questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde/

*/

load data[129,3]=c:\research\preg\Data.txt;
data=data[1:127,.];
/*output file=c:\research\preg\Pdpr.out reset;*/
ny=rows(data);
p=ln(data[2:ny,1]);
d=ln(data[1:ny-1,2]);
format 10,5;
"P/D";?;
e=p;
f=d;
a=0;
z=e-f;
lagtrunc=0;
k=1;
su=100;
do until k>10;
    {blh,tlh}=lhreg(e,z,k,lagtrunc);
    reps=500;
    tlhboot=zeros(reps,1);    
    tuboot=zeros(reps,1);
    iter=1;
    do until iter>reps;
        {estar,fstar}=markboot(e,f,su);
        zstar=estar-fstar;
        {xx,tlhboot[iter,.]}=lhreg(estar,zstar,k,lagtrunc);
        iter=iter+1;
    endo;
    tlhboot=sortc(tlhboot,1);    
    tlhcriter=dummy(tlhboot,tlh);
    tlhpval=sumc(tlhcriter[.,1])/rows(tlhboot);
    "k         = " k;?;
    "b_k       = " blh;
    "t(A)      = " tlh;
    "p-value   = " tlhpval;?;
    k=k+1;
endo;
"Number of bootstrap replications = " reps;?;

/* Procedure Definition Area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR		 
**        Alan G. Isaac
**   FORMAT		 
**        {x,xlags} = varlags(var,lags)
**   INPUT		 
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT		 
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

/***************************************************************************
PROC: AIC_LAG

The procedure selects the VAR lag order (p0) using the AIC, considering
a maximum lag order of p. The procedure calls the procedure VARLAGS
(provided above).

Format: p0=aic_lag(z,p)

Inputs

z = data matrix (z_1~z_2~...~z_M),
    where z_i is a column vector of observations for the ith endogenous
    variable
p = maximum VAR lag order

Output

p0 = VAR lag order selected using the AIC
***************************************************************************/
proc(1)=aic_lag(z,p);
    local y,M,ylags,T,i,X,j,b,e,sig,AIC,p0;
    AIC=zeros(p,1);
    y=z;
    M=cols(z);
    {y,ylags}=varlags(y,p);
    T=rows(y);
    i=1;
    do until i>p;
        X=ylags[.,1:i*M]~ones(T,1);
        j=(cols(X)-1)/M;
        b=y/X;
        e=y-X*b;
        sig=e'e/T;
        AIC[i,.]=ln(det(sig))+2*((M^2)*j+M)/T;
        i=i+1;
    endo;
    p0=minindc(AIC);
    retp(p0);
endp;

/******************************************************************************
PROC: LHREG

The procedure generates the OLS slope coefficient and t-statistic for the
predictive regression:

e(t+k) - e(t) = a_k + b_k*z(t) + u(t).

The t-statistic is calculated using the Newey and West (1987) HAC standard
error. The procedure requires the procedure VARLAGS (provided above).

Format: {blh,tblh}=lhreg(e,z,horizon,lagtrunc)

Input

e        = data vector for e
z        = data vector for f
horizon  = k
lagtrunc = truncation lag for Newey and West (1987) standard error
         = 0 to select truncation lag using Andrews (1991) procedure
         = -1 for to select truncation lag to 2*(k-1)

Output

blh  = OLS slope coefficient
tblh = HAC t-statistic

References

Donald K. Andrews, "Heteroskedasticity and Autocorrelation Consistent
Covariance Matrix Estimation," Econometrica 59 (1991): 807-858

Whitney K. Newey and Kenneth D. West, "A Simple, Positive Semi-Definite,
Heteroskedastistic and Autocorrelation Consistent Covariance Matrix,"
Econometrica 55 (1987): 703-708
******************************************************************************/
proc(2)=lhreg(e,z,horizon,lagtrunc);
   local elags,zlags,de,t,x,blh,u,u1,u2,u1lag,u2lag,x1,x2,b1,rho1,b2,rho2,
   e1,e2,s21,s22,a1n,a1d,a1,a,xu,omega,v,uu,uulags,xx,xxlags,xu0,xuv,xuux,
   covblh,seblh,tblh;
   {e,elags}=varlags(e,horizon);
   {z,zlags}=varlags(z,horizon);
   de=e-elags[.,horizon];
   t=rows(de);
   x=ones(t,1)~zlags[.,horizon];
   blh=de/x;
   u=de-x*blh;
   if lagtrunc==-1;
      a=2*(horizon-1);
   elseif lagtrunc==0;
      u1=u;
      u2=u.*zlags[.,horizon];
      {u1,u1lag}=varlags(u1,1);
      {u2,u2lag}=varlags(u2,1);
      x1=ones(rows(u1),1)~u1lag;
      x2=ones(rows(u2),1)~u2lag;
      b1=u1/x1;
      rho1=b1[2,.];
      b2=u2/x2;
      rho2=b2[2,.];
      e1=u1-x1*b1;
      e2=u2-x2*b2;
      s21=e1'e1/(rows(e1)-cols(x1));
      s22=e2'e2/(rows(e2)-cols(x2));
      a1n=4*rho1^2*s21^2/(((1-rho1)^6)*((1+rho1)^2))+4*rho2^2*s22^2/(((1-rho2)^6)*((1+rho2)^2));
      a1d=s21^2/((1-rho1)^4)+s22^2/((1-rho2)^4);
      a1=a1n/a1d;
      a=1.1447*(a1*t)^(1/3);
      a=round(a);
   else;
      a=lagtrunc;
   endif;
   xu=u.*x;
   omega=xu'xu;
   v=1;
   do until v>a;
      {uu,uulags}=varlags(u,v);
      {xx,xxlags}=varlags(x,v);
      xu0=uu.*xx;
      xuv=uulags[.,v].*xxlags[.,v+v-1:v+v];
      xuux=xu0'xuv;
      omega=omega+(1-(v/(a+1)))*2*xu0'xuv;
      v=v+1;
   endo;
   covblh=invpd(x'x)*omega*invpd(x'x);
   seblh=sqrt(diag(covblh));
   tblh=blh./seblh;
   retp(blh[2],tblh[2]);
endp;

/******************************************************************************
PROC: MARKBOOT

The procedure generates a sequence of psuedo-observations for e and f of the
same length as the original data series using the bootstrap described in
Mark (1995, p. 207). It calls the procedures VARLAGS and AIC_LAG (provided
above). Note that the AIC is used to select the lag order for the z process
(considering a maximum lag of 4), following the recommendation of Kilian
(1999). Also note that the slope coefficients for z process are corrected
for small-sample bias using the adjustment in Shaman and Stine (1988).

Format: {estar,fstar}=markboot(e,f,su)

Input

e    = original data vector for e
f    = original data vector for f
su   = number of start-up transient observations

Output

estar = pseudo observations for e
fstar = pseudo observations for f

References

Lutz Kilian, "Exchange Rates and Monetary Fundamentals: What Do We Learn
from Long-Horizon Regression?" Journal of Applied Econometrics 14 (1999):
491-510

Nelson Mark, "Exchange Rates and Fundamentals: Evidence on Long-Horizon
Predictability" American Economic Review 85 (1995): 201-218

Paul Shaman and Robert Stine, "The Bias of Autoregressive Coefficient
Estimators," Journal of the American Statistical Association 83 (1988):
842-848
******************************************************************************/
proc(2)=markboot(e,f,su);
   local z,p0,elags,zlags,de,T,xde,bde,xz,bz,ude,uz,U,bza,segment,iter,s,q,
   w,N,Ustar,c,destar,zstar,i,estar,fstar;
   z=e-f;
   p0=aic_lag(z,4);
   {e,elags}=varlags(e,p0);
   {z,zlags}=varlags(z,p0);
   de=e-elags[.,1];
   T=rows(de);
   xde=ones(T,1);
   bde=de/xde;
   xz=zlags~ones(T,1);
   bz=z/xz;
   ude=de-xde*bde;
   uz=z-xz*bz;
   U=ude~uz;
   bza=zeros(p0,1)|bz[p0+1];
   if p0==1;
      bza[1]=(T*bz[1]+1)/(T-3);
   elseif p0==2;
      bza[2]=(T*bz[2]+2)/(T-4);
      bza[1]=(T*bz[1]+1+bza[2])/(T-1); 
   elseif p0==3;
      bza[3]=(T*bz[3]+1)/(T-5);
      bza[1]=(T*bz[1]+1+2*bza[3])/(T-1);
      bza[2]=(T*bz[2]+2-bza[1]+bza[3])/(T-4);
   elseif p0==4;
      bza[4]=(T*bz[4]+2)/(T-6);
      bza[1]=(T*bz[1]+1+bza[4])/(T-1);
      bza[3]=(T*bz[3]+1-2*bza[1]+bza[4])/(T-5);
      bza[2]=(T*bz[2]+2-bza[1]+bza[3]-2*bza[4])/(T-2);
   endif;
      
   /* Generating pseudo-disturbances */

   segment=zeros(T,1);             @ interval vector @
   iter=1;                         @ initializing @
   do until iter>T;                @ begin do loop @
       segment[iter,1]=iter*(1/T); @ creating intervals along (0,1] @
       iter=iter+1;                @ new iter @
   endo;                           @ end do loop @
   s=zeros(T+su+p0,1);             @ integer draw vector @
   q=1;                            @ initializing @
   do until q>T+su+p0;             @ begin do loop @
       w=rndu(1,1);                @ draw uniform random # @
       N=1;                        @ initializing @
       do until s[q,1]>0;          @ begin do loop @
           if w<=segment[N,1];     @ assigning integer to uniform draw @
               s[q,1]=N;           @ if draw <= Nth segment value, select @
           else;                   @ otherwise, go to next segment value @
               N=N+1;              @ new N @
           endif;                  @ end if @
       endo;                       @ end do loop @
       q=q+1;                      @ new q @
   endo;                           @ end do loop @
   Ustar=zeros(T+su+p0,2);         @ psuedo-disturbances @
   c=1;                            @ initializing @
   do until c>T+su+p0;             @ begin do loop @
       w=s[c,1];                   @ integer for cth obs @
       Ustar[c,.]=U[w,.];          @ pseudo-disturbance for cth obs @
       c=c+1;                      @ new c @
   endo;                           @ end do loop @
   Ustar=Ustar-meanc(Ustar)';

   /* Building pseudo-sample */

   destar=zeros(T+su+p0,1);        @ pseudo realizations @
   zstar=zeros(T+su+p0,1);
   i=p0+1;                         @ initializing @
   do until i>T+su+p0;             @ begin do loop @
       destar[i,.]=bde+Ustar[i,1]; @ generating obs @
       zstar[i,.]=bza[p0+1]+bza[1:p0]'*zstar[i-1:i-p0]+Ustar[i,2];
       i=i+1;                      @ new i @
   endo;                           @ end do loop @
   estar=cumsumc(destar);
   fstar=estar-zstar;
   estar=estar[su+1:T+su+p0,.];    @ adjusting sample size @
   fstar=fstar[su+1:T+su+p0,.];   
   retp(estar,fstar);
endp;
